#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Project   : Tissu - Functions to handle settings with Fabric
# -----------------------------------------------------------------------------
# License   : BSD License
# -----------------------------------------------------------------------------
# Authors   : Thierry Stiegler <thierry.stiegler@gmail.com>
# -----------------------------------------------------------------------------

"""
CONSTANTS used in TISSU's code
"""

# A
ALL_ROLE = "all"

# B
# C
CURRENT_TISSU = "current_tissu"

# D
DEFAULT_SETTINGS_NAME = "default"
DEFAULT_SETTINGS_FILENAME = "%s.py" % DEFAULT_SETTINGS_NAME
DEFAULT_TISSU_SETTINGS_MODULE = 'settings.%s' % DEFAULT_SETTINGS_NAME
DEFAULT_SSH_PORT = 22

# E
# F
FABRIC_USE_SSH_CONFIG = "FABRIC_USE_SSH_CONFIG"
# G
# H
HOSTDEFS = "hostdefs"
HOSTKEY = "key"
HOSTNAME = "hostname"

# I
# J
# K
# L
# M
MY_SETTINGS = "my_settings"
# N
# O
# P
PASSWORD = "password"
PASSWORDS = "passwords"
SSH_PORT = "port"
# Q

# R
ROLES = "FABRIC_ROLES"
ROLEDEFS = "roledefs"

# S
SETTINGS_DIRNAME = "settings"

# T
TISSU_SETTINGS_MODULE = "TISSU_SETTINGS_MODULE"

# U
USER = "user"

# V
VERSION = "0.1-alpha"
# W
# X
# Y
# Z

# EOF - vim: ts=4 sw=4 noet