# -*- coding: utf-8 -*-

import time
import functools

from tornado.ioloop import IOLoop
import kola
from kola import safe_call, safe_func


class Blueprint(kola.Blueprint):

    def __init__(self, name):
        super(Blueprint, self).__init__(name)

    def repeat_app_timer(self, interval):
        """
        每隔一段时间执行(秒)
        """
        def inner_repeat_timer(func):
            @functools.wraps(func)
            def func_wrapper(*args, **kwargs):
                # 每次也要再加入

                result = safe_call(func, *args, **kwargs)
                IOLoop.instance().add_timeout(time.time() + interval, func_wrapper)

                return result

            self.events.repeat_app_timer += functools.partial(IOLoop.instance().add_timeout,
                                                              time.time() + interval, func_wrapper)
            return func_wrapper
        return inner_repeat_timer
