# -*- coding: utf-8 -*-
"""
    tlutil.rc4
"""


__all__ = [
    "crypt"
]


def KSA(key):
    keylength = len(key)

    S = range(256)

    j = 0
    for i in range(256):
        j = (j + S[i] + key[i % keylength]) % 256
        S[i], S[j] = S[j], S[i]  # swap

    return S


def PRGA(S):
    i = 0
    j = 0
    while True:
        i = (i + 1) % 256
        j = (j + S[i]) % 256
        S[i], S[j] = S[j], S[i]  # swap

        K = S[(S[i] + S[j]) % 256]
        yield K


def RC4(key):
    S = KSA(key)
    return PRGA(S)


def _convert_key(s):
    return [ord(c) for c in s]


def crypt(key, data):
    ret = []
    key = _convert_key(key)
    keystream = RC4(key)
    for c in data:
        one = chr(ord(c) ^ keystream.next())
        ret.append(one)
    return ''.join(ret)
