import re
import os
from valideer import accepts
from valideer import HomogeneousSequence

from validators import *


class Variables(dict):
    @accepts(key="key", value="value")
    def __setitem__(self, key, value):
        # set in .env if environment is development, else heroku...etc
        super(Variables, self).__setitem__(key, value)    

    def clear(self):
        self._backup()
        super(Variables, self).clear()
        self._save()

    @accepts(tokens="tokens")
    def update(self, tokens):
        self._backup()
        super(Variables, self).update(tokens)
        self._save()

    @accepts(keys=HomogeneousSequence("key"))
    def remove(self, *keys):
        self._backup()
        [self.pop(k) for k in keys if k in self]
        self._save()

    def _save(self):
        with open(os.path.join(os.getcwd(), '.env'), 'w+') as e:
            e.write("\n".join([("%s=%s"%(k,v)) for k,v in self.items()]))
            e.write("\n")

    def _backup(self):
        """FUTURE"""
        pass

    @classmethod
    def from_env(self):
        try:    
            with open(os.path.join(os.getcwd(), '.env'), 'r') as f: 
                return Variables(lines_to_token(f.readlines()))
        except IOError:
            # no .env file found, create it
            open(os.path.join(os.getcwd(), '.env'), 'w+').close()
            return Variables()


def lines_to_token(lines):
    return [tuple(l.split('=', 1)) \
            for l in filter(lines_to_token.regexp.match, 
                            map(lambda l: l.strip(), lines))]
lines_to_token.regexp = re.compile(r"^([A-Z\_]+)\=([^\n]+)$")

