
PACKAGE = "toolbox"
VERSION = "0.1"
WEBSITE = 'http://www.tragicallyleet.com/projects/toolbox'
LICENSE = 'MIT'

DESCRIPTION = "Toolbox: manage multiple versions of Java libraries and other tools."

CLASSIFIERS = [
    'Development Status :: 4 - Beta',
    'Environment :: Console',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: MIT License',
    'Natural Language :: English',
    'Operating System :: MacOS :: MacOS X',
    'Operating System :: POSIX',
    'Programming Language :: Python',
    'Topic :: Software Development',
]

from paver.easy import *
import paver.doctools
from paver.setuputils import setup

setup(
    name=PACKAGE,
    packages=['toolbox'],
    version=VERSION,
    url=WEBSITE,
    download_url=WEBSITE,
    author="Jeffrey Hulten",
    author_email="jhulten@gmail.com",
    license="LICENSE",
    description=DESCRIPTION,
    classifiers=CLASSIFIERS,
    entry_points="""
        [console_scripts]
        tbx = toolbox:run_script
        """,
    package_dir = {'': 'src'},
)
