
import os, sys, StringIO
from toolbox import toolbox
from nose.tools import with_setup

toolpath = os.path.abspath(os.path.join(os.path.dirname(__file__), "tooldir"))
standard_out = None

def setup_stdout():
    global standard_out
    standard_out = sys.stdout
    
def teardown_stdout():
    global standard_out
    sys.stdout = standard_out
    
def setup_create_symlink():
    global toolpath
    os.symlink(os.path.join(toolpath, "testa-1.1"), os.path.join(toolpath, "testa"))

def teardown_cleanup_symlinks():
    global toolpath
    for d in os.listdir(toolpath):
        if os.path.islink(os.path.join(toolpath, d)):
            os.remove(os.path.join(toolpath, d))

def test_create_toolbox():
    global toolpath
    tbx = toolbox(toolpath)
    assert tbx.tooldir.path == toolpath, \
        "%s does not match %s" % (tbx.tooldir.path, toolpath)

@with_setup(setup_stdout, teardown_stdout)
def test_list_all():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.list([])
    out = outfile.getvalue()
    assert out.startswith("testa"), out

@with_setup(setup_stdout, teardown_stdout)
def test_list_tool():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.list(["testa"])
    out = outfile.getvalue()
    assert not out.find("1.0") == -1, out

@with_setup(setup_stdout, teardown_stdout)
def test_no_such_tool():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.list(["bogus"])
    out = outfile.getvalue()
    assert out.strip() == "No such tool.", out

@with_setup(setup_stdout, teardown_stdout)
def test_switch_to_bad_version():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.switch(["testa","2.0"])
    out = outfile.getvalue()
    assert out.startswith("Version does not exist"), out
    assert len(out.split("\n")) == 6, out.split("\n")

@with_setup(setup_stdout, teardown_stdout)
def test_switch_to_bad_tool():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.switch(["bogus","2.0"])
    out = outfile.getvalue()
    assert out.strip() == "No such tool.", out
    
@with_setup(None, teardown_cleanup_symlinks)
@with_setup(setup_stdout, teardown_stdout)
def test_switch_first_time():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.switch(["testa","1.0"])
    out = outfile.getvalue()
    assert out.strip() == "testa 1.0 active.", out

@with_setup(setup_create_symlink, teardown_cleanup_symlinks)
@with_setup(setup_stdout, teardown_stdout)
def test_switch_second_time():
    global toolpath
    sys.stdout = outfile = StringIO.StringIO()
    tbx = toolbox(toolpath)
    tbx.switch(["testa","1.0"])
    out = outfile.getvalue()
    assert out.strip() == "testa 1.0 active.", out
