from tornado.web import RequestHandler

import json
import tornado


class RestHandler(RequestHandler):

    app_name = None
    app_ver = None
    Encoder = json.JSONEncoder

    def set_default_headers(self):
        if not (RestHandler.app_name is None or RestHandler.app_ver is None):
            self.set_header("Server", "{}/{} tornado/{}"
                            .format(RestHandler.app_name, RestHandler.app_ver,
                                    tornado.version))
        self.set_header("Access-Control-Allow-Origin", "*")
        self.set_header("Access-Control-Allow-Headers",
                        "Content-Type, Cookie, Authorization, X-Filename")
        self.set_header("Access-Control-Allow-Methods",
                        "GET,PUT,POST,DELETE,OPTIONS")
        self.set_header("Access-Control-Max-Age", 86400)

    def respond(self, data=None, code=200):
        self.set_header("Content-Type", "application/json; charset=UTF-8")
        self.write(json.dumps(data, indent=2, cls=RestHandler.Encoder))
        self.set_status(code)
        self.flush()
        self.finish()

    def options(self, *args, **kwargs):
        self.respond()

    def get_body_arguments(self):
        return json.loads(self.request.body.decode("UTF-8"))

    def get_body_argument(self, name):
        return self.get_body_arguments()[name]
