# -*- coding: utf-8 -*-


from tornado.web import UIModule


class CSS(UIModule):
    def render(self, origin, compress=None, *args, **kwargs):
        cdn = self.handler.cdn
        debug = self.handler.debug

        css_version = self.handler.css_version

        to_show = None

        buff = ''

        if debug or compress is None:
            if isinstance(origin, str):
                to_show = [origin]
            else:
                to_show = origin
        else:
            if isinstance(compress, str):
                to_show = [compress]
            else:
                to_show = compress

        for i in to_show:
            buff += '<link href="' + cdn + i + '?v=' + css_version + '" media="screen" rel="stylesheet" type="text/css">'
        pass

        return buff







