# -*- coding: utf-8 -*-


import functools
import inspect



def setup_model(method):
    """
    create tornadoez style unittest
    used for model
    """
    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):
        args, varargs, keywords, defaults = inspect.getargspec(method)

        aa = dict(zip(args[-len(defaults):], defaults))
        aa.update(kwargs)

        handler = aa.get('handler')

        if handler:
            # setattr(handler,'application',Simulator())
            for k, v in handler.items():
                setattr(self, k, v)

        return method(self)
        # return method(self,*args,**kwargs)


    return wrapper
