# -*- coding: utf-8 -*-

from cliez.loader import ArgLoader
import os, sys, types
import tornado.ioloop
import traceback

from tornado.web import Application


if sys.version_info < (3,0):
    def tasks(imported):
        """
        ref from fabric.main
        Handles loading all of the tasks for a given `imported` module
        """
        # Obey the use of <module>.__all__ if it is present
        imported_vars = vars(imported)
        if "__all__" in imported_vars:
            imported_vars = [(name, imported_vars[name]) for name in \
                imported_vars if name in imported_vars["__all__"]]
        else:
            imported_vars = imported_vars.items()
            pass

        entries = []
        names = []
        for tup in imported_vars:
            name, obj = tup
            if isinstance(obj, types.FunctionType) and name[0] != '_':
                names.append(name)
                entries.append(obj)

        return names, entries

else:
    def tasks(imported):
        """
        for python3
        """
        # Obey the use of <module>.__all__ if it is present
        imported_vars = vars(imported)


        if "__all__" in imported_vars:
            imported_vars = [(name, imported_vars[name]) for name in \
                imported_vars if name in imported_vars["__all__"]]
        else:
            imported_vars = imported_vars.items()
            pass

        entries = []
        names = []
        for tup in imported_vars:
            name, obj = tup
            if isinstance(obj, types.FunctionType) and name[0] != '_':
                names.append(name)
                entries.append(obj)

        return names, entries




def embed(a):
    """
    must be implement:

    --host
    --port
    --debug

    :param a:
    :return:
    """
    importer = __import__



    entry = a.argv[1] if 1 < len(a.argv) else None

    # change http.py name to boot.py because python3 has a built-in package called http
    config = a.options.get('--filename') or 'boot.py'


    port = a.options.get('--port') or 9001
    host = a.options.get('--host') or ""

    default_settings = {
        'template_path': os.path.join('.', "templates"),
        'static_path': os.path.join('.', 'static'),
        'static_url_prefix': '/static/',
        'login_url': '/login'
    }

    if a.options['--help'] is True:
        print(a)
        sys.exit(0)

    _debug = a.options.get('--debug') or False

    ez_env = {
        'debug': _debug
    }



    imported = importer(os.path.splitext(config)[0])
    if _debug:
        print("Project:%s\nLoad:%s" % (config))

    names, entries = tasks(imported)

    if entry in names:
        pos = names.index(entry)
        settings, handlers = entries[pos](**ez_env)
    else:
        print("Entry:'%s' not exist.choice can use:" % entry)
        print("")
        for i in names:
            print("     -", i)
        print("")
        sys.exit(-1)

    if _debug:
        print("Tornado service start,port:%s" % port)

    default_settings.update(settings)

    application = Application(handlers=handlers, default_host=host, transforms=a.options.get('--transforms'),
                              wsgi=a.options.get('--wsgi'), **default_settings)
    application.listen(port)
    tornado.ioloop.IOLoop.instance().start()


if __name__ == '__main__':
    main()
    pass
