# -*- coding: utf-8 -*-

from cliez.loader import ArgLoader
import os, sys, types
import tornado.ioloop
import traceback

from tornado.web import Application


if sys.version_info < (3,0):
    def tasks(imported):
        """
        ref from fabric.main
        Handles loading all of the tasks for a given `imported` module
        """
        # Obey the use of <module>.__all__ if it is present
        imported_vars = vars(imported)
        if "__all__" in imported_vars:
            imported_vars = [(name, imported_vars[name]) for name in \
                imported_vars if name in imported_vars["__all__"]]
        else:
            imported_vars = imported_vars.items()
            pass

        entries = []
        names = []
        for tup in imported_vars:
            name, obj = tup
            if isinstance(obj, types.FunctionType) and name[0] != '_':
                names.append(name)
                entries.append(obj)

        return names, entries

else:
    def tasks(imported):
        """
        for python3
        """
        # Obey the use of <module>.__all__ if it is present
        imported_vars = vars(imported)


        if "__all__" in imported_vars:
            imported_vars = [(name, imported_vars[name]) for name in \
                imported_vars if name in imported_vars["__all__"]]
        else:
            imported_vars = imported_vars.items()
            pass

        entries = []
        names = []
        for tup in imported_vars:
            name, obj = tup
            if isinstance(obj, types.FunctionType) and name[0] != '_':
                names.append(name)
                entries.append(obj)

        return names, entries




def main():
    importer = __import__

    a = ArgLoader((
        ('Useage ez [options] tornado-web-path entry'),
        '',
        '',
        'Options:',
        ('--host:', 'tornado bind host default is None'),
        ('--port:', 'bind port to work,default is 9001'),
        ('--transform:', 'transform wrapper'),
        ('--wsgi:', 'wsgi wrapper'),


        ('--filename:', 'tornado config file name,default is boot.py', '-n'),
        ('--debug', 'debug flag'),
        ('--help', 'print help document', '-h'),
    ))

    runtime = a.argv[1] if 1 < len(a.argv) else False
    entry = a.argv[2] if 2 < len(a.argv) else None

    # change http.py name to boot.py because python3 has a built-in package called http
    config = a.options.get('--filename') or 'boot.py'


    port = a.options.get('--port') or 9001
    host = a.options.get('--host') or ""

    default_settings = {
        'template_path': os.path.join('.', "templates"),
        'static_path': os.path.join('.', 'static'),
        'static_url_prefix': '/static/',
        'login_url': '/login'
    }

    if a.options['--help'] is True:
        print(a)
        sys.exit(0)

    _debug = a.options.get('--debug') or False

    ez_env = {
        'debug': _debug
    }

    try:
        runtime_path = os.path.realpath(os.path.expanduser(runtime))

        os.chdir(runtime_path)

        # order broken,that not my wish
        # sys.path = list(set(sys.path))

        if runtime_path in sys.path:
            key = sys.path.index(runtime_path)
            del sys.path[key]

        sys.path.insert(0, runtime_path)
        imported = importer(os.path.splitext(config)[0])
        if _debug:
            print("Project:%s\nLoad:%s" % (runtime_path, config))


            # importer(os.path.join)
    except AttributeError:
        print("AttributeError.maybe your forget set your project root or error config.")
        print(traceback.format_exc())
        sys.exit(-1)
    except OSError:
        print("Tornado project:'%s' not exist." % runtime)
        print(traceback.format_exc())
        sys.exit(-1)
    except TypeError:
        print(traceback.format_exc())
        sys.exit(-1)

    names, entries = tasks(imported)

    if entry in names:
        pos = names.index(entry)
        settings, handlers = entries[pos](**ez_env)
    else:
        print("Entry:'%s' not exist.choice can use:" % entry)
        print("")
        for i in names:
            print("     -", i)
        print("")
        sys.exit(-1)

    if _debug:
        print("Tornado service start,port:%s" % port)

    default_settings.update(settings)

    application = Application(handlers=handlers, default_host=host, transforms=a.options.get('--transforms'),
                              wsgi=a.options.get('--wsgi'), **default_settings)
    application.listen(port)
    tornado.ioloop.IOLoop.instance().start()


if __name__ == '__main__':
    main()
    pass
