# -*- coding: utf-8 -*-


import tornado.web
from tornado.util import ObjectDict

from tornado.web import _UIModuleNamespace, StaticFileHandler
from tornado.escape import xhtml_escape, url_escape

import functools
import inspect
import re

from time import time

from tornadoez.mail import MailClient2



# try:
# from tornado.web import _UIModuleNamespace
# except:
#
# class _UIModuleNamespace(object):
# """Hack for python3.Lazy namespace which creates UIModule proxies bound to a handler."""
# def __init__(self, handler, ui_modules):
# self.handler = handler
# self.ui_modules = ui_modules
#
# def __getitem__(self, key):
# return self.handler._ui_module(key, self.ui_modules[key])
#
# def __getattr__(self, key):
# try:
# return self[key]
# except KeyError as e:
# raise AttributeError(str(e))


from tornado.web import HTTPError
from tornadoez.escape import json_encode


def api_public(method):
    """
    create api controller
    """

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):

        doc = False if len(self.request.arguments) else True

        if doc:
            template = self.application.settings.get("api_template", None)

            docs = self.__doc__

            if template:
                self.render(template, docs=docs)
                return
            else:
                self.write(docs)
                return

        pass

        return method(self, *args, **kwargs)

    return wrapper


def api(method):
    """
    create api controller
    """

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):

        if self.debug:

            doc = False if len(self.request.arguments) else True

            if doc:
                template = self.application.settings.get("api_template", None)

                docs = self.__doc__

                if template:
                    self.render(template, docs=docs)
                    return
                else:
                    self.write(docs)
                    return

        pass

        return method(self, *args, **kwargs)

    return wrapper


def model(method):
    """
    create protocol data
    """

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):
        self.handler = args[0]

        self.db = self.handler.db
        self.acct_db = self.handler.acct_db
        self.statsd = self.handler.statsd

        self.debug = self.handler.debug

        if hasattr(self.handler, "dbs"):
            self.dbs = self.handler.dbs

        if hasattr(self.handler, "cache_db"):
            self.cache_db = self.handler.cache_db

        return method(self, *args, **kwargs)

    return wrapper


def protocol(method):
    """
    create protocol data
    """

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):
        args, varargs, keywords, defaults = inspect.getargspec(method)

        aa = dict(zip(args[-len(defaults):], defaults))
        aa.update(kwargs)

        for k, v in aa.items():
            setattr(self, k, v)

        return method(self)

    return wrapper


def detect_browser(method):
    """

    :param method:
    :return:
    """


    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):
        self.browser_type = "mobile"

        regex = r"(nokia|iphone|android|motorola|^mot\-|softbank|foma|docomo|kddi|up\.browser|up\.link|" \
                "htc|dopod|blazer|netfront|helio|hosin|huawei|novarra|CoolPad|webos|techfaith|palmsource|" \
                "blackberry|alcatel|amoi|ktouch|nexian|samsung|^sam\-|s[cg]h|^lge|ericsson|philips|sagem|wellcom|bunjalloo|maui|" \
                "symbian|smartphone|midp|wap|phone|windows ce|iemobile|^spice|^bird|^zte\-|longcos|pantech|gionee|^sie\-|portalmmm|" \
                "jig\sbrowser|hiptop|^ucweb|^benq|haier|^lct|opera\s*mobi|opera\*mini|320×320|240×320|176×220" \
                ")"

        user_agent = self.request.headers.get('User-Agent')

        result = re.search(regex, user_agent, re.I)

        if result:
            self.browser_type = "mobile"
        else:
            self.browser_type = "desktop"

        return method(self, *args, **kwargs)


    return wrapper


def detect_ie(method):
    """
    ie 678
    :return:
    """

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):
        user_agent = self.request.headers.get('User-Agent')

        if user_agent.find("MSIE 6") > -1:
            self.hacking_ie = 6
        elif user_agent.find("MSIE 7") > -1:
            self.hacking_ie = 7
        elif user_agent.find("MSIE 8") > -1:
            self.hacking_ie = 8

        return method(self, *args, **kwargs)

    return wrapper



def io_init(method):

    @functools.wraps(method)
    def wrapper(self, *args, **kwargs):



        return method(self, *args, **kwargs)

    return wrapper


    pass



class RequestHandler(tornado.web.RequestHandler):
    def __init__(self, application, request, **kwargs):
        '''
        a lot of code copy from tornado,because we must make sure self.initialize execute at last
        :param application:
        :param request:
        :param kwargs:
        :return:
        '''

        self.application = application
        self.request = request
        self._headers_written = False
        self._finished = False
        self._auto_finish = True
        self._transforms = None  # will be set in _execute
        self._prepared_future = None
        self.path_args = None
        self.path_kwargs = None
        self.ui = ObjectDict((n, self._ui_method(m)) for n, m in
                             application.ui_methods.items())



        # ez-hack

        self.debug = self.application.settings.get('debug', False)
        self.css_debug = self.application.settings.get('css_debug', False)
        self.js_debug = self.application.settings.get('js_debug', False)

        self.cdn = self.application.settings.get('cdn', '')
        self.browser_type = self.application.settings.get('browser_default_type', 'mobile')
        self.auth_callback = self.application.settings.get('auth_callback', NotImplemented)

        self.db = self.application.settings.get('db', NotImplemented)
        # self.acct_db = self.application.settings.get('acct_db', NotImplemented)

        self.cache_db = self.application.settings.get('cache_db', NotImplemented)
        self.session = self.application.settings.get('session', NotImplemented)

        #
        # self.files_db = self.application.settings.get('files_db', NotImplemented)
        # self.dbs = self.application.settings.get('dbs', NotImplemented)


        # self.statsd = self.application.settings.get('statsd', NotImplemented)

        # mail client
        # _smtp_config = self.application.settings.get('smtp')
        #
        # if _smtp_config:
        #     self.smtp = MailClient2(_smtp_config)
        # else:
        #     self.smtp = None

        self.smtp=None
        # self.db = None
        self.acct_db = None
        # self.cache_db=None
        # self.session=None
        self.files_db=None
        self.dbs=None

        self.statsd=None


        self.locale_callback = self.application.settings.get('locale_callback', NotImplemented)

        self.hacking_ie = None

        # maybe not a good design
        # self.template_urls = self.application.settings.get('template_urls', NotImplemented)
        # self.template_keys = self.application.settings.get('template_keys', NotImplemented)

        self.api_messages = self.application.settings.get('api_messages', {})

        self.project_version = self.application.settings.get('version', None)
        self.project_name = self.application.settings.get('project', {}).get('name', '')
        self.project_desc = self.application.settings.get('project', {}).get('desc', '')
        self.project_keywords = self.application.settings.get('project', {}).get('keywords', '')

        self.css_version = self.application.settings.get('css_version', str(int(time())))
        self.js_version = self.application.settings.get('js_version', str(int(time())))

        self.favicon = self.application.settings.get('favicon', "/static/favicon.ico")
        self.copyright_text = self.application.settings.get('copyright_text', '')
        self.copyright = self.application.settings.get('copyright', '')
        self.author = self.application.settings.get('author', '')







        # UIModules are available as both `modules` and `_tt_modules` in the
        # template namespace.  Historically only `modules` was available
        # but could be clobbered by user additions to the namespace.
        # The template {% module %} directive looks in `_tt_modules` to avoid
        # possible conflicts.
        self.ui["_tt_modules"] = _UIModuleNamespace(self,
                                                    application.ui_modules)
        self.ui["modules"] = self.ui["_tt_modules"]
        self.clear()
        self.request.connection.set_close_callback(self.on_connection_close)
        self.initialize(**kwargs)
        pass


    # def initialize(self):
    # self.debug = None
    #     self.css_debug = None
    #     self.js_debug = None
    #
    #
    #     self.cdn = None
    #     self.browser_type = None
    #     self.db = None
    #     self.acct_db = None
    #     self.auth_callback = None
    #
    #     self.message_queue = None
    #     self.queue_config = None
    #
    #     self.cache_db = None
    #     self.cache_config = None
    #
    #     self.files_db = None
    #     self.dbs = None
    #
    #     self.db_refer = None
    #
    #     self.session = None
    #     self.statsd = None
    #
    #     self.locale_callback = None
    #
    #     self.hacking_ie = None
    #
    #     # maybe not a good design
    #     # self.template_urls = None
    #     # self.template_keys = None
    #
    #     self.api_messages = None
    #
    #     self.project_version = None
    #     self.project_name = None
    #     self.project_desc = None
    #     self.project_keywords = None
    #
    #     self.css_version = None
    #     self.js_version = None
    #
    #
    #     self.favicon = None
    #     self.copyright_text = None
    #     self.copyright = None
    #     self.author = None
    #
    #
    #     #mail client
    #     _smtp_config = None
    #
    #     if _smtp_config:
    #         self.smtp = None
    #     else:
    #         self.smtp = None
    #
    #     # ez-hack-end
    #
    #     pass


    def get_current_user(self):
        '''
        use user custom auth function if set.
        :return:
        '''
        if self.auth_callback:
            return self.auth_callback(self)
        return None


    def get_user_locale(self):
        """Override to determine the locale from the authenticated user.

        If None is returned, we fall back to `get_browser_locale()`.

        This method should return a `tornado.locale.Locale` object,
        most likely obtained via a call like ``tornado.locale.get("en")``
        """

        if self.locale_callback:
            return self.locale_callback(self)
        return None


    def get_template_namespace(self):
        '''
        Add other namespace
        :return:
        '''

        namespace = super(RequestHandler, self).get_template_namespace()

        namespace.update({
            'cdn': self.cdn,
            'hacking_ie': self.hacking_ie,
            'debug': int(self.debug),
            'project_version': self.project_version,
            'project_name': self.project_name,
            'project_desc': self.project_desc,
            'project_keywords': self.project_keywords,
            'author': self.author,
            'copyright': self.copyright,
            'copyright_text': self.copyright_text,
            'js_version': self.js_version,
            'css_version': self.css_version,
            'js_debug': self.js_debug,
            'css_debug': self.css_debug
        })

        return namespace


    def api_write(self, status, messages=None, jsonp=None, **kwargs):
        """
        @todo we can add wrap to log api dump
        :param status: status code
        :param messages: messages
        :param kwargs: extra-data
        :return:None
        """

        messages = messages if messages is not None else self.api_messages

        data = dict(status=status)

        if messages:
            data['msg'] = self.locale.translate(messages.get(status))

        data.update(kwargs)

        if jsonp:
            self.set_header('Content-Type', 'application/javascript')
            self.write(jsonp + '(' + json_encode(data) + ');')
        else:
            self.set_header('Content-Type', 'application/json')
            self.write(json_encode(data))

        pass


    def compute_etag(self):

        self.set_header('Server', 'Next')
        return None


    def static_url(self, path, **kwargs):


        self.require_setting("static_path", "static_url")
        get_url = self.settings.get("static_handler_class",
                                    StaticFileHandler).make_static_url

        return self.cdn + get_url(self.settings, path, **kwargs)
        pass


    def post_redirect(self, url, msg, breadcrumbs=[], recommend=[], *args, **kwargs):

        """
        don't use get to set argument
        :param url:
        :param data:
        :return:
        """

        # 基于html的方式很容易被攻击者伪造
        # data_str = ''
        #
        # for k, v in data.items():
        # if isinstance(v, list):
        # for vv in v:
        # data_str += k + '[]=' + xhtml_escape(vv) + '&'
        # else:
        # data_str += k + '=' + xhtml_escape(v) + '&'
        # pass
        #
        # data_str.strip('&')
        #
        # if url.find('?') == -1:
        # url += '?'
        # else:
        # url += '&'
        #
        # redirect_url = url + data_str

        try:
            breads_title, breads_url = zip(*breadcrumbs)
            self.set_cookie('rt_breads_title', url_escape('|'.join(breads_title)))
            self.set_cookie('rt_breads_url', url_escape('|'.join(breads_url)))
        except:
            pass

        try:
            rec_title, rec_url = zip(*(recommend))
            self.set_cookie('rt_rec_title', url_escape('|'.join(rec_title)))
            self.set_cookie('rt_rec_url', url_escape('|'.join(rec_url)))
        except:
            pass

        for k, v in kwargs.items():
            if isinstance(v, list):
                self.set_cookie('rt_' + k, url_escape('|'.join(v)))
            else:
                self.set_cookie('rt_' + k, url_escape(v))
            pass

        self.set_cookie('rt_msg', url_escape(msg))
        self.redirect(url)
        pass


    @detect_ie
    @detect_browser
    def render(self, template_name, **kwargs):
        template_name = template_name.format(self.browser_type)
        return super(RequestHandler, self).render(template_name, **kwargs)


pass




