# -*- coding: utf-8 -*-


from tornado.template import Loader
from email.mime.text import MIMEText
import smtplib


class MailClient(object):
    def __init__(self, subject, application, **kwargs):
        self.server = application.get('server')
        self.port = application.get('port', 465)
        self.mail_from = application.get('mail_from')
        self.user = application.get('user')
        self.password = application.get('password')

        self.subject = subject

        self.debug = application.get('debug', False)

        self.template_root = application.get('template_root')
        self.template_file = application.get('template_file')

        self.template = Loader(self.template_root).load(self.template_file)

        self.mime_text = application.get('mime_text', 'html')
        self.charset = application.get('charset', 'utf-8')
        # self.timeout = application.get('timeout', 10)
        pass


    def send(self, mail_to, **kwargs):
        content = self.template.generate(**kwargs)
        msg = MIMEText(content, self.mime_text, self.charset)
        msg['Subject'] = self.subject
        msg['From'] = self.mail_from
        msg['To'] = mail_to

        smtp = smtplib.SMTP()
        smtp.connect(self.server, self.port)
        smtp.login(self.user, self.password)
        smtp.sendmail(self.mail_from, mail_to, msg.as_string())

        if self.debug:
            print("Success in sending email to %s" % mail_to)

        smtp.quit()

