from functools import wraps

def arg_expect_wrapped(f):
    """Transform a function that takes its arguments in an array into one that
takes position arguments. This does not affect **kwargs"""

    @wraps(f)
    def wrapped(*args, **kwargs):
        return f(args, **kwargs)
    return wrapped

def arg_expect_unwrapped(f):
    """Transform a function that takes positional arguments into into one that
takes its arguments in an array. This does not affect **kwargs"""

    @wraps(f)
    def wrapped(args, **kwargs):
        return f(*args, **kwargs)
    return wrapped
