#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# ***** BEGIN LICENSE BLOCK *****
# Copyright (C) 2012-2014  Hayaki Saito <user@zuse.jp>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ***** END LICENSE BLOCK *****

'''
Reference:

- Xterm Control Sequences
  http://invisible-island.net/xterm/ctlseqs/ctlseqs.html

- TeraTerm / Supported Control Functions
  http://ttssh2.sourceforge.jp/manual/en/about/ctrlseq.html

- MinTTY / Mintty-specific control sequences
  http://code.google.com/p/mintty/wiki/CtrlSeqs

- RLogin / Supported control codes
  http://nanno.dip.jp/softlib/man/rlogin/ctrlcode.html

- Private Control Functions used by DEC
  http://vt100.net/emu/ctrlfunc_dec.html

'''

_SEQDB = {
    """ input """
    '< <NUL>'            : 'NUL / Ctrl-@, Ctrl-SP, Ctrl-2',
    '< <SOH>'            : 'SOH / Ctrl-A',
    '< <STX>'            : 'STX / Ctrl-B',
    '< <ETX>'            : 'ETX / Ctrl-C',
    '< <EOT>'            : 'EOT / Ctrl-D',
    '< <ENQ>'            : 'ENQ / Ctrl-E',
    '< <ACK>'            : 'ACK / Ctrl-F',
    '< <BEL>'            : 'BEL / Ctrl-G',
    '< <BS>'             : 'BS / Ctrl-H,may be Backspace key',
    '< <HT>'             : 'HT / Ctrl-I,may be Tab key',
    '< <NL>'             : 'NL / Ctrl-J',
    '< <VT>'             : 'VT / Ctrl-K',
    '< <NP>'             : 'NP / Ctrl-L',
    '< <CR>'             : 'CR / Ctrl-M',
    '< <SO>'             : 'SO / Ctrl-N',
    '< <DLE>'            : 'DLE / Ctrl-P',
    '< <DC1>'            : 'DC1 / Ctrl-Q',
    '< <DC2>'            : 'DC2 / Ctrl-R',
    '< <DC3>'            : 'DC3 / Ctrl-S',
    '< <DC4>'            : 'DC4 / Ctrl-T',
    '< <NAK>'            : 'NAK / Ctrl-U',
    '< <SYN>'            : 'SYN / Ctrl-V',
    '< <ETB>'            : 'ETB / Ctrl-W',
    '< <CAN>'            : 'CAN / Ctrl-X',
    '< <EM>'             : 'EM / Ctrl-Y',
    '< <SUB>'            : 'SUB / Ctrl-Z',
    '< <ESC>'            : 'ESC / Ctrl-[, Ctrl-3,  or Escape key',
    '< <FS> '            : 'FS / Ctrl-\\, Ctrl-4',
    '< <GS>'             : 'GS / Ctrl-], Ctrl-5',
    '< <RS>'             : 'RS / Ctrl-^, Ctrl-6',
    '< <US>'             : 'US / Ctrl-_, Ctrl-7',
    '< <DEL>'            : 'DEL / Ctrl-8 or Delete key',
    '< ESC P<ST>'        : 'DCS / device control string',
    '< ESC P$r<ST>'      : 'DECRPSS / report selection or setting',
    '< ESC P$r$}<ST>'    : 'DECRPSS / report DECSASD (Select Active Status Display) status',
    '< ESC P$r*x<ST>'    : 'DECRPSS / report DECSACE (Select Attribute Change Extent) status',
    '< ESC P$r"q<ST>'    : 'DECRPSS / report DECSCA (Set Character Attribute) status',
    '< ESC P$r"p<ST>'    : 'DECRPSS / report DECSCL (Set Conformance Level) status',
    '< ESC P$r$|<ST>'    : 'DECRPSS / report DECSCPP (Set Columns Per Page) status',
    '< ESC P$rt<ST>'     : 'DECRPSS / report DECSLPP (Set Lines Per Page) status',
    '< ESC P$r*|<ST>'    : 'DECRPSS / report DECSNLS (Set Number of Lines per Screen) status',
    '< ESC P$r$~<ST>'    : 'DECRPSS / report DECSSDT (Set Status Line Type) status',
    '< ESC P$rs<ST>'     : 'DECRPSS / report DECSLRM (Set Left and Right Margins) status',
    '< ESC P$rr<ST>'     : 'DECRPSS / report DECSTBM (Set Top and Bottom Margins) status',
    '< ESC P$rm<ST>'     : 'DECRPSS / report SGR (Set Graphic Rendition) status',
    '< ESC P$rp<ST>'     : 'DECRPSS / report DECSSL (Select Set-Up Language) status',
    '< ESC P$r$s<ST>'    : 'DECRPSS / report DECSPRTT (Select Printer Type) status',
    '< ESC P$r"t<ST>'    : 'DECRPSS / report DECSRFR (Select Refresh Rate) status',
    '< ESC P$r(p<ST>'    : 'DECRPSS / report DECSDPT (Select Digital Printed Data Type) status',
    '< ESC P$r*p<ST>'    : 'DECRPSS / report DECSPPCS (Select ProPrinter Character Set) status',
    '< ESC P$r*r<ST>'    : 'DECRPSS / report DECSCS (Select Communication Speed) status',
    '< ESC P$r*u<ST>'    : 'DECRPSS / report DECSCP (Select Communication Port) status',
    '< ESC P$r p<ST>'    : 'DECRPSS / report DECSSCLS (Set Scroll Speed) status',
    '< ESC P$r q<ST>'    : 'DECRPSS / report DECSCUSR (Set Cursor Style) status',
    '< ESC P$r r<ST>'    : 'DECRPSS / report DECSKCV (Set Key Click Volume) status',
    '< ESC P$r t<ST>'    : 'DECRPSS / report DECSWBV (Set Warning Bell Volume) status',
    '< ESC P$r u<ST>'    : 'DECRPSS / report DECSMBV (Set Margin Bell Volume) status',
    '< ESC P$r v<ST>'    : 'DECRPSS / report DECSLCK (Set Lock Key Style) status',
    '< ESC P$r*s<ST>'    : 'DECRPSS / report DECSFC (Select Flow Control Type) status',
    '< ESC P$r$q<ST>'    : 'DECRPSS / report DECSDDT (Select Disconnect Delay Time) status',
    '< ESC P$r"u<ST>'    : 'DECRPSS / report DECSTRL (Set Transmit Rate Limit) status',
    '< ESC P$r+w<ST>'    : 'DECRPSS / report DECSPP (Set Port Parameter) status',
    '< ESC P+r<ST>'      : 'response for termcap query',
    '< ESC P0+r<ST>'     : 'error resopnse for termcap query',
    '< ESC P1+r<ST>'     : 'answer for termcap query',
    '< ESC P0+r6277<ST>' : 'error response for termcap query bw (auto_left_margin)',
    '< ESC P0+r616d<ST>' : 'error response for termcap query am (auto_right_margin)',
    '< ESC P0+r7574<ST>' : 'error response for termcap query ut (back_color_erase)',
    '< ESC P0+r6363<ST>' : 'error response for termcap query cc (can_change)',
    '< ESC P0+r7873<ST>' : 'error response for termcap query xs (ceol_standout_glitch)',
    '< ESC P0+r5941<ST>' : 'error response for termcap query YA (col_addr_glitch)',
    '< ESC P0+r5946<ST>' : 'error response for termcap query YF (cpi_changes_res)',
    '< ESC P0+r5942<ST>' : 'error response for termcap query YB (cr_cancels_micro_mode)',
    '< ESC P0+r7874<ST>' : 'error response for termcap query xt (dest_tabs_magic_smso)',
    '< ESC P0+r786e<ST>' : 'error response for termcap query xn (eat_newline_glitch)',
    '< ESC P0+r656f<ST>' : 'error response for termcap query eo (erase_overstrike)',
    '< ESC P0+r676e<ST>' : 'error response for termcap query gn (generic_type)',
    '< ESC P0+r6863<ST>' : 'error response for termcap query hc (hard_copy)',
    '< ESC P0+r4843<ST>' : 'error response for termcap query HC (hard_cursor)',
    '< ESC P0+r6b6d<ST>' : 'error response for termcap query km (has_meta_key)',
    '< ESC P0+r5943<ST>' : 'error response for termcap query YC (has_print_wheel)',
    '< ESC P0+r6873<ST>' : 'error response for termcap query hs (has_status_line)',
    '< ESC P0+r686c<ST>' : 'error response for termcap query hl (hue_lightness_saturation)',
    '< ESC P0+r696e<ST>' : 'error response for termcap query in (insert_null_glitch)',
    '< ESC P0+r5947<ST>' : 'error response for termcap query YG (lpi_changes_res)',
    '< ESC P0+r6461<ST>' : 'error response for termcap query da (memory_above)',
    '< ESC P0+r6462<ST>' : 'error response for termcap query db (memory_below)',
    '< ESC P0+r6d69<ST>' : 'error response for termcap query mi (move_insert_mode)',
    '< ESC P0+r6d73<ST>' : 'error response for termcap query ms (move_standout_mode)',
    '< ESC P0+r6e78<ST>' : 'error response for termcap query nx (needs_xon_xoff)',
    '< ESC P0+r7862<ST>' : 'error response for termcap query xb (no_esc_ctlc)',
    '< ESC P0+r4e50<ST>' : 'error response for termcap query NP (no_pad_char)',
    '< ESC P0+r4e44<ST>' : 'error response for termcap query ND (non_dest_scroll_region)',
    '< ESC P0+r4e52<ST>' : 'error response for termcap query NR (non_rev_rmcup)',
    '< ESC P0+r6f73<ST>' : 'error response for termcap query os (over_strike)',
    '< ESC P0+r3569<ST>' : 'error response for termcap query 5i (prtr_silent)',
    '< ESC P0+r5944<ST>' : 'error response for termcap query YD (row_addr_glitch)',
    '< ESC P0+r5945<ST>' : 'error response for termcap query YE (semi_auto_right_margin)',
    '< ESC P0+r6573<ST>' : 'error response for termcap query es (status_line_esc_ok)',
    '< ESC P0+r687a<ST>' : 'error response for termcap query hz (tilde_glitch)',
    '< ESC P0+r756c<ST>' : 'error response for termcap query ul (transparent_underline)',
    '< ESC P0+r786f<ST>' : 'error response for termcap query xo (xon_xoff)',
    '< ESC P0+r636f<ST>' : 'error response for termcap query co (columns)',
    '< ESC P0+r6974<ST>' : 'error response for termcap query it (init_tabs)',
    '< ESC P0+r6c68<ST>' : 'error response for termcap query lh (label_height)',
    '< ESC P0+r6c77<ST>' : 'error response for termcap query lw (label_width)',
    '< ESC P0+r6c69<ST>' : 'error response for termcap query li (lines)',
    '< ESC P0+r6c6d<ST>' : 'error response for termcap query lm (lines_of_memory)',
    '< ESC P0+r7367<ST>' : 'error response for termcap query sg (magic_cookie_glitch)',
    '< ESC P0+r6d61<ST>' : 'error response for termcap query ma (max_attributes)',
    '< ESC P0+r436f<ST>' : 'error response for termcap query Co (max_colors)',
    '< ESC P0+r7061<ST>' : 'error response for termcap query pa (max_pairs)',
    '< ESC P0+r4d57<ST>' : 'error response for termcap query MW (maximum_windows)',
    '< ESC P0+r4e43<ST>' : 'error response for termcap query NC (no_color_video)',
    '< ESC P0+r4e6c<ST>' : 'error response for termcap query Nl (num_labels)',
    '< ESC P0+r7062<ST>' : 'error response for termcap query pb (padding_baud_rate)',
    '< ESC P0+r7674<ST>' : 'error response for termcap query vt (virtual_terminal)',
    '< ESC P0+r7773<ST>' : 'error response for termcap query ws (width_status_line)',
    '< ESC P0+r596f<ST>' : 'error response for termcap query Yo (bit_image_entwining)',
    '< ESC P0+r5970<ST>' : 'error response for termcap query Yp (bit_image_type)',
    '< ESC P0+r5961<ST>' : 'error response for termcap query Ya (buffer_capacity)',
    '< ESC P0+r4254<ST>' : 'error response for termcap query BT (buttons)',
    '< ESC P0+r5963<ST>' : 'error response for termcap query Yc (dot_horz_spacing)',
    '< ESC P0+r5962<ST>' : 'error response for termcap query Yb (dot_vert_spacing)',
    '< ESC P0+r5964<ST>' : 'error response for termcap query Yd (max_micro_address)',
    '< ESC P0+r5965<ST>' : 'error response for termcap query Ye (max_micro_jump)',
    '< ESC P0+r5966<ST>' : 'error response for termcap query Yf (micro_col_size)',
    '< ESC P0+r5967<ST>' : 'error response for termcap query Yg (micro_line_size)',
    '< ESC P0+r5968<ST>' : 'error response for termcap query Yh (number_of_pins)',
    '< ESC P0+r5969<ST>' : 'error response for termcap query Yi (output_res_char)',
    '< ESC P0+r596b<ST>' : 'error response for termcap query Yk (output_res_horz_inch)',
    '< ESC P0+r596a<ST>' : 'error response for termcap query Yj (output_res_line)',
    '< ESC P0+r596c<ST>' : 'error response for termcap query Yl (output_res_vert_inch)',
    '< ESC P0+r596d<ST>' : 'error response for termcap query Ym (print_rate)',
    '< ESC P0+r596e<ST>' : 'error response for termcap query Yn (wide_char_size)',
    '< ESC P0+r6163<ST>' : 'error response for termcap query ac (acs_chars)',
    '< ESC P0+r6274<ST>' : 'error response for termcap query bt (back_tab)',
    '< ESC P0+r626c<ST>' : 'error response for termcap query bl (bell)',
    '< ESC P0+r6372<ST>' : 'error response for termcap query cr (carriage_return)',
    '< ESC P0+r5a41<ST>' : 'error response for termcap query ZA (change_char_pitch)',
    '< ESC P0+r5a42<ST>' : 'error response for termcap query ZB (change_line_pitch)',
    '< ESC P0+r5a43<ST>' : 'error response for termcap query ZC (change_res_horz)',
    '< ESC P0+r5a44<ST>' : 'error response for termcap query ZD (change_res_vert)',
    '< ESC P0+r6373<ST>' : 'error response for termcap query cs (change_scroll_region)',
    '< ESC P0+r7250<ST>' : 'error response for termcap query rP (char_padding)',
    '< ESC P0+r6374<ST>' : 'error response for termcap query ct (clear_all_tabs)',
    '< ESC P0+r4d43<ST>' : 'error response for termcap query MC (clear_margins)',
    '< ESC P0+r636c<ST>' : 'error response for termcap query cl (clear_screen)',
    '< ESC P0+r6362<ST>' : 'error response for termcap query cb (clr_bol)',
    '< ESC P0+r6365<ST>' : 'error response for termcap query ce (clr_eol)',
    '< ESC P0+r6364<ST>' : 'error response for termcap query cd (clr_eos)',
    '< ESC P0+r6368<ST>' : 'error response for termcap query ch (column_address)',
    '< ESC P0+r4343<ST>' : 'error response for termcap query CC (command_character)',
    '< ESC P0+r4357<ST>' : 'error response for termcap query CW (create_window)',
    '< ESC P0+r636d<ST>' : 'error response for termcap query cm (cursor_address)',
    '< ESC P0+r646f<ST>' : 'error response for termcap query do (cursor_down)',
    '< ESC P0+r686f<ST>' : 'error response for termcap query ho (cursor_home)',
    '< ESC P0+r7669<ST>' : 'error response for termcap query vi (cursor_invisible)',
    '< ESC P0+r6c65<ST>' : 'error response for termcap query le (cursor_left)',
    '< ESC P0+r434d<ST>' : 'error response for termcap query CM (cursor_mem_address)',
    '< ESC P0+r7665<ST>' : 'error response for termcap query ve (cursor_normal)',
    '< ESC P0+r6e64<ST>' : 'error response for termcap query nd (cursor_right)',
    '< ESC P0+r6c6c<ST>' : 'error response for termcap query ll (cursor_to_ll)',
    '< ESC P0+r7570<ST>' : 'error response for termcap query up (cursor_up)',
    '< ESC P0+r7673<ST>' : 'error response for termcap query vs (cursor_visible)',
    '< ESC P0+r5a45<ST>' : 'error response for termcap query ZE (define_char)',
    '< ESC P0+r6463<ST>' : 'error response for termcap query dc (delete_character)',
    '< ESC P0+r646c<ST>' : 'error response for termcap query dl (delete_line)',
    '< ESC P0+r4449<ST>' : 'error response for termcap query DI (dial_phone)',
    '< ESC P0+r6473<ST>' : 'error response for termcap query ds (dis_status_line)',
    '< ESC P0+r444b<ST>' : 'error response for termcap query DK (display_clock)',
    '< ESC P0+r6864<ST>' : 'error response for termcap query hd (down_half_line)',
    '< ESC P0+r6541<ST>' : 'error response for termcap query eA (ena_acs)',
    '< ESC P0+r6173<ST>' : 'error response for termcap query as (enter_alt_charset_mode)',
    '< ESC P0+r5341<ST>' : 'error response for termcap query SA (enter_am_mode)',
    '< ESC P0+r6d62<ST>' : 'error response for termcap query mb (enter_blink_mode)',
    '< ESC P0+r6d64<ST>' : 'error response for termcap query md (enter_bold_mode)',
    '< ESC P0+r7469<ST>' : 'error response for termcap query ti (enter_ca_mode)',
    '< ESC P0+r646d<ST>' : 'error response for termcap query dm (enter_delete_mode)',
    '< ESC P0+r6d68<ST>' : 'error response for termcap query mh (enter_dim_mode)',
    '< ESC P0+r5a46<ST>' : 'error response for termcap query ZF (enter_doublewide_mode)',
    '< ESC P0+r5a47<ST>' : 'error response for termcap query ZG (enter_draft_quality)',
    '< ESC P0+r696d<ST>' : 'error response for termcap query im (enter_insert_mode)',
    '< ESC P0+r5a48<ST>' : 'error response for termcap query ZH (enter_italics_mode)',
    '< ESC P0+r5a49<ST>' : 'error response for termcap query ZI (enter_leftward_mode)',
    '< ESC P0+r5a4a<ST>' : 'error response for termcap query ZJ (enter_micro_mode)',
    '< ESC P0+r5a4b<ST>' : 'error response for termcap query ZK (enter_near_letter_quality)',
    '< ESC P0+r5a4c<ST>' : 'error response for termcap query ZL (enter_normal_quality)',
    '< ESC P0+r6d70<ST>' : 'error response for termcap query mp (enter_protected_mode)',
    '< ESC P0+r6d72<ST>' : 'error response for termcap query mr (enter_reverse_mode)',
    '< ESC P0+r6d6b<ST>' : 'error response for termcap query mk (enter_secure_mode)',
    '< ESC P0+r5a4d<ST>' : 'error response for termcap query ZM (enter_shadow_mode)',
    '< ESC P0+r736f<ST>' : 'error response for termcap query so (enter_standout_mode)',
    '< ESC P0+r5a4e<ST>' : 'error response for termcap query ZN (enter_subscript_mode)',
    '< ESC P0+r5a4f<ST>' : 'error response for termcap query ZO (enter_superscript_mode)',
    '< ESC P0+r7573<ST>' : 'error response for termcap query us (enter_underline_mode)',
    '< ESC P0+r5a50<ST>' : 'error response for termcap query ZP (enter_upward_mode)',
    '< ESC P0+r5358<ST>' : 'error response for termcap query SX (enter_xon_mode)',
    '< ESC P0+r6563<ST>' : 'error response for termcap query ec (erase_chars)',
    '< ESC P0+r6165<ST>' : 'error response for termcap query ae (exit_alt_charset_mode)',
    '< ESC P0+r5241<ST>' : 'error response for termcap query RA (exit_am_mode)',
    '< ESC P0+r6d65<ST>' : 'error response for termcap query me (exit_attribute_mode)',
    '< ESC P0+r7465<ST>' : 'error response for termcap query te (exit_ca_mode)',
    '< ESC P0+r6564<ST>' : 'error response for termcap query ed (exit_delete_mode)',
    '< ESC P0+r5a51<ST>' : 'error response for termcap query ZQ (exit_doublewide_mode)',
    '< ESC P0+r6569<ST>' : 'error response for termcap query ei (exit_insert_mode)',
    '< ESC P0+r5a52<ST>' : 'error response for termcap query ZR (exit_italics_mode)',
    '< ESC P0+r5a53<ST>' : 'error response for termcap query ZS (exit_leftward_mode)',
    '< ESC P0+r5a54<ST>' : 'error response for termcap query ZT (exit_micro_mode)',
    '< ESC P0+r5a55<ST>' : 'error response for termcap query ZU (exit_shadow_mode)',
    '< ESC P0+r7365<ST>' : 'error response for termcap query se (exit_standout_mode)',
    '< ESC P0+r5a56<ST>' : 'error response for termcap query ZV (exit_subscript_mode)',
    '< ESC P0+r5a57<ST>' : 'error response for termcap query ZW (exit_superscript_mode)',
    '< ESC P0+r7565<ST>' : 'error response for termcap query ue (exit_underline_mode)',
    '< ESC P0+r5a58<ST>' : 'error response for termcap query ZX (exit_upward_mode)',
    '< ESC P0+r5258<ST>' : 'error response for termcap query RX (exit_xon_mode)',
    '< ESC P0+r5041<ST>' : 'error response for termcap query PA (fixed_pause)',
    '< ESC P0+r6668<ST>' : 'error response for termcap query fh (flash_hook)',
    '< ESC P0+r7662<ST>' : 'error response for termcap query vb (flash_screen)',
    '< ESC P0+r6666<ST>' : 'error response for termcap query ff (form_feed)',
    '< ESC P0+r6673<ST>' : 'error response for termcap query fs (from_status_line)',
    '< ESC P0+r5747<ST>' : 'error response for termcap query WG (goto_window)',
    '< ESC P0+r4855<ST>' : 'error response for termcap query HU (hangup)',
    '< ESC P0+r6931<ST>' : 'error response for termcap query i1 (init_1string)',
    '< ESC P0+r6973<ST>' : 'error response for termcap query is (init_2string)',
    '< ESC P0+r6933<ST>' : 'error response for termcap query i3 (init_3string)',
    '< ESC P0+r6966<ST>' : 'error response for termcap query if (init_file)',
    '< ESC P0+r6950<ST>' : 'error response for termcap query iP (init_prog)',
    '< ESC P0+r4963<ST>' : 'error response for termcap query Ic (initialize_color)',
    '< ESC P0+r4970<ST>' : 'error response for termcap query Ip (initialize_pair)',
    '< ESC P0+r6963<ST>' : 'error response for termcap query ic (insert_character)',
    '< ESC P0+r616c<ST>' : 'error response for termcap query al (insert_line)',
    '< ESC P0+r6970<ST>' : 'error response for termcap query ip (insert_padding)',
    '< ESC P0+r4b31<ST>' : 'error response for termcap query K1 (key_a1)',
    '< ESC P0+r4b33<ST>' : 'error response for termcap query K3 (key_a3)',
    '< ESC P0+r4b32<ST>' : 'error response for termcap query K2 (key_b2)',
    '< ESC P0+r6b62<ST>' : 'error response for termcap query kb (key_backspace)',
    '< ESC P0+r4031<ST>' : 'error response for termcap query @1 (key_beg)',
    '< ESC P0+r6b42<ST>' : 'error response for termcap query kB (key_btab)',
    '< ESC P0+r4b34<ST>' : 'error response for termcap query K4 (key_c1)',
    '< ESC P0+r4b35<ST>' : 'error response for termcap query K5 (key_c3)',
    '< ESC P0+r4032<ST>' : 'error response for termcap query @2 (key_cancel)',
    '< ESC P0+r6b61<ST>' : 'error response for termcap query ka (key_catab)',
    '< ESC P0+r6b43<ST>' : 'error response for termcap query kC (key_clear)',
    '< ESC P0+r4033<ST>' : 'error response for termcap query @3 (key_close)',
    '< ESC P0+r4034<ST>' : 'error response for termcap query @4 (key_command)',
    '< ESC P0+r4035<ST>' : 'error response for termcap query @5 (key_copy)',
    '< ESC P0+r4036<ST>' : 'error response for termcap query @6 (key_create)',
    '< ESC P0+r6b74<ST>' : 'error response for termcap query kt (key_ctab)',
    '< ESC P0+r6b44<ST>' : 'error response for termcap query kD (key_dc)',
    '< ESC P0+r6b4c<ST>' : 'error response for termcap query kL (key_dl)',
    '< ESC P0+r6b64<ST>' : 'error response for termcap query kd (key_down)',
    '< ESC P0+r6b4d<ST>' : 'error response for termcap query kM (key_eic)',
    '< ESC P0+r4037<ST>' : 'error response for termcap query @7 (key_end)',
    '< ESC P0+r4038<ST>' : 'error response for termcap query @8 (key_enter)',
    '< ESC P0+r6b45<ST>' : 'error response for termcap query kE (key_eol)',
    '< ESC P0+r6b53<ST>' : 'error response for termcap query kS (key_eos)',
    '< ESC P0+r4039<ST>' : 'error response for termcap query @9 (key_exit)',
    '< ESC P0+r6b30<ST>' : 'error response for termcap query k0 (key_f0)',
    '< ESC P0+r6b31<ST>' : 'error response for termcap query k1 (key_f1)',
    '< ESC P0+r6b3b<ST>' : 'error response for termcap query k; (key_f10)',
    '< ESC P0+r4631<ST>' : 'error response for termcap query F1 (key_f11)',
    '< ESC P0+r4632<ST>' : 'error response for termcap query F2 (key_f12)',
    '< ESC P0+r4633<ST>' : 'error response for termcap query F3 (key_f13)',
    '< ESC P0+r4634<ST>' : 'error response for termcap query F4 (key_f14)',
    '< ESC P0+r4635<ST>' : 'error response for termcap query F5 (key_f15)',
    '< ESC P0+r4636<ST>' : 'error response for termcap query F6 (key_f16)',
    '< ESC P0+r4637<ST>' : 'error response for termcap query F7 (key_f17)',
    '< ESC P0+r4638<ST>' : 'error response for termcap query F8 (key_f18)',
    '< ESC P0+r4639<ST>' : 'error response for termcap query F9 (key_f19)',
    '< ESC P0+r6b32<ST>' : 'error response for termcap query k2 (key_f2)',
    '< ESC P0+r4641<ST>' : 'error response for termcap query FA (key_f20)',
    '< ESC P0+r4642<ST>' : 'error response for termcap query FB (key_f21)',
    '< ESC P0+r4643<ST>' : 'error response for termcap query FC (key_f22)',
    '< ESC P0+r4644<ST>' : 'error response for termcap query FD (key_f23)',
    '< ESC P0+r4645<ST>' : 'error response for termcap query FE (key_f24)',
    '< ESC P0+r4646<ST>' : 'error response for termcap query FF (key_f25)',
    '< ESC P0+r4647<ST>' : 'error response for termcap query FG (key_f26)',
    '< ESC P0+r4648<ST>' : 'error response for termcap query FH (key_f27)',
    '< ESC P0+r4649<ST>' : 'error response for termcap query FI (key_f28)',
    '< ESC P0+r464a<ST>' : 'error response for termcap query FJ (key_f29)',
    '< ESC P0+r6b33<ST>' : 'error response for termcap query k3 (key_f3)',
    '< ESC P0+r464b<ST>' : 'error response for termcap query FK (key_f30)',
    '< ESC P0+r464c<ST>' : 'error response for termcap query FL (key_f31)',
    '< ESC P0+r464d<ST>' : 'error response for termcap query FM (key_f32)',
    '< ESC P0+r464e<ST>' : 'error response for termcap query FN (key_f33)',
    '< ESC P0+r464f<ST>' : 'error response for termcap query FO (key_f34)',
    '< ESC P0+r4650<ST>' : 'error response for termcap query FP (key_f35)',
    '< ESC P0+r4651<ST>' : 'error response for termcap query FQ (key_f36)',
    '< ESC P0+r4652<ST>' : 'error response for termcap query FR (key_f37)',
    '< ESC P0+r4653<ST>' : 'error response for termcap query FS (key_f38)',
    '< ESC P0+r4654<ST>' : 'error response for termcap query FT (key_f39)',
    '< ESC P0+r6b34<ST>' : 'error response for termcap query k4 (key_f4)',
    '< ESC P0+r4655<ST>' : 'error response for termcap query FU (key_f40)',
    '< ESC P0+r4656<ST>' : 'error response for termcap query FV (key_f41)',
    '< ESC P0+r4657<ST>' : 'error response for termcap query FW (key_f42)',
    '< ESC P0+r4658<ST>' : 'error response for termcap query FX (key_f43)',
    '< ESC P0+r4659<ST>' : 'error response for termcap query FY (key_f44)',
    '< ESC P0+r465a<ST>' : 'error response for termcap query FZ (key_f45)',
    '< ESC P0+r4661<ST>' : 'error response for termcap query Fa (key_f46)',
    '< ESC P0+r4662<ST>' : 'error response for termcap query Fb (key_f47)',
    '< ESC P0+r4663<ST>' : 'error response for termcap query Fc (key_f48)',
    '< ESC P0+r4664<ST>' : 'error response for termcap query Fd (key_f49)',
    '< ESC P0+r6b35<ST>' : 'error response for termcap query k5 (key_f5)',
    '< ESC P0+r4665<ST>' : 'error response for termcap query Fe (key_f50)',
    '< ESC P0+r4666<ST>' : 'error response for termcap query Ff (key_f51)',
    '< ESC P0+r4667<ST>' : 'error response for termcap query Fg (key_f52)',
    '< ESC P0+r4668<ST>' : 'error response for termcap query Fh (key_f53)',
    '< ESC P0+r4669<ST>' : 'error response for termcap query Fi (key_f54)',
    '< ESC P0+r466a<ST>' : 'error response for termcap query Fj (key_f55)',
    '< ESC P0+r466b<ST>' : 'error response for termcap query Fk (key_f56)',
    '< ESC P0+r466c<ST>' : 'error response for termcap query Fl (key_f57)',
    '< ESC P0+r466d<ST>' : 'error response for termcap query Fm (key_f58)',
    '< ESC P0+r466e<ST>' : 'error response for termcap query Fn (key_f59)',
    '< ESC P0+r6b36<ST>' : 'error response for termcap query k6 (key_f6)',
    '< ESC P0+r466f<ST>' : 'error response for termcap query Fo (key_f60)',
    '< ESC P0+r4670<ST>' : 'error response for termcap query Fp (key_f61)',
    '< ESC P0+r4671<ST>' : 'error response for termcap query Fq (key_f62)',
    '< ESC P0+r4672<ST>' : 'error response for termcap query Fr (key_f63)',
    '< ESC P0+r6b37<ST>' : 'error response for termcap query k7 (key_f7)',
    '< ESC P0+r6b38<ST>' : 'error response for termcap query k8 (key_f8)',
    '< ESC P0+r6b39<ST>' : 'error response for termcap query k9 (key_f9)',
    '< ESC P0+r4030<ST>' : 'error response for termcap query @0 (key_find)',
    '< ESC P0+r2531<ST>' : 'error response for termcap query %1 (key_help)',
    '< ESC P0+r6b68<ST>' : 'error response for termcap query kh (key_home)',
    '< ESC P0+r6b49<ST>' : 'error response for termcap query kI (key_ic)',
    '< ESC P0+r6b41<ST>' : 'error response for termcap query kA (key_il)',
    '< ESC P0+r6b6c<ST>' : 'error response for termcap query kl (key_left)',
    '< ESC P0+r6b48<ST>' : 'error response for termcap query kH (key_ll)',
    '< ESC P0+r2532<ST>' : 'error response for termcap query %2 (key_mark)',
    '< ESC P0+r2533<ST>' : 'error response for termcap query %3 (key_message)',
    '< ESC P0+r2534<ST>' : 'error response for termcap query %4 (key_move)',
    '< ESC P0+r2535<ST>' : 'error response for termcap query %5 (key_next)',
    '< ESC P0+r6b4e<ST>' : 'error response for termcap query kN (key_npage)',
    '< ESC P0+r2536<ST>' : 'error response for termcap query %6 (key_open)',
    '< ESC P0+r2537<ST>' : 'error response for termcap query %7 (key_options)',
    '< ESC P0+r6b50<ST>' : 'error response for termcap query kP (key_ppage)',
    '< ESC P0+r2538<ST>' : 'error response for termcap query %8 (key_previous)',
    '< ESC P0+r2539<ST>' : 'error response for termcap query %9 (key_print)',
    '< ESC P0+r2530<ST>' : 'error response for termcap query %0 (key_redo)',
    '< ESC P0+r2631<ST>' : 'error response for termcap query &1 (key_reference)',
    '< ESC P0+r2632<ST>' : 'error response for termcap query &2 (key_refresh)',
    '< ESC P0+r2633<ST>' : 'error response for termcap query &3 (key_replace)',
    '< ESC P0+r2634<ST>' : 'error response for termcap query &4 (key_restart)',
    '< ESC P0+r2635<ST>' : 'error response for termcap query &5 (key_resume)',
    '< ESC P0+r6b72<ST>' : 'error response for termcap query kr (key_right)',
    '< ESC P0+r2636<ST>' : 'error response for termcap query &6 (key_save)',
    '< ESC P0+r2639<ST>' : 'error response for termcap query &9 (key_sbeg)',
    '< ESC P0+r2630<ST>' : 'error response for termcap query &0 (key_scancel)',
    '< ESC P0+r2a31<ST>' : 'error response for termcap query *1 (key_scommand)',
    '< ESC P0+r2a32<ST>' : 'error response for termcap query *2 (key_scopy)',
    '< ESC P0+r2a33<ST>' : 'error response for termcap query *3 (key_screate)',
    '< ESC P0+r2a34<ST>' : 'error response for termcap query *4 (key_sdc)',
    '< ESC P0+r2a35<ST>' : 'error response for termcap query *5 (key_sdl)',
    '< ESC P0+r2a36<ST>' : 'error response for termcap query *6 (key_select)',
    '< ESC P0+r2a37<ST>' : 'error response for termcap query *7 (key_send)',
    '< ESC P0+r2a38<ST>' : 'error response for termcap query *8 (key_seol)',
    '< ESC P0+r2a39<ST>' : 'error response for termcap query *9 (key_sexit)',
    '< ESC P0+r6b46<ST>' : 'error response for termcap query kF (key_sf)',
    '< ESC P0+r2a30<ST>' : 'error response for termcap query *0 (key_sfind)',
    '< ESC P0+r2331<ST>' : 'error response for termcap query #1 (key_shelp)',
    '< ESC P0+r2332<ST>' : 'error response for termcap query #2 (key_shome)',
    '< ESC P0+r2333<ST>' : 'error response for termcap query #3 (key_sic)',
    '< ESC P0+r2334<ST>' : 'error response for termcap query #4 (key_sleft)',
    '< ESC P0+r2561<ST>' : 'error response for termcap query %a (key_smessage)',
    '< ESC P0+r2562<ST>' : 'error response for termcap query %b (key_smove)',
    '< ESC P0+r2563<ST>' : 'error response for termcap query %c (key_snext)',
    '< ESC P0+r2564<ST>' : 'error response for termcap query %d (key_soptions)',
    '< ESC P0+r2565<ST>' : 'error response for termcap query %e (key_sprevious)',
    '< ESC P0+r2566<ST>' : 'error response for termcap query %f (key_sprint)',
    '< ESC P0+r6b52<ST>' : 'error response for termcap query kR (key_sr)',
    '< ESC P0+r2567<ST>' : 'error response for termcap query %g (key_sredo)',
    '< ESC P0+r2568<ST>' : 'error response for termcap query %h (key_sreplace)',
    '< ESC P0+r2569<ST>' : 'error response for termcap query %i (key_sright)',
    '< ESC P0+r256a<ST>' : 'error response for termcap query %j (key_srsume)',
    '< ESC P0+r2131<ST>' : 'error response for termcap query !1 (key_ssave)',
    '< ESC P0+r2132<ST>' : 'error response for termcap query !2 (key_ssuspend)',
    '< ESC P0+r6b54<ST>' : 'error response for termcap query kT (key_stab)',
    '< ESC P0+r2133<ST>' : 'error response for termcap query !3 (key_sundo)',
    '< ESC P0+r2637<ST>' : 'error response for termcap query &7 (key_suspend)',
    '< ESC P0+r2638<ST>' : 'error response for termcap query &8 (key_undo)',
    '< ESC P0+r6b75<ST>' : 'error response for termcap query ku (key_up)',
    '< ESC P0+r6b65<ST>' : 'error response for termcap query ke (keypad_local)',
    '< ESC P0+r6b73<ST>' : 'error response for termcap query ks (keypad_xmit)',
    '< ESC P0+r6c30<ST>' : 'error response for termcap query l0 (lab_f0)',
    '< ESC P0+r6c31<ST>' : 'error response for termcap query l1 (lab_f1)',
    '< ESC P0+r6c61<ST>' : 'error response for termcap query la (lab_f10)',
    '< ESC P0+r6c32<ST>' : 'error response for termcap query l2 (lab_f2)',
    '< ESC P0+r6c33<ST>' : 'error response for termcap query l3 (lab_f3)',
    '< ESC P0+r6c34<ST>' : 'error response for termcap query l4 (lab_f4)',
    '< ESC P0+r6c35<ST>' : 'error response for termcap query l5 (lab_f5)',
    '< ESC P0+r6c36<ST>' : 'error response for termcap query l6 (lab_f6)',
    '< ESC P0+r6c37<ST>' : 'error response for termcap query l7 (lab_f7)',
    '< ESC P0+r6c38<ST>' : 'error response for termcap query l8 (lab_f8)',
    '< ESC P0+r6c39<ST>' : 'error response for termcap query l9 (lab_f9)',
    '< ESC P0+r4c66<ST>' : 'error response for termcap query Lf (label_format)',
    '< ESC P0+r4c46<ST>' : 'error response for termcap query LF (label_off)',
    '< ESC P0+r4c4f<ST>' : 'error response for termcap query LO (label_on)',
    '< ESC P0+r6d6f<ST>' : 'error response for termcap query mo (meta_off)',
    '< ESC P0+r6d6d<ST>' : 'error response for termcap query mm (meta_on)',
    '< ESC P0+r5a59<ST>' : 'error response for termcap query ZY (micro_column_address)',
    '< ESC P0+r5a5a<ST>' : 'error response for termcap query ZZ (micro_down)',
    '< ESC P0+r5a61<ST>' : 'error response for termcap query Za (micro_left)',
    '< ESC P0+r5a62<ST>' : 'error response for termcap query Zb (micro_right)',
    '< ESC P0+r5a63<ST>' : 'error response for termcap query Zc (micro_row_address)',
    '< ESC P0+r5a64<ST>' : 'error response for termcap query Zd (micro_up)',
    '< ESC P0+r6e77<ST>' : 'error response for termcap query nw (newline)',
    '< ESC P0+r5a65<ST>' : 'error response for termcap query Ze (order_of_pins)',
    '< ESC P0+r6f63<ST>' : 'error response for termcap query oc (orig_colors)',
    '< ESC P0+r6f70<ST>' : 'error response for termcap query op (orig_pair)',
    '< ESC P0+r7063<ST>' : 'error response for termcap query pc (pad_char)',
    '< ESC P0+r4443<ST>' : 'error response for termcap query DC (parm_dch)',
    '< ESC P0+r444c<ST>' : 'error response for termcap query DL (parm_delete_line)',
    '< ESC P0+r444f<ST>' : 'error response for termcap query DO (parm_down_cursor)',
    '< ESC P0+r5a66<ST>' : 'error response for termcap query Zf (parm_down_micro)',
    '< ESC P0+r4943<ST>' : 'error response for termcap query IC (parm_ich)',
    '< ESC P0+r5346<ST>' : 'error response for termcap query SF (parm_index)',
    '< ESC P0+r414c<ST>' : 'error response for termcap query AL (parm_insert_line)',
    '< ESC P0+r4c45<ST>' : 'error response for termcap query LE (parm_left_cursor)',
    '< ESC P0+r5a67<ST>' : 'error response for termcap query Zg (parm_left_micro)',
    '< ESC P0+r5249<ST>' : 'error response for termcap query RI (parm_right_cursor)',
    '< ESC P0+r5a68<ST>' : 'error response for termcap query Zh (parm_right_micro)',
    '< ESC P0+r5352<ST>' : 'error response for termcap query SR (parm_rindex)',
    '< ESC P0+r5550<ST>' : 'error response for termcap query UP (parm_up_cursor)',
    '< ESC P0+r5a69<ST>' : 'error response for termcap query Zi (parm_up_micro)',
    '< ESC P0+r706b<ST>' : 'error response for termcap query pk (pkey_key)',
    '< ESC P0+r706c<ST>' : 'error response for termcap query pl (pkey_local)',
    '< ESC P0+r7078<ST>' : 'error response for termcap query px (pkey_xmit)',
    '< ESC P0+r706e<ST>' : 'error response for termcap query pn (plab_norm)',
    '< ESC P0+r7073<ST>' : 'error response for termcap query ps (print_screen)',
    '< ESC P0+r704f<ST>' : 'error response for termcap query pO (prtr_non)',
    '< ESC P0+r7066<ST>' : 'error response for termcap query pf (prtr_off)',
    '< ESC P0+r706f<ST>' : 'error response for termcap query po (prtr_on)',
    '< ESC P0+r5055<ST>' : 'error response for termcap query PU (pulse)',
    '< ESC P0+r5144<ST>' : 'error response for termcap query QD (quick_dial)',
    '< ESC P0+r5243<ST>' : 'error response for termcap query RC (remove_clock)',
    '< ESC P0+r7270<ST>' : 'error response for termcap query rp (repeat_char)',
    '< ESC P0+r5246<ST>' : 'error response for termcap query RF (req_for_input)',
    '< ESC P0+r7231<ST>' : 'error response for termcap query r1 (reset_1string)',
    '< ESC P0+r7232<ST>' : 'error response for termcap query r2 (reset_2string)',
    '< ESC P0+r7233<ST>' : 'error response for termcap query r3 (reset_3string)',
    '< ESC P0+r7266<ST>' : 'error response for termcap query rf (reset_file)',
    '< ESC P0+r7263<ST>' : 'error response for termcap query rc (restore_cursor)',
    '< ESC P0+r6376<ST>' : 'error response for termcap query cv (row_address)',
    '< ESC P0+r7363<ST>' : 'error response for termcap query sc (save_cursor)',
    '< ESC P0+r7366<ST>' : 'error response for termcap query sf (scroll_forward)',
    '< ESC P0+r7372<ST>' : 'error response for termcap query sr (scroll_reverse)',
    '< ESC P0+r5a6a<ST>' : 'error response for termcap query Zj (select_char_set)',
    '< ESC P0+r7361<ST>' : 'error response for termcap query sa (set_attributes)',
    '< ESC P0+r5362<ST>' : 'error response for termcap query Sb (set_background)',
    '< ESC P0+r5a6b<ST>' : 'error response for termcap query Zk (set_bottom_margin)',
    '< ESC P0+r5a6c<ST>' : 'error response for termcap query Zl (set_bottom_margin_parm)',
    '< ESC P0+r5343<ST>' : 'error response for termcap query SC (set_clock)',
    '< ESC P0+r7370<ST>' : 'error response for termcap query sp (set_color_pair)',
    '< ESC P0+r5366<ST>' : 'error response for termcap query Sf (set_foreground)',
    '< ESC P0+r5a6d<ST>' : 'error response for termcap query Zm (set_left_margin_parm)',
    '< ESC P0+r4d52<ST>' : 'error response for termcap query MR (set_right_margin)',
    '< ESC P0+r5a6e<ST>' : 'error response for termcap query Zn (set_right_margin_parm)',
    '< ESC P0+r7374<ST>' : 'error response for termcap query st (set_tab)',
    '< ESC P0+r5a6f<ST>' : 'error response for termcap query Zo (set_top_margin)',
    '< ESC P0+r5a70<ST>' : 'error response for termcap query Zp (set_top_margin_parm)',
    '< ESC P0+r7769<ST>' : 'error response for termcap query wi (set_window)',
    '< ESC P0+r5a71<ST>' : 'error response for termcap query Zq (start_bit_image)',
    '< ESC P0+r5a72<ST>' : 'error response for termcap query Zr (start_char_set_def)',
    '< ESC P0+r5a73<ST>' : 'error response for termcap query Zs (stop_bit_image)',
    '< ESC P0+r5a74<ST>' : 'error response for termcap query Zt (stop_char_set_def)',
    '< ESC P0+r5a75<ST>' : 'error response for termcap query Zu (subscript_characters)',
    '< ESC P0+r5a76<ST>' : 'error response for termcap query Zv (superscript_characters)',
    '< ESC P0+r7461<ST>' : 'error response for termcap query ta (tab)',
    '< ESC P0+r5a77<ST>' : 'error response for termcap query Zw (these_cause_cr)',
    '< ESC P0+r7473<ST>' : 'error response for termcap query ts (to_status_line)',
    '< ESC P0+r544f<ST>' : 'error response for termcap query TO (tone)',
    '< ESC P0+r7563<ST>' : 'error response for termcap query uc (underline_char)',
    '< ESC P0+r6875<ST>' : 'error response for termcap query hu (up_half_line)',
    '< ESC P0+r7530<ST>' : 'error response for termcap query u0 (user0)',
    '< ESC P0+r7531<ST>' : 'error response for termcap query u1 (user1)',
    '< ESC P0+r7532<ST>' : 'error response for termcap query u2 (user2)',
    '< ESC P0+r7533<ST>' : 'error response for termcap query u3 (user3)',
    '< ESC P0+r7534<ST>' : 'error response for termcap query u4 (user4)',
    '< ESC P0+r7535<ST>' : 'error response for termcap query u5 (user5)',
    '< ESC P0+r7536<ST>' : 'error response for termcap query u6 (user6)',
    '< ESC P0+r7537<ST>' : 'error response for termcap query u7 (user7)',
    '< ESC P0+r7538<ST>' : 'error response for termcap query u8 (user8)',
    '< ESC P0+r7539<ST>' : 'error response for termcap query u9 (user9)',
    '< ESC P0+r5741<ST>' : 'error response for termcap query WA (wait_tone)',
    '< ESC P0+r5846<ST>' : 'error response for termcap query XF (xoff_character)',
    '< ESC P0+r584e<ST>' : 'error response for termcap query XN (xon_character)',
    '< ESC P0+r5a78<ST>' : 'error response for termcap query Zx (zero_motion)',
    '< ESC P0+r5338<ST>' : 'error response for termcap query S8 (alt_scancode_esc)',
    '< ESC P0+r5976<ST>' : 'error response for termcap query Yv (bit_image_carriage_return)',
    '< ESC P0+r5a7a<ST>' : 'error response for termcap query Zz (bit_image_newline)',
    '< ESC P0+r5879<ST>' : 'error response for termcap query Xy (bit_image_repeat)',
    '< ESC P0+r5a79<ST>' : 'error response for termcap query Zy (char_set_names)',
    '< ESC P0+r6369<ST>' : 'error response for termcap query ci (code_set_init)',
    '< ESC P0+r5977<ST>' : 'error response for termcap query Yw (color_names)',
    '< ESC P0+r5978<ST>' : 'error response for termcap query Yx (define_bit_image_region)',
    '< ESC P0+r6476<ST>' : 'error response for termcap query dv (device_type)',
    '< ESC P0+r5331<ST>' : 'error response for termcap query S1 (display_pc_char)',
    '< ESC P0+r5979<ST>' : 'error response for termcap query Yy (end_bit_image_region)',
    '< ESC P0+r5332<ST>' : 'error response for termcap query S2 (enter_pc_charset_mode)',
    '< ESC P0+r5334<ST>' : 'error response for termcap query S4 (enter_scancode_mode)',
    '< ESC P0+r5333<ST>' : 'error response for termcap query S3 (exit_pc_charset_mode)',
    '< ESC P0+r5335<ST>' : 'error response for termcap query S5 (exit_scancode_mode)',
    '< ESC P0+r476d<ST>' : 'error response for termcap query Gm (get_mouse)',
    '< ESC P0+r4b6d<ST>' : 'error response for termcap query Km (key_mouse)',
    '< ESC P0+r4d69<ST>' : 'error response for termcap query Mi (mouse_info)',
    '< ESC P0+r5336<ST>' : 'error response for termcap query S6 (pc_term_options)',
    '< ESC P0+r786c<ST>' : 'error response for termcap query xl (pkey_plab)',
    '< ESC P0+r5251<ST>' : 'error response for termcap query RQ (req_mouse_pos)',
    '< ESC P0+r5337<ST>' : 'error response for termcap query S7 (scancode_escape)',
    '< ESC P0+r7330<ST>' : 'error response for termcap query s0 (set0_des_seq)',
    '< ESC P0+r7331<ST>' : 'error response for termcap query s1 (set1_des_seq)',
    '< ESC P0+r7332<ST>' : 'error response for termcap query s2 (set2_des_seq)',
    '< ESC P0+r7333<ST>' : 'error response for termcap query s3 (set3_des_seq)',
    '< ESC P0+r4142<ST>' : 'error response for termcap query AB (set_a_background)',
    '< ESC P0+r4146<ST>' : 'error response for termcap query AF (set_a_foreground)',
    '< ESC P0+r597a<ST>' : 'error response for termcap query Yz (set_color_band)',
    '< ESC P0+r4d4c<ST>' : 'error response for termcap query ML (set_left_margin or set_lr_margin)',
    '< ESC P0+r595a<ST>' : 'error response for termcap query YZ (set_page_length)',
    '< ESC P0+r4d54<ST>' : 'error response for termcap query MT (set_tb_margin)',
    '< ESC P0+r5868<ST>' : 'error response for termcap query Xh (enter_horizontal_hl_mode)',
    '< ESC P0+r586c<ST>' : 'error response for termcap query Xl (enter_left_hl_mode)',
    '< ESC P0+r586f<ST>' : 'error response for termcap query Xo (enter_low_hl_mode)',
    '< ESC P0+r5872<ST>' : 'error response for termcap query Xr (enter_right_hl_mode)',
    '< ESC P0+r5874<ST>' : 'error response for termcap query Xt (enter_top_hl_mode)',
    '< ESC P0+r5876<ST>' : 'error response for termcap query Xv (enter_vertical_hl_mode)',
    '< ESC P0+r7341<ST>' : 'error response for termcap query sA (set_a_attributes)',
    '< ESC P0+r734c<ST>' : 'error response for termcap query sL (set_pglen_inch)',
    '< ESC P1+r6277<ST>' : 'answer for termcap query bw (auto_left_margin)',
    '< ESC P1+r616d<ST>' : 'answer for termcap query am (auto_right_margin)',
    '< ESC P1+r7574<ST>' : 'answer for termcap query ut (back_color_erase)',
    '< ESC P1+r6363<ST>' : 'answer for termcap query cc (can_change)',
    '< ESC P1+r7873<ST>' : 'answer for termcap query xs (ceol_standout_glitch)',
    '< ESC P1+r5941<ST>' : 'answer for termcap query YA (col_addr_glitch)',
    '< ESC P1+r5946<ST>' : 'answer for termcap query YF (cpi_changes_res)',
    '< ESC P1+r5942<ST>' : 'answer for termcap query YB (cr_cancels_micro_mode)',
    '< ESC P1+r7874<ST>' : 'answer for termcap query xt (dest_tabs_magic_smso)',
    '< ESC P1+r786e<ST>' : 'answer for termcap query xn (eat_newline_glitch)',
    '< ESC P1+r656f<ST>' : 'answer for termcap query eo (erase_overstrike)',
    '< ESC P1+r676e<ST>' : 'answer for termcap query gn (generic_type)',
    '< ESC P1+r6863<ST>' : 'answer for termcap query hc (hard_copy)',
    '< ESC P1+r4843<ST>' : 'answer for termcap query HC (hard_cursor)',
    '< ESC P1+r6b6d<ST>' : 'answer for termcap query km (has_meta_key)',
    '< ESC P1+r5943<ST>' : 'answer for termcap query YC (has_print_wheel)',
    '< ESC P1+r6873<ST>' : 'answer for termcap query hs (has_status_line)',
    '< ESC P1+r686c<ST>' : 'answer for termcap query hl (hue_lightness_saturation)',
    '< ESC P1+r696e<ST>' : 'answer for termcap query in (insert_null_glitch)',
    '< ESC P1+r5947<ST>' : 'answer for termcap query YG (lpi_changes_res)',
    '< ESC P1+r6461<ST>' : 'answer for termcap query da (memory_above)',
    '< ESC P1+r6462<ST>' : 'answer for termcap query db (memory_below)',
    '< ESC P1+r6d69<ST>' : 'answer for termcap query mi (move_insert_mode)',
    '< ESC P1+r6d73<ST>' : 'answer for termcap query ms (move_standout_mode)',
    '< ESC P1+r6e78<ST>' : 'answer for termcap query nx (needs_xon_xoff)',
    '< ESC P1+r7862<ST>' : 'answer for termcap query xb (no_esc_ctlc)',
    '< ESC P1+r4e50<ST>' : 'answer for termcap query NP (no_pad_char)',
    '< ESC P1+r4e44<ST>' : 'answer for termcap query ND (non_dest_scroll_region)',
    '< ESC P1+r4e52<ST>' : 'answer for termcap query NR (non_rev_rmcup)',
    '< ESC P1+r6f73<ST>' : 'answer for termcap query os (over_strike)',
    '< ESC P1+r3569<ST>' : 'answer for termcap query 5i (prtr_silent)',
    '< ESC P1+r5944<ST>' : 'answer for termcap query YD (row_addr_glitch)',
    '< ESC P1+r5945<ST>' : 'answer for termcap query YE (semi_auto_right_margin)',
    '< ESC P1+r6573<ST>' : 'answer for termcap query es (status_line_esc_ok)',
    '< ESC P1+r687a<ST>' : 'answer for termcap query hz (tilde_glitch)',
    '< ESC P1+r756c<ST>' : 'answer for termcap query ul (transparent_underline)',
    '< ESC P1+r786f<ST>' : 'answer for termcap query xo (xon_xoff)',
    '< ESC P1+r636f<ST>' : 'answer for termcap query co (columns)',
    '< ESC P1+r6974<ST>' : 'answer for termcap query it (init_tabs)',
    '< ESC P1+r6c68<ST>' : 'answer for termcap query lh (label_height)',
    '< ESC P1+r6c77<ST>' : 'answer for termcap query lw (label_width)',
    '< ESC P1+r6c69<ST>' : 'answer for termcap query li (lines)',
    '< ESC P1+r6c6d<ST>' : 'answer for termcap query lm (lines_of_memory)',
    '< ESC P1+r7367<ST>' : 'answer for termcap query sg (magic_cookie_glitch)',
    '< ESC P1+r6d61<ST>' : 'answer for termcap query ma (max_attributes)',
    '< ESC P1+r436f<ST>' : 'answer for termcap query Co (max_colors)',
    '< ESC P1+r7061<ST>' : 'answer for termcap query pa (max_pairs)',
    '< ESC P1+r4d57<ST>' : 'answer for termcap query MW (maximum_windows)',
    '< ESC P1+r4e43<ST>' : 'answer for termcap query NC (no_color_video)',
    '< ESC P1+r4e6c<ST>' : 'answer for termcap query Nl (num_labels)',
    '< ESC P1+r7062<ST>' : 'answer for termcap query pb (padding_baud_rate)',
    '< ESC P1+r7674<ST>' : 'answer for termcap query vt (virtual_terminal)',
    '< ESC P1+r7773<ST>' : 'answer for termcap query ws (width_status_line)',
    '< ESC P1+r596f<ST>' : 'answer for termcap query Yo (bit_image_entwining)',
    '< ESC P1+r5970<ST>' : 'answer for termcap query Yp (bit_image_type)',
    '< ESC P1+r5961<ST>' : 'answer for termcap query Ya (buffer_capacity)',
    '< ESC P1+r4254<ST>' : 'answer for termcap query BT (buttons)',
    '< ESC P1+r5963<ST>' : 'answer for termcap query Yc (dot_horz_spacing)',
    '< ESC P1+r5962<ST>' : 'answer for termcap query Yb (dot_vert_spacing)',
    '< ESC P1+r5964<ST>' : 'answer for termcap query Yd (max_micro_address)',
    '< ESC P1+r5965<ST>' : 'answer for termcap query Ye (max_micro_jump)',
    '< ESC P1+r5966<ST>' : 'answer for termcap query Yf (micro_col_size)',
    '< ESC P1+r5967<ST>' : 'answer for termcap query Yg (micro_line_size)',
    '< ESC P1+r5968<ST>' : 'answer for termcap query Yh (number_of_pins)',
    '< ESC P1+r5969<ST>' : 'answer for termcap query Yi (output_res_char)',
    '< ESC P1+r596b<ST>' : 'answer for termcap query Yk (output_res_horz_inch)',
    '< ESC P1+r596a<ST>' : 'answer for termcap query Yj (output_res_line)',
    '< ESC P1+r596c<ST>' : 'answer for termcap query Yl (output_res_vert_inch)',
    '< ESC P1+r596d<ST>' : 'answer for termcap query Ym (print_rate)',
    '< ESC P1+r596e<ST>' : 'answer for termcap query Yn (wide_char_size)',
    '< ESC P1+r6163<ST>' : 'answer for termcap query ac (acs_chars)',
    '< ESC P1+r6274<ST>' : 'answer for termcap query bt (back_tab)',
    '< ESC P1+r626c<ST>' : 'answer for termcap query bl (bell)',
    '< ESC P1+r6372<ST>' : 'answer for termcap query cr (carriage_return)',
    '< ESC P1+r5a41<ST>' : 'answer for termcap query ZA (change_char_pitch)',
    '< ESC P1+r5a42<ST>' : 'answer for termcap query ZB (change_line_pitch)',
    '< ESC P1+r5a43<ST>' : 'answer for termcap query ZC (change_res_horz)',
    '< ESC P1+r5a44<ST>' : 'answer for termcap query ZD (change_res_vert)',
    '< ESC P1+r6373<ST>' : 'answer for termcap query cs (change_scroll_region)',
    '< ESC P1+r7250<ST>' : 'answer for termcap query rP (char_padding)',
    '< ESC P1+r6374<ST>' : 'answer for termcap query ct (clear_all_tabs)',
    '< ESC P1+r4d43<ST>' : 'answer for termcap query MC (clear_margins)',
    '< ESC P1+r636c<ST>' : 'answer for termcap query cl (clear_screen)',
    '< ESC P1+r6362<ST>' : 'answer for termcap query cb (clr_bol)',
    '< ESC P1+r6365<ST>' : 'answer for termcap query ce (clr_eol)',
    '< ESC P1+r6364<ST>' : 'answer for termcap query cd (clr_eos)',
    '< ESC P1+r6368<ST>' : 'answer for termcap query ch (column_address)',
    '< ESC P1+r4343<ST>' : 'answer for termcap query CC (command_character)',
    '< ESC P1+r4357<ST>' : 'answer for termcap query CW (create_window)',
    '< ESC P1+r636d<ST>' : 'answer for termcap query cm (cursor_address)',
    '< ESC P1+r646f<ST>' : 'answer for termcap query do (cursor_down)',
    '< ESC P1+r686f<ST>' : 'answer for termcap query ho (cursor_home)',
    '< ESC P1+r7669<ST>' : 'answer for termcap query vi (cursor_invisible)',
    '< ESC P1+r6c65<ST>' : 'answer for termcap query le (cursor_left)',
    '< ESC P1+r434d<ST>' : 'answer for termcap query CM (cursor_mem_address)',
    '< ESC P1+r7665<ST>' : 'answer for termcap query ve (cursor_normal)',
    '< ESC P1+r6e64<ST>' : 'answer for termcap query nd (cursor_right)',
    '< ESC P1+r6c6c<ST>' : 'answer for termcap query ll (cursor_to_ll)',
    '< ESC P1+r7570<ST>' : 'answer for termcap query up (cursor_up)',
    '< ESC P1+r7673<ST>' : 'answer for termcap query vs (cursor_visible)',
    '< ESC P1+r5a45<ST>' : 'answer for termcap query ZE (define_char)',
    '< ESC P1+r6463<ST>' : 'answer for termcap query dc (delete_character)',
    '< ESC P1+r646c<ST>' : 'answer for termcap query dl (delete_line)',
    '< ESC P1+r4449<ST>' : 'answer for termcap query DI (dial_phone)',
    '< ESC P1+r6473<ST>' : 'answer for termcap query ds (dis_status_line)',
    '< ESC P1+r444b<ST>' : 'answer for termcap query DK (display_clock)',
    '< ESC P1+r6864<ST>' : 'answer for termcap query hd (down_half_line)',
    '< ESC P1+r6541<ST>' : 'answer for termcap query eA (ena_acs)',
    '< ESC P1+r6173<ST>' : 'answer for termcap query as (enter_alt_charset_mode)',
    '< ESC P1+r5341<ST>' : 'answer for termcap query SA (enter_am_mode)',
    '< ESC P1+r6d62<ST>' : 'answer for termcap query mb (enter_blink_mode)',
    '< ESC P1+r6d64<ST>' : 'answer for termcap query md (enter_bold_mode)',
    '< ESC P1+r7469<ST>' : 'answer for termcap query ti (enter_ca_mode)',
    '< ESC P1+r646d<ST>' : 'answer for termcap query dm (enter_delete_mode)',
    '< ESC P1+r6d68<ST>' : 'answer for termcap query mh (enter_dim_mode)',
    '< ESC P1+r5a46<ST>' : 'answer for termcap query ZF (enter_doublewide_mode)',
    '< ESC P1+r5a47<ST>' : 'answer for termcap query ZG (enter_draft_quality)',
    '< ESC P1+r696d<ST>' : 'answer for termcap query im (enter_insert_mode)',
    '< ESC P1+r5a48<ST>' : 'answer for termcap query ZH (enter_italics_mode)',
    '< ESC P1+r5a49<ST>' : 'answer for termcap query ZI (enter_leftward_mode)',
    '< ESC P1+r5a4a<ST>' : 'answer for termcap query ZJ (enter_micro_mode)',
    '< ESC P1+r5a4b<ST>' : 'answer for termcap query ZK (enter_near_letter_quality)',
    '< ESC P1+r5a4c<ST>' : 'answer for termcap query ZL (enter_normal_quality)',
    '< ESC P1+r6d70<ST>' : 'answer for termcap query mp (enter_protected_mode)',
    '< ESC P1+r6d72<ST>' : 'answer for termcap query mr (enter_reverse_mode)',
    '< ESC P1+r6d6b<ST>' : 'answer for termcap query mk (enter_secure_mode)',
    '< ESC P1+r5a4d<ST>' : 'answer for termcap query ZM (enter_shadow_mode)',
    '< ESC P1+r736f<ST>' : 'answer for termcap query so (enter_standout_mode)',
    '< ESC P1+r5a4e<ST>' : 'answer for termcap query ZN (enter_subscript_mode)',
    '< ESC P1+r5a4f<ST>' : 'answer for termcap query ZO (enter_superscript_mode)',
    '< ESC P1+r7573<ST>' : 'answer for termcap query us (enter_underline_mode)',
    '< ESC P1+r5a50<ST>' : 'answer for termcap query ZP (enter_upward_mode)',
    '< ESC P1+r5358<ST>' : 'answer for termcap query SX (enter_xon_mode)',
    '< ESC P1+r6563<ST>' : 'answer for termcap query ec (erase_chars)',
    '< ESC P1+r6165<ST>' : 'answer for termcap query ae (exit_alt_charset_mode)',
    '< ESC P1+r5241<ST>' : 'answer for termcap query RA (exit_am_mode)',
    '< ESC P1+r6d65<ST>' : 'answer for termcap query me (exit_attribute_mode)',
    '< ESC P1+r7465<ST>' : 'answer for termcap query te (exit_ca_mode)',
    '< ESC P1+r6564<ST>' : 'answer for termcap query ed (exit_delete_mode)',
    '< ESC P1+r5a51<ST>' : 'answer for termcap query ZQ (exit_doublewide_mode)',
    '< ESC P1+r6569<ST>' : 'answer for termcap query ei (exit_insert_mode)',
    '< ESC P1+r5a52<ST>' : 'answer for termcap query ZR (exit_italics_mode)',
    '< ESC P1+r5a53<ST>' : 'answer for termcap query ZS (exit_leftward_mode)',
    '< ESC P1+r5a54<ST>' : 'answer for termcap query ZT (exit_micro_mode)',
    '< ESC P1+r5a55<ST>' : 'answer for termcap query ZU (exit_shadow_mode)',
    '< ESC P1+r7365<ST>' : 'answer for termcap query se (exit_standout_mode)',
    '< ESC P1+r5a56<ST>' : 'answer for termcap query ZV (exit_subscript_mode)',
    '< ESC P1+r5a57<ST>' : 'answer for termcap query ZW (exit_superscript_mode)',
    '< ESC P1+r7565<ST>' : 'answer for termcap query ue (exit_underline_mode)',
    '< ESC P1+r5a58<ST>' : 'answer for termcap query ZX (exit_upward_mode)',
    '< ESC P1+r5258<ST>' : 'answer for termcap query RX (exit_xon_mode)',
    '< ESC P1+r5041<ST>' : 'answer for termcap query PA (fixed_pause)',
    '< ESC P1+r6668<ST>' : 'answer for termcap query fh (flash_hook)',
    '< ESC P1+r7662<ST>' : 'answer for termcap query vb (flash_screen)',
    '< ESC P1+r6666<ST>' : 'answer for termcap query ff (form_feed)',
    '< ESC P1+r6673<ST>' : 'answer for termcap query fs (from_status_line)',
    '< ESC P1+r5747<ST>' : 'answer for termcap query WG (goto_window)',
    '< ESC P1+r4855<ST>' : 'answer for termcap query HU (hangup)',
    '< ESC P1+r6931<ST>' : 'answer for termcap query i1 (init_1string)',
    '< ESC P1+r6973<ST>' : 'answer for termcap query is (init_2string)',
    '< ESC P1+r6933<ST>' : 'answer for termcap query i3 (init_3string)',
    '< ESC P1+r6966<ST>' : 'answer for termcap query if (init_file)',
    '< ESC P1+r6950<ST>' : 'answer for termcap query iP (init_prog)',
    '< ESC P1+r4963<ST>' : 'answer for termcap query Ic (initialize_color)',
    '< ESC P1+r4970<ST>' : 'answer for termcap query Ip (initialize_pair)',
    '< ESC P1+r6963<ST>' : 'answer for termcap query ic (insert_character)',
    '< ESC P1+r616c<ST>' : 'answer for termcap query al (insert_line)',
    '< ESC P1+r6970<ST>' : 'answer for termcap query ip (insert_padding)',
    '< ESC P1+r4b31<ST>' : 'answer for termcap query K1 (key_a1)',
    '< ESC P1+r4b33<ST>' : 'answer for termcap query K3 (key_a3)',
    '< ESC P1+r4b32<ST>' : 'answer for termcap query K2 (key_b2)',
    '< ESC P1+r6b62<ST>' : 'answer for termcap query kb (key_backspace)',
    '< ESC P1+r4031<ST>' : 'answer for termcap query @1 (key_beg)',
    '< ESC P1+r6b42<ST>' : 'answer for termcap query kB (key_btab)',
    '< ESC P1+r4b34<ST>' : 'answer for termcap query K4 (key_c1)',
    '< ESC P1+r4b35<ST>' : 'answer for termcap query K5 (key_c3)',
    '< ESC P1+r4032<ST>' : 'answer for termcap query @2 (key_cancel)',
    '< ESC P1+r6b61<ST>' : 'answer for termcap query ka (key_catab)',
    '< ESC P1+r6b43<ST>' : 'answer for termcap query kC (key_clear)',
    '< ESC P1+r4033<ST>' : 'answer for termcap query @3 (key_close)',
    '< ESC P1+r4034<ST>' : 'answer for termcap query @4 (key_command)',
    '< ESC P1+r4035<ST>' : 'answer for termcap query @5 (key_copy)',
    '< ESC P1+r4036<ST>' : 'answer for termcap query @6 (key_create)',
    '< ESC P1+r6b74<ST>' : 'answer for termcap query kt (key_ctab)',
    '< ESC P1+r6b44<ST>' : 'answer for termcap query kD (key_dc)',
    '< ESC P1+r6b4c<ST>' : 'answer for termcap query kL (key_dl)',
    '< ESC P1+r6b64<ST>' : 'answer for termcap query kd (key_down)',
    '< ESC P1+r6b4d<ST>' : 'answer for termcap query kM (key_eic)',
    '< ESC P1+r4037<ST>' : 'answer for termcap query @7 (key_end)',
    '< ESC P1+r4038<ST>' : 'answer for termcap query @8 (key_enter)',
    '< ESC P1+r6b45<ST>' : 'answer for termcap query kE (key_eol)',
    '< ESC P1+r6b53<ST>' : 'answer for termcap query kS (key_eos)',
    '< ESC P1+r4039<ST>' : 'answer for termcap query @9 (key_exit)',
    '< ESC P1+r6b30<ST>' : 'answer for termcap query k0 (key_f0)',
    '< ESC P1+r6b31<ST>' : 'answer for termcap query k1 (key_f1)',
    '< ESC P1+r6b3b<ST>' : 'answer for termcap query k; (key_f10)',
    '< ESC P1+r4631<ST>' : 'answer for termcap query F1 (key_f11)',
    '< ESC P1+r4632<ST>' : 'answer for termcap query F2 (key_f12)',
    '< ESC P1+r4633<ST>' : 'answer for termcap query F3 (key_f13)',
    '< ESC P1+r4634<ST>' : 'answer for termcap query F4 (key_f14)',
    '< ESC P1+r4635<ST>' : 'answer for termcap query F5 (key_f15)',
    '< ESC P1+r4636<ST>' : 'answer for termcap query F6 (key_f16)',
    '< ESC P1+r4637<ST>' : 'answer for termcap query F7 (key_f17)',
    '< ESC P1+r4638<ST>' : 'answer for termcap query F8 (key_f18)',
    '< ESC P1+r4639<ST>' : 'answer for termcap query F9 (key_f19)',
    '< ESC P1+r6b32<ST>' : 'answer for termcap query k2 (key_f2)',
    '< ESC P1+r4641<ST>' : 'answer for termcap query FA (key_f20)',
    '< ESC P1+r4642<ST>' : 'answer for termcap query FB (key_f21)',
    '< ESC P1+r4643<ST>' : 'answer for termcap query FC (key_f22)',
    '< ESC P1+r4644<ST>' : 'answer for termcap query FD (key_f23)',
    '< ESC P1+r4645<ST>' : 'answer for termcap query FE (key_f24)',
    '< ESC P1+r4646<ST>' : 'answer for termcap query FF (key_f25)',
    '< ESC P1+r4647<ST>' : 'answer for termcap query FG (key_f26)',
    '< ESC P1+r4648<ST>' : 'answer for termcap query FH (key_f27)',
    '< ESC P1+r4649<ST>' : 'answer for termcap query FI (key_f28)',
    '< ESC P1+r464a<ST>' : 'answer for termcap query FJ (key_f29)',
    '< ESC P1+r6b33<ST>' : 'answer for termcap query k3 (key_f3)',
    '< ESC P1+r464b<ST>' : 'answer for termcap query FK (key_f30)',
    '< ESC P1+r464c<ST>' : 'answer for termcap query FL (key_f31)',
    '< ESC P1+r464d<ST>' : 'answer for termcap query FM (key_f32)',
    '< ESC P1+r464e<ST>' : 'answer for termcap query FN (key_f33)',
    '< ESC P1+r464f<ST>' : 'answer for termcap query FO (key_f34)',
    '< ESC P1+r4650<ST>' : 'answer for termcap query FP (key_f35)',
    '< ESC P1+r4651<ST>' : 'answer for termcap query FQ (key_f36)',
    '< ESC P1+r4652<ST>' : 'answer for termcap query FR (key_f37)',
    '< ESC P1+r4653<ST>' : 'answer for termcap query FS (key_f38)',
    '< ESC P1+r4654<ST>' : 'answer for termcap query FT (key_f39)',
    '< ESC P1+r6b34<ST>' : 'answer for termcap query k4 (key_f4)',
    '< ESC P1+r4655<ST>' : 'answer for termcap query FU (key_f40)',
    '< ESC P1+r4656<ST>' : 'answer for termcap query FV (key_f41)',
    '< ESC P1+r4657<ST>' : 'answer for termcap query FW (key_f42)',
    '< ESC P1+r4658<ST>' : 'answer for termcap query FX (key_f43)',
    '< ESC P1+r4659<ST>' : 'answer for termcap query FY (key_f44)',
    '< ESC P1+r465a<ST>' : 'answer for termcap query FZ (key_f45)',
    '< ESC P1+r4661<ST>' : 'answer for termcap query Fa (key_f46)',
    '< ESC P1+r4662<ST>' : 'answer for termcap query Fb (key_f47)',
    '< ESC P1+r4663<ST>' : 'answer for termcap query Fc (key_f48)',
    '< ESC P1+r4664<ST>' : 'answer for termcap query Fd (key_f49)',
    '< ESC P1+r6b35<ST>' : 'answer for termcap query k5 (key_f5)',
    '< ESC P1+r4665<ST>' : 'answer for termcap query Fe (key_f50)',
    '< ESC P1+r4666<ST>' : 'answer for termcap query Ff (key_f51)',
    '< ESC P1+r4667<ST>' : 'answer for termcap query Fg (key_f52)',
    '< ESC P1+r4668<ST>' : 'answer for termcap query Fh (key_f53)',
    '< ESC P1+r4669<ST>' : 'answer for termcap query Fi (key_f54)',
    '< ESC P1+r466a<ST>' : 'answer for termcap query Fj (key_f55)',
    '< ESC P1+r466b<ST>' : 'answer for termcap query Fk (key_f56)',
    '< ESC P1+r466c<ST>' : 'answer for termcap query Fl (key_f57)',
    '< ESC P1+r466d<ST>' : 'answer for termcap query Fm (key_f58)',
    '< ESC P1+r466e<ST>' : 'answer for termcap query Fn (key_f59)',
    '< ESC P1+r6b36<ST>' : 'answer for termcap query k6 (key_f6)',
    '< ESC P1+r466f<ST>' : 'answer for termcap query Fo (key_f60)',
    '< ESC P1+r4670<ST>' : 'answer for termcap query Fp (key_f61)',
    '< ESC P1+r4671<ST>' : 'answer for termcap query Fq (key_f62)',
    '< ESC P1+r4672<ST>' : 'answer for termcap query Fr (key_f63)',
    '< ESC P1+r6b37<ST>' : 'answer for termcap query k7 (key_f7)',
    '< ESC P1+r6b38<ST>' : 'answer for termcap query k8 (key_f8)',
    '< ESC P1+r6b39<ST>' : 'answer for termcap query k9 (key_f9)',
    '< ESC P1+r4030<ST>' : 'answer for termcap query @0 (key_find)',
    '< ESC P1+r2531<ST>' : 'answer for termcap query %1 (key_help)',
    '< ESC P1+r6b68<ST>' : 'answer for termcap query kh (key_home)',
    '< ESC P1+r6b49<ST>' : 'answer for termcap query kI (key_ic)',
    '< ESC P1+r6b41<ST>' : 'answer for termcap query kA (key_il)',
    '< ESC P1+r6b6c<ST>' : 'answer for termcap query kl (key_left)',
    '< ESC P1+r6b48<ST>' : 'answer for termcap query kH (key_ll)',
    '< ESC P1+r2532<ST>' : 'answer for termcap query %2 (key_mark)',
    '< ESC P1+r2533<ST>' : 'answer for termcap query %3 (key_message)',
    '< ESC P1+r2534<ST>' : 'answer for termcap query %4 (key_move)',
    '< ESC P1+r2535<ST>' : 'answer for termcap query %5 (key_next)',
    '< ESC P1+r6b4e<ST>' : 'answer for termcap query kN (key_npage)',
    '< ESC P1+r2536<ST>' : 'answer for termcap query %6 (key_open)',
    '< ESC P1+r2537<ST>' : 'answer for termcap query %7 (key_options)',
    '< ESC P1+r6b50<ST>' : 'answer for termcap query kP (key_ppage)',
    '< ESC P1+r2538<ST>' : 'answer for termcap query %8 (key_previous)',
    '< ESC P1+r2539<ST>' : 'answer for termcap query %9 (key_print)',
    '< ESC P1+r2530<ST>' : 'answer for termcap query %0 (key_redo)',
    '< ESC P1+r2631<ST>' : 'answer for termcap query &1 (key_reference)',
    '< ESC P1+r2632<ST>' : 'answer for termcap query &2 (key_refresh)',
    '< ESC P1+r2633<ST>' : 'answer for termcap query &3 (key_replace)',
    '< ESC P1+r2634<ST>' : 'answer for termcap query &4 (key_restart)',
    '< ESC P1+r2635<ST>' : 'answer for termcap query &5 (key_resume)',
    '< ESC P1+r6b72<ST>' : 'answer for termcap query kr (key_right)',
    '< ESC P1+r2636<ST>' : 'answer for termcap query &6 (key_save)',
    '< ESC P1+r2639<ST>' : 'answer for termcap query &9 (key_sbeg)',
    '< ESC P1+r2630<ST>' : 'answer for termcap query &0 (key_scancel)',
    '< ESC P1+r2a31<ST>' : 'answer for termcap query *1 (key_scommand)',
    '< ESC P1+r2a32<ST>' : 'answer for termcap query *2 (key_scopy)',
    '< ESC P1+r2a33<ST>' : 'answer for termcap query *3 (key_screate)',
    '< ESC P1+r2a34<ST>' : 'answer for termcap query *4 (key_sdc)',
    '< ESC P1+r2a35<ST>' : 'answer for termcap query *5 (key_sdl)',
    '< ESC P1+r2a36<ST>' : 'answer for termcap query *6 (key_select)',
    '< ESC P1+r2a37<ST>' : 'answer for termcap query *7 (key_send)',
    '< ESC P1+r2a38<ST>' : 'answer for termcap query *8 (key_seol)',
    '< ESC P1+r2a39<ST>' : 'answer for termcap query *9 (key_sexit)',
    '< ESC P1+r6b46<ST>' : 'answer for termcap query kF (key_sf)',
    '< ESC P1+r2a30<ST>' : 'answer for termcap query *0 (key_sfind)',
    '< ESC P1+r2331<ST>' : 'answer for termcap query #1 (key_shelp)',
    '< ESC P1+r2332<ST>' : 'answer for termcap query #2 (key_shome)',
    '< ESC P1+r2333<ST>' : 'answer for termcap query #3 (key_sic)',
    '< ESC P1+r2334<ST>' : 'answer for termcap query #4 (key_sleft)',
    '< ESC P1+r2561<ST>' : 'answer for termcap query %a (key_smessage)',
    '< ESC P1+r2562<ST>' : 'answer for termcap query %b (key_smove)',
    '< ESC P1+r2563<ST>' : 'answer for termcap query %c (key_snext)',
    '< ESC P1+r2564<ST>' : 'answer for termcap query %d (key_soptions)',
    '< ESC P1+r2565<ST>' : 'answer for termcap query %e (key_sprevious)',
    '< ESC P1+r2566<ST>' : 'answer for termcap query %f (key_sprint)',
    '< ESC P1+r6b52<ST>' : 'answer for termcap query kR (key_sr)',
    '< ESC P1+r2567<ST>' : 'answer for termcap query %g (key_sredo)',
    '< ESC P1+r2568<ST>' : 'answer for termcap query %h (key_sreplace)',
    '< ESC P1+r2569<ST>' : 'answer for termcap query %i (key_sright)',
    '< ESC P1+r256a<ST>' : 'answer for termcap query %j (key_srsume)',
    '< ESC P1+r2131<ST>' : 'answer for termcap query !1 (key_ssave)',
    '< ESC P1+r2132<ST>' : 'answer for termcap query !2 (key_ssuspend)',
    '< ESC P1+r6b54<ST>' : 'answer for termcap query kT (key_stab)',
    '< ESC P1+r2133<ST>' : 'answer for termcap query !3 (key_sundo)',
    '< ESC P1+r2637<ST>' : 'answer for termcap query &7 (key_suspend)',
    '< ESC P1+r2638<ST>' : 'answer for termcap query &8 (key_undo)',
    '< ESC P1+r6b75<ST>' : 'answer for termcap query ku (key_up)',
    '< ESC P1+r6b65<ST>' : 'answer for termcap query ke (keypad_local)',
    '< ESC P1+r6b73<ST>' : 'answer for termcap query ks (keypad_xmit)',
    '< ESC P1+r6c30<ST>' : 'answer for termcap query l0 (lab_f0)',
    '< ESC P1+r6c31<ST>' : 'answer for termcap query l1 (lab_f1)',
    '< ESC P1+r6c61<ST>' : 'answer for termcap query la (lab_f10)',
    '< ESC P1+r6c32<ST>' : 'answer for termcap query l2 (lab_f2)',
    '< ESC P1+r6c33<ST>' : 'answer for termcap query l3 (lab_f3)',
    '< ESC P1+r6c34<ST>' : 'answer for termcap query l4 (lab_f4)',
    '< ESC P1+r6c35<ST>' : 'answer for termcap query l5 (lab_f5)',
    '< ESC P1+r6c36<ST>' : 'answer for termcap query l6 (lab_f6)',
    '< ESC P1+r6c37<ST>' : 'answer for termcap query l7 (lab_f7)',
    '< ESC P1+r6c38<ST>' : 'answer for termcap query l8 (lab_f8)',
    '< ESC P1+r6c39<ST>' : 'answer for termcap query l9 (lab_f9)',
    '< ESC P1+r4c66<ST>' : 'answer for termcap query Lf (label_format)',
    '< ESC P1+r4c46<ST>' : 'answer for termcap query LF (label_off)',
    '< ESC P1+r4c4f<ST>' : 'answer for termcap query LO (label_on)',
    '< ESC P1+r6d6f<ST>' : 'answer for termcap query mo (meta_off)',
    '< ESC P1+r6d6d<ST>' : 'answer for termcap query mm (meta_on)',
    '< ESC P1+r5a59<ST>' : 'answer for termcap query ZY (micro_column_address)',
    '< ESC P1+r5a5a<ST>' : 'answer for termcap query ZZ (micro_down)',
    '< ESC P1+r5a61<ST>' : 'answer for termcap query Za (micro_left)',
    '< ESC P1+r5a62<ST>' : 'answer for termcap query Zb (micro_right)',
    '< ESC P1+r5a63<ST>' : 'answer for termcap query Zc (micro_row_address)',
    '< ESC P1+r5a64<ST>' : 'answer for termcap query Zd (micro_up)',
    '< ESC P1+r6e77<ST>' : 'answer for termcap query nw (newline)',
    '< ESC P1+r5a65<ST>' : 'answer for termcap query Ze (order_of_pins)',
    '< ESC P1+r6f63<ST>' : 'answer for termcap query oc (orig_colors)',
    '< ESC P1+r6f70<ST>' : 'answer for termcap query op (orig_pair)',
    '< ESC P1+r7063<ST>' : 'answer for termcap query pc (pad_char)',
    '< ESC P1+r4443<ST>' : 'answer for termcap query DC (parm_dch)',
    '< ESC P1+r444c<ST>' : 'answer for termcap query DL (parm_delete_line)',
    '< ESC P1+r444f<ST>' : 'answer for termcap query DO (parm_down_cursor)',
    '< ESC P1+r5a66<ST>' : 'answer for termcap query Zf (parm_down_micro)',
    '< ESC P1+r4943<ST>' : 'answer for termcap query IC (parm_ich)',
    '< ESC P1+r5346<ST>' : 'answer for termcap query SF (parm_index)',
    '< ESC P1+r414c<ST>' : 'answer for termcap query AL (parm_insert_line)',
    '< ESC P1+r4c45<ST>' : 'answer for termcap query LE (parm_left_cursor)',
    '< ESC P1+r5a67<ST>' : 'answer for termcap query Zg (parm_left_micro)',
    '< ESC P1+r5249<ST>' : 'answer for termcap query RI (parm_right_cursor)',
    '< ESC P1+r5a68<ST>' : 'answer for termcap query Zh (parm_right_micro)',
    '< ESC P1+r5352<ST>' : 'answer for termcap query SR (parm_rindex)',
    '< ESC P1+r5550<ST>' : 'answer for termcap query UP (parm_up_cursor)',
    '< ESC P1+r5a69<ST>' : 'answer for termcap query Zi (parm_up_micro)',
    '< ESC P1+r706b<ST>' : 'answer for termcap query pk (pkey_key)',
    '< ESC P1+r706c<ST>' : 'answer for termcap query pl (pkey_local)',
    '< ESC P1+r7078<ST>' : 'answer for termcap query px (pkey_xmit)',
    '< ESC P1+r706e<ST>' : 'answer for termcap query pn (plab_norm)',
    '< ESC P1+r7073<ST>' : 'answer for termcap query ps (print_screen)',
    '< ESC P1+r704f<ST>' : 'answer for termcap query pO (prtr_non)',
    '< ESC P1+r7066<ST>' : 'answer for termcap query pf (prtr_off)',
    '< ESC P1+r706f<ST>' : 'answer for termcap query po (prtr_on)',
    '< ESC P1+r5055<ST>' : 'answer for termcap query PU (pulse)',
    '< ESC P1+r5144<ST>' : 'answer for termcap query QD (quick_dial)',
    '< ESC P1+r5243<ST>' : 'answer for termcap query RC (remove_clock)',
    '< ESC P1+r7270<ST>' : 'answer for termcap query rp (repeat_char)',
    '< ESC P1+r5246<ST>' : 'answer for termcap query RF (req_for_input)',
    '< ESC P1+r7231<ST>' : 'answer for termcap query r1 (reset_1string)',
    '< ESC P1+r7232<ST>' : 'answer for termcap query r2 (reset_2string)',
    '< ESC P1+r7233<ST>' : 'answer for termcap query r3 (reset_3string)',
    '< ESC P1+r7266<ST>' : 'answer for termcap query rf (reset_file)',
    '< ESC P1+r7263<ST>' : 'answer for termcap query rc (restore_cursor)',
    '< ESC P1+r6376<ST>' : 'answer for termcap query cv (row_address)',
    '< ESC P1+r7363<ST>' : 'answer for termcap query sc (save_cursor)',
    '< ESC P1+r7366<ST>' : 'answer for termcap query sf (scroll_forward)',
    '< ESC P1+r7372<ST>' : 'answer for termcap query sr (scroll_reverse)',
    '< ESC P1+r5a6a<ST>' : 'answer for termcap query Zj (select_char_set)',
    '< ESC P1+r7361<ST>' : 'answer for termcap query sa (set_attributes)',
    '< ESC P1+r5362<ST>' : 'answer for termcap query Sb (set_background)',
    '< ESC P1+r5a6b<ST>' : 'answer for termcap query Zk (set_bottom_margin)',
    '< ESC P1+r5a6c<ST>' : 'answer for termcap query Zl (set_bottom_margin_parm)',
    '< ESC P1+r5343<ST>' : 'answer for termcap query SC (set_clock)',
    '< ESC P1+r7370<ST>' : 'answer for termcap query sp (set_color_pair)',
    '< ESC P1+r5366<ST>' : 'answer for termcap query Sf (set_foreground)',
    '< ESC P1+r5a6d<ST>' : 'answer for termcap query Zm (set_left_margin_parm)',
    '< ESC P1+r4d52<ST>' : 'answer for termcap query MR (set_right_margin)',
    '< ESC P1+r5a6e<ST>' : 'answer for termcap query Zn (set_right_margin_parm)',
    '< ESC P1+r7374<ST>' : 'answer for termcap query st (set_tab)',
    '< ESC P1+r5a6f<ST>' : 'answer for termcap query Zo (set_top_margin)',
    '< ESC P1+r5a70<ST>' : 'answer for termcap query Zp (set_top_margin_parm)',
    '< ESC P1+r7769<ST>' : 'answer for termcap query wi (set_window)',
    '< ESC P1+r5a71<ST>' : 'answer for termcap query Zq (start_bit_image)',
    '< ESC P1+r5a72<ST>' : 'answer for termcap query Zr (start_char_set_def)',
    '< ESC P1+r5a73<ST>' : 'answer for termcap query Zs (stop_bit_image)',
    '< ESC P1+r5a74<ST>' : 'answer for termcap query Zt (stop_char_set_def)',
    '< ESC P1+r5a75<ST>' : 'answer for termcap query Zu (subscript_characters)',
    '< ESC P1+r5a76<ST>' : 'answer for termcap query Zv (superscript_characters)',
    '< ESC P1+r7461<ST>' : 'answer for termcap query ta (tab)',
    '< ESC P1+r5a77<ST>' : 'answer for termcap query Zw (these_cause_cr)',
    '< ESC P1+r7473<ST>' : 'answer for termcap query ts (to_status_line)',
    '< ESC P1+r544f<ST>' : 'answer for termcap query TO (tone)',
    '< ESC P1+r7563<ST>' : 'answer for termcap query uc (underline_char)',
    '< ESC P1+r6875<ST>' : 'answer for termcap query hu (up_half_line)',
    '< ESC P1+r7530<ST>' : 'answer for termcap query u0 (user0)',
    '< ESC P1+r7531<ST>' : 'answer for termcap query u1 (user1)',
    '< ESC P1+r7532<ST>' : 'answer for termcap query u2 (user2)',
    '< ESC P1+r7533<ST>' : 'answer for termcap query u3 (user3)',
    '< ESC P1+r7534<ST>' : 'answer for termcap query u4 (user4)',
    '< ESC P1+r7535<ST>' : 'answer for termcap query u5 (user5)',
    '< ESC P1+r7536<ST>' : 'answer for termcap query u6 (user6)',
    '< ESC P1+r7537<ST>' : 'answer for termcap query u7 (user7)',
    '< ESC P1+r7538<ST>' : 'answer for termcap query u8 (user8)',
    '< ESC P1+r7539<ST>' : 'answer for termcap query u9 (user9)',
    '< ESC P1+r5741<ST>' : 'answer for termcap query WA (wait_tone)',
    '< ESC P1+r5846<ST>' : 'answer for termcap query XF (xoff_character)',
    '< ESC P1+r584e<ST>' : 'answer for termcap query XN (xon_character)',
    '< ESC P1+r5a78<ST>' : 'answer for termcap query Zx (zero_motion)',
    '< ESC P1+r5338<ST>' : 'answer for termcap query S8 (alt_scancode_esc)',
    '< ESC P1+r5976<ST>' : 'answer for termcap query Yv (bit_image_carriage_return)',
    '< ESC P1+r5a7a<ST>' : 'answer for termcap query Zz (bit_image_newline)',
    '< ESC P1+r5879<ST>' : 'answer for termcap query Xy (bit_image_repeat)',
    '< ESC P1+r5a79<ST>' : 'answer for termcap query Zy (char_set_names)',
    '< ESC P1+r6369<ST>' : 'answer for termcap query ci (code_set_init)',
    '< ESC P1+r5977<ST>' : 'answer for termcap query Yw (color_names)',
    '< ESC P1+r5978<ST>' : 'answer for termcap query Yx (define_bit_image_region)',
    '< ESC P1+r6476<ST>' : 'answer for termcap query dv (device_type)',
    '< ESC P1+r5331<ST>' : 'answer for termcap query S1 (display_pc_char)',
    '< ESC P1+r5979<ST>' : 'answer for termcap query Yy (end_bit_image_region)',
    '< ESC P1+r5332<ST>' : 'answer for termcap query S2 (enter_pc_charset_mode)',
    '< ESC P1+r5334<ST>' : 'answer for termcap query S4 (enter_scancode_mode)',
    '< ESC P1+r5333<ST>' : 'answer for termcap query S3 (exit_pc_charset_mode)',
    '< ESC P1+r5335<ST>' : 'answer for termcap query S5 (exit_scancode_mode)',
    '< ESC P1+r476d<ST>' : 'answer for termcap query Gm (get_mouse)',
    '< ESC P1+r4b6d<ST>' : 'answer for termcap query Km (key_mouse)',
    '< ESC P1+r4d69<ST>' : 'answer for termcap query Mi (mouse_info)',
    '< ESC P1+r5336<ST>' : 'answer for termcap query S6 (pc_term_options)',
    '< ESC P1+r786c<ST>' : 'answer for termcap query xl (pkey_plab)',
    '< ESC P1+r5251<ST>' : 'answer for termcap query RQ (req_mouse_pos)',
    '< ESC P1+r5337<ST>' : 'answer for termcap query S7 (scancode_escape)',
    '< ESC P1+r7330<ST>' : 'answer for termcap query s0 (set0_des_seq)',
    '< ESC P1+r7331<ST>' : 'answer for termcap query s1 (set1_des_seq)',
    '< ESC P1+r7332<ST>' : 'answer for termcap query s2 (set2_des_seq)',
    '< ESC P1+r7333<ST>' : 'answer for termcap query s3 (set3_des_seq)',
    '< ESC P1+r4142<ST>' : 'answer for termcap query AB (set_a_background)',
    '< ESC P1+r4146<ST>' : 'answer for termcap query AF (set_a_foreground)',
    '< ESC P1+r597a<ST>' : 'answer for termcap query Yz (set_color_band)',
    '< ESC P1+r4d4c<ST>' : 'answer for termcap query ML (set_left_margin or set_lr_margin)',
    '< ESC P1+r595a<ST>' : 'answer for termcap query YZ (set_page_length)',
    '< ESC P1+r4d54<ST>' : 'answer for termcap query MT (set_tb_margin)',
    '< ESC P1+r5868<ST>' : 'answer for termcap query Xh (enter_horizontal_hl_mode)',
    '< ESC P1+r586c<ST>' : 'answer for termcap query Xl (enter_left_hl_mode)',
    '< ESC P1+r586f<ST>' : 'answer for termcap query Xo (enter_low_hl_mode)',
    '< ESC P1+r5872<ST>' : 'answer for termcap query Xr (enter_right_hl_mode)',
    '< ESC P1+r5874<ST>' : 'answer for termcap query Xt (enter_top_hl_mode)',
    '< ESC P1+r5876<ST>' : 'answer for termcap query Xv (enter_vertical_hl_mode)',
    '< ESC P1+r7341<ST>' : 'answer for termcap query sA (set_a_attributes)',
    '< ESC P1+r734c<ST>' : 'answer for termcap query sL (set_pglen_inch)',
    '< ESC P1+r436f=3136<ST>'         :  'answer for termcap query Co=16',
    '< ESC P1+r436f=323536<ST>'       :  'answer for termcap query Co=256',
    '< ESC P1+r6b75=1B4F41 <ST>'      :  'answer for termcap query ku=\eOA',
    '< ESC P1+r6b64=1B4F42 <ST>'      :  'answer for termcap query kd=\eOB',
    '< ESC P1+r6b72=1B4F43 <ST>'      :  'answer for termcap query kr=\eOC',
    '< ESC P1+r6b6c=1B4F44 <ST>'      :  'answer for termcap query kl=\eOD',
    '< ESC P1+r2332=1B5B313B3248 <ST>':  'answer for termcap query #2=\e[1;2H',
    '< ESC P1+r2334=1B5B313B3244 <ST>':  'answer for termcap query #4=\e[1;2D',
    '< ESC P1+r2569=1B5B313B3243 <ST>':  'answer for termcap query %i=\e[1;2C',
    '< ESC P1+r2a37=1B5B313B3246 <ST>':  'answer for termcap query *7=\e[1;2F',
    '< ESC P1+r6b31=1B4F50 <ST>'      :  'answer for termcap query k1=\eOP',
    '< ESC P1+r6b32=1B4F51 <ST>'      :  'answer for termcap query k2=\eOQ',
    '< ESC P1+r6b33=1B4F52 <ST>'      :  'answer for termcap query k3=\eOR',
    '< ESC P1+r6b34=1B4F53 <ST>'      :  'answer for termcap query k4=\eOS',
    '< ESC P1+r6b35=1B5B31357E <ST>'  :  'answer for termcap query k5=\e[15~',
    '< ESC P1+r6b36=1B5B31377E <ST>'  :  'answer for termcap query k6=\e[17~',
    '< ESC P1+r6b37=1B5B31387E <ST>'  :  'answer for termcap query k7=\e[18~',
    '< ESC P1+r6b38=1B5B31397E <ST>'  :  'answer for termcap query k8=\e[19~',
    '< ESC P1+r6b39=1B5B32307E <ST>'  :  'answer for termcap query k9=\e[20~',
    '< ESC P1+r6b3b=1B5B32317E <ST>'  :  'answer for termcap query k;=\e[21~',
    '< ESC P1+r4631=1B5B32337E <ST>'  :  'answer for termcap query F1=\e[23~',
    '< ESC P1+r4632=1B5B32347E <ST>'  :  'answer for termcap query F2=\e[24~',
    '< ESC P1+r2531=1B5B32387E <ST>'  :  'answer for termcap query %1=\e[28~',
    '< ESC P1+r2638= <ST>'            :  'answer for termcap query &8=',
    '< ESC P1+r6b62=08 <ST>'          :  'answer for termcap query kb=^H',
    '< ESC P1+r6b49=1B5B327E <ST>'    :  'answer for termcap query kI=\e[2~',
    '< ESC P1+r6b44=1B5B337E <ST>'    :  'answer for termcap query kD=\e[3~',
    '< ESC P1+r6b68=1B4F48 <ST>'      :  'answer for termcap query kh=\eOH',
    '< ESC P1+r4037=1B4F46 <ST>'      :  'answer for termcap query @7=\eOF',
    '< ESC P1+r6b50=1B5B357E <ST>'    :  'answer for termcap query kP=\e[5~',
    '< ESC P1+r6b4e=1B5B367E <ST>'    :  'answer for termcap query kN=\e[6~',
    '< ESC P1+r4b31=1B4F48 <ST>'      :  'answer for termcap query K1=\eO8',
    '< ESC P1+r4b33=1B5B357E <ST>'    :  'answer for termcap query K3=\e[5~',
    '< ESC P1+r4b34=1B4F46 <ST>'      :  'answer for termcap query K4=\eOF',
    '< ESC P1+r4b35=1B5B367E <ST>'    :  'answer for termcap query K5=\e[6~',
    '< ESC P1+r6b42=1B5B5A <ST>'      :  'answer for termcap query kB=\e[Z',
    '< CSI A'            : 'Cursor key(normal keypad): up arrow',
    '< CSI B'            : 'Cursor key(normal keypad): down arrow',
    '< CSI C'            : 'Cursor key(normal keypad): right arrow',
    '< CSI D'            : 'Cursor key(normal keypad): left arrow',
    '< CSI 1;2A'         : 'Cursor key (xterm): Shift + up arrow',
    '< CSI 1;2B'         : 'Cursor key (xterm): Shift + down arrow',
    '< CSI 1;2C'         : 'Cursor key (xterm): Shift + right arrow',
    '< CSI 1;2D'         : 'Cursor key (xterm): Shift + left arrow',
    '< CSI 1;5A'         : 'Cursor key (xterm): Ctrl + up arrow',
    '< CSI 1;5B'         : 'Cursor key (xterm): Ctrl + down arrow',
    '< CSI 1;5C'         : 'Cursor key (xterm): Ctrl + right arrow',
    '< CSI 1;5D'         : 'Cursor key (xterm): Ctrl + left arrow',
    '< CSI 1;6A'         : 'Cursor key (xterm): Shift + Ctrl + up arrow',
    '< CSI 1;6B'         : 'Cursor key (xterm): Shift + Ctrl + down arrow',
    '< CSI 1;6C'         : 'Cursor key (xterm): Shift + Ctrl + right arrow',
    '< CSI 1;6D'         : 'Cursor key (xterm): Shift + Ctrl + left arrow',
    '< ESC O A'          : 'Cursor key(application keypad): up arrow',
    '< ESC O B'          : 'Cursor key(application keypad): down arrow',
    '< ESC O C'          : 'Cursor key(application keypad): right arrow',
    '< ESC O D'          : 'Cursor key(application keypad): left arrow',
    '< CSI [0]M'         : 'xterm normal mouse reporting, following 3 bytes mean (code, row, col)',
    '< CSI M'            : 'urxvt (1015) mouse reporting (code,row,col)',
    '< CSI [3]M'         : 'urxvt (1015) mouse reporting (code=(%s-32),row=%s,col=%s)',
    '< CSI <[3]M'        : 'SGR (1006) mouse reporting (code=%s,row=%s,col=%s)',
    '< CSI <M'           : 'SGR (1006) mouse reporting (code,row,col)',
    '< CSI <[3]m'        : 'SGR (1006) mouse reporting, button up (code=%s,row=%s,col=%s)',
    '< CSI <m'           : 'SGR (1006) mouse reporting, button up (code, row, col)',
    '< CSI &w'           : 'DECLRP / DEC Locator Report',
    '< CSI [4]&w'        : 'DECLRP / DEC Locator Report (type=%s,button=%s,row=%s,col=%s)',
    '< CSI [5]&w'        : 'DECLRP / DEC Locator Report (type=%s,button=%s,row=%s,col=%s, page=%s)',
    '< CSI 0&w'          : 'DECLRP / DEC Locator Report Pe = 0 - locator unavailable - no other parameters sent',
    '< CSI 1&w'          : 'DECLRP / DEC Locator Report Pe = 1 - reponse for DECRQLP',
    '< CSI 2&w'          : 'DECLRP / DEC Locator Report Pe = 2 - left button down',
    '< CSI 2;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 2 - left button down (button=%s,row=%s,col=%s)',
    '< CSI 2;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 2 - left button down (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 3&w'          : 'DECLRP / DEC Locator Report Pe = 3 - left button up',
    '< CSI 3;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 3 - left button up (button=%s,row=%s,col=%s)',
    '< CSI 3;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 3 - left button up (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 4&w'          : 'DECLRP / DEC Locator Report Pe = 4 - middle button down',
    '< CSI 4;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 4 - middle button down (button=%s,row=%s,col=%s)',
    '< CSI 4;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 4 - middle button down (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 5&w'          : 'DECLRP / DEC Locator Report Pe = 5 - middle button up',
    '< CSI 5;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 5 - middle button up (button=%s,row=%s,col=%s)',
    '< CSI 5;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 5 - middle button up (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 6&w'          : 'DECLRP / DEC Locator Report Pe = 6 - right button down',
    '< CSI 6;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 6 - right button down (button=%s,row=%s,col=%s)',
    '< CSI 6;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 6 - right button down (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 7&w'          : 'DECLRP / DEC Locator Report Pe = 7 - right button up',
    '< CSI 7;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 7 - right button up (button=%s,row=%s,col=%s)',
    '< CSI 7;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 7 - right button up (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 8&w'          : 'DECLRP / DEC Locator Report Pe = 8 - M4 button down',
    '< CSI 8;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 8 - M4 button down (button=%s,row=%s,col=%s)',
    '< CSI 8;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 8 - M4 button down (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 9&w'          : 'DECLRP / DEC Locator Report Pe = 9 - M4 button up',
    '< CSI 9;[3]&w'      : 'DECLRP / DEC Locator Report Pe = 9 - M4 button up (button=%s,row=%s,col=%s)',
    '< CSI 9;[4]&w'      : 'DECLRP / DEC Locator Report Pe = 9 - M4 button up (button=%s,row=%s,col=%s, page=%s)',
    '< CSI 10&w'         : 'DECLRP / DEC Locator Report Pe = 10 - locator outside filter rectangle',
    '< CSI 10;[3]&w'     : 'DECLRP / DEC Locator Report Pe = 10 - locator outside filter rectangle (button=%s,row=%s,col=%s)',
    '< CSI 10;[4]&w'     : 'DECLRP / DEC Locator Report Pe = 10 - locator outside filter rectangle (button=%s,row=%s,col=%s, page=%s)',
    '< CSI [0]I'         : 'Focus mode reporting: focus in',
    '< CSI [0]O'         : 'Focus mode reporting: focus out',
    '< CSI ?[3]R'        : 'DSR-DECXCPR(cursor position report) response, DEC specific: (row=%s,col=%s,page=%s)',
    '< CSI [2]R'         : 'DSR-CPR(cursor position report) response: (row=%s,col=%s)',
    '< CSI R'            : 'DSR-CPR(cursor position report) response',
    '< CSI 0n'           : 'DSR-OS(operating status report) response: "good status"',
    '< CSI 3n'           : 'DSR-OS(operating status report) response: "it has a malfunction"',
    '< CSI ?10n'         : 'DSR - Printer Port response: "Printer ready"',
    '< CSI ?11n'         : 'DSR - Printer Port response: "Printer not ready"',
    '< CSI ?13n'         : 'DSR - Printer Port response: "No printer"',
    '< CSI ?18n'         : 'DSR - Printer Port response: "Printer busy"',
    '< CSI ?19n'         : 'DSR - Printer Port response: "Printer assigned to other session"',
    '< CSI ?27n'         : 'DSR - Keyboard',
    '< CSI ?27;%d;%d;%dn': 'DSR - Keyboard: "The keyboard language is %d, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;0;%d;%dn': 'DSR - Keyboard: "The keyboard language cannot be determined, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;1;%d;%dn': 'DSR - Keyboard: "The keyboard language is North American, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;2;%d;%dn': 'DSR - Keyboard: "The keyboard language is British, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;3;%d;%dn': 'DSR - Keyboard: "The keyboard language is Belgian(Flemish), the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;4;%d;%dn': 'DSR - Keyboard: "The keyboard language is French Canadian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;5;%d;%dn': 'DSR - Keyboard: "The keyboard language is Danish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;6;%d;%dn': 'DSR - Keyboard: "The keyboard language is Finnish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;7;%d;%dn': 'DSR - Keyboard: "The keyboard language is German, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;8;%d;%dn': 'DSR - Keyboard: "The keyboard language is Dutch, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;9;%d;%dn': 'DSR - Keyboard: "The keyboard language is Italian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;10;%d;%dn': 'DSR - Keyboard: "The keyboard language is Swiss French, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;11;%d;%dn': 'DSR - Keyboard: "The keyboard language is Swiss German, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;12;%d;%dn': 'DSR - Keyboard: "The keyboard language is Swedish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;13;%d;%dn': 'DSR - Keyboard: "The keyboard language is Norwegian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;14;%d;%dn': 'DSR - Keyboard: "The keyboard language is French, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;15;%d;%dn': 'DSR - Keyboard: "The keyboard language is Spanish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;16;%d;%dn': 'DSR - Keyboard: "The keyboard language is Portuguese, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;19;%d;%dn': 'DSR - Keyboard: "The keyboard language is Hebrew, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;22;%d;%dn': 'DSR - Keyboard: "The keyboard language is Greek, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;28;%d;%dn': 'DSR - Keyboard: "The keyboard language is Canadian(English), the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;29;%d;%dn': 'DSR - Keyboard: "The keyboard language is Turkish-Q/Turkish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;30;%d;%dn': 'DSR - Keyboard: "The keyboard language is Turkish-F/Turkish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;31;%d;%dn': 'DSR - Keyboard: "The keyboard language is Hungarian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;33;%d;%dn': 'DSR - Keyboard: "The keyboard language is Slovak, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;35;%d;%dn': 'DSR - Keyboard: "The keyboard language is Polish, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;36;%d;%dn': 'DSR - Keyboard: "The keyboard language is Romanian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;38;%d;%dn': 'DSR - Keyboard: "The keyboard language is SCS, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;39;%d;%dn': 'DSR - Keyboard: "The keyboard language is Russian, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?27;40;%d;%dn': 'DSR - Keyboard: "The keyboard language is Latin American, the keyboard status is %d, and the keyboard type is %d."',
    '< CSI ?70n'         : 'DSR - Data Integrity response: "Ready"',
    '< CSI ?71n'         : 'DSR - Data Integrity response: "Malfunction"',
    '< CSI ?73n'         : 'DSR - Data Integrity response: "The terminal has not reported data integrity"',
    '< CSI 1W'           : 'Ambiguous reporting(MinTTY): treat ambiguous width characters as single width',
    '< CSI 2W'           : 'Ambiguous reporting(MinTTY): treat ambiguous width characters as double width',
    '< CSI ?c'           : 'DA1 Response',
    '< CSI ?1;0c'        : 'DA1 Response: VT100 with no options (could be WizConsole VT100 mode)',
    '< CSI ?1;2c'        : 'DA1 Response: VT100 with AVO (could be a VT102/rxvt/rxvt-unicode/konsole/'
                           'kterm/mlterm/iTerm2/tmux/aterm/wterm/Terminal.app(Mac)/mrxvt/MinTTY/'
                           'TeraTerm/ck/Poderosa/tty.js)',
    '< CSI ?1;6c'        : 'DA1 Response: VT100 with AVO and GPO (could be MacTerm)',
    '< CSI ?1;2;4;7c'    : 'DA1 Response: mlterm(3.1.7 or later) with SIXEL/DRCS',
    '< CSI ?1;2;4c'      : 'DA1 Response: mlterm(3.1.7 or later) with DRCS',
    '< CSI ?6c'          : 'DA1 Response: VT102 (could be linux xvt/console/PuTTY/Terminal.app(GNUStep)/yaft/Cathode/tty.js(linux console mode)/vSSH)',
    '< CSI ?26c'         : 'DA1 Response: DEC LN03 printer or its alias response',
    '< CSI ?62c'         : 'DA1 Response: VT200 family (could be mosh/WizConsole VT200 mode)',
    '< CSI ?62;9;c'      : 'DA1 Response: VT200 family (could be gnome-terminal)',
    '< CSI ?63c'         : 'DA1 Response: VT300 family',
    '< CSI ?64;1;2;6;9;15;21;22c': 'DA1 Response: VT400 family (could be xterm pl>=280)',
    '< CSI ?64;1;4;7;9;22;29c': 'DA1 Response: VT400 family (could be tanasinn)',
    '< CSI ?65;1;2;3;4;6;8;9;18;21;22;29;42;44c': 'DA1 Response: VT500 family (could be RLogin)',
    '< CSI ?73;4;6;8;9;10;11;12;16;18c': 'DA1 Response: DEClaser 2100 printer',
    '< CSI >c'           : 'DA2 Response',
    '< CSI >0;[2]c'      : 'DA2 Response: VT100, Pv=%s, keyboard type=%s',
    '< CSI >0;0;1c'      : 'DA2 Response: fvterm',
    '< CSI >0;95;c'      : 'DA2 Response: xterm patch#95 (could be iTerm/iTerm2)',
    '< CSI >0;95;0c'     : 'DA2 Response: xterm patch#95 (could be tmux)',
    '< CSI >0;95;1c'     : 'DA2 Response: xterm patch#95 (could be avaliable mouse)',
    '< CSI >0;115;0c'    : 'DA2 Response: xterm patch#115 (could be Konsole)',
    '< CSI >0;136;0c'    : 'DA2 Response: xterm patch#136 (could be PuTTY/MinTTY v0.3/vSSH)',
    '< CSI >0;270;0c'    : 'DA2 Response: VT100 (could be xterm patch#270)',
    '< CSI >0;271;0c'    : 'DA2 Response: VT100 (could be xterm patch#271)',
    '< CSI >0;272;0c'    : 'DA2 Response: VT100 (could be xterm patch#272)',
    '< CSI >0;273;0c'    : 'DA2 Response: VT100 (could be xterm patch#273)',
    '< CSI >0;274;0c'    : 'DA2 Response: VT100 (could be xterm patch#274)',
    '< CSI >0;275;0c'    : 'DA2 Response: VT100 (could be xterm patch#275)',
    '< CSI >0;276;0c'    : 'DA2 Response: VT100 (could be xterm patch#276 or tty.js)',
    '< CSI >0;277;0c'    : 'DA2 Response: VT100 (could be xterm patch#277 or tanasinn)',
    '< CSI >0;278;0c'    : 'DA2 Response: VT100 (could be xterm patch#278)',
    '< CSI >0;279;0c'    : 'DA2 Response: VT100 (could be xterm patch#279)',
    '< CSI >0;280;0c'    : 'DA2 Response: VT100 (could be xterm patch#280 with option "-ti vt100")',
    '< CSI >0;281;0c'    : 'DA2 Response: VT100 (could be xterm patch#281 with option "-ti vt100")',
    '< CSI >0;282;0c'    : 'DA2 Response: VT100 (could be xterm patch#282 with option "-ti vt100")',
    '< CSI >0;283;0c'    : 'DA2 Response: VT100 (could be xterm patch#283 with option "-ti vt100")',
    '< CSI >0;284;0c'    : 'DA2 Response: VT100 (could be xterm patch#284 with option "-ti vt100")',
    '< CSI >0;285;0c'    : 'DA2 Response: VT100 (could be xterm patch#285 with option "-ti vt100")',
    '< CSI >0;286;0c'    : 'DA2 Response: VT100 (could be xterm patch#286 with option "-ti vt100")',
    '< CSI >0;287;0c'    : 'DA2 Response: VT100 (could be xterm patch#287 with option "-ti vt100")',
    '< CSI >0;288;0c'    : 'DA2 Response: VT100 (could be xterm patch#288 with option "-ti vt100")',
    '< CSI >0;289;0c'    : 'DA2 Response: VT100 (could be xterm patch#289 with option "-ti vt100")',
    '< CSI >0;290;0c'    : 'DA2 Response: VT100 (could be xterm patch#290 with option "-ti vt100")',
    '< CSI >0;291;0c'    : 'DA2 Response: VT100 (could be xterm patch#291 with option "-ti vt100")',
    '< CSI >0;292;0c'    : 'DA2 Response: VT100 (could be xterm patch#292 with option "-ti vt100")',
    '< CSI >0;293;0c'    : 'DA2 Response: VT100 (could be xterm patch#293 with option "-ti vt100")',
    '< CSI >0;294;0c'    : 'DA2 Response: VT100 (could be xterm patch#294 with option "-ti vt100")',
    '< CSI >0;295;0c'    : 'DA2 Response: VT100 (could be xterm patch#295 with option "-ti vt100")',
    '< CSI >0;296;0c'    : 'DA2 Response: VT100 (could be xterm patch#296 with option "-ti vt100")',
    '< CSI >0;297;0c'    : 'DA2 Response: VT100 (could be xterm patch#297 with option "-ti vt100")',
    '< CSI >0;298;0c'    : 'DA2 Response: VT100 (could be xterm patch#298 with option "-ti vt100")',
    '< CSI >0;299;0c'    : 'DA2 Response: VT100 (could be xterm patch#299 with option "-ti vt100")',
    '< CSI >0;300;0c'    : 'DA2 Response: VT100 (could be xterm patch#300 with option "-ti vt100")',
    '< CSI >0;301;0c'    : 'DA2 Response: VT100 (could be xterm patch#301 with option "-ti vt100")',
    '< CSI >1;[2]c'      : 'DA2 Response: VT220, Pv=%s, keyboard type=%s',
    '< CSI >1;10;0c'     : 'DA2 Response: VT220 (could be mosh/WizConsole VT200 mode)',
    '< CSI >1;96;0c'     : 'DA2 Response: VT220 (could be mlterm)',
    '< CSI >1;1115;0c'   : 'DA2 Response: VT220 (could be VTE, such as gnome-terminal)',
    '< CSI >1;2403;0c'   : 'DA2 Response: VT220 (could be VTE, such as gnome-terminal)',
    '< CSI >1;2802;0c'   : 'DA2 Response: VT220 (could be VTE, such as gnome-terminal)',
    '< CSI >2;[2]c'      : 'DA2 Response: VT240, Pv=%s, keyboard type=%s',
    '< CSI >6;[2]c'      : 'DA2 Response: Haiku terminal, Pv=%s, keyboard type=%s',
    '< CSI >18;[2]c'     : 'DA2 Response: VT330, Pv=%s, keyboard type=%s',
    '< CSI >19;[2]c'     : 'DA2 Response: VT340, Pv=%s, keyboard type=%s',
    '< CSI >24;[2]c'     : 'DA2 Response: VT320, Pv=%s, keyboard type=%s',
    '< CSI >28;[2]c'     : 'DA2 Response: DECTerm window, Pv=%s, keyboard type=%s',
    '< CSI >32;[2]c'     : 'DA2 Response: VT382, Pv=%s, keyboard type=%s',
    '< CSI >32;100;2c'   : 'DA2 Response: VT382 (could be TeraTerm)',
    '< CSI >32;277;2c'   : 'DA2 Response: VT382 (could be mouseterm-plus)',
    '< CSI >41;[2]c'     : 'DA2 Response: VT420, Pv=%s, keyboard type=%s',
    '< CSI >41;280;0c'   : 'DA2 Response: VT420 (could be xterm patch#280)',
    '< CSI >41;281;0c'   : 'DA2 Response: VT420 (could be xterm patch#281)',
    '< CSI >41;282;0c'   : 'DA2 Response: VT420 (could be xterm patch#282)',
    '< CSI >41;283;0c'   : 'DA2 Response: VT420 (could be xterm patch#283)',
    '< CSI >41;284;0c'   : 'DA2 Response: VT420 (could be xterm patch#284)',
    '< CSI >41;285;0c'   : 'DA2 Response: VT420 (could be xterm patch#285)',
    '< CSI >41;286;0c'   : 'DA2 Response: VT420 (could be xterm patch#286)',
    '< CSI >41;287;0c'   : 'DA2 Response: VT420 (could be xterm patch#287)',
    '< CSI >41;288;0c'   : 'DA2 Response: VT420 (could be xterm patch#288)',
    '< CSI >41;289;0c'   : 'DA2 Response: VT420 (could be xterm patch#289)',
    '< CSI >41;290;0c'   : 'DA2 Response: VT420 (could be xterm patch#290)',
    '< CSI >41;291;0c'   : 'DA2 Response: VT420 (could be xterm patch#291)',
    '< CSI >41;292;0c'   : 'DA2 Response: VT420 (could be xterm patch#292)',
    '< CSI >41;293;0c'   : 'DA2 Response: VT420 (could be xterm patch#293)',
    '< CSI >41;294;0c'   : 'DA2 Response: VT420 (could be xterm patch#294)',
    '< CSI >41;295;0c'   : 'DA2 Response: VT420 (could be xterm patch#295)',
    '< CSI >41;296;0c'   : 'DA2 Response: VT420 (could be xterm patch#296)',
    '< CSI >41;297;0c'   : 'DA2 Response: VT420 (could be xterm patch#297)',
    '< CSI >41;298;0c'   : 'DA2 Response: VT420 (could be xterm patch#298)',
    '< CSI >41;299;0c'   : 'DA2 Response: VT420 (could be xterm patch#299)',
    '< CSI >41;300;0c'   : 'DA2 Response: VT420 (could be xterm patch#300)',
    '< CSI >41;301;0c'   : 'DA2 Response: VT420 (could be xterm patch#301)',
    '< CSI >46;[3]c'     : 'DA2 Response: DEClaser 2100 printer, firmVer=%s, protocol=%s minorVer=%s',
    '< CSI >47;[3]c'     : 'DA2 Response: DEClaser 2200 printer, firmVer=%s, protocol=%s minorVer=%s',
    '< CSI >61;[2]c'     : 'DA2 Response: VT510, Pv=%s, keyboard type=%s',
    '< CSI >64;[2]c'     : 'DA2 Response: VT520, Pv=%s, keyboard type=%s',
    '< CSI >65;[2]c'     : 'DA2 Response: VT525, Pv=%s, keyboard type=%s',
    '< CSI >65;100;1c'   : 'DA2 Response: VT500 family (could be RLogin)',
    '< CSI >77;[2]c'     : 'DA2 Response: could be MinTTY, Pv=%s, keyboard type=%s',
    '< CSI >77;[1];c'    : 'DA2 Response: could be MinTTY, Pv=%s',
    '< CSI >77;10003;c'  : 'DA2 Response: could be MinTTY 1.0.3',
    '< CSI >77;10101;c'  : 'DA2 Response: could be MinTTY 1.1.1',
    '< CSI >77;10102;c'  : 'DA2 Response: could be MinTTY 1.1.2',
    '< CSI >77;10103;c'  : 'DA2 Response: could be MinTTY 1.1.3',
    '< CSI >82;[2]c'     : 'DA2 Response: could be mrxvt, Pv=%s, keyboard type=%s',
    '< CSI >82;1;0c'     : 'DA2 Response: could be Poderosa',
    '< CSI >82;20710;0c' : 'DA2 Response: could be rxvt/ck',
    '< CSI >82;0.5.4;0c' : 'DA2 Response: could be mrxvt 0.5.4',
    '< CSI >83;[2]c'     : 'DA2 Response: could be GNU Screen, Pv=%s, keyboard type=%s',
    '< CSI >83;40000;0c' : 'DA2 Response: could be GNU Screen 4.0.0',
    '< CSI >83;40001;0c' : 'DA2 Response: could be GNU Screen 4.0.1',
    '< CSI >83;40002;0c' : 'DA2 Response: could be GNU Screen 4.0.2',
    '< CSI >83;40003;0c' : 'DA2 Response: could be GNU Screen 4.0.3 or tty.js(screen mode)',
    '< CSI >83;40100;0c' : 'DA2 Response: could be GNU Screen 4.1.0',
    '< CSI >85;95;c'     : 'DA2 Response: could be rxvt-unicode',
    '< CSI >85;95;0c'    : 'DA2 Response: could be rxvt-unicode or tty.js(rxvt-unicode mode)',
    '< CSI $y'           : 'DECRPM / DECRQM response, report ANSI mode',
    '< CSI ?$y'          : 'DECRPM / DECRQM response, report DEC private mode',
    '< CSI 1t'           : 'CSI 11 t Response: window is open',
    '< CSI 2t'           : 'CSI 11 t Response: window is iconified',
    '< CSI 3;[2]t'       : 'CSI 13 t Response: window position (x, y) is (%s, %s)',
    '< CSI 4;[2]t'       : 'CSI 14 t Response: window size (height, width) in pixels is (%s, %s)',
    '< CSI 8;[2]t'       : 'CSI 18 t Response: text area size (height, width) in characters is (%s, %s)',
    '< CSI 9;[2]t'       : 'CSI 19 t Response: screen size (height, width) in characters is (%s, %s)',
    '< ESC ]L<ST>'       : 'OSC L / CSI 20 t Response: report icon label',
    '< ESC ]l<ST>'       : 'OSC l / CSI 21 t Response: report title',
    '< ESC O P'          : 'F1 key (xterm)',
    '< ESC O Q'          : 'F2 key (xterm)',
    '< ESC O R'          : 'F3 key (xterm)',
    '< ESC O S'          : 'F4 key (xterm)',
    '< ESC O ['          : 'alternate escape key (in application escape keycode mode, proposed by mintty)',
    '< CSI 15~'          : 'F5 key (xterm)',
    '< CSI 17~'          : 'F6 key (xterm)',
    '< CSI 18~'          : 'F7 key (xterm)',
    '< CSI 19~'          : 'F8 key (xterm)',
    '< CSI 20~'          : 'F9 key (xterm)',
    '< CSI 21~'          : 'F10 key (xterm)',
    '< CSI 23~'          : 'F11 key (xterm)',
    '< CSI 24~'          : 'F12 key (xterm)',
    '< CSI 8850~'        : 'SKK mode report: hankaku mode (sentimental-skk)',
    '< CSI 8851~'        : 'SKK mode report: zenkaku mode (sentimental-skk)',
    '< CSI 8852~'        : 'SKK mode report: hiragana mode (sentimental-skk)',
    '< CSI 8853~'        : 'SKK mode report: katakana mode (sentimental-skk)',
    '< CSI 8854~'        : 'SKK mode report: abbrev mode (sentimental-skk)',
    '< CSI 1;2P'         : 'Shift + F1 key (xterm)',
    '< CSI 1;2Q'         : 'Shift + F2 key (xterm)',
    '< CSI 1;2R'         : 'Shift + F3 key (xterm)',
    '< CSI 1;2S'         : 'Shift + F4 key (xterm)',
    '< CSI 15;2~'        : 'F5 key (xterm)',
    '< CSI 17;2~'        : 'F6 key (xterm)',
    '< CSI 18;2~'        : 'F7 key (xterm)',
    '< CSI 19;2~'        : 'F8 key (xterm)',
    '< CSI 20;2~'        : 'F9 key (xterm)',
    '< CSI 21;2~'        : 'F10 key (xterm)',
    '< CSI 23;2~'        : 'F11 key (xterm)',
    '< CSI 24;2~'        : 'F12 key (xterm)',
    '< CSI 1;5P'         : 'Ctrl + F1 key (xterm)',
    '< CSI 1;5Q'         : 'Ctrl + F2 key (xterm)',
    '< CSI 1;5R'         : 'Ctrl + F3 key (xterm)',
    '< CSI 1;5S'         : 'Ctrl + F4 key (xterm)',
    '< CSI 15;5~'        : 'Ctrl + F5 key (xterm)',
    '< CSI 17;5~'        : 'Ctrl + F6 key (xterm)',
    '< CSI 18;5~'        : 'Ctrl + F7 key (xterm)',
    '< CSI 19;5~'        : 'Ctrl + F8 key (xterm)',
    '< CSI 20;5~'        : 'Ctrl + F9 key (xterm)',
    '< CSI 21;5~'        : 'Ctrl + F10 key (xterm)',
    '< CSI 23;5~'        : 'Ctrl + F11 key (xterm)',
    '< CSI 24;5~'        : 'Ctrl + F12 key (xterm)',
    '< CSI 1;6P'         : 'Shift + Ctrl + F1 key (xterm)',
    '< CSI 1;6Q'         : 'Shift + Ctrl + F2 key (xterm)',
    '< CSI 1;6R'         : 'Shift + Ctrl + F3 key (xterm)',
    '< CSI 1;6S'         : 'Shift + Ctrl + F4 key (xterm)',
    '< CSI 15;6~'        : 'Shift + Ctrl + F5 key (xterm)',
    '< CSI 17;6~'        : 'Shift + Ctrl + F6 key (xterm)',
    '< CSI 18;6~'        : 'Shift + Ctrl + F7 key (xterm)',
    '< CSI 19;6~'        : 'Shift + Ctrl + F8 key (xterm)',
    '< CSI 20;6~'        : 'Shift + Ctrl + F9 key (xterm)',
    '< CSI 21;6~'        : 'Shift + Ctrl + F10 key (xterm)',
    '< CSI 23;6~'        : 'Shift + Ctrl + F11 key (xterm)',
    '< CSI 24;6~'        : 'Shift + Ctrl + F12 key (xterm)',
    '< CSI 200~'         : 'Start sequense of bracketed paste',
    '< CSI 201~'         : 'Terminate bracketed paste',

    """ output """
    '> <NUL>'            : 'NUL / null character',
    '> <SOH>'            : 'SOH / start of heading',
    '> <STX>'            : 'STX / start of text',
    '> <ETX>'            : 'ETX / end of text',
    '> <EOT>'            : 'EOT / end of transmission',
    '> <ENQ>'            : 'ENQ / enquiry',
    '> <ACK>'            : 'ACK / acknowledge',
    '> <BEL>'            : 'BEL / bell',
    '> <BS>'             : 'BS / back space',
    '> <HT>'             : 'HT / character tabulation',
    '> <NL>'             : 'LF / line feed',
    '> <VT>'             : 'VT / line tabulation',
    '> <FF>'             : 'FF / form feed',
    '> <CR>'             : 'CR / carriage return',
    '> <SO>'             : 'SO(LS1) / shift out (locking shift 1)',
    '> <SI>'             : 'SI(LS0) / shift in (locking shift 0)',
    '> <DLE>'            : 'DLE / data link escape',
    '> <DC1>'            : 'DC1 / device control one',
    '> <DC2>'            : 'DC2 / device control two',
    '> <DC3>'            : 'DC3 / device control three',
    '> <DC4>'            : 'DC4 / device control four',
    '> <NAK>'            : 'NAK / negative acknowledge',
    '> <SYN>'            : 'SYN / synchronous idle',
    '> <ETB>'            : 'ETB / end of transmission block',
    '> <CAN>'            : 'CAN / cancel',
    '> <EM>'             : 'EM / end of medium',
    '> <SUB>'            : 'SUB / substitute',
    '> <ESC>'            : 'ESC / escape',
    '> <FS> '            : 'FS(IS4) / file separator (Information separator four)',
    '> <GS>'             : 'GS(IS3) / group separator (Information separator three)',
    '> <RS>'             : 'RS(IS2) / record separator (Information separator two)',
    '> <US>'             : 'US(IS1) / unit separator (Information separator one)',
    '> <DEL>'            : 'DEL / delete',
    '> ESC P<ST>'        : 'DCS / device control string',
    '> ESC P$q<ST>'      : 'DECRQSS / request selection or setting',
    '> ESC P$q$}<ST>'    : 'DECRQSS / query for DECSASD (Select Active Status Display) status',
    '> ESC P$q*x<ST>'    : 'DECRQSS / query for DECSACE (Select Attribute Change Extent) status',
    '> ESC P$q"q<ST>'    : 'DECRQSS / query for DECSCA (Set Character Attribute) status',
    '> ESC P$q"p<ST>'    : 'DECRQSS / query for DECSCL (Set Conformance Level) status',
    '> ESC P$q$|<ST>'    : 'DECRQSS / query for DECSCPP (Set Columns Per Page) status',
    '> ESC P$qt<ST>'     : 'DECRQSS / query for DECSLPP (Set Lines Per Page) status',
    '> ESC P$q*|<ST>'    : 'DECRQSS / query for DECSNLS (Set Number of Lines per Screen) status',
    '> ESC P$q$~<ST>'    : 'DECRQSS / query for DECSSDT (Set Status Line Type) status',
    '> ESC P$qs<ST>'     : 'DECRQSS / query for DECSLRM (Set Left and Right Margins) status',
    '> ESC P$qr<ST>'     : 'DECRQSS / query for DECSTBM (Set Top and Bottom Margins) status',
    '> ESC P$qm<ST>'     : 'DECRQSS / query for SGR (Set Graphic Rendition) status',
    '> ESC P$qp<ST>'     : 'DECRQSS / query for DECSSL (Select Set-Up Language) status',
    '> ESC P$q$s<ST>'    : 'DECRQSS / query for DECSPRTT (Select Printer Type) status',
    '> ESC P$q"t<ST>'    : 'DECRQSS / query for DECSRFR (Select Refresh Rate) status',
    '> ESC P$q(p<ST>'    : 'DECRQSS / query for DECSDPT (Select Digital Printed Data Type) status',
    '> ESC P$q*p<ST>'    : 'DECRQSS / query for DECSPPCS (Select ProPrinter Character Set) status',
    '> ESC P$q*r<ST>'    : 'DECRQSS / query for DECSCS (Select Communication Speed) status',
    '> ESC P$q*u<ST>'    : 'DECRQSS / query for DECSCP (Select Communication Port) status',
    '> ESC P$q p<ST>'    : 'DECRQSS / query for DECSSCLS (Set Scroll Speed) status',
    '> ESC P$q q<ST>'    : 'DECRQSS / query for DECSCUSR (Set Cursor Style) status',
    '> ESC P$q r<ST>'    : 'DECRQSS / query for DECSKCV (Set Key Click Volume) status',
    '> ESC P$q t<ST>'    : 'DECRQSS / query for DECSWBV (Set Warning Bell Volume) status',
    '> ESC P$q u<ST>'    : 'DECRQSS / query for DECSMBV (Set Margin Bell Volume) status',
    '> ESC P$q v<ST>'    : 'DECRQSS / query for DECSLCK (Set Lock Key Style) status',
    '> ESC P$q*s<ST>'    : 'DECRQSS / query for DECSFC (Select Flow Control Type) status',
    '> ESC P$q$q<ST>'    : 'DECRQSS / query for DECSDDT (Select Disconnect Delay Time) status',
    '> ESC P$q"u<ST>'    : 'DECRQSS / query for DECSTRL (Set Transmit Rate Limit) status',
    '> ESC P$q+w<ST>'    : 'DECRQSS / query for DECSPP (Set Port Parameter) status',
    '> ESC P+q<ST>'      : 'termcap query (xterm/tanasinn)',
    '> ESC P+q6277<ST>'  : 'termcap query for bw (auto_left_margin)',
    '> ESC P+q616d<ST>'  : 'termcap query for am (auto_right_margin)',
    '> ESC P+q7574<ST>'  : 'termcap query for ut (back_color_erase)',
    '> ESC P+q6363<ST>'  : 'termcap query for cc (can_change)',
    '> ESC P+q7873<ST>'  : 'termcap query for xs (ceol_standout_glitch)',
    '> ESC P+q5941<ST>'  : 'termcap query for YA (col_addr_glitch)',
    '> ESC P+q5946<ST>'  : 'termcap query for YF (cpi_changes_res)',
    '> ESC P+q5942<ST>'  : 'termcap query for YB (cr_cancels_micro_mode)',
    '> ESC P+q7874<ST>'  : 'termcap query for xt (dest_tabs_magic_smso)',
    '> ESC P+q786e<ST>'  : 'termcap query for xn (eat_newline_glitch)',
    '> ESC P+q656f<ST>'  : 'termcap query for eo (erase_overstrike)',
    '> ESC P+q676e<ST>'  : 'termcap query for gn (generic_type)',
    '> ESC P+q6863<ST>'  : 'termcap query for hc (hard_copy)',
    '> ESC P+q4843<ST>'  : 'termcap query for HC (hard_cursor)',
    '> ESC P+q6b6d<ST>'  : 'termcap query for km (has_meta_key)',
    '> ESC P+q5943<ST>'  : 'termcap query for YC (has_print_wheel)',
    '> ESC P+q6873<ST>'  : 'termcap query for hs (has_status_line)',
    '> ESC P+q686c<ST>'  : 'termcap query for hl (hue_lightness_saturation)',
    '> ESC P+q696e<ST>'  : 'termcap query for in (insert_null_glitch)',
    '> ESC P+q5947<ST>'  : 'termcap query for YG (lpi_changes_res)',
    '> ESC P+q6461<ST>'  : 'termcap query for da (memory_above)',
    '> ESC P+q6462<ST>'  : 'termcap query for db (memory_below)',
    '> ESC P+q6d69<ST>'  : 'termcap query for mi (move_insert_mode)',
    '> ESC P+q6d73<ST>'  : 'termcap query for ms (move_standout_mode)',
    '> ESC P+q6e78<ST>'  : 'termcap query for nx (needs_xon_xoff)',
    '> ESC P+q7862<ST>'  : 'termcap query for xb (no_esc_ctlc)',
    '> ESC P+q4e50<ST>'  : 'termcap query for NP (no_pad_char)',
    '> ESC P+q4e44<ST>'  : 'termcap query for ND (non_dest_scroll_region)',
    '> ESC P+q4e52<ST>'  : 'termcap query for NR (non_rev_rmcup)',
    '> ESC P+q6f73<ST>'  : 'termcap query for os (over_strike)',
    '> ESC P+q3569<ST>'  : 'termcap query for 5i (prtr_silent)',
    '> ESC P+q5944<ST>'  : 'termcap query for YD (row_addr_glitch)',
    '> ESC P+q5945<ST>'  : 'termcap query for YE (semi_auto_right_margin)',
    '> ESC P+q6573<ST>'  : 'termcap query for es (status_line_esc_ok)',
    '> ESC P+q687a<ST>'  : 'termcap query for hz (tilde_glitch)',
    '> ESC P+q756c<ST>'  : 'termcap query for ul (transparent_underline)',
    '> ESC P+q786f<ST>'  : 'termcap query for xo (xon_xoff)',
    '> ESC P+q636f<ST>'  : 'termcap query for co (columns)',
    '> ESC P+q6974<ST>'  : 'termcap query for it (init_tabs)',
    '> ESC P+q6c68<ST>'  : 'termcap query for lh (label_height)',
    '> ESC P+q6c77<ST>'  : 'termcap query for lw (label_width)',
    '> ESC P+q6c69<ST>'  : 'termcap query for li (lines)',
    '> ESC P+q6c6d<ST>'  : 'termcap query for lm (lines_of_memory)',
    '> ESC P+q7367<ST>'  : 'termcap query for sg (magic_cookie_glitch)',
    '> ESC P+q6d61<ST>'  : 'termcap query for ma (max_attributes)',
    '> ESC P+q436f<ST>'  : 'termcap query for Co (max_colors)',
    '> ESC P+q7061<ST>'  : 'termcap query for pa (max_pairs)',
    '> ESC P+q4d57<ST>'  : 'termcap query for MW (maximum_windows)',
    '> ESC P+q4e43<ST>'  : 'termcap query for NC (no_color_video)',
    '> ESC P+q4e6c<ST>'  : 'termcap query for Nl (num_labels)',
    '> ESC P+q7062<ST>'  : 'termcap query for pb (padding_baud_rate)',
    '> ESC P+q7674<ST>'  : 'termcap query for vt (virtual_terminal)',
    '> ESC P+q7773<ST>'  : 'termcap query for ws (width_status_line)',
    '> ESC P+q596f<ST>'  : 'termcap query for Yo (bit_image_entwining)',
    '> ESC P+q5970<ST>'  : 'termcap query for Yp (bit_image_type)',
    '> ESC P+q5961<ST>'  : 'termcap query for Ya (buffer_capacity)',
    '> ESC P+q4254<ST>'  : 'termcap query for BT (buttons)',
    '> ESC P+q5963<ST>'  : 'termcap query for Yc (dot_horz_spacing)',
    '> ESC P+q5962<ST>'  : 'termcap query for Yb (dot_vert_spacing)',
    '> ESC P+q5964<ST>'  : 'termcap query for Yd (max_micro_address)',
    '> ESC P+q5965<ST>'  : 'termcap query for Ye (max_micro_jump)',
    '> ESC P+q5966<ST>'  : 'termcap query for Yf (micro_col_size)',
    '> ESC P+q5967<ST>'  : 'termcap query for Yg (micro_line_size)',
    '> ESC P+q5968<ST>'  : 'termcap query for Yh (number_of_pins)',
    '> ESC P+q5969<ST>'  : 'termcap query for Yi (output_res_char)',
    '> ESC P+q596b<ST>'  : 'termcap query for Yk (output_res_horz_inch)',
    '> ESC P+q596a<ST>'  : 'termcap query for Yj (output_res_line)',
    '> ESC P+q596c<ST>'  : 'termcap query for Yl (output_res_vert_inch)',
    '> ESC P+q596d<ST>'  : 'termcap query for Ym (print_rate)',
    '> ESC P+q596e<ST>'  : 'termcap query for Yn (wide_char_size)',
    '> ESC P+q6163<ST>'  : 'termcap query for ac (acs_chars)',
    '> ESC P+q6274<ST>'  : 'termcap query for bt (back_tab)',
    '> ESC P+q626c<ST>'  : 'termcap query for bl (bell)',
    '> ESC P+q6372<ST>'  : 'termcap query for cr (carriage_return)',
    '> ESC P+q5a41<ST>'  : 'termcap query for ZA (change_char_pitch)',
    '> ESC P+q5a42<ST>'  : 'termcap query for ZB (change_line_pitch)',
    '> ESC P+q5a43<ST>'  : 'termcap query for ZC (change_res_horz)',
    '> ESC P+q5a44<ST>'  : 'termcap query for ZD (change_res_vert)',
    '> ESC P+q6373<ST>'  : 'termcap query for cs (change_scroll_region)',
    '> ESC P+q7250<ST>'  : 'termcap query for rP (char_padding)',
    '> ESC P+q6374<ST>'  : 'termcap query for ct (clear_all_tabs)',
    '> ESC P+q4d43<ST>'  : 'termcap query for MC (clear_margins)',
    '> ESC P+q636c<ST>'  : 'termcap query for cl (clear_screen)',
    '> ESC P+q6362<ST>'  : 'termcap query for cb (clr_bol)',
    '> ESC P+q6365<ST>'  : 'termcap query for ce (clr_eol)',
    '> ESC P+q6364<ST>'  : 'termcap query for cd (clr_eos)',
    '> ESC P+q6368<ST>'  : 'termcap query for ch (column_address)',
    '> ESC P+q4343<ST>'  : 'termcap query for CC (command_character)',
    '> ESC P+q4357<ST>'  : 'termcap query for CW (create_window)',
    '> ESC P+q636d<ST>'  : 'termcap query for cm (cursor_address)',
    '> ESC P+q646f<ST>'  : 'termcap query for do (cursor_down)',
    '> ESC P+q686f<ST>'  : 'termcap query for ho (cursor_home)',
    '> ESC P+q7669<ST>'  : 'termcap query for vi (cursor_invisible)',
    '> ESC P+q6c65<ST>'  : 'termcap query for le (cursor_left)',
    '> ESC P+q434d<ST>'  : 'termcap query for CM (cursor_mem_address)',
    '> ESC P+q7665<ST>'  : 'termcap query for ve (cursor_normal)',
    '> ESC P+q6e64<ST>'  : 'termcap query for nd (cursor_right)',
    '> ESC P+q6c6c<ST>'  : 'termcap query for ll (cursor_to_ll)',
    '> ESC P+q7570<ST>'  : 'termcap query for up (cursor_up)',
    '> ESC P+q7673<ST>'  : 'termcap query for vs (cursor_visible)',
    '> ESC P+q5a45<ST>'  : 'termcap query for ZE (define_char)',
    '> ESC P+q6463<ST>'  : 'termcap query for dc (delete_character)',
    '> ESC P+q646c<ST>'  : 'termcap query for dl (delete_line)',
    '> ESC P+q4449<ST>'  : 'termcap query for DI (dial_phone)',
    '> ESC P+q6473<ST>'  : 'termcap query for ds (dis_status_line)',
    '> ESC P+q444b<ST>'  : 'termcap query for DK (display_clock)',
    '> ESC P+q6864<ST>'  : 'termcap query for hd (down_half_line)',
    '> ESC P+q6541<ST>'  : 'termcap query for eA (ena_acs)',
    '> ESC P+q6173<ST>'  : 'termcap query for as (enter_alt_charset_mode)',
    '> ESC P+q5341<ST>'  : 'termcap query for SA (enter_am_mode)',
    '> ESC P+q6d62<ST>'  : 'termcap query for mb (enter_blink_mode)',
    '> ESC P+q6d64<ST>'  : 'termcap query for md (enter_bold_mode)',
    '> ESC P+q7469<ST>'  : 'termcap query for ti (enter_ca_mode)',
    '> ESC P+q646d<ST>'  : 'termcap query for dm (enter_delete_mode)',
    '> ESC P+q6d68<ST>'  : 'termcap query for mh (enter_dim_mode)',
    '> ESC P+q5a46<ST>'  : 'termcap query for ZF (enter_doublewide_mode)',
    '> ESC P+q5a47<ST>'  : 'termcap query for ZG (enter_draft_quality)',
    '> ESC P+q696d<ST>'  : 'termcap query for im (enter_insert_mode)',
    '> ESC P+q5a48<ST>'  : 'termcap query for ZH (enter_italics_mode)',
    '> ESC P+q5a49<ST>'  : 'termcap query for ZI (enter_leftward_mode)',
    '> ESC P+q5a4a<ST>'  : 'termcap query for ZJ (enter_micro_mode)',
    '> ESC P+q5a4b<ST>'  : 'termcap query for ZK (enter_near_letter_quality)',
    '> ESC P+q5a4c<ST>'  : 'termcap query for ZL (enter_normal_quality)',
    '> ESC P+q6d70<ST>'  : 'termcap query for mp (enter_protected_mode)',
    '> ESC P+q6d72<ST>'  : 'termcap query for mr (enter_reverse_mode)',
    '> ESC P+q6d6b<ST>'  : 'termcap query for mk (enter_secure_mode)',
    '> ESC P+q5a4d<ST>'  : 'termcap query for ZM (enter_shadow_mode)',
    '> ESC P+q736f<ST>'  : 'termcap query for so (enter_standout_mode)',
    '> ESC P+q5a4e<ST>'  : 'termcap query for ZN (enter_subscript_mode)',
    '> ESC P+q5a4f<ST>'  : 'termcap query for ZO (enter_superscript_mode)',
    '> ESC P+q7573<ST>'  : 'termcap query for us (enter_underline_mode)',
    '> ESC P+q5a50<ST>'  : 'termcap query for ZP (enter_upward_mode)',
    '> ESC P+q5358<ST>'  : 'termcap query for SX (enter_xon_mode)',
    '> ESC P+q6563<ST>'  : 'termcap query for ec (erase_chars)',
    '> ESC P+q6165<ST>'  : 'termcap query for ae (exit_alt_charset_mode)',
    '> ESC P+q5241<ST>'  : 'termcap query for RA (exit_am_mode)',
    '> ESC P+q6d65<ST>'  : 'termcap query for me (exit_attribute_mode)',
    '> ESC P+q7465<ST>'  : 'termcap query for te (exit_ca_mode)',
    '> ESC P+q6564<ST>'  : 'termcap query for ed (exit_delete_mode)',
    '> ESC P+q5a51<ST>'  : 'termcap query for ZQ (exit_doublewide_mode)',
    '> ESC P+q6569<ST>'  : 'termcap query for ei (exit_insert_mode)',
    '> ESC P+q5a52<ST>'  : 'termcap query for ZR (exit_italics_mode)',
    '> ESC P+q5a53<ST>'  : 'termcap query for ZS (exit_leftward_mode)',
    '> ESC P+q5a54<ST>'  : 'termcap query for ZT (exit_micro_mode)',
    '> ESC P+q5a55<ST>'  : 'termcap query for ZU (exit_shadow_mode)',
    '> ESC P+q7365<ST>'  : 'termcap query for se (exit_standout_mode)',
    '> ESC P+q5a56<ST>'  : 'termcap query for ZV (exit_subscript_mode)',
    '> ESC P+q5a57<ST>'  : 'termcap query for ZW (exit_superscript_mode)',
    '> ESC P+q7565<ST>'  : 'termcap query for ue (exit_underline_mode)',
    '> ESC P+q5a58<ST>'  : 'termcap query for ZX (exit_upward_mode)',
    '> ESC P+q5258<ST>'  : 'termcap query for RX (exit_xon_mode)',
    '> ESC P+q5041<ST>'  : 'termcap query for PA (fixed_pause)',
    '> ESC P+q6668<ST>'  : 'termcap query for fh (flash_hook)',
    '> ESC P+q7662<ST>'  : 'termcap query for vb (flash_screen)',
    '> ESC P+q6666<ST>'  : 'termcap query for ff (form_feed)',
    '> ESC P+q6673<ST>'  : 'termcap query for fs (from_status_line)',
    '> ESC P+q5747<ST>'  : 'termcap query for WG (goto_window)',
    '> ESC P+q4855<ST>'  : 'termcap query for HU (hangup)',
    '> ESC P+q6931<ST>'  : 'termcap query for i1 (init_1string)',
    '> ESC P+q6973<ST>'  : 'termcap query for is (init_2string)',
    '> ESC P+q6933<ST>'  : 'termcap query for i3 (init_3string)',
    '> ESC P+q6966<ST>'  : 'termcap query for if (init_file)',
    '> ESC P+q6950<ST>'  : 'termcap query for iP (init_prog)',
    '> ESC P+q4963<ST>'  : 'termcap query for Ic (initialize_color)',
    '> ESC P+q4970<ST>'  : 'termcap query for Ip (initialize_pair)',
    '> ESC P+q6963<ST>'  : 'termcap query for ic (insert_character)',
    '> ESC P+q616c<ST>'  : 'termcap query for al (insert_line)',
    '> ESC P+q6970<ST>'  : 'termcap query for ip (insert_padding)',
    '> ESC P+q4b31<ST>'  : 'termcap query for K1 (key_a1)',
    '> ESC P+q4b33<ST>'  : 'termcap query for K3 (key_a3)',
    '> ESC P+q4b32<ST>'  : 'termcap query for K2 (key_b2)',
    '> ESC P+q6b62<ST>'  : 'termcap query for kb (key_backspace)',
    '> ESC P+q4031<ST>'  : 'termcap query for @1 (key_beg)',
    '> ESC P+q6b42<ST>'  : 'termcap query for kB (key_btab)',
    '> ESC P+q4b34<ST>'  : 'termcap query for K4 (key_c1)',
    '> ESC P+q4b35<ST>'  : 'termcap query for K5 (key_c3)',
    '> ESC P+q4032<ST>'  : 'termcap query for @2 (key_cancel)',
    '> ESC P+q6b61<ST>'  : 'termcap query for ka (key_catab)',
    '> ESC P+q6b43<ST>'  : 'termcap query for kC (key_clear)',
    '> ESC P+q4033<ST>'  : 'termcap query for @3 (key_close)',
    '> ESC P+q4034<ST>'  : 'termcap query for @4 (key_command)',
    '> ESC P+q4035<ST>'  : 'termcap query for @5 (key_copy)',
    '> ESC P+q4036<ST>'  : 'termcap query for @6 (key_create)',
    '> ESC P+q6b74<ST>'  : 'termcap query for kt (key_ctab)',
    '> ESC P+q6b44<ST>'  : 'termcap query for kD (key_dc)',
    '> ESC P+q6b4c<ST>'  : 'termcap query for kL (key_dl)',
    '> ESC P+q6b64<ST>'  : 'termcap query for kd (key_down)',
    '> ESC P+q6b4d<ST>'  : 'termcap query for kM (key_eic)',
    '> ESC P+q4037<ST>'  : 'termcap query for @7 (key_end)',
    '> ESC P+q4038<ST>'  : 'termcap query for @8 (key_enter)',
    '> ESC P+q6b45<ST>'  : 'termcap query for kE (key_eol)',
    '> ESC P+q6b53<ST>'  : 'termcap query for kS (key_eos)',
    '> ESC P+q4039<ST>'  : 'termcap query for @9 (key_exit)',
    '> ESC P+q6b30<ST>'  : 'termcap query for k0 (key_f0)',
    '> ESC P+q6b31<ST>'  : 'termcap query for k1 (key_f1)',
    '> ESC P+q6b3b<ST>'  : 'termcap query for k; (key_f10)',
    '> ESC P+q4631<ST>'  : 'termcap query for F1 (key_f11)',
    '> ESC P+q4632<ST>'  : 'termcap query for F2 (key_f12)',
    '> ESC P+q4633<ST>'  : 'termcap query for F3 (key_f13)',
    '> ESC P+q4634<ST>'  : 'termcap query for F4 (key_f14)',
    '> ESC P+q4635<ST>'  : 'termcap query for F5 (key_f15)',
    '> ESC P+q4636<ST>'  : 'termcap query for F6 (key_f16)',
    '> ESC P+q4637<ST>'  : 'termcap query for F7 (key_f17)',
    '> ESC P+q4638<ST>'  : 'termcap query for F8 (key_f18)',
    '> ESC P+q4639<ST>'  : 'termcap query for F9 (key_f19)',
    '> ESC P+q6b32<ST>'  : 'termcap query for k2 (key_f2)',
    '> ESC P+q4641<ST>'  : 'termcap query for FA (key_f20)',
    '> ESC P+q4642<ST>'  : 'termcap query for FB (key_f21)',
    '> ESC P+q4643<ST>'  : 'termcap query for FC (key_f22)',
    '> ESC P+q4644<ST>'  : 'termcap query for FD (key_f23)',
    '> ESC P+q4645<ST>'  : 'termcap query for FE (key_f24)',
    '> ESC P+q4646<ST>'  : 'termcap query for FF (key_f25)',
    '> ESC P+q4647<ST>'  : 'termcap query for FG (key_f26)',
    '> ESC P+q4648<ST>'  : 'termcap query for FH (key_f27)',
    '> ESC P+q4649<ST>'  : 'termcap query for FI (key_f28)',
    '> ESC P+q464a<ST>'  : 'termcap query for FJ (key_f29)',
    '> ESC P+q6b33<ST>'  : 'termcap query for k3 (key_f3)',
    '> ESC P+q464b<ST>'  : 'termcap query for FK (key_f30)',
    '> ESC P+q464c<ST>'  : 'termcap query for FL (key_f31)',
    '> ESC P+q464d<ST>'  : 'termcap query for FM (key_f32)',
    '> ESC P+q464e<ST>'  : 'termcap query for FN (key_f33)',
    '> ESC P+q464f<ST>'  : 'termcap query for FO (key_f34)',
    '> ESC P+q4650<ST>'  : 'termcap query for FP (key_f35)',
    '> ESC P+q4651<ST>'  : 'termcap query for FQ (key_f36)',
    '> ESC P+q4652<ST>'  : 'termcap query for FR (key_f37)',
    '> ESC P+q4653<ST>'  : 'termcap query for FS (key_f38)',
    '> ESC P+q4654<ST>'  : 'termcap query for FT (key_f39)',
    '> ESC P+q6b34<ST>'  : 'termcap query for k4 (key_f4)',
    '> ESC P+q4655<ST>'  : 'termcap query for FU (key_f40)',
    '> ESC P+q4656<ST>'  : 'termcap query for FV (key_f41)',
    '> ESC P+q4657<ST>'  : 'termcap query for FW (key_f42)',
    '> ESC P+q4658<ST>'  : 'termcap query for FX (key_f43)',
    '> ESC P+q4659<ST>'  : 'termcap query for FY (key_f44)',
    '> ESC P+q465a<ST>'  : 'termcap query for FZ (key_f45)',
    '> ESC P+q4661<ST>'  : 'termcap query for Fa (key_f46)',
    '> ESC P+q4662<ST>'  : 'termcap query for Fb (key_f47)',
    '> ESC P+q4663<ST>'  : 'termcap query for Fc (key_f48)',
    '> ESC P+q4664<ST>'  : 'termcap query for Fd (key_f49)',
    '> ESC P+q6b35<ST>'  : 'termcap query for k5 (key_f5)',
    '> ESC P+q4665<ST>'  : 'termcap query for Fe (key_f50)',
    '> ESC P+q4666<ST>'  : 'termcap query for Ff (key_f51)',
    '> ESC P+q4667<ST>'  : 'termcap query for Fg (key_f52)',
    '> ESC P+q4668<ST>'  : 'termcap query for Fh (key_f53)',
    '> ESC P+q4669<ST>'  : 'termcap query for Fi (key_f54)',
    '> ESC P+q466a<ST>'  : 'termcap query for Fj (key_f55)',
    '> ESC P+q466b<ST>'  : 'termcap query for Fk (key_f56)',
    '> ESC P+q466c<ST>'  : 'termcap query for Fl (key_f57)',
    '> ESC P+q466d<ST>'  : 'termcap query for Fm (key_f58)',
    '> ESC P+q466e<ST>'  : 'termcap query for Fn (key_f59)',
    '> ESC P+q6b36<ST>'  : 'termcap query for k6 (key_f6)',
    '> ESC P+q466f<ST>'  : 'termcap query for Fo (key_f60)',
    '> ESC P+q4670<ST>'  : 'termcap query for Fp (key_f61)',
    '> ESC P+q4671<ST>'  : 'termcap query for Fq (key_f62)',
    '> ESC P+q4672<ST>'  : 'termcap query for Fr (key_f63)',
    '> ESC P+q6b37<ST>'  : 'termcap query for k7 (key_f7)',
    '> ESC P+q6b38<ST>'  : 'termcap query for k8 (key_f8)',
    '> ESC P+q6b39<ST>'  : 'termcap query for k9 (key_f9)',
    '> ESC P+q4030<ST>'  : 'termcap query for @0 (key_find)',
    '> ESC P+q2531<ST>'  : 'termcap query for %1 (key_help)',
    '> ESC P+q6b68<ST>'  : 'termcap query for kh (key_home)',
    '> ESC P+q6b49<ST>'  : 'termcap query for kI (key_ic)',
    '> ESC P+q6b41<ST>'  : 'termcap query for kA (key_il)',
    '> ESC P+q6b6c<ST>'  : 'termcap query for kl (key_left)',
    '> ESC P+q6b48<ST>'  : 'termcap query for kH (key_ll)',
    '> ESC P+q2532<ST>'  : 'termcap query for %2 (key_mark)',
    '> ESC P+q2533<ST>'  : 'termcap query for %3 (key_message)',
    '> ESC P+q2534<ST>'  : 'termcap query for %4 (key_move)',
    '> ESC P+q2535<ST>'  : 'termcap query for %5 (key_next)',
    '> ESC P+q6b4e<ST>'  : 'termcap query for kN (key_npage)',
    '> ESC P+q2536<ST>'  : 'termcap query for %6 (key_open)',
    '> ESC P+q2537<ST>'  : 'termcap query for %7 (key_options)',
    '> ESC P+q6b50<ST>'  : 'termcap query for kP (key_ppage)',
    '> ESC P+q2538<ST>'  : 'termcap query for %8 (key_previous)',
    '> ESC P+q2539<ST>'  : 'termcap query for %9 (key_print)',
    '> ESC P+q2530<ST>'  : 'termcap query for %0 (key_redo)',
    '> ESC P+q2631<ST>'  : 'termcap query for &1 (key_reference)',
    '> ESC P+q2632<ST>'  : 'termcap query for &2 (key_refresh)',
    '> ESC P+q2633<ST>'  : 'termcap query for &3 (key_replace)',
    '> ESC P+q2634<ST>'  : 'termcap query for &4 (key_restart)',
    '> ESC P+q2635<ST>'  : 'termcap query for &5 (key_resume)',
    '> ESC P+q6b72<ST>'  : 'termcap query for kr (key_right)',
    '> ESC P+q2636<ST>'  : 'termcap query for &6 (key_save)',
    '> ESC P+q2639<ST>'  : 'termcap query for &9 (key_sbeg)',
    '> ESC P+q2630<ST>'  : 'termcap query for &0 (key_scancel)',
    '> ESC P+q2a31<ST>'  : 'termcap query for *1 (key_scommand)',
    '> ESC P+q2a32<ST>'  : 'termcap query for *2 (key_scopy)',
    '> ESC P+q2a33<ST>'  : 'termcap query for *3 (key_screate)',
    '> ESC P+q2a34<ST>'  : 'termcap query for *4 (key_sdc)',
    '> ESC P+q2a35<ST>'  : 'termcap query for *5 (key_sdl)',
    '> ESC P+q2a36<ST>'  : 'termcap query for *6 (key_select)',
    '> ESC P+q2a37<ST>'  : 'termcap query for *7 (key_send)',
    '> ESC P+q2a38<ST>'  : 'termcap query for *8 (key_seol)',
    '> ESC P+q2a39<ST>'  : 'termcap query for *9 (key_sexit)',
    '> ESC P+q6b46<ST>'  : 'termcap query for kF (key_sf)',
    '> ESC P+q2a30<ST>'  : 'termcap query for *0 (key_sfind)',
    '> ESC P+q2331<ST>'  : 'termcap query for #1 (key_shelp)',
    '> ESC P+q2332<ST>'  : 'termcap query for #2 (key_shome)',
    '> ESC P+q2333<ST>'  : 'termcap query for #3 (key_sic)',
    '> ESC P+q2334<ST>'  : 'termcap query for #4 (key_sleft)',
    '> ESC P+q2561<ST>'  : 'termcap query for %a (key_smessage)',
    '> ESC P+q2562<ST>'  : 'termcap query for %b (key_smove)',
    '> ESC P+q2563<ST>'  : 'termcap query for %c (key_snext)',
    '> ESC P+q2564<ST>'  : 'termcap query for %d (key_soptions)',
    '> ESC P+q2565<ST>'  : 'termcap query for %e (key_sprevious)',
    '> ESC P+q2566<ST>'  : 'termcap query for %f (key_sprint)',
    '> ESC P+q6b52<ST>'  : 'termcap query for kR (key_sr)',
    '> ESC P+q2567<ST>'  : 'termcap query for %g (key_sredo)',
    '> ESC P+q2568<ST>'  : 'termcap query for %h (key_sreplace)',
    '> ESC P+q2569<ST>'  : 'termcap query for %i (key_sright)',
    '> ESC P+q256a<ST>'  : 'termcap query for %j (key_srsume)',
    '> ESC P+q2131<ST>'  : 'termcap query for !1 (key_ssave)',
    '> ESC P+q2132<ST>'  : 'termcap query for !2 (key_ssuspend)',
    '> ESC P+q6b54<ST>'  : 'termcap query for kT (key_stab)',
    '> ESC P+q2133<ST>'  : 'termcap query for !3 (key_sundo)',
    '> ESC P+q2637<ST>'  : 'termcap query for &7 (key_suspend)',
    '> ESC P+q2638<ST>'  : 'termcap query for &8 (key_undo)',
    '> ESC P+q6b75<ST>'  : 'termcap query for ku (key_up)',
    '> ESC P+q6b65<ST>'  : 'termcap query for ke (keypad_local)',
    '> ESC P+q6b73<ST>'  : 'termcap query for ks (keypad_xmit)',
    '> ESC P+q6c30<ST>'  : 'termcap query for l0 (lab_f0)',
    '> ESC P+q6c31<ST>'  : 'termcap query for l1 (lab_f1)',
    '> ESC P+q6c61<ST>'  : 'termcap query for la (lab_f10)',
    '> ESC P+q6c32<ST>'  : 'termcap query for l2 (lab_f2)',
    '> ESC P+q6c33<ST>'  : 'termcap query for l3 (lab_f3)',
    '> ESC P+q6c34<ST>'  : 'termcap query for l4 (lab_f4)',
    '> ESC P+q6c35<ST>'  : 'termcap query for l5 (lab_f5)',
    '> ESC P+q6c36<ST>'  : 'termcap query for l6 (lab_f6)',
    '> ESC P+q6c37<ST>'  : 'termcap query for l7 (lab_f7)',
    '> ESC P+q6c38<ST>'  : 'termcap query for l8 (lab_f8)',
    '> ESC P+q6c39<ST>'  : 'termcap query for l9 (lab_f9)',
    '> ESC P+q4c66<ST>'  : 'termcap query for Lf (label_format)',
    '> ESC P+q4c46<ST>'  : 'termcap query for LF (label_off)',
    '> ESC P+q4c4f<ST>'  : 'termcap query for LO (label_on)',
    '> ESC P+q6d6f<ST>'  : 'termcap query for mo (meta_off)',
    '> ESC P+q6d6d<ST>'  : 'termcap query for mm (meta_on)',
    '> ESC P+q5a59<ST>'  : 'termcap query for ZY (micro_column_address)',
    '> ESC P+q5a5a<ST>'  : 'termcap query for ZZ (micro_down)',
    '> ESC P+q5a61<ST>'  : 'termcap query for Za (micro_left)',
    '> ESC P+q5a62<ST>'  : 'termcap query for Zb (micro_right)',
    '> ESC P+q5a63<ST>'  : 'termcap query for Zc (micro_row_address)',
    '> ESC P+q5a64<ST>'  : 'termcap query for Zd (micro_up)',
    '> ESC P+q6e77<ST>'  : 'termcap query for nw (newline)',
    '> ESC P+q5a65<ST>'  : 'termcap query for Ze (order_of_pins)',
    '> ESC P+q6f63<ST>'  : 'termcap query for oc (orig_colors)',
    '> ESC P+q6f70<ST>'  : 'termcap query for op (orig_pair)',
    '> ESC P+q7063<ST>'  : 'termcap query for pc (pad_char)',
    '> ESC P+q4443<ST>'  : 'termcap query for DC (parm_dch)',
    '> ESC P+q444c<ST>'  : 'termcap query for DL (parm_delete_line)',
    '> ESC P+q444f<ST>'  : 'termcap query for DO (parm_down_cursor)',
    '> ESC P+q5a66<ST>'  : 'termcap query for Zf (parm_down_micro)',
    '> ESC P+q4943<ST>'  : 'termcap query for IC (parm_ich)',
    '> ESC P+q5346<ST>'  : 'termcap query for SF (parm_index)',
    '> ESC P+q414c<ST>'  : 'termcap query for AL (parm_insert_line)',
    '> ESC P+q4c45<ST>'  : 'termcap query for LE (parm_left_cursor)',
    '> ESC P+q5a67<ST>'  : 'termcap query for Zg (parm_left_micro)',
    '> ESC P+q5249<ST>'  : 'termcap query for RI (parm_right_cursor)',
    '> ESC P+q5a68<ST>'  : 'termcap query for Zh (parm_right_micro)',
    '> ESC P+q5352<ST>'  : 'termcap query for SR (parm_rindex)',
    '> ESC P+q5550<ST>'  : 'termcap query for UP (parm_up_cursor)',
    '> ESC P+q5a69<ST>'  : 'termcap query for Zi (parm_up_micro)',
    '> ESC P+q706b<ST>'  : 'termcap query for pk (pkey_key)',
    '> ESC P+q706c<ST>'  : 'termcap query for pl (pkey_local)',
    '> ESC P+q7078<ST>'  : 'termcap query for px (pkey_xmit)',
    '> ESC P+q706e<ST>'  : 'termcap query for pn (plab_norm)',
    '> ESC P+q7073<ST>'  : 'termcap query for ps (print_screen)',
    '> ESC P+q704f<ST>'  : 'termcap query for pO (prtr_non)',
    '> ESC P+q7066<ST>'  : 'termcap query for pf (prtr_off)',
    '> ESC P+q706f<ST>'  : 'termcap query for po (prtr_on)',
    '> ESC P+q5055<ST>'  : 'termcap query for PU (pulse)',
    '> ESC P+q5144<ST>'  : 'termcap query for QD (quick_dial)',
    '> ESC P+q5243<ST>'  : 'termcap query for RC (remove_clock)',
    '> ESC P+q7270<ST>'  : 'termcap query for rp (repeat_char)',
    '> ESC P+q5246<ST>'  : 'termcap query for RF (req_for_input)',
    '> ESC P+q7231<ST>'  : 'termcap query for r1 (reset_1string)',
    '> ESC P+q7232<ST>'  : 'termcap query for r2 (reset_2string)',
    '> ESC P+q7233<ST>'  : 'termcap query for r3 (reset_3string)',
    '> ESC P+q7266<ST>'  : 'termcap query for rf (reset_file)',
    '> ESC P+q7263<ST>'  : 'termcap query for rc (restore_cursor)',
    '> ESC P+q6376<ST>'  : 'termcap query for cv (row_address)',
    '> ESC P+q7363<ST>'  : 'termcap query for sc (save_cursor)',
    '> ESC P+q7366<ST>'  : 'termcap query for sf (scroll_forward)',
    '> ESC P+q7372<ST>'  : 'termcap query for sr (scroll_reverse)',
    '> ESC P+q5a6a<ST>'  : 'termcap query for Zj (select_char_set)',
    '> ESC P+q7361<ST>'  : 'termcap query for sa (set_attributes)',
    '> ESC P+q5362<ST>'  : 'termcap query for Sb (set_background)',
    '> ESC P+q5a6b<ST>'  : 'termcap query for Zk (set_bottom_margin)',
    '> ESC P+q5a6c<ST>'  : 'termcap query for Zl (set_bottom_margin_parm)',
    '> ESC P+q5343<ST>'  : 'termcap query for SC (set_clock)',
    '> ESC P+q7370<ST>'  : 'termcap query for sp (set_color_pair)',
    '> ESC P+q5366<ST>'  : 'termcap query for Sf (set_foreground)',
    '> ESC P+q5a6d<ST>'  : 'termcap query for Zm (set_left_margin_parm)',
    '> ESC P+q4d52<ST>'  : 'termcap query for MR (set_right_margin)',
    '> ESC P+q5a6e<ST>'  : 'termcap query for Zn (set_right_margin_parm)',
    '> ESC P+q7374<ST>'  : 'termcap query for st (set_tab)',
    '> ESC P+q5a6f<ST>'  : 'termcap query for Zo (set_top_margin)',
    '> ESC P+q5a70<ST>'  : 'termcap query for Zp (set_top_margin_parm)',
    '> ESC P+q7769<ST>'  : 'termcap query for wi (set_window)',
    '> ESC P+q5a71<ST>'  : 'termcap query for Zq (start_bit_image)',
    '> ESC P+q5a72<ST>'  : 'termcap query for Zr (start_char_set_def)',
    '> ESC P+q5a73<ST>'  : 'termcap query for Zs (stop_bit_image)',
    '> ESC P+q5a74<ST>'  : 'termcap query for Zt (stop_char_set_def)',
    '> ESC P+q5a75<ST>'  : 'termcap query for Zu (subscript_characters)',
    '> ESC P+q5a76<ST>'  : 'termcap query for Zv (superscript_characters)',
    '> ESC P+q7461<ST>'  : 'termcap query for ta (tab)',
    '> ESC P+q5a77<ST>'  : 'termcap query for Zw (these_cause_cr)',
    '> ESC P+q7473<ST>'  : 'termcap query for ts (to_status_line)',
    '> ESC P+q544f<ST>'  : 'termcap query for TO (tone)',
    '> ESC P+q7563<ST>'  : 'termcap query for uc (underline_char)',
    '> ESC P+q6875<ST>'  : 'termcap query for hu (up_half_line)',
    '> ESC P+q7530<ST>'  : 'termcap query for u0 (user0)',
    '> ESC P+q7531<ST>'  : 'termcap query for u1 (user1)',
    '> ESC P+q7532<ST>'  : 'termcap query for u2 (user2)',
    '> ESC P+q7533<ST>'  : 'termcap query for u3 (user3)',
    '> ESC P+q7534<ST>'  : 'termcap query for u4 (user4)',
    '> ESC P+q7535<ST>'  : 'termcap query for u5 (user5)',
    '> ESC P+q7536<ST>'  : 'termcap query for u6 (user6)',
    '> ESC P+q7537<ST>'  : 'termcap query for u7 (user7)',
    '> ESC P+q7538<ST>'  : 'termcap query for u8 (user8)',
    '> ESC P+q7539<ST>'  : 'termcap query for u9 (user9)',
    '> ESC P+q5741<ST>'  : 'termcap query for WA (wait_tone)',
    '> ESC P+q5846<ST>'  : 'termcap query for XF (xoff_character)',
    '> ESC P+q584e<ST>'  : 'termcap query for XN (xon_character)',
    '> ESC P+q5a78<ST>'  : 'termcap query for Zx (zero_motion)',
    '> ESC P+q5338<ST>'  : 'termcap query for S8 (alt_scancode_esc)',
    '> ESC P+q5976<ST>'  : 'termcap query for Yv (bit_image_carriage_return)',
    '> ESC P+q5a7a<ST>'  : 'termcap query for Zz (bit_image_newline)',
    '> ESC P+q5879<ST>'  : 'termcap query for Xy (bit_image_repeat)',
    '> ESC P+q5a79<ST>'  : 'termcap query for Zy (char_set_names)',
    '> ESC P+q6369<ST>'  : 'termcap query for ci (code_set_init)',
    '> ESC P+q5977<ST>'  : 'termcap query for Yw (color_names)',
    '> ESC P+q5978<ST>'  : 'termcap query for Yx (define_bit_image_region)',
    '> ESC P+q6476<ST>'  : 'termcap query for dv (device_type)',
    '> ESC P+q5331<ST>'  : 'termcap query for S1 (display_pc_char)',
    '> ESC P+q5979<ST>'  : 'termcap query for Yy (end_bit_image_region)',
    '> ESC P+q5332<ST>'  : 'termcap query for S2 (enter_pc_charset_mode)',
    '> ESC P+q5334<ST>'  : 'termcap query for S4 (enter_scancode_mode)',
    '> ESC P+q5333<ST>'  : 'termcap query for S3 (exit_pc_charset_mode)',
    '> ESC P+q5335<ST>'  : 'termcap query for S5 (exit_scancode_mode)',
    '> ESC P+q476d<ST>'  : 'termcap query for Gm (get_mouse)',
    '> ESC P+q4b6d<ST>'  : 'termcap query for Km (key_mouse)',
    '> ESC P+q4d69<ST>'  : 'termcap query for Mi (mouse_info)',
    '> ESC P+q5336<ST>'  : 'termcap query for S6 (pc_term_options)',
    '> ESC P+q786c<ST>'  : 'termcap query for xl (pkey_plab)',
    '> ESC P+q5251<ST>'  : 'termcap query for RQ (req_mouse_pos)',
    '> ESC P+q5337<ST>'  : 'termcap query for S7 (scancode_escape)',
    '> ESC P+q7330<ST>'  : 'termcap query for s0 (set0_des_seq)',
    '> ESC P+q7331<ST>'  : 'termcap query for s1 (set1_des_seq)',
    '> ESC P+q7332<ST>'  : 'termcap query for s2 (set2_des_seq)',
    '> ESC P+q7333<ST>'  : 'termcap query for s3 (set3_des_seq)',
    '> ESC P+q4142<ST>'  : 'termcap query for AB (set_a_background)',
    '> ESC P+q4146<ST>'  : 'termcap query for AF (set_a_foreground)',
    '> ESC P+q597a<ST>'  : 'termcap query for Yz (set_color_band)',
    '> ESC P+q4d4c<ST>'  : 'termcap query for ML (set_left_margin / set_lr_margin)',
    '> ESC P+q595a<ST>'  : 'termcap query for YZ (set_page_length)',
    '> ESC P+q4d54<ST>'  : 'termcap query for MT (set_tb_margin)',
    '> ESC P+q5868<ST>'  : 'termcap query for Xh (enter_horizontal_hl_mode)',
    '> ESC P+q586c<ST>'  : 'termcap query for Xl (enter_left_hl_mode)',
    '> ESC P+q586f<ST>'  : 'termcap query for Xo (enter_low_hl_mode)',
    '> ESC P+q5872<ST>'  : 'termcap query for Xr (enter_right_hl_mode)',
    '> ESC P+q5874<ST>'  : 'termcap query for Xt (enter_top_hl_mode)',
    '> ESC P+q5876<ST>'  : 'termcap query for Xv (enter_vertical_hl_mode)',
    '> ESC P+q7341<ST>'  : 'termcap query for sA (set_a_attributes)',
    '> ESC P+q734c<ST>'  : 'termcap query for sL (set_pglen_inch)',
    '> ESC ]<ST>'        : 'OSC / operating system command',
    '> ESC ]0<ST>'       : 'OSC 0 / set icon name and window title',
    '> ESC ]1<ST>'       : 'OSC 1 / set icon name',
    '> ESC ]2<ST>'       : 'OSC 2 / set window title',
    '> ESC ]4<ST>'       : 'OSC 4 / get or set color palette',
    '> ESC ]5<ST>'       : 'OSC 5 / set or set alternate color palette',
    '> ESC ]5;0<ST>'     : 'OSC 5 / set alternate bold color',
    '> ESC ]5;1<ST>'     : 'OSC 5 / set alternate underline color',
    '> ESC ]5;2<ST>'     : 'OSC 5 / set alternate blink color',
    '> ESC ]5;3<ST>'     : 'OSC 5 / set alternate reverse color',
    '> ESC ]9<ST>'       : 'OSC 9 / Growl integration (iTerm2)',
    '> ESC ]10<ST>'      : 'OSC 10 / set foreground color',
    '> ESC ]10;?<ST>'    : 'OSC 10 / get foreground color',
    '> ESC ]11<ST>'      : 'OSC 11 / set background color',
    '> ESC ]11;?<ST>'    : 'OSC 11 / get background color',
    '> ESC ]12<ST>'      : 'OSC 12 / set cursor color',
    '> ESC ]12;?<ST>'    : 'OSC 12 / get cursor color',
    '> ESC ]13<ST>'      : 'OSC 13 / set mouse foreground color',
    '> ESC ]13;?<ST>'    : 'OSC 13 / get mouse foreground color',
    '> ESC ]14<ST>'      : 'OSC 14 / set mouse background color',
    '> ESC ]14;?<ST>'    : 'OSC 14 / get mouse background color',
    '> ESC ]15<ST>'      : 'OSC 15 / set tektronix foreground color',
    '> ESC ]15;?<ST>'    : 'OSC 15 / get tektronix foreground color',
    '> ESC ]16<ST>'      : 'OSC 16 / set tektronix background color',
    '> ESC ]16;?<ST>'    : 'OSC 16 / get tektronix background color',
    '> ESC ]17<ST>'      : 'OSC 17 / set highlight background color',
    '> ESC ]17;?<ST>'    : 'OSC 17 / get highlight background color',
    '> ESC ]18<ST>'      : 'OSC 18 / set textronix cursor color',
    '> ESC ]18;?<ST>'    : 'OSC 18 / get textronix cursor color',
    '> ESC ]19<ST>'      : 'OSC 19 / set highlight foreground color',
    '> ESC ]19;?<ST>'    : 'OSC 19 / get highlight foreground color',
    '> ESC ]46<ST>'      : 'OSC 46 / change log file',
    '> ESC ]50<ST>'      : 'OSC 50 / set font(xterm), set property(Konsole), execute various commands(iTerm2, deprecated)',
    '> ESC ]51<ST>'      : 'OSC 51 / reserved for Emacs',
    '> ESC ]52;i<ST>'    : 'OSC 52 / term+-edit-insert (term+.el)',
    '> ESC ]52;h<ST>'    : 'OSC 52 / term+-shell-history (term+.el)',
    '> ESC ]52<ST>'      : 'OSC 52 - PASTE64 / base64 clipboard read/write operation (xterm)',
    '> ESC ]104<ST>'     : 'OSC 104 / reset specified color number',
    '> ESC ]105<ST>'     : 'OSC 105 / reset specified special color number',
    '> ESC ]110<ST>'     : 'OSC 110 / reset VT100 text foreground color',
    '> ESC ]111<ST>'     : 'OSC 111 / reset VT100 text background color',
    '> ESC ]112<ST>'     : 'OSC 112 / reset cursor color',
    '> ESC ]113<ST>'     : 'OSC 113 / reset mouse foreground color',
    '> ESC ]114<ST>'     : 'OSC 114 / reset mouse background color',
    '> ESC ]115<ST>'     : 'OSC 115 / reset tektronix foreground color',
    '> ESC ]116<ST>'     : 'OSC 116 / reset tektronix background color',
    '> ESC ]117<ST>'     : 'OSC 117 / reset highlight color',
    '> ESC ]118<ST>'     : 'OSC 118 / reset tektoronix cursor color',
    '> ESC ]701<ST>'     : 'OSC 701 / manipulate locale (MinTTY)',
    '> ESC ]1337<ST>'    : 'OSC 1337 / execute various commands(iTerm2)',
    '> ESC ]5379<ST>'    : 'OSC 5379 / exec command or set (mlterm)',
    '> ESC ]5380<ST>'    : 'OSC 5380 / get pty (mlterm)',
    '> ESC ]5381<ST>'    : 'OSC 5381 / get GUI menu (mlterm)',
    '> ESC ]5383<ST>'    : 'OSC 5383 / set & save (mlterm)',
    '> ESC ]7770<ST>'    : 'OSC 7770 / manipulate font size (MinTTY)',
    '> ESC ]7770;?<ST>'  : 'OSC 7770 / query font size (MinTTY)',
    '> ESC ]7771<ST>'    : 'OSC 7771 / font coverage (MinTTY)',
    '> ESC ]8900<ST>'    : 'OSC 8900 - GWREPT / glyph width report (yaft)',
    '< ESC ]$t<ST>'      : 'OSC $t / set window title (PowerTerm)',
    '> ESC X<ST>'        : 'SOS / start of string',
    '> ESC ^<ST>'        : 'PM / private message',
    '> ESC _<ST>'        : 'APC / application program command',
    '> ESC 1'            : 'DECHTS or DECGON / horizontal tab set(LA100/LN07/LN05/RLogin) or graphics on (VT105)',
    '> ESC 2'            : 'DECCAHT or DECGOFF / clear all horizontal tabs(LA100/LN07/LN05/RLogin) or graphics off (VT105)',
    '> ESC 3'            : 'DECVTS / vertical tab set (LA100/LN07/LN05/RLogin)',
    '> ESC 4'            : 'DECCAVT / clear all vertical tabs (LA100/LN07/LN05/RLogin)',
    '> ESC 6'            : 'DECBI / backward index',
    '> ESC 7'            : 'DECSC / save cursor',
    '> ESC 8'            : 'DECRC / restore cursor',
    '> ESC 9'            : 'DECFI / forward index',
    '> ESC ='            : 'DECKPAM / application keypad',
    '> ESC >'            : 'DECKPNM / normal keypad',
    '> ESC D'            : 'IND / moves the cursor down one line in the same column',
    '> ESC E'            : 'NEL / moves the cursor to the first position on the next line',
    '> ESC H'            : 'HTS / sets a horizontal tab stop at the column where the cursor is. ',
    '> ESC I'            : 'HTJ / horizontal tab with justify',
    '> ESC J'            : 'VTS / sets a vertical tab stop',
    '> ESC K'            : 'PLD / partial line down',
    '> ESC L'            : 'PLU / partial line up',
    '> ESC M'            : 'RI / moves the cursor up one line in the same column',
    '> ESC N'            : 'SS2 / temporarily maps the G2 character set into GL or GR, for the next graphic character',
    '> ESC O'            : 'SS3 / temporarily maps the G3 character set into GL or GR, for the next graphic character',
    '> ESC \\'           : 'ST / String terminator. Ends a DCS, SOS, OSC, PM and APC sequence',
    '> ESC c'            : 'RIS / full reset',
    '> ESC <SP>F'        : 'S7C1T',
    '> ESC <SP>G'        : 'S8C1T',
    '> ESC <SP>L'        : 'Set ANSI conformance level 1',
    '> ESC <SP>M'        : 'Set ANSI conformance level 2',
    '> ESC <SP>N'        : 'Set ANSI conformance level 3',
    '> ESC #3'           : 'DECDHLT / double height line, top half',
    '> ESC #4'           : 'DECDHLB / double height line, bottom half',
    '> ESC #5'           : 'DECSWL / single width line',
    '> ESC #6'           : 'DECDWL / double width line',
    '> ESC #8'           : 'DECALN / screen alignment pattern',
    '> ESC %@'           : 'Select default character set',
    '> ESC %G'           : 'Select UTF-8 character set',
    '> ESC (0'           : 'designate G0 charset: DEC Special Character and Line Drawing Set',
    '> ESC (A'           : 'designate G0 charset: United Kingdom (UK)',
    '> ESC (B'           : 'designate G0 charset: United States (USASCII)',
    '> ESC (4'           : 'designate G0 charset: Dutch',
    '> ESC (C'           : 'designate G0 charset: Finnish',
    '> ESC (5'           : 'designate G0 charset: Finnish',
    '> ESC (R'           : 'designate G0 charset: French',
    '> ESC (Q'           : 'designate G0 charset: French Canadian',
    '> ESC (K'           : 'designate G0 charset: German',
    '> ESC (I'           : 'designate G0 charset: Italian',
    '> ESC (E'           : 'designate G0 charset: Norwegian/Danish',
    '> ESC (6'           : 'designate G0 charset: Norwegian/Danish',
    '> ESC (Z'           : 'designate G0 charset: Spanish',
    '> ESC (H'           : 'designate G0 charset: Swedish',
    '> ESC (7'           : 'designate G0 charset: Swedish',
    '> ESC (='           : 'designate G0 charset: Swiss',
    '> ESC )0'           : 'designate G1 charset: DEC Special Character and Line Drawing Set',
    '> ESC )A'           : 'designate G1 charset: United Kingdom (UK)',
    '> ESC )B'           : 'designate G1 charset: United States (USASCII)',
    '> ESC )4'           : 'designate G1 charset: Dutch',
    '> ESC )C'           : 'designate G1 charset: Finnish',
    '> ESC )5'           : 'designate G1 charset: Finnish',
    '> ESC )R'           : 'designate G1 charset: French',
    '> ESC )Q'           : 'designate G1 charset: French Canadian',
    '> ESC )K'           : 'designate G1 charset: German',
    '> ESC )I'           : 'designate G1 charset: Italian',
    '> ESC )E'           : 'designate G1 charset: Norwegian/Danish',
    '> ESC )6'           : 'designate G1 charset: Norwegian/Danish',
    '> ESC )Z'           : 'designate G1 charset: Spanish',
    '> ESC )H'           : 'designate G1 charset: Swedish',
    '> ESC )7'           : 'designate G1 charset: Swedish',
    '> ESC )='           : 'designate G1 charset: Swiss',
    '> ESC *0'           : 'designate G2 charset: DEC Special Character and Line Drawing Set',
    '> ESC *A'           : 'designate G2 charset: United Kingdom (UK)',
    '> ESC *B'           : 'designate G2 charset: United States (USASCII)',
    '> ESC *4'           : 'designate G2 charset: Dutch',
    '> ESC *C'           : 'designate G2 charset: Finnish',
    '> ESC *5'           : 'designate G2 charset: Finnish',
    '> ESC *R'           : 'designate G2 charset: French',
    '> ESC *Q'           : 'designate G2 charset: French Canadian',
    '> ESC *K'           : 'designate G2 charset: German',
    '> ESC *I'           : 'designate G2 charset: Italian',
    '> ESC *E'           : 'designate G2 charset: Norwegian/Danish',
    '> ESC *6'           : 'designate G2 charset: Norwegian/Danish',
    '> ESC *Z'           : 'designate G2 charset: Spanish',
    '> ESC *H'           : 'designate G2 charset: Swedish',
    '> ESC *7'           : 'designate G2 charset: Swedish',
    '> ESC *='           : 'designate G2 charset: Swiss',
    '> ESC +0'           : 'designate G3 charset: DEC Special Character and Line Drawing Set',
    '> ESC +A'           : 'designate G3 charset: United Kingdom (UK)',
    '> ESC +B'           : 'designate G3 charset: United States (USASCII)',
    '> ESC +4'           : 'designate G3 charset: Dutch',
    '> ESC +C'           : 'designate G3 charset: Finnish',
    '> ESC +5'           : 'designate G3 charset: Finnish',
    '> ESC +R'           : 'designate G3 charset: French',
    '> ESC +Q'           : 'designate G3 charset: French Canadian',
    '> ESC +K'           : 'designate G3 charset: German',
    '> ESC +I'           : 'designate G3 charset: Italian',
    '> ESC +E'           : 'designate G3 charset: Norwegian/Danish',
    '> ESC +6'           : 'designate G3 charset: Norwegian/Danish',
    '> ESC +Z'           : 'designate G3 charset: Spanish',
    '> ESC +H'           : 'designate G3 charset: Swedish',
    '> ESC +7'           : 'designate G3 charset: Swedish',
    '> ESC +='           : 'designate G3 charset: Swiss',
    '> ESC Q'            : 'PU1 / private use one',
    '> ESC R'            : 'PU2 / private use two',
    '> ESC S'            : 'STS / set transmit state',
    '> ESC T'            : 'CCH / cancel character',
    '> ESC U'            : 'MW / message waiting',
    '> ESC V'            : 'SPA / start of guarded area',
    '> ESC W'            : 'EPA / end of guarded area',
    '> ESC Z'            : 'SCI / single character introducer',
    '> CSI @'            : 'ICH / insert blank characters',
    '> CSI [0]@'         : 'ICH 1 / insert a blank character',
    '> CSI A'            : 'CUU / cursor up',
    '> CSI [0]A'         : 'CUU 1 / cursor up',
    '> CSI =A'           : 'SBC / set border color',
    '> CSI =0A'          : 'SBC 0 / set border color to black',
    '> CSI =1A'          : 'SBC 1 / set border color to blue',
    '> CSI =2A'          : 'SBC 2 / set border color to green',
    '> CSI =3A'          : 'SBC 3 / set border color to cyan',
    '> CSI =4A'          : 'SBC 4 / set border color to red',
    '> CSI =5A'          : 'SBC 5 / set border color to magenta',
    '> CSI =6A'          : 'SBC 6 / set border color to brown',
    '> CSI =7A'          : 'SBC 7 / set border color to white',
    '> CSI =8A'          : 'SBC 8 / set border color to gray',
    '> CSI =9A'          : 'SBC 9 / set border color to light blue',
    '> CSI =10A'         : 'SBC 10 / set border color to light green',
    '> CSI =11A'         : 'SBC 11 / set border color to light cyan',
    '> CSI =12A'         : 'SBC 12 / set border color to light red',
    '> CSI =13A'         : 'SBC 13 / set border color to light magenta',
    '> CSI =14A'         : 'SBC 14 / set border color to yellow',
    '> CSI =15A'         : 'SBC 15 / set border color to light white',
    '> CSI B'            : 'CUD / cursor down',
    '> CSI [0]B'         : 'CUD 1 / cursor down',
    '> CSI =B'           : 'SBP / set bell parameters',
    '> CSI =[2]B'        : 'SBP / set bell parameters - frequency=%d, duration=%d',
    '> CSI C'            : 'CUF / cursor forward',
    '> CSI [0]C'         : 'CUF 1 / cursor forward',
    '> CSI =C'           : 'set cursor parameters',
    '> CSI D'            : 'CUB / cursor backward',
    '> CSI [0]D'         : 'CUB 1 / cursor backward',
    '> CSI =D'           : 'SBI / set backward intensity',
    '> CSI E'            : 'CNL / cursor next line',
    '> CSI [0]E'         : 'CNL 1 / cursor next line',
    '> CSI F'            : 'CPL / cursor preceding line',
    '> CSI [0]F'         : 'CPL 1 / cursor preceding line',
    '> CSI G'            : 'CHA / cursor character absolute',
    '> CSI [0]G'         : 'CHA 1 / cursor character absolute',
    '> CSI H'            : 'CUP',
    '> CSI [2]H'         : 'CUP / move cursor to (row=%s, col=%s)',
    '> CSI [0]H'         : 'CUP / move cursor to (1, 1)',
    '> CSI I'            : 'CHT / cursor forward tabulation',
    '> CSI [0]I'         : 'CHT 1 / cursor forward tabulation',
    '> CSI J'            : 'ED / erase display',
    '> CSI [0]J'         : 'ED 0 / erase display: from cursor through the end of the display',
    '> CSI 0J'           : 'ED 0 / erase display: from cursor through the end of the display',
    '> CSI 1J'           : 'ED 1 / erase display: from the beginning of the display through the cursor',
    '> CSI 2J'           : 'ED 2 / erase display: the complete of display',
    '> CSI K'            : 'EL / erase line',
    '> CSI [0]K'         : 'EL 0 / erase line: from the cursor through the end of the line',
    '> CSI 0K'           : 'EL 0 / erase line: from the cursor through the end of the line',
    '> CSI 1K'           : 'EL 1 / erase line: from the beginning of the line through the cursor',
    '> CSI 2K'           : 'EL 2 / erase line: the complete of line',
    '> CSI ?K'           : 'DECSEL / selective erase: from the cursor through the end of line',
    '> CSI ?0K'          : 'DECSEL 0 / selective erase: from the cursor through the end of line',
    '> CSI ?1K'          : 'DECSEL 1 / selective erase: from the beginning of the line through the cursor',
    '> CSI ?2K'          : 'DECSEL 2 / selective erase: the complete of line',
    '> CSI L'            : 'IL / insert lines',
    '> CSI [0]L'         : 'IL 1 / insert a line',
    '> CSI M'            : 'DL / delete lines',
    '> CSI [0]M'         : 'DL 1 / delete a line',
    '> CSI P'            : 'DCH / delete characters',
    '> CSI [0]P'         : 'DCH 1 / delete a character',
    '> CSI S'            : 'SU / scroll up',
    '> CSI [0]S'         : 'SU 1 / scroll up',
    '> CSI T'            : 'SD / scroll down',
    '> CSI [0]T'         : 'SD 1 / scroll down',
    '> CSI [1]T'         : 'SD / scroll down %s times',
    '> CSI [6]T'         : 'Initiate highlight mouse tracking (startx=%s,starty=%s,endx=%s,endy=%s,mousex=%s,mousey=%s)',
    '> CSI >T'           : 'Title Mode - Reset (xterm)',
    '> CSI >0T'          : 'Title Mode - Reset (xterm) 0: Do not set window/icon labels using hexadecimal',
    '> CSI >1T'          : 'Title Mode - Reset (xterm) 1: Do not query window/icon labels using hexadecimal',
    '> CSI >2T'          : 'Title Mode - Reset (xterm) 2: Do not set window/icon labels using UTF-8',
    '> CSI >3T'          : 'Title Mode - Reset (xterm) 3: Do not query window/icon labels using UTF-8',
    '> CSI X'            : 'ECH / erase characters',
    '> CSI [0]X'         : 'ECH 1 / erase a character',
    '> CSI Z'            : 'CBT / cursor backward tabulation',
    '> CSI [0]Z'         : 'CBT 1 / cursor backward tabulation',
    '> CSI `'            : 'HPA / horizontal position absolute',
    '> CSI [0]`'         : 'HPA 1 / horizontal position absolute',
    '> CSI a'            : 'HPR / horizontal position relative',
    '> CSI [0]a'         : 'HPR 1 / horizontal position relative',
    '> CSI b'            : 'REP / repeat',
    '> CSI c'            : 'DA1 / request primary device attribute',
    '> CSI >c'           : 'DA2 / request secondary device attribute',
    '> CSI d'            : 'VPA / vertical position absolute',
    '> CSI e'            : 'VPR / vertical position relative',
    '> CSI f'            : 'HVP / horizontal and vertical position',
    '> CSI g'            : 'TBC / tab clear',
    '> CSI h'            : 'SM / set mode',
    '> CSI ?h'           : 'DECSET',
    '> CSI ?1h'          : 'DECSET 1 - DECCKM / application cursor keys',
    '> CSI ?2h'          : 'DECSET 2 - DECANM / designate USASCII for G0-G3 (DECANM), and set VT100 mode',
    '> CSI ?3h'          : 'DECSET 3 - DECCOLM / 132 column mode',
    '> CSI ?4h'          : 'DECSET 4 - DECSCLM / enable smooth scroll mode',
    '> CSI ?5h'          : 'DECSET 5 - DECSCNM / enable reverse video',
    '> CSI ?6h'          : 'DECSET 6 - DECOM / enable origin mode',
    '> CSI ?7h'          : 'DECSET 7 - DECAWM / enable auto-wrap mode',
    '> CSI ?8h'          : 'DECSET 8 - DECARM / disable auto repeat keys',
    '> CSI ?9h'          : 'DECSET 9 / enable X10 compatible mouse mode',
    '> CSI ?10h'         : 'DECSET 10 / show toolbar (rxvt)',
    '> CSI ?12h'         : 'DECSET 12 / blinking cursor (att610)',
    '> CSI ?12;25h'      : 'DECSET 12;25 / visible and blinking cursor',
    '> CSI ?25h'         : 'DECSET 25 - DECTCEM / show cursor',
    '> CSI ?30h'         : 'DECSET 30 / show scroll bar (rxvt)',
    '> CSI ?35h'         : 'DECSET 35 / enable font-shifting functions / allow xterm shift+key sequences (rxvt/Eterm)',
    '> CSI ?38h'         : 'DECSET 38 - DECTEK / enter Tektronix mode',
    '> CSI ?40h'         : 'DECSET 40 / disallow 80 -> 132 mode',
    '> CSI ?41h'         : 'DECSET 41 / more(1) fix',
    '> CSI ?42h'         : 'DECSET 42 / enable nation replacement character set',
    '> CSI ?43h'         : 'DECSET 43 / expanded/compressed print mode',
    '> CSI ?44h'         : 'DECSET 44 / turn on margin bell',
    '> CSI ?45h'         : 'DECSET 45 / reverse wraparound mode',
    '> CSI ?46h'         : 'DECSET 46 / start logging',
    '> CSI ?47h'         : 'DECSET 47 / use alternate screen buffer',
    '> CSI ?51h'         : 'DECSET 51 - DECBWRM / enable black/white reversal mode',
    '> CSI ?52h'         : 'DECSET 52 - DECOPM / enable origin placement mode',
    '> CSI ?55h'         : 'DECSET 55 - DECBPM / enable bold page mode',
    '> CSI ?60h'         : 'DECSET 60 - DECHCCM / enable horizontal cursor-coupling mode',
    '> CSI ?61h'         : 'DECSET 61 - DECVCCM / enable vertical cursor-coupling mode',
    '> CSI ?63h'         : 'DECSET 63 - DECPCCM / enable page cursor-coupling mode',
    '> CSI ?66h'         : 'DECSET 66 - DECNKM / enable application keypad',
    '> CSI ?67h'         : 'DECSET 67 - DECBKM / enable backarrow key mode',
    '> CSI ?68h'         : 'DECSET 68 - DECKBUM / use data processing keys',
    '> CSI ?69h'         : 'DECSET 69 - DECLRM / enable left and right margin mode',
    '> CSI ?80h'         : 'DECSET 80 - DECSDM / disable SIXEL scrolling mode',
    '> CSI ?95h'         : 'DECSET 95 - DECNCSM / do not clear screen when DECCOLM is set/reset',
    '> CSI ?1000h'       : 'DECSET 1000 / enable xterm normal mouse tracking',
    '> CSI ?1001h'       : 'DECSET 1001 / enable highlight mouse tracking',
    '> CSI ?1002h'       : 'DECSET 1002 / enable button mouse tracking',
    '> CSI ?1003h'       : 'DECSET 1003 / enable all mouse tracking',
    '> CSI ?1004h'       : 'DECSET 1004 / enable focus tracking',
    '> CSI ?1005h'       : 'DECSET 1005 / enable UTF8 mouse mode',
    '> CSI ?1006h'       : 'DECSET 1006 / enable SGR mouse mode',
    '> CSI ?1007h'       : 'DECSET 1007 / enable alternate scroll mode',
    '> CSI ?1010h'       : 'DECSET 1010 / scroll to bottom on tty output (rxvt)',
    '> CSI ?1011h'       : 'DECSET 1011 / scroll to bottom on key press (rxvt)',
    '> CSI ?1015h'       : 'DECSET 1015 / enable urxvt mouse mode',
    '> CSI ?1047h'       : 'DECSET 1047 / use alternate screen buffer, clearing screen first if in the main screen',
    '> CSI ?1049h'       : 'DECSET 1049 / save cursor as in DECSC and use alternate screen buffer',
    '> CSI ?2004h'       : 'DECSET 2004 / enable bracketed paste mode',
    '> CSI ?7700h'       : 'DECSET 7700 / enable ambiguous reporting (MinTTY/tanasinn)',
    '> CSI ?7727h'       : 'DECSET 7727 / application escape keycode mode (MinTTY/TeraTerm/RLogin/mlterm/tanasinn)',
    '> CSI ?7728h'       : 'DECSET 7728 / treat ^\ as normal escape keycode (MinTTY)',
    '> CSI ?7766h'       : 'DECSET 7766 / show scroll bar (MinTTY)',
    '> CSI ?7783h'       : 'DECSET 7783 / enable shortcut override mode (MinTTY)',
    '> CSI ?7786h'       : 'DECSET 7786 / enable mousewheel reporting (cursor emulation) mode (MinTTY)',
    '> CSI ?7787h'       : 'DECSET 7787 / enable application mousewheel reporting mode (MinTTY)',
    '> CSI ?8428h'       : 'DECSET 8428 - RLAMBCHM / treat ambiguous characters as narrow(RLogin)',
    '> CSI ?8441h'       : 'DECSET 8441 / IME open(RLogin)',
    '> CSI ?8442h'       : 'DECSET 8442 / application escape keycode mode (RLogin)',
    '> CSI ?8443h'       : 'DECSET 8443 / enable mousewheel reporting (cursor emulation) mode (RLogin)',
    '> CSI ?8448h'       : 'DECSET 8448 / disable Unicode Normalization (RLogin)',
    '> CSI ?8452h'       : 'DECRST 8452 / force a line break after displaying inline SIXEL - compatible with DEC VT (RLogin)',
    '> CSI ?8453h'       : 'DECSET 8453 - DRCSMMv1 / enable DRCS-unicode mapping (RLogin)',
    '> CSI ?8800h'       : 'DECSET 8800 - DRCSMMv1 / enable DRCS-unicode mapping (drcsterm/tanasinn/mlterm/RLogin)',
    '> CSI ?8840h'       : 'DECSET 8840 / treat ambiguous characters as wide (tanasinn)',
    '> CSI i'            : 'MC',
    '> CSI ?i'           : 'MC - DEC Specific',
    '> CSI l'            : 'RM',
    '> CSI ?l'           : 'DECRST',
    '> CSI ?1l'          : 'DECRST 1 - DECCKM / normal cursor keys',
    '> CSI ?2l'          : 'DECRST 2 - DECANM / VT52 mode',
    '> CSI ?3l'          : 'DECRST 3 - DECCOLM / 80 column mode',
    '> CSI ?3;4l'        : 'DECRST 3;4 - enable 80 column mode and disable smooth scroll mode',
    '> CSI ?4l'          : 'DECRST 4 - DECSCLM / disable smooth scroll mode',
    '> CSI ?5l'          : 'DECRST 5 - DECSCNM / disable reverse video',
    '> CSI ?6l'          : 'DECRST 6 - DECOM / disable origin mode',
    '> CSI ?7l'          : 'DECRST 7 - DECAWM / disable auto-wrap mode',
    '> CSI ?8l'          : 'DECRST 8 - DECARM / disable auto repeat keys',
    '> CSI ?9l'          : 'DECRST 9 / disable X10 compatible mouse mode',
    '> CSI ?10l'         : 'DECRST 10 / hide toolbar (rxvt)',
    '> CSI ?12l'         : 'DECRST 12 / steady cursor',
    '> CSI ?25l'         : 'DECRST 25 - DECTCEM / hide cursor',
    '> CSI ?30l'         : 'DECRST 30 / hide scroll bar (rxvt)',
    '> CSI ?35l'         : 'DECRST 35 / disable font-shifting functions / disallow xterm shift+key sequences (rxvt/Eterm)',
    '> CSI ?38l'         : 'DECRST 38 - DECTEK / exit Tektronix mode',
    '> CSI ?40l'         : 'DECRST 40 / allow 80 -> 132 mode',
    '> CSI ?41l'         : 'DECRST 41 / no more(1) fix',
    '> CSI ?42l'         : 'DECRST 42 / disable nation replacement character set',
    '> CSI ?43l'         : 'DECRST 43 / expanded/compressed print mode',
    '> CSI ?44l'         : 'DECRST 44 / turn off margin bell',
    '> CSI ?45l'         : 'DECRST 45 / no reverse wraparound mode',
    '> CSI ?46l'         : 'DECRST 46 / stop logging',
    '> CSI ?47l'         : 'DECRST 47 / use normal screen buffer',
    '> CSI ?51l'         : 'DECRST 51 - DECBWRM / disable black/white reversal mode',
    '> CSI ?52l'         : 'DECRST 52 - DECOPM / disable origin placement mode',
    '> CSI ?55l'         : 'DECRST 55 - DECBPM / disable bold page mode',
    '> CSI ?60l'         : 'DECRST 60 - DECHCCM / disable horizontal cursor-coupling mode',
    '> CSI ?61l'         : 'DECRST 61 - DECVCCM / disable vertical cursor-coupling mode',
    '> CSI ?63l'         : 'DECRST 63 - DECPCCM / disable page cursor-coupling mode',
    '> CSI ?66l'         : 'DECRST 66 - DECNKM / disable numeric keypad',
    '> CSI ?67l'         : 'DECRST 67 - DECBKM / disable backarrow key mode',
    '> CSI ?68l'         : 'DECRST 68 - DECKBUM / use typewriter keys',
    '> CSI ?69l'         : 'DECRST 69 - DECLRM / disable left and right margin mode',
    '> CSI ?80l'         : 'DECRST 80 - DECSDM / enable SIXEL scrolling mode',
    '> CSI ?95l'         : 'DECRST 95 - DECNCSM / clear screen when DECCOLM is set/reset',
    '> CSI ?1000l'       : 'DECRST 1000 / disable xterm normal mouse mode',
    '> CSI ?1001l'       : 'DECRST 1001 / disable highlight mouse tracking',
    '> CSI ?1002l'       : 'DECRST 1002 / disable button mouse tracking',
    '> CSI ?1003l'       : 'DECRST 1003 / disable all mouse tracking',
    '> CSI ?1004l'       : 'DECRST 1004 / disable focus tracking',
    '> CSI ?1005l'       : 'DECRST 1005 / disable UTF8 mouse mode',
    '> CSI ?1006l'       : 'DECRST 1006 / disable SGR mouse mode',
    '> CSI ?1007l'       : 'DECRST 1007 / disable alternate scroll mode',
    '> CSI ?1010l'       : 'DECRST 1010 / don\'t scroll to bottom on tty output (rxvt)',
    '> CSI ?1011l'       : 'DECRST 1011 / don\'t scroll to bottom on key press (rxvt)',
    '> CSI ?1015l'       : 'DECRST 1015 / disable urxvt mouse mode',
    '> CSI ?1047l'       : 'DECRST 1047 / use normal screen buffer, clearing screen first if in the alt screen',
    '> CSI ?1049l'       : 'DECRST 1049 / use normal screen buffer and restore cursor as in DECRC',
    '> CSI ?2004l'       : 'DECRST 2004 / reset bracketed paste mode',
    '> CSI ?7700l'       : 'DECRST 7700 / disable ambiguous reporting (mintty)',
    '> CSI ?7727l'       : 'DECRST 7727 / normal escape keycode mode (MinTTY/TeraTerm/RLogin/mlterm/tanasinn)',
    '> CSI ?7728l'       : 'DECRST 7728 / treat ^[ as normal escape keycode (MinTTY)',
    '> CSI ?7766l'       : 'DECRST 7766 / hide scroll bar (MinTTY)',
    '> CSI ?7783l'       : 'DECRST 7783 / disable shortcut override mode (MinTTY)',
    '> CSI ?7786l'       : 'DECRST 7786 / disable mousewheel reporting (cursor emulation) mode (MinTTY)',
    '> CSI ?7787l'       : 'DECRST 7787 / disable application mousewheel reporting mode (MinTTY)',
    '> CSI ?8428l'       : 'DECRST 8428 - RLAMBCHM / treat ambiguous characters as wide(RLogin)',
    '> CSI ?8441l'       : 'DECRST 8441 / IME close(RLogin)',
    '> CSI ?8442l'       : 'DECRST 8442 / normal escape keycode mode (RLogin)',
    '> CSI ?8443l'       : 'DECRST 8443 / disable mousewheel reporting (cursor emulation) mode (RLogin)',
    '> CSI ?8448l'       : 'DECRST 8448 / enable Unicode Normalization (RLogin)',
    '> CSI ?8452l'       : 'DECRST 8452 / don\'t force a line break after displaying inline SIXEL - compatible with xterm (RLogin)',
    '> CSI ?8453l'       : 'DECRST 8453 - DRCSMMv1 / disable DRCS-unicode mapping (drcsterm/tanasinn/mlterm/RLogin)',
    '> CSI ?8800l'       : 'DECRST 8800 - DRCSMMv1 / disable DRCS-unicode mapping (drcsterm/tanasinn/mlterm/RLogin)',
    '> CSI ?8840l'       : 'DECRST 8840 / treat ambiguous characters as narrow (tanasinn)',
    '> CSI m'            : 'SGR / select graphics rendition',
    '> CSI 0m'           : 'SGR 0 / reset attributes',
    '> CSI 00m'          : 'SGR 0 / reset attributes',
    '> CSI [0]m'         : 'SGR 0 / reset attributes',
    '> CSI 1m'           : 'SGR 1 / bold',
    '> CSI 4m'           : 'SGR 4 / underlined',
    '> CSI 5m'           : 'SGR 5 / blink',
    '> CSI 7m'           : 'SGR 7 / inverse',
    '> CSI 22m'          : 'SGR 22 / normal (neigher bold nor faint)',
    '> CSI 24m'          : 'SGR 24 / not underlined',
    '> CSI 25m'          : 'SGR 25 / steady (not blinking)',
    '> CSI 27m'          : 'SGR 27 / positive (not inverse)',
    '> CSI 30m'          : 'SGR 30 / set fourground color to black',
    '> CSI 31m'          : 'SGR 31 / set fourground color to red',
    '> CSI 32m'          : 'SGR 32 / set fourground color to green',
    '> CSI 33m'          : 'SGR 33 / set fourground color to yellow',
    '> CSI 34m'          : 'SGR 34 / set fourground color to blue',
    '> CSI 35m'          : 'SGR 35 / set fourground color to magenta',
    '> CSI 36m'          : 'SGR 36 / set fourground color to cyan',
    '> CSI 37m'          : 'SGR 37 / set fourground color to white',
    '> CSI 39m'          : 'SGR 39 / set fourground color to default',
    '> CSI 38;5;[1]m'    : 'SGR 38;5;* / set fourground color to %s',
    '> CSI 39;49m'       : 'SGR 39;49 / set fourground and background color to default',
    '> CSI 40m'          : 'SGR 40 / set background color to black',
    '> CSI 41m'          : 'SGR 41 / set background color to red',
    '> CSI 42m'          : 'SGR 42 / set background color to green',
    '> CSI 43m'          : 'SGR 43 / set background color to yellow',
    '> CSI 44m'          : 'SGR 44 / set background color to blue',
    '> CSI 45m'          : 'SGR 45 / set background color to magenta',
    '> CSI 46m'          : 'SGR 46 / set background color to cyan',
    '> CSI 47m'          : 'SGR 47 / set background color to white',
    '> CSI 48;5;[1]m'    : 'SGR 48;5;* / set background color to %s',
    '> CSI 49m'          : 'SGR 49 / set background color to default',
    '> CSI 90m'          : 'SGR 90 / set foreground color to gray',
    '> CSI 91m'          : 'SGR 91 / set foreground color to bright red',
    '> CSI 92m'          : 'SGR 92 / set foreground color to bright green',
    '> CSI 93m'          : 'SGR 93 / set foreground color to bright yellow',
    '> CSI 94m'          : 'SGR 94 / set foreground color to bright blue',
    '> CSI 95m'          : 'SGR 95 / set foreground color to bright magenta',
    '> CSI 96m'          : 'SGR 96 / set foreground color to bright cyan',
    '> CSI 97m'          : 'SGR 97 / set foreground color to bright white',
    '> CSI 100m'         : 'SGR 100 / set background color to gray',
    '> CSI 101m'         : 'SGR 101 / set background color to bright red',
    '> CSI 102m'         : 'SGR 102 / set background color to bright green',
    '> CSI 103m'         : 'SGR 103 / set background color to bright yellow',
    '> CSI 104m'         : 'SGR 104 / set background color to bright blue',
    '> CSI 105m'         : 'SGR 105 / set background color to bright magenta',
    '> CSI 106m'         : 'SGR 106 / set background color to bright cyan',
    '> CSI 107m'         : 'SGR 107 / set background color to bright white',
    '> CSI >m'           : 'Special Keyboard Modifier Settings (xterm)',
    '> CSI n'            : 'DSR / request device status report',
    '> CSI 5n'           : 'DSR - OS / request operating status',
    '> CSI 6n'           : 'DSR - CPR / request cursor position report',
    '> CSI ?n'           : 'DSR - DEC Specific',
    '> CSI ?6n'          : 'DSR - DECXCPR / requests cursor position report, DEC Specific',
    '> CSI ?15n'         : 'DSR - Printer Port / the host asks for the current printer status',
    '> CSI ?26n'         : 'DSR - Keyboard / The host asks for the keyboard status',
    '> CSI ?75n'         : 'DSR - Data Integrity / Request the data integrity flag',
    '> CSI >p'           : 'Pointer Mode',
    '> CSI >[0]p'        : 'Pointer Mode 1: hide if the mouse tracking mode is not enabled',
    '> CSI >0p'          : 'Pointer Mode 0: never hide the pointer',
    '> CSI >1p'          : 'Pointer Mode 1: hide if the mouse tracking mode is not enabled',
    '> CSI >2p'          : 'Pointer Mode 2: always hide the pointer',
    '> CSI !p'           : 'DECSTR / soft terminal reset',
    '> CSI $p'           : 'DECRQM / request ANSI mode',
    '> CSI ?$p'          : 'DECRQM - DEC specific / request DEC private mode',
    '> CSI >n'           : 'disable special keyboard modifier settings (xterm)',
    '> CSI "p'           : 'DECSCL / set conformance level',
    '> CSI 61;0"p'       : 'DECSCL / set conformance level: VT100 8bit control',
    '> CSI 61;1"p'       : 'DECSCL / set conformance level: VT100 7bit control',
    '> CSI 61;2"p'       : 'DECSCL / set conformance level: VT100 8bit control',
    '> CSI 62;0"p'       : 'DECSCL / set conformance level: VT200 8bit control',
    '> CSI 62;1"p'       : 'DECSCL / set conformance level: VT200 7bit control',
    '> CSI 62;2"p'       : 'DECSCL / set conformance level: VT200 8bit control',
    '> CSI 63;0"p'       : 'DECSCL / set conformance level: VT300 8bit control',
    '> CSI 63;1"p'       : 'DECSCL / set conformance level: VT300 7bit control',
    '> CSI 63;2"p'       : 'DECSCL / set conformance level: VT300 8bit control',
    '> CSI [0]q'         : 'DECLL 0 / load LEDs: clear all LEDs',
    '> CSI 0q'           : 'DECLL 0 / load LEDs: clear all LEDs',
    '> CSI 1q'           : 'DECLL 1 / load LEDs: light num lock',
    '> CSI 2q'           : 'DECLL 2 / load LEDs: light caps lock',
    '> CSI 3q'           : 'DECLL 3 / load LEDs: light scroll lock',
    '> CSI 21q'          : 'DECLL 21 / load LEDs: extinguish num lock',
    '> CSI 22q'          : 'DECLL 22 / load LEDs: extinguish caps lock',
    '> CSI 23q'          : 'DECLL 23 / load LEDs: extinguish scroll lock',
    '> CSI <SP>@'        : 'SL / scroll left',
    '> CSI <SP>A'        : 'SR / scroll right',
    '> CSI <SP>q'        : 'DECSCUSR / set cursor style',
    '> CSI [0]<SP>q'     : 'DECSCUSR 1 / set cursor style: blinking block (default)',
    '> CSI 0<SP>q'       : 'DECSCUSR 0 / set cursor style: blinking block',
    '> CSI 1<SP>q'       : 'DECSCUSR 1 / set cursor style: blinking block (default)',
    '> CSI 2<SP>q'       : 'DECSCUSR 2 / set cursor style: steady block',
    '> CSI 3<SP>q'       : 'DECSCUSR 3 / set cursor style: blinking underline',
    '> CSI 4<SP>q'       : 'DECSCUSR 4 / set cursor style: steady underline',
    '> CSI 5<SP>q'       : 'DECSCUSR 5 / set cursor style: blinking bar',
    '> CSI 6<SP>q'       : 'DECSCUSR 6 / set cursor style: steady bar',
    '> CSI "q'           : 'DECSCA / select character protection attribute',
    '> CSI [0]"q'        : 'DECSCA 0 / select character protection attribute: DECSED and DECSEL can erase',
    '> CSI 0"q'          : 'DECSCA 0 / select character protection attribute: DECSED and DECSEL can erase',
    '> CSI 1"q'          : 'DECSCA 1 / select character protection attribute: DECSED and DECSEL cannot erase',
    '> CSI 2"q'          : 'DECSCA 2 / select character protection attribute: DECSED and DECSEL can erase',
    '> CSI r'            : 'DECSTBM / set top and bottom margins: full size of window',
    '> CSI [2]r'         : 'DECSTBM / set top and bottom margins: top=%s bottom=%s',
    '> CSI [0]s'         : 'DECSLRM or Save cursor/ set right and left margins, or Save cursor (ANSI.SYS)',
    '> CSI [2]s'         : 'DECSLRM / set right and left margins: left=%s right=%s',
    '> CSI ?s'           : 'save DEC private mode values',
    '> CSI ?r'           : 'restore DEC private mode values',
    '> CSI [0]u'         : 'Restore cursor (ANSI.SYS)',
    '> CSI t'            : 'DECSLPP or Window Manipulation (dtterm)',
    '> CSI [1]t'         : 'DECSLPP / Resize to %s lines',
    '> CSI 1t'           : 'Window Manipulation (dtterm) 1: de-iconify window',
    '> CSI 2t'           : 'Window Manipulation (dtterm) 2: iconify window',
    '> CSI 3;[2]t'       : 'Window Manipulation (dtterm) 3: move window (%s, %s)',
    '> CSI 4;[2]t'       : 'Window Manipulation (dtterm) 4: resize window to given height and width in pixels (%s, %s)',
    '> CSI 5t'           : 'Window Manipulation (dtterm) 5: raise the window to the front of the stacking order',
    '> CSI 6t'           : 'Window Manipulation (dtterm) 6: lower the window to the bottom of the stacking order',
    '> CSI 7t'           : 'Window Manipulation (dtterm) 7: reflesh the window',
    '> CSI 8;[2]t'       : 'Window Manipulation (dtterm) 8: resize the text area to given height and width in characters (%s, %s)',
    '> CSI 9;1t'         : 'Window Manipulation (dtterm) 9: maximize the window',
    '> CSI 9;2t'         : 'Window Manipulation (dtterm) 9: maximize the window vertically',
    '> CSI 9;3t'         : 'Window Manipulation (dtterm) 9: maximize the window horizontally',
    '> CSI 10;0t'        : 'Window Manipulation (dtterm) 10: undo full-screen mode',
    '> CSI 10;1t'        : 'Window Manipulation (dtterm) 10: change to full-screen',
    '> CSI 10;2t'        : 'Window Manipulation (dtterm) 10: toggle full-screen',
    '> CSI 11t'          : 'Window Manipulation (dtterm) 11: report the window state',
    '> CSI 13t'          : 'Window Manipulation (dtterm) 13: report the window position',
    '> CSI 14t'          : 'Window Manipulation (dtterm) 14: report the window size in pixels',
    '> CSI 18t'          : 'Window Manipulation (dtterm) 18: report the text area size in characters',
    '> CSI 19t'          : 'Window Manipulation (dtterm) 19: report the screen size in characters',
    '> CSI 20t'          : 'Window Manipulation (dtterm) 20: report the window\'s icon label',
    '> CSI 21t'          : 'Window Manipulation (dtterm) 21: report the window\'s title',
    '> CSI 22;0t'        : 'Window Manipulation (dtterm) 22: save icon and window title on stack',
    '> CSI 22;1t'        : 'Window Manipulation (dtterm) 22: save icon title on stack',
    '> CSI 22;2t'        : 'Window Manipulation (dtterm) 22: save window title on stack',
    '> CSI 23;0t'        : 'Window Manipulation (dtterm) 23: restore icon and window title on stack',
    '> CSI 23;1t'        : 'Window Manipulation (dtterm) 23: restore icon title on stack',
    '> CSI 23;2t'        : 'Window Manipulation (dtterm) 23: restore window title on stack',
    '> CSI $t'           : 'DECRARA / reverse attributes in rectangular area',
    '> CSI [5]$t'        : 'DECRARA / reverse attributes in rectangular area - top=%s, left=%s, bottom=%s, right=%s, attribute=%s',
    '> CSI >t'           : 'Title Mode - Set (xterm)',
    '> CSI >0t'          : 'Title Mode - Set (xterm) 0: Set window/icon labels using hexadecimal',
    '> CSI >1t'          : 'Title Mode - Set (xterm) 1: Query window/icon labels using hexadecimal',
    '> CSI >2t'          : 'Title Mode - Set (xterm) 2: Set window/icon labels using UTF-8',
    '> CSI >3t'          : 'Title Mode - Set (xterm) 3: Query window/icon labels using UTF-8',
    '> CSI <SP>t'        : 'DECSWBV / set warning bell volume',
    '> CSI [1]<SP>t'     : 'DECSWBV / set warning bell volume to %s',
    '> CSI u'            : 'Restore cursor (ANSI.SYS)',
    '> CSI <SP>u'        : 'DECSMBV / set margin bell volume',
    '> CSI [1]<SP>u'     : 'DECSMBV / set margin bell volume to %s',
    '> CSI $v'           : 'DECCRA / copy rectangular area',
    '> CSI \'w'          : 'DECEFR / enable filter rectangle',
    '> CSI x'            : 'DECRECTPARM / request terminal parameters',
    '> CSI *x'           : 'DECSACE / select attribute change extent',
    '> CSI *y'           : 'DECRQCRA / request checksum of rectangular area',
    '> CSI $x'           : 'DECFRA / fill rectangular area',
    '> CSI \'z'          : 'DECELR / enable locator reporting ',
    '> CSI $z'           : 'DECERA / erase rectangular area',
    '> CSI [4]$z'        : 'DECERA / erase rectangular area - top=%s, left=%s, bottom=%s, right=%s',
    '> CSI `$'           : 'DECSLE / select locator events',
    '> CSI [0]`{'        : 'DECSLE 0 / select locator events: only respond to explicit host requests',
    '> CSI 0\'{'         : 'DECSLE 0 / select locator events: only respond to explicit host requests',
    '> CSI 1\'{'         : 'DECSLE 1 / select locator events: report button down transitions',
    '> CSI 2\'{'         : 'DECSLE 2 / select locator events: do not report button down transitions',
    '> CSI 3\'{'         : 'DECSLE 3 / select locator events: report button up transitions',
    '> CSI 4\'{'         : 'DECSLE 4 / select locator events: do not report button up transitions',
    '> CSI ${'           : 'DECSERA / selective erase rectangular area',
    '> CSI [4]${'        : 'DECSERA / selective erase rectangular area (%s, %s, %s, %s)',
    '> CSI \'|'          : 'DECRQLP / request locator position',
    '> CSI \'}'          : 'DECIC / insert Ps Column(s)',
    '> CSI [0]\'}'       : 'DECIC 1 / insert a Column',
    '> CSI [1]\'}'       : 'DECIC / insert %s Column(s)',
    '> CSI \'~'          : 'DECDC / insert Ps Column(s)',
    '> CSI [0]\'~'       : 'DECDC / insert a Column',
    '> CSI [1]\'~'       : 'DECDC / insert %s Column(s)',
    '> CSI [0]]'         : 'ignore next character (linux console)',
    '> CSI 1;[1]]'       : 'set color %d as the underline color (linux console)',
    '> CSI 2;[1]]'       : 'set color %d as the dim color (linux console)',
    '> CSI 8]'           : 'make the current color pair the default attributes (linux console)',
    '> CSI 9;[1]]'       : 'set screen blank timeout to %d minutes (linux console)',
    '> CSI 10;[1]]'      : 'set bell frequency with %d Hz (linux console)',
    '> CSI 11;[1]]'      : 'set bell duration with %d msec (linux console)',
    '> CSI 12;[1]]'      : 'bring %dth console to the front (linux console)',
    '> CSI 13]'          : 'unblank the screen (linux console)',
    '> CSI 14;[1]]'      : 'set the VESA powerdown interval with %d minutes (linux console)',
}

_DEFAULT_CONF = """
#
# expression := <io-prefix>, <seq>,
# io-prefix := '<' | '>' // <: input, >: outut
# seq := ss2 | ss3 | esc | csi | cstr | cchar
# ss2 := 'ESC N ' <any-byte>
# ss3 := 'ESC O ' <any-byte>
# esc := 'ESC ', ( <esc-ibytes>, <esc-fbyte>
#                | <esc-fbyte> )
# csi := 'CSI ', ( <csi-pbytes>, <csi-ibytes>, <csi-fbyte>
#                | <csi-ibytes>, <csi-fbyte>
#                | <csi-fbyte> )
# cstr := 'ESC ', <cstr-prefix>, ' ', <cstr-body>, '<ST>'
# cchar := '<' . <mnemonic> . '>'
#
_SEQDB_OVERLAY = {
    '< CSI 17~'          : '!tracer.set_enabled() if tracer.is_disabled() else tracer.set_disabled()',
    '< CSI 18~'          : '!controller.resume() if controller.is_suspended() else controller.set_break()',
    '< CSI 19~'          : '!controller.set_normal_step()',
    '< CSI 20~'          : '!controller.set_fuzzy_step()',
}

def get():
    return _SEQDB_OVERLAY

"""

import os
import sys


# get resource directory path ($HOME/.trachet)
rcdir = os.path.join(os.getenv("HOME"), ".trachet")

if not os.path.exists(rcdir):
    # create resouce directory
    os.makedirs(rcdir)

# get configure file path ($HOME/.trachet/conf.py)
confpath = os.path.join(rcdir, "conf.py")

if not os.path.exists(confpath):
    # create default configured setting file
    f = open(confpath, "w")
    try:
        f.write(_DEFAULT_CONF)
    finally:
        f.close()

# add resource directory to default import directory
sys.path.insert(0, rcdir)
try:
    import conf
    for key, value in conf.get().items():
        _SEQDB[key] = value
except Exception:
    print str(sys.exc_info())
finally:
    sys.path.remove(rcdir)


# return reserved sequence map
def get():
    return _SEQDB


def _test():
    """
    >>> _test()
    'ok'
    """
    import re
    pattern = re.compile("\\[([0-9]+)\\]")
    for key, value in get().items():
        if "[*]" in key:
            raise Exception("[*] syntax is deprecated.")
        match = re.search(pattern, key)
        if match is not None:
            n = match.group(1)
            try:
                value % tuple([0] * int(n))
            except TypeError:
                raise Exception("invalid entry: (%s, %s)" % (key, value))
    return "ok"

if __name__ == "__main__":
    import doctest
    doctest.testmod()
