#!/usr/bin/env python

# example base.py

import pygtk
pygtk.require('2.0')
import gtk
import sys

# elementos basicos
# self.window -> ventana a la que podemos anyadir widgets
class Base():

    def delete_event(self, widget, event, data=None):
         # If you return FALSE in the "delete_event" signal handler,
         # GTK will emit the "destroy" signal. Returning TRUE means
         # you don't want the window to be destroyed.
         # This is useful for popping up 'are you sure you want to quit?'
         # type dialogs.
         print "delete event occurred"
         gtk.main_quit()
         #sys.exit(0)
         # Change FALSE to TRUE and the main window will not be destroyed
         # with a "delete_event".
         return False

    def __init__(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.largo = 500
        self.ancho = 50
        self.window.set_size_request(self.largo,self.ancho)
        #definimos el evento destroy
        self.window.connect("delete_event", self.delete_event)
        #programa
        #self.window.show_all()
        # obtenemos el centro de la pantalla en funcion del window que vamos a mostrar
        width, height = self.window.get_size()
        self.x = (gtk.gdk.screen_width()/2) - (width/2)
        self.y = (gtk.gdk.screen_height()/2) - (height/2)

    def __init_old__(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        #self.window.set_decorated(False)
        canvas = gtk.DrawingArea()
        canvas.set_size_request(500, 150)
        canvas.connect('expose-event', self.expose)
        self.window.add(canvas)
        #definimos el evento destroy
        self.window.connect("delete_event", self.delete_event)
        #programa
        #self.window.show_all()

    def rounded_rectangle(self, cr, x, y, w, h, r=20):
        # This is just one of the samples from 
        # http://www.cairographics.org/cookbook/roundedrectangles/
        #   A****BQ
        #  H      C
        #  *      *
        #  G      D
        #   F****E
        cr.move_to(x+r,y)                      # Move to A
        cr.line_to(x+w-r,y)                    # Straight line to B
        cr.curve_to(x+w,y,x+w,y,x+w,y+r)       # Curve to C, Control points are both at Q
        cr.line_to(x+w,y+h-r)                  # Move to D
        cr.curve_to(x+w,y+h,x+w,y+h,x+w-r,y+h) # Curve to E
        cr.line_to(x+r,y+h)                    # Line to F
        cr.curve_to(x,y+h,x,y+h,x,y+h-r)       # Curve to G
        cr.line_to(x,y+r)                      # Line to H
        cr.curve_to(x,y,x,y,x+r,y)             # Curve to A

    def expose(self, canvas, event):
        # Create cairo context
        cr = canvas.window.cairo_create()
        # Restrict drawing to the exposed area, so that
        # no unnecessary drawing is done
        cr.rectangle(event.area.x, event.area.y, 
                 event.area.width, event.area.height)
        cr.clip()
        self.rounded_rectangle(cr, 100, 100, 100, 100)
        cr.set_line_width(4.0)
        cr.set_source_rgb(1.0, 0.0, 0.0)
        cr.stroke_preserve()
        cr.set_source_rgb(1.0, 0.5, 0.5)
        cr.fill()

    def main(self):
        gtk.main()

print __name__
if __name__ == "__main__":
    base = Base()
    base.main()

