#!/usr/bin/env python

# example base.py

import pygtk
pygtk.require('2.0')
import gtk
import sys
from base import *
from conexion import *
from pymouse import PyMouse
from parser import Parser
from logger import *

# elementos basicos
# self.window -> ventana a la que podemos anyadir widgets
class W_Cajatraduce(Base):

    def keyPress(self, widget, event):
        Log("########## ATENZIONE #########","INFO")
        Log(event.keyval,"INFO")
        Log("##############################","INFO")
        # pulsamos intro -> traducimos
        if event.keyval == 65293:
            pregunta = self.txtentry.get_text()
            c = Conexion(pregunta)
            c.start()
            c.join()
            contenido = c.getContenido()
            parser = Parser()
            Log("=== Contenido xxx ===","INFO")
            Log(pregunta,"INFO")
            traduccion = parser.get(contenido)
            Log(traduccion,"INFO")
            self.addTraduccion(pregunta,traduccion)
            Log("=================","INFO")
        # pulsamos ESC -> salimos
        elif event.keyval == 65307:
            self.window.hide_all()
            gtk.main_quit()

    def getLargoAncho(self):
        dimensiones = []
        dimensiones.append(self.largo)
        dimensiones.append(self.ancho)
        return dimensiones

    def getMiddleCoords(self):
        coordenadas = []
        coordenadas.append(self.x)
        coordenadas.append(self.y)
        return coordenadas

    def __init__(self):
    	self.iniciado = None
    	self.cajatraduccion = None
    	Base.__init__(self)
    	self.vbox = gtk.VBox()
        self.button = gtk.Button("Traducir")
        self.txtentry = gtk.Entry()
        self.txtentry.connect('key-press-event', self.keyPress)
        self.button.connect("clicked", self.TraducirClicked, "Anything can go here")        
        #vbox.pack_start(self.button)
        self.vbox.pack_start(self.txtentry)
        self.window.add(self.vbox)
        self.window.show_all()
        # la traemos al frente
        self.window.set_keep_above(1)
        # la posicionamos
        self.window.move(self.x,self.y)
        self.txtentry.grab_focus()
        # ponemos titulo
        titulo = "Una ventana de prueba"
        self.window.set_title(titulo)

    def TraducirClicked(event,widget,data):
        print "########## Traducir clicked #########"
        print "Datos: " + data
        print "#####################################"

    def addTraduccion(self,pregunta,respuesta):
        # anyade la caja de traduccion
        anchocaja = 100
        if self.cajatraduccion is None:
            Log("anyadimos caja traduccion","INFO")
            align = gtk.Alignment()
            align.set_padding(0,0,0,10)  # 10 a la derecha
            self.scrolledWindow = gtk.ScrolledWindow()
            self.scrolledWindow.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
            self.scrolledWindow.set_size_request(self.largo, anchocaja)
            self.cajatraduccion = gtk.Label(respuesta)
            self.cajatraduccion.set_size_request(self.largo,-1)
            self.cajatraduccion.set_line_wrap(True)
            self.cajatraduccion.set_justify(gtk.JUSTIFY_LEFT)
            align.add(self.cajatraduccion)
            self.scrolledWindow.add_with_viewport(align)
            self.vbox.pack_end(self.scrolledWindow)
            self.window.set_size_request(self.largo, self.ancho+anchocaja)
            self.window.show_all()
        else:
            Log("modificamos contenido caja traduccion","INFO")
            self.cajatraduccion.set_text(respuesta)

    def main(self):
        Base.main(self)

