# -*-coding: utf-8-*-

from sqlalchemy import (
    Column,
    Integer,
    String,
    ForeignKey,
    UniqueConstraint,
)
from sqlalchemy.orm import relationship, backref

from ..models import (
    DBSession,
    Base
)


class Country(Base):
    __tablename__ = 'country'
    __table_args__ = (
        UniqueConstraint(
            'iso_code',
            name='unique_idx_country_iso_code',
        ),
    )

    id = Column(
        Integer,
        autoincrement=True,
        primary_key=True
    )
    resource_id = Column(
        Integer,
        ForeignKey(
            'resource.id',
            name="fk_resource_id_country",
            ondelete='restrict',
            onupdate='cascade',
        ),
        nullable=False,
    )
    iso_code = Column(
        String(length=2),
        nullable=False,
    )
    name = Column(
        String(length=32),
        nullable=False,
    )

    resource = relationship(
        'Resource',
        backref=backref(
            'country',
            uselist=False,
            cascade="all,delete"
        ),
        cascade="all,delete",
        uselist=False,
    )

    @classmethod
    def get(cls, id):
        if id is None:
            return None
        return DBSession.query(cls).get(id)

    @classmethod
    def by_iso_code(cls, iso_code):
        return DBSession.query(cls).filter(cls.iso_code == iso_code).first()
