"""alter db

Revision ID: 4cfd87a8dfa3
Revises: 282012598f63
Create Date: 2014-06-26 15:47:21.287897

"""

# revision identifiers, used by Alembic.
revision = '4cfd87a8dfa3'
down_revision = '282012598f63'

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('commission',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('date_from', sa.Date(), nullable=False),
    sa.Column('resource_id', sa.Integer(), nullable=False),
    sa.Column('service_id', sa.Integer(), nullable=False),
    sa.Column('percentage', sa.Numeric(precision=5, scale=2), nullable=True),
    sa.Column('price', sa.Numeric(precision=16, scale=2), nullable=True),
    sa.Column('currency_id', sa.Integer(), nullable=True),
    sa.CheckConstraint('percentage is not null or (price is not null and currency_id is not null)', name='chk_commission_amount'),
    sa.ForeignKeyConstraint(['currency_id'], ['currency.id'], name='fk_currency_id_commission', onupdate='cascade', ondelete='restrict'),
    sa.ForeignKeyConstraint(['resource_id'], ['resource.id'], name='fk_resource_id_commission', onupdate='cascade', ondelete='restrict'),
    sa.ForeignKeyConstraint(['service_id'], ['service.id'], name='fk_service_id_commission', onupdate='cascade', ondelete='restrict'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('touroperator_commission',
    sa.Column('touroperator_id', sa.Integer(), nullable=False),
    sa.Column('commission_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['commission_id'], ['commission.id'], name='fk_commission_id_touroperator_commission', onupdate='cascade', ondelete='restrict'),
    sa.ForeignKeyConstraint(['touroperator_id'], ['touroperator.id'], name='fk_touroperator_id_touroperator_commission', onupdate='cascade', ondelete='restrict'),
    sa.PrimaryKeyConstraint('touroperator_id', 'commission_id')
    )
    op.alter_column(u'service_item', 'base_price',
               existing_type=sa.NUMERIC(precision=16, scale=2),
               nullable=False)
    op.alter_column(u'tour', 'base_price',
               existing_type=sa.NUMERIC(precision=16, scale=2),
               nullable=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(u'tour', 'base_price',
               existing_type=sa.NUMERIC(precision=16, scale=2),
               nullable=True)
    op.alter_column(u'service_item', 'base_price',
               existing_type=sa.NUMERIC(precision=16, scale=2),
               nullable=True)
    op.drop_table('touroperator_commission')
    op.drop_table('commission')
    ### end Alembic commands ###
