import unittest

import inspect

def call(func, **kwargs):
    argspec = inspect.getargspec(func)
    params = kwargs
    if not argspec.keywords:
        params = dict()
        for key in kwargs.keys():
            if key in argspec.args:
                params[key] = kwargs.get(key)
    return func(**params)


def concat_two_params(arg1, arg2):
    return arg1+arg2

def concat_no_params():
    return 'something'

class Klass:
    def some_method(self):
        return 'something'

class TestCallWithParams(unittest.TestCase):

    def test_two_parameters_simple(self):
        params = {'arg1': 'value1', 'arg2': 'value2'}
        result = call(concat_two_params, **params)
        self.assertEquals('value1value2', result)

    def test_two_parameters_extra_parameter(self):
        params = {'arg1': 'value1', 'arg2': 'value2', 'arg3': 'value3'}
        result = call(concat_two_params, **params)
        self.assertEquals('value1value2', result)

    def test_no_arguments_no_parameters(self):
        params = {}
        result = call(concat_no_params, **params)
        self.assertEquals('something', result)

    def test_no_arguments_two_parameters(self):
        params = {'arg1': 'value1', 'arg2': 'value2', 'arg3': 'value3'}
        result = call(concat_no_params, **params)
        self.assertEquals('something', result)

class TestGetMethodByName(unittest.TestCase):

    def test_simple(self):
        facade = Klass()
        m = getattr(facade, 'some_method')
        result = m()
        self.assertEquals('something', result)