import logging
from subprocess import check_output, Popen, PIPE


class Upnpc:

    def external_ip(self):
        cmd = "upnpc -s | grep ExternalIPAddress | cut -d' ' -f3"
        logging.debug(cmd)
        return Popen(cmd, shell=True, stdout=PIPE).stdout.read().strip()

    def mapped_ports(self, protocol):
        cmd = "upnpc -l | grep %s | awk '{ print $3 }' | cut -d'-' -f1" % protocol
        logging.debug(cmd)
        return map(int, Popen(cmd, shell=True, stdout=PIPE).stdout.read().splitlines())

    def get_external_ports(self, protocol, local_port):
        cmd = "upnpc -l | grep %s | grep '%s:%s' | awk '{ print $3 }' | cut -d'-' -f1" % \
              (protocol, self.get_local_ip(), local_port)
        logging.debug(cmd)
        return map(int, Popen(cmd, shell=True, stdout=PIPE).stdout.read().splitlines())

    def remove(self, external_port):
        cmd = "upnpc -d {} TCP".format(external_port)
        logging.debug(cmd)
        Popen(cmd, shell=True, stdout=PIPE).stdout.read()

    def add(self, local_port, external_port):
        cmd = "upnpc -a {} {} {} TCP".format(self.get_local_ip(), local_port, external_port)
        logging.debug(cmd)
        Popen(cmd, shell=True, stdout=PIPE).stdout.read()

    def get_local_ip(self):
        return check_output(["hostname", "-I"]).split(" ")[0]