from ConfigParser import ConfigParser
import os.path

import convertible


class Domain:

    def __init__(self, user_domain, update_token):
        self.update_token = update_token
        self.user_domain = user_domain


class Port:

    def __init__(self, local_port, external_port):
        self.local_port = local_port
        self.external_port = external_port


class Service:

    def __init__(self, name, protocol, type, port, url):
        self.name = name
        self.protocol = protocol
        self.type = type
        self.port = port
        self.url = url


class DomainConfig:

    def __init__(self, filename):
        self.filename = filename

    def load(self):
        if not os.path.isfile(self.filename):
            raise Exception('{} does not exist'.format(self.filename))
        obj = convertible.read_json(self.filename)
        return obj

    def save(self, obj):
        convertible.write_json(self.filename, obj)

    def remove(self):
        if os.path.isfile(self.filename):
            os.remove(self.filename)


class InsiderConfig:

    def __init__(self, filename):
        self.parser = ConfigParser()
        self.parser.read(filename)
        self.filename = filename

    def update(self, domain, api_url):
        self.parser.set('redirect', 'domain', domain)
        self.parser.set('redirect', 'api_url', api_url)
        with open(self.filename, 'wb') as file:
            self.parser.write(file)

    def get_redirect_api_url(self):
        return self.parser.get('redirect', 'api_url')

    def get_redirect_main_domain(self):
        return self.parser.get('redirect', 'domain')

    def get_cron_period_mins(self):
        return self.parser.getint('cron', 'period_mins')

