#!/usr/bin/env python

from setuptools import setup

setup(
    author='Giovanni Torres Parra',
    author_email='fiatjaf@gmail.com',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 2',
        ],
    description='A somewhat simpler reinterpretation of the UNIX `tree` viewer',
    license='MIT',
    include_package_data=True,
    maintainer='Giovanni Torres Parra',
    maintainer_email='fiatjaf@gmail.com',
    name='tree-dir',
    py_modules=['tree'],
    install_requires=[
        'treelib>=1.2.8'
    ],
    url='https://github.com/fiatjaf/tree-dir',
    version='0.0.11',
    entry_points='''

    [console_scripts]
    tree-dir=tree:main
    '''
)

