from treelib import Tree
import os
import sys

def main():
    here = sys.argv[1] if len(sys.argv) > 1 else '.'
    tree = tree_here(here)
    tree.show()

def tree_here(path):

    # scan
    nfiles = 0
    dirs = []
    for entry in os.listdir(path):
        if entry[0] == '.':
            continue

        subpath = path + '/' + entry
        if os.path.isdir(subpath):
            dirs.append(subpath)
        else:
            nfiles += 1

    # create nodes
    tree = Tree()

    name = path.split('/')[-1]
    filecount = '%s %s' % (nfiles, 'files' if nfiles > 1 else 'file')
    dirlabel = u'%s -> %s' % (name.decode('utf-8'), filecount) if nfiles else name.decode('utf-8')
    tree.create_node(dirlabel, path)
    for d in dirs:
        tree.paste(path, tree_here(d))

    return tree

if __name__ == '__main__':
    main()
