/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import java.text.DecimalFormat;
import java.util.Arrays;

public class EdgeAttribute {
    double[] vect;
    public static final double TOLERANCE = 1.0E-15;

    public EdgeAttribute() {
        this.vect = null;
    }

    public EdgeAttribute(double[] dArray) {
        this.vect = dArray;
    }

    public EdgeAttribute(String string) {
        try {
            if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
                String[] stringArray = string.split(" ");
                this.vect = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.vect[i] = Double.parseDouble(stringArray[i]);
                }
            } else {
                this.vect = new double[1];
                this.vect[0] = Double.parseDouble(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error creating new edge attribute: input string does not have double where expected or bracket problem: " + numberFormatException.getMessage());
            System.exit(1);
        }
    }

    public double getAttribute() {
        if (this.vect == null) {
            return 0.0;
        }
        return this.vect[0];
    }

    public void setEdgeAttribute(EdgeAttribute edgeAttribute) {
        this.vect = edgeAttribute.vect;
    }

    public EdgeAttribute clone() {
        return new EdgeAttribute(Arrays.copyOf(this.vect, this.vect.length));
    }

    public String toString() {
        if (this.vect == null) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0.##########");
        if (this.vect.length == 1) {
            return decimalFormat.format(this.vect[0]);
        }
        String string = "[" + decimalFormat.format(this.vect[0]);
        for (int i = 1; i < this.vect.length; ++i) {
            string = string + " " + decimalFormat.format(this.vect[i]);
        }
        return string + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof EdgeAttribute)) {
            return false;
        }
        for (int i = 0; i < this.vect.length; ++i) {
            if (!(Math.abs(this.vect[i] - ((EdgeAttribute)object).vect[i]) > 1.0E-15)) continue;
            return false;
        }
        return true;
    }

    public double norm() {
        if (this.vect == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.vect.length; ++i) {
            d += Math.pow(this.vect[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static EdgeAttribute difference(EdgeAttribute edgeAttribute, EdgeAttribute edgeAttribute2) {
        if (edgeAttribute == null && edgeAttribute2 == null) {
            System.out.println("Calculating difference between two null edge attributes; returning null");
            return null;
        }
        if (edgeAttribute == null) {
            return edgeAttribute2;
        }
        if (edgeAttribute2 == null) {
            return edgeAttribute;
        }
        if (edgeAttribute.vect == null) {
            return edgeAttribute2;
        }
        if (edgeAttribute2.vect == null) {
            return edgeAttribute;
        }
        if (edgeAttribute.vect.length != edgeAttribute2.vect.length) {
            System.err.println("Error:  vectors different lengths when computing difference of EdgeAttributes " + edgeAttribute + " and " + edgeAttribute2);
            System.exit(1);
        }
        int n = edgeAttribute.vect.length;
        EdgeAttribute edgeAttribute3 = new EdgeAttribute();
        edgeAttribute3.vect = new double[n];
        for (int i = 0; i < n; ++i) {
            edgeAttribute3.vect[i] = edgeAttribute.vect[i] - edgeAttribute2.vect[i];
        }
        return edgeAttribute3;
    }

    public static EdgeAttribute add(EdgeAttribute edgeAttribute, EdgeAttribute edgeAttribute2) {
        if (edgeAttribute.vect == null) {
            return edgeAttribute2;
        }
        if (edgeAttribute2.vect == null) {
            return edgeAttribute;
        }
        if (edgeAttribute.vect.length != edgeAttribute2.vect.length) {
            System.err.println("Error:  vectors different lengths when adding EdgeAttributes " + edgeAttribute + " and " + edgeAttribute2);
            System.exit(1);
        }
        int n = edgeAttribute.vect.length;
        EdgeAttribute edgeAttribute3 = new EdgeAttribute();
        edgeAttribute3.vect = new double[n];
        for (int i = 0; i < n; ++i) {
            edgeAttribute3.vect[i] = edgeAttribute.vect[i] + edgeAttribute2.vect[i];
        }
        return edgeAttribute3;
    }

    public static EdgeAttribute weightedPairAverage(EdgeAttribute edgeAttribute, EdgeAttribute edgeAttribute2, double d) {
        if (edgeAttribute == null && edgeAttribute2 == null) {
            System.out.println("Calculating point between two null edge attributes; returning null");
            return null;
        }
        if (edgeAttribute == null) {
            edgeAttribute = EdgeAttribute.zeroAttribute(edgeAttribute2.size());
        }
        if (edgeAttribute2 == null) {
            edgeAttribute2 = EdgeAttribute.zeroAttribute(edgeAttribute.size());
        }
        if (edgeAttribute.vect.length != edgeAttribute2.vect.length) {
            System.err.println("Error calculating point between edge attributes.  Edge attributes are different lenghts: " + edgeAttribute + " and " + edgeAttribute2);
            System.exit(1);
        }
        if (d < 0.0 || d > 1.0) {
            System.err.println("Error calculating point between edge attributes:  position " + d + " must be between 0 and 1");
        }
        if (edgeAttribute.equals(edgeAttribute2)) {
            return edgeAttribute;
        }
        EdgeAttribute edgeAttribute3 = new EdgeAttribute(new double[edgeAttribute.vect.length]);
        for (int i = 0; i < edgeAttribute.vect.length; ++i) {
            edgeAttribute3.vect[i] = (1.0 - d) * edgeAttribute.vect[i] + d * edgeAttribute2.vect[i];
        }
        return edgeAttribute3;
    }

    public void scaleBy(double d) {
        for (int i = 0; i < this.vect.length; ++i) {
            this.vect[i] = this.vect[i] * d;
        }
    }

    public int size() {
        if (this.vect == null) {
            return 0;
        }
        return this.vect.length;
    }

    public void ensurePositive() {
        if (this.vect.length == 1) {
            this.vect[0] = Math.abs(this.vect[0]);
        }
    }

    public static EdgeAttribute zeroAttribute(int n) {
        if (n < 1) {
            System.err.println("Error creating zero edge attribute of size " + n + "; invalid size");
            System.exit(1);
        }
        EdgeAttribute edgeAttribute = new EdgeAttribute(new double[n]);
        Arrays.fill(edgeAttribute.vect, 0.0);
        return edgeAttribute;
    }
}

