/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Bipartition;
import distanceAlg1.EdgeAttribute;
import distanceAlg1.PhyloTree;
import distanceAlg1.PhyloTreeEdge;
import distanceAlg1.RatioSequence;
import distanceAlg1.TreeDistance;
import java.util.Vector;
import polyAlg.PolyMain;

public class Geodesic {
    private RatioSequence rs;
    private Vector<PhyloTreeEdge> commonEdges;
    private double leafContributionSquared = 0.0;

    public Geodesic(RatioSequence ratioSequence) {
        this.rs = ratioSequence;
        this.commonEdges = new Vector();
    }

    public Geodesic(RatioSequence ratioSequence, Vector<PhyloTreeEdge> vector) {
        this.rs = ratioSequence;
        this.commonEdges = vector;
    }

    public Geodesic(RatioSequence ratioSequence, Vector<PhyloTreeEdge> vector, double d) {
        this.rs = ratioSequence;
        this.commonEdges = vector;
        this.leafContributionSquared = d;
    }

    public RatioSequence getRS() {
        return this.rs;
    }

    public void setRS(RatioSequence ratioSequence) {
        this.rs = ratioSequence;
    }

    public double getDist() {
        double d = 0.0;
        for (int i = 0; i < this.commonEdges.size(); ++i) {
            d += Math.pow(this.commonEdges.get(i).getLength(), 2.0);
        }
        return Math.sqrt(Math.pow(this.rs.getNonDesRSWithMinDist().getDistance(), 2.0) + d + this.leafContributionSquared);
    }

    public void addCommonEdge(PhyloTreeEdge phyloTreeEdge) {
        this.commonEdges.add(phyloTreeEdge);
    }

    public String toStringVerboseOld(PhyloTree phyloTree, PhyloTree phyloTree2) {
        int n;
        Vector<PhyloTreeEdge> vector = this.getCommonEdges();
        Boolean bl = false;
        String string = "\nSplits only in T1:\n";
        for (n = 0; n < phyloTree.getEdges().size(); ++n) {
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!vector.get(i).sameBipartition(phyloTree.getEdge(n))) continue;
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            string = string + phyloTree.getEdge(n).toStringVerbose(phyloTree.getLeaf2NumMap()) + "\n" + phyloTree.getEdge(n) + "\n";
        }
        string = string + "\n\nSplits only in T2:\n";
        for (n = 0; n < phyloTree2.getEdges().size(); ++n) {
            if (vector.contains(phyloTree2.getEdge(n))) continue;
            string = string + phyloTree2.getEdge(n).toStringVerbose(phyloTree2.getLeaf2NumMap()) + "\n" + phyloTree2.getEdge(n) + "\n";
        }
        string = string + "\n\nCommon splits:\n";
        for (n = 0; n < vector.size(); ++n) {
            string = string + vector.get(n).toStringVerbose(phyloTree.getLeaf2NumMap()) + "\n" + vector.get(n) + "\n";
        }
        return string;
    }

    public Geodesic clone() {
        return new Geodesic(this.rs.clone(), TreeDistance.myVectorClonePhyloTreeEdge(this.commonEdges));
    }

    public String toString() {
        return "" + this.getDist() + "; " + this.rs.getNonDesRSWithMinDist();
    }

    public Vector<PhyloTreeEdge> getCommonEdges() {
        return this.commonEdges;
    }

    public void setCommonEdges(Vector<PhyloTreeEdge> vector) {
        this.commonEdges = vector;
    }

    public int numCommonEdges() {
        return this.commonEdges.size();
    }

    public int numTopologies() {
        return this.rs.getAscRSWithMinDist().size() + 1;
    }

    public Geodesic reverse() {
        return new Geodesic(this.rs.reverse(), this.commonEdges, this.leafContributionSquared);
    }

    public double getLeafContributionSquared() {
        return this.leafContributionSquared;
    }

    public void setLeafContributionSquared(double d) {
        this.leafContributionSquared = d;
    }

    public static PhyloTree getTreeAt(PhyloTree phyloTree, PhyloTree phyloTree2, double d) {
        EdgeAttribute edgeAttribute;
        int n;
        int n2 = -2;
        int n3 = -2;
        Vector<Object> vector = new Vector();
        Vector<Object> vector2 = new Vector();
        Vector<PhyloTreeEdge> vector3 = Geodesic.getCommonEdges(phyloTree, phyloTree2, d);
        PhyloTree phyloTree3 = phyloTree.clone();
        PhyloTree phyloTree4 = phyloTree2.clone();
        for (int i = 0; i < vector3.size(); ++i) {
            phyloTree3.removeSplit(vector3.get(i));
            phyloTree4.removeSplit(vector3.get(i));
        }
        Geodesic geodesic = PolyMain.getGeodesic(phyloTree3, phyloTree4, null);
        PhyloTree phyloTree5 = new PhyloTree(vector3, phyloTree.getLeaf2NumMap());
        EdgeAttribute[] edgeAttributeArray = new EdgeAttribute[phyloTree.getLeafEdgeAttribs().length];
        for (n = 0; n < edgeAttributeArray.length; ++n) {
            edgeAttributeArray[n] = EdgeAttribute.weightedPairAverage(phyloTree.getLeafEdgeAttribs()[n], phyloTree2.getLeafEdgeAttribs()[n], d);
        }
        phyloTree5.setLeafEdgeAttribs(edgeAttributeArray);
        if (geodesic.getRS().size() == 0) {
            return phyloTree5;
        }
        if (geodesic.getRS().getRatio(0).getTime() > d) {
            n2 = -1;
            n3 = 0;
        } else if (geodesic.getRS().getRatio(geodesic.getRS().size() - 1).getTime() < d) {
            n2 = geodesic.getRS().size() - 1;
            n3 = geodesic.getRS().size();
        } else {
            for (n = 0; n < geodesic.getRS().size(); ++n) {
                double d2 = geodesic.getRS().getRatio(n).getTime();
                if (n2 == -2 && d2 >= d) {
                    n2 = n - 1;
                }
                if (n3 != -2 || n2 == -2 || !(d2 > d)) continue;
                n3 = n;
            }
        }
        if (n3 == -2) {
            n3 = geodesic.getRS().size();
        }
        for (n = 0; n <= n2; ++n) {
            vector2 = geodesic.getRS().getRatio(n).getFEdges();
            for (PhyloTreeEdge phyloTreeEdge : vector2) {
                edgeAttribute = phyloTreeEdge.getAttribute().clone();
                edgeAttribute.scaleBy((d * geodesic.getRS().getRatio(n).getFLength() - (1.0 - d) * geodesic.getRS().getRatio(n).getELength()) / geodesic.getRS().getRatio(n).getFLength());
                phyloTree5.addEdge(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
            }
        }
        for (n = n3; n < geodesic.getRS().size(); ++n) {
            vector = geodesic.getRS().getRatio(n).getEEdges();
            for (PhyloTreeEdge phyloTreeEdge : vector) {
                edgeAttribute = phyloTreeEdge.getAttribute().clone();
                edgeAttribute.scaleBy(((1.0 - d) * geodesic.getRS().getRatio(n).getELength() - d * geodesic.getRS().getRatio(n).getFLength()) / geodesic.getRS().getRatio(n).getELength());
                phyloTree5.addEdge(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
            }
        }
        return phyloTree5;
    }

    public static Vector<PhyloTreeEdge> getCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2, double d) {
        EdgeAttribute edgeAttribute;
        Vector<PhyloTreeEdge> vector = new Vector<PhyloTreeEdge>();
        if (!phyloTree.getLeaf2NumMap().equals(phyloTree2.getLeaf2NumMap())) {
            System.err.println("Error: the two trees do not have the same leaves!");
            System.err.println("First tree's leaves are " + phyloTree.getLeaf2NumMap());
            System.err.println("Second tree's leaves are " + phyloTree2.getLeaf2NumMap());
            System.exit(1);
        }
        if (d < 0.0 || d > 1.0) {
            System.err.println("Error:  position " + d + " must be between 0 and 1");
            System.exit(1);
        }
        for (PhyloTreeEdge phyloTreeEdge : phyloTree.getEdges()) {
            if (phyloTree2.getSplits().contains(phyloTreeEdge.asSplit())) {
                Bipartition bipartition = phyloTreeEdge.asSplit();
                edgeAttribute = EdgeAttribute.weightedPairAverage(phyloTreeEdge.getAttribute(), phyloTree2.getAttribOfSplit(bipartition), d);
                vector.add(new PhyloTreeEdge(bipartition.clone(), edgeAttribute.clone(), -1));
                continue;
            }
            if (!phyloTreeEdge.isCompatibleWith(phyloTree2.getSplits())) continue;
            edgeAttribute = EdgeAttribute.weightedPairAverage(phyloTreeEdge.getAttribute(), null, d);
            vector.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute.clone(), -1));
        }
        for (PhyloTreeEdge phyloTreeEdge : phyloTree2.getEdges()) {
            if (!phyloTreeEdge.isCompatibleWith(phyloTree.getSplits()) || phyloTree.getSplits().contains(phyloTreeEdge.asSplit())) continue;
            edgeAttribute = EdgeAttribute.weightedPairAverage(null, phyloTreeEdge.getAttribute(), d);
            vector.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute.clone(), -1));
        }
        return vector;
    }
}

