/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Bipartition;
import distanceAlg1.EdgeAttribute;
import distanceAlg1.Geodesic;
import distanceAlg1.PhyloTree;
import distanceAlg1.PhyloTreeEdge;
import distanceAlg1.Ratio;
import distanceAlg1.RatioSequence;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class TreeDistance {
    public static Vector<RatioSequence> finalRatioSeqs = new Vector();
    public static double minTreeDist = -1.0;
    public static RatioSequence minTreeDistRatioSeq = null;
    public static long numMaxPaths = 0L;
    public static long numPrunes = 0L;
    public static long numNodes = 0L;
    public static int pathToSearch = 0;
    private static long numBaseCase = 0L;
    public static Vector<PhyloTree> aTreesNoCommonEdges = new Vector();
    public static Vector<PhyloTree> bTreesNoCommonEdges = new Vector();
    public static double firstTreeDist = -1.0;
    public static boolean rooted = true;
    public static boolean normalize = false;
    public static int verbose = 0;
    public static Hashtable<String, Double> nodeHashtable = new Hashtable(5000);
    public static Hashtable<String, Geodesic> subTreeHashtable = new Hashtable(5000);
    public static Hashtable<String, RatioSequence> subTreeRSHashtable = new Hashtable(5000);
    public static String LEAF_CONTRIBUTION_SQUARED_DESCRIPTION = "(Leaf contribution squared = square of the length of the vector whose i-th element is the absolute value of the difference between the length of the split ending in leaf i in the first tree and the length of the split ending in leaf i in the second tree.)";

    public static void resetTreeDistanceState() {
        finalRatioSeqs = new Vector();
        minTreeDist = -1.0;
        minTreeDistRatioSeq = null;
        nodeHashtable = new Hashtable(5000);
        numPrunes = 0L;
        numNodes = 0L;
        numMaxPaths = 0L;
        firstTreeDist = -1.0;
    }

    public static Vector<Bipartition> zeroCol(int n, Vector<Bipartition> vector) {
        for (Bipartition bipartition : vector) {
            if (bipartition == null || !bipartition.contains(n)) continue;
            bipartition.removeOne(n);
        }
        return vector;
    }

    public static boolean checkForDuplicateEdges(Vector<PhyloTreeEdge> vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size() - 1; ++i) {
            for (int j = i + 1; j < vector.size(); ++j) {
                if (!vector.get(i).sameBipartition(vector.get(j))) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static Geodesic getGeodesic2(PhyloTree phyloTree, PhyloTree phyloTree2, String string, String string2) {
        int n;
        int n2;
        double d = 0.0;
        EdgeAttribute[] edgeAttributeArray = phyloTree.getLeafEdgeAttribs();
        EdgeAttribute[] edgeAttributeArray2 = phyloTree2.getLeafEdgeAttribs();
        Geodesic geodesic = new Geodesic(new RatioSequence());
        String string3 = "";
        for (n2 = 0; n2 < phyloTree.getLeaf2NumMap().size(); ++n2) {
            if (!phyloTree.getLeaf2NumMap().get(n2).equals(phyloTree2.getLeaf2NumMap().get(n2))) {
                System.out.println("Exiting: Leaves don't match for trees " + phyloTree + " and " + phyloTree2);
                System.exit(1);
            }
            d += Math.pow(EdgeAttribute.difference(edgeAttributeArray[n2], edgeAttributeArray2[n2]).norm(), 2.0);
        }
        geodesic.setLeafContributionSquared(d);
        if (verbose > 0) {
            System.out.println("Starting tree: " + phyloTree.getNewick(true));
            string3 = string3 + "Starting tree: " + phyloTree.getNewick(true) + "\n";
            System.out.println("Target tree: " + phyloTree2.getNewick(true));
            string3 = string3 + "Target tree: " + phyloTree2.getNewick(true) + "\n";
            System.out.println("\nStarting tree edges:");
            string3 = string3 + "\nStarting tree edges:\n";
            string3 = string3 + PhyloTreeEdge.printEdgesVerbose(phyloTree.getEdges(), phyloTree.getLeaf2NumMap(), true);
            System.out.println("\nTarget tree edges:");
            string3 = string3 + "\nTarget tree edges:\n";
            string3 = string3 + PhyloTreeEdge.printEdgesVerbose(phyloTree2.getEdges(), phyloTree2.getLeaf2NumMap(), true);
            System.out.println("\nLeaf contribution squared " + TreeDistance.truncate(d, 6));
            string3 = string3 + "\nLeaf contribution squared " + TreeDistance.truncate(d, 6) + "\n";
            System.out.println(LEAF_CONTRIBUTION_SQUARED_DESCRIPTION);
            string3 = string3 + LEAF_CONTRIBUTION_SQUARED_DESCRIPTION + "\n";
        }
        subTreeHashtable = new Hashtable(5000);
        aTreesNoCommonEdges = new Vector();
        bTreesNoCommonEdges = new Vector();
        TreeDistance.splitOnCommonEdge(phyloTree, phyloTree2);
        geodesic.setCommonEdges(PhyloTree.getCommonEdges(phyloTree, phyloTree2));
        if (verbose > 0) {
            System.out.println("\nCommon edges are:  (Length = abs. value of difference in length between the two trees)");
            string3 = string3 + "\nCommon edges are:  (Length = abs. value of difference in length between the two trees)\n";
            Vector<PhyloTreeEdge> vector = geodesic.getCommonEdges();
            string3 = string3 + PhyloTreeEdge.printEdgesVerbose(vector, phyloTree.getLeaf2NumMap(), true);
            double d2 = 0.0;
            for (n = 0; n < vector.size(); ++n) {
                d2 += Math.pow(vector.get(n).getLength(), 2.0);
            }
            System.out.println("\nCommon edges contribution squared: " + TreeDistance.truncate(d2, 6));
            string3 = string3 + "\nCommon edges contribution squared: " + TreeDistance.truncate(d2, 6) + "\n";
            System.out.println("(sum of squares of above differences in length)");
            string3 = string3 + "(sum of squares of above differences in length)\n";
            System.out.println("=============================================================================================================================");
            string3 = string3 + "=============================================================================================================================\n";
            System.out.println("\nNow finding the geodesic between the following subtrees, which have no edges in common:");
            string3 = string3 + "\nNow finding the geodesic between the following subtrees, which have no edges in common:\n";
        }
        for (n2 = 0; n2 < aTreesNoCommonEdges.size(); ++n2) {
            PhyloTree phyloTree3 = aTreesNoCommonEdges.get(n2);
            PhyloTree phyloTree4 = bTreesNoCommonEdges.get(n2);
            if (verbose > 0) {
                System.out.println("Leaves or subtree representatives in subtrees:");
                string3 = string3 + "Leaves or subtree representatives in subtrees:\n";
                for (n = 0; n < phyloTree3.getLeaf2NumMap().size(); ++n) {
                    System.out.println("" + phyloTree3.getLeaf2NumMap().get(n));
                    string3 = string3 + phyloTree3.getLeaf2NumMap().get(n) + "\n";
                }
                System.out.println("\nStarting subtree edges:");
                string3 = string3 + "\nStarting subtree edges:\n";
                string3 = string3 + PhyloTreeEdge.printEdgesVerbose(phyloTree3.getEdges(), phyloTree3.getLeaf2NumMap(), false);
                System.out.println("\nTarget subtree edges:");
                string3 = string3 + "\nTarget subtree edges:\n";
                string3 = string3 + PhyloTreeEdge.printEdgesVerbose(phyloTree4.getEdges(), phyloTree4.getLeaf2NumMap(), false);
            }
            Geodesic geodesic2 = TreeDistance.getGeodesicRecursive(phyloTree3, phyloTree4, string);
            if (verbose > 0) {
                System.out.println("\nGeodesic distance between above subtrees, ignoring edges ending in leaves: " + TreeDistance.truncate(geodesic2.getRS().getNonDesRSWithMinDist().getDistance(), 6));
                string3 = string3 + "\nGeodesic distance between above subtrees, ignoring edges ending in leaves: " + TreeDistance.truncate(geodesic2.getRS().getNonDesRSWithMinDist().getDistance(), 6) + "\n";
                System.out.println("Ratio sequence corresponding to the geodesic:\nCombinatorial type: " + geodesic2.getRS().getNonDesRSWithMinDist().toStringCombType());
                string3 = string3 + "Ratio sequence corresponding to the geodesic:\nCombinatorial type: " + geodesic2.getRS().getNonDesRSWithMinDist().toStringCombType() + "\n";
                System.out.println(geodesic2.getRS().getNonDesRSWithMinDist().toStringVerbose(phyloTree3.getLeaf2NumMap()));
                string3 = string3 + geodesic2.getRS().getNonDesRSWithMinDist().toStringVerbose(phyloTree3.getLeaf2NumMap()) + "\n";
                System.out.println("------------------------------------------------------------------------------------------------------------");
                string3 = string3 + "------------------------------------------------------------------------------------------------------------\n";
            }
            geodesic.setRS(RatioSequence.interleave(geodesic.getRS(), geodesic2.getRS()));
        }
        if (verbose > 0) {
            System.out.println("\nGeodesic distance between start and target tree is " + TreeDistance.truncate(geodesic.getDist(), 6));
            string3 = string3 + "\nGeodesic distance between start and target tree is " + TreeDistance.truncate(geodesic.getDist(), 6) + "\n";
        }
        if (verbose > 0) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(string2));
                printWriter.println(string3);
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error opening or writing to " + string2 + ": " + fileNotFoundException.getMessage());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("Error opening or writing to " + string2 + ": " + iOException.getMessage());
                System.exit(1);
            }
        }
        return geodesic;
    }

    public static Vector<PhyloTree> splitOnCommonEdge(PhyloTree phyloTree, PhyloTree phyloTree2) {
        int n;
        Vector<PhyloTree> vector = new Vector<PhyloTree>();
        int n2 = phyloTree.getEdges().size();
        int n3 = phyloTree2.getEdges().size();
        if (n2 == 0 && n3 == 0) {
            return vector;
        }
        Vector<PhyloTreeEdge> vector2 = PhyloTree.getCommonEdges(phyloTree, phyloTree2);
        if (vector2.size() == 0) {
            aTreesNoCommonEdges.add(phyloTree);
            bTreesNoCommonEdges.add(phyloTree2);
            vector.add(phyloTree);
            vector.add(phyloTree2);
            return vector;
        }
        PhyloTreeEdge phyloTreeEdge = vector2.get(0);
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<PhyloTreeEdge> vector5 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector6 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector7 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector8 = new Vector<PhyloTreeEdge>();
        for (n = 0; n < n2; ++n) {
            vector5.add(new PhyloTreeEdge(phyloTree.getEdge(n).getAttribute(), phyloTree.getEdge(n).getOriginalEdge(), phyloTree.getEdge(n).getOriginalID()));
            vector7.add(new PhyloTreeEdge(phyloTree.getEdge(n).getAttribute(), phyloTree.getEdge(n).getOriginalEdge(), phyloTree.getEdge(n).getOriginalID()));
        }
        for (n = 0; n < n3; ++n) {
            vector6.add(new PhyloTreeEdge(phyloTree2.getEdge(n).getAttribute(), phyloTree2.getEdge(n).getOriginalEdge(), phyloTree2.getEdge(n).getOriginalID()));
            vector8.add(new PhyloTreeEdge(phyloTree2.getEdge(n).getAttribute(), phyloTree2.getEdge(n).getOriginalEdge(), phyloTree2.getEdge(n).getOriginalID()));
        }
        Boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < phyloTree.getLeaf2NumMap().size(); ++i) {
            int n6;
            if (phyloTreeEdge.contains(i)) {
                vector3.add(phyloTree.getLeaf2NumMap().get(i));
                if (!bl.booleanValue()) {
                    vector4.add(phyloTree.getLeaf2NumMap().get(i) + "*");
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (!phyloTree.getEdge(n6).properlyContains(phyloTreeEdge)) continue;
                        vector7.get(n6).addOne(n5);
                    }
                    for (n6 = 0; n6 < n3; ++n6) {
                        if (!phyloTree2.getEdge(n6).properlyContains(phyloTreeEdge)) continue;
                        vector8.get(n6).addOne(n5);
                    }
                    ++n5;
                    bl = true;
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    if (!phyloTreeEdge.properlyContains(phyloTree.getEdge(n6)) || !phyloTree.getEdge(n6).contains(i)) continue;
                    vector5.get(n6).addOne(n4);
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    if (!phyloTreeEdge.properlyContains(phyloTree2.getEdge(n6)) || !phyloTree2.getEdge(n6).contains(i)) continue;
                    vector6.get(n6).addOne(n4);
                }
                ++n4;
                continue;
            }
            vector4.add(phyloTree.getLeaf2NumMap().get(i));
            for (n6 = 0; n6 < n2; ++n6) {
                if (!phyloTree.getEdge(n6).contains(i)) continue;
                vector7.get(n6).addOne(n5);
            }
            for (n6 = 0; n6 < n3; ++n6) {
                if (!phyloTree2.getEdges().get(n6).contains(i)) continue;
                vector8.get(n6).addOne(n5);
            }
            ++n5;
        }
        vector5 = TreeDistance.deleteZeroEdges(vector5);
        vector6 = TreeDistance.deleteZeroEdges(vector6);
        vector7 = TreeDistance.deleteZeroEdges(vector7);
        vector8 = TreeDistance.deleteZeroEdges(vector8);
        PhyloTree phyloTree3 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector5), TreeDistance.myVectorCloneString(vector3));
        PhyloTree phyloTree4 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector7), TreeDistance.myVectorCloneString(vector4));
        PhyloTree phyloTree5 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector6), TreeDistance.myVectorCloneString(vector3));
        PhyloTree phyloTree6 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector8), TreeDistance.myVectorCloneString(vector4));
        vector.addAll(TreeDistance.splitOnCommonEdge(phyloTree3, phyloTree5));
        vector.addAll(TreeDistance.splitOnCommonEdge(phyloTree4, phyloTree6));
        return vector;
    }

    public static Geodesic getGeodesicRecursive(PhyloTree phyloTree, PhyloTree phyloTree2, String string) {
        int n;
        TreeDistance.resetTreeDistanceState();
        int n2 = phyloTree.getEdges().size();
        int n3 = phyloTree2.getEdges().size();
        if (n2 == 0 && n3 == 0) {
            return new Geodesic(new RatioSequence());
        }
        Vector<PhyloTreeEdge> vector = PhyloTree.getCommonEdges(phyloTree, phyloTree2);
        if (verbose > 1) {
            System.out.println("Common edges are " + vector);
        }
        if (vector.size() == 0) {
            if (string.equals("divide")) {
                Geodesic geodesic = subTreeHashtable.get(phyloTree.getLeaf2NumMap().toString());
                if (geodesic == null) {
                    geodesic = TreeDistance.getDivideAndConquerGeodesicNoCommonEdges(phyloTree, phyloTree2);
                    subTreeHashtable.put(phyloTree.getLeaf2NumMap().toString(), geodesic.clone());
                }
                return geodesic;
            }
            if (string.equals("DivideAndConquerRS")) {
                RatioSequence ratioSequence = subTreeRSHashtable.get(phyloTree.getLeaf2NumMap().toString());
                if (ratioSequence == null) {
                    ratioSequence = TreeDistance.getDivideAndConquerRSNoCommonEdges(phyloTree, phyloTree2);
                    subTreeRSHashtable.put(phyloTree.getLeaf2NumMap().toString(), ratioSequence.clone());
                }
                return new Geodesic(ratioSequence);
            }
            if (string.equals("dynamic")) {
                return TreeDistance.getPruned2GeodesicNoCommonEdges(phyloTree, phyloTree2);
            }
            System.out.println("" + string + " is an invalid algorithm");
            System.exit(0);
        }
        PhyloTreeEdge phyloTreeEdge = vector.get(0);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<PhyloTreeEdge> vector4 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector5 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector6 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector7 = new Vector<PhyloTreeEdge>();
        for (n = 0; n < n2; ++n) {
            vector4.add(new PhyloTreeEdge(phyloTree.getEdge(n).getAttribute(), phyloTree.getEdge(n).getOriginalEdge(), phyloTree.getEdge(n).getOriginalID()));
            vector6.add(new PhyloTreeEdge(phyloTree.getEdge(n).getAttribute(), phyloTree.getEdge(n).getOriginalEdge(), phyloTree.getEdge(n).getOriginalID()));
        }
        for (n = 0; n < n3; ++n) {
            vector5.add(new PhyloTreeEdge(phyloTree2.getEdge(n).getAttribute(), phyloTree2.getEdge(n).getOriginalEdge(), phyloTree2.getEdge(n).getOriginalID()));
            vector7.add(new PhyloTreeEdge(phyloTree2.getEdge(n).getAttribute(), phyloTree2.getEdge(n).getOriginalEdge(), phyloTree2.getEdge(n).getOriginalID()));
        }
        Boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < phyloTree.getLeaf2NumMap().size(); ++i) {
            int n6;
            if (phyloTreeEdge.contains(i)) {
                vector2.add(phyloTree.getLeaf2NumMap().get(i));
                if (!bl.booleanValue()) {
                    vector3.add(phyloTree.getLeaf2NumMap().get(i));
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (!phyloTree.getEdge(n6).properlyContains(phyloTreeEdge)) continue;
                        vector6.get(n6).addOne(n5);
                    }
                    for (n6 = 0; n6 < n3; ++n6) {
                        if (!phyloTree2.getEdge(n6).properlyContains(phyloTreeEdge)) continue;
                        vector7.get(n6).addOne(n5);
                    }
                    ++n5;
                    bl = true;
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    if (!phyloTreeEdge.properlyContains(phyloTree.getEdge(n6)) || !phyloTree.getEdge(n6).contains(i)) continue;
                    vector4.get(n6).addOne(n4);
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    if (!phyloTreeEdge.properlyContains(phyloTree2.getEdge(n6)) || !phyloTree2.getEdge(n6).contains(i)) continue;
                    vector5.get(n6).addOne(n4);
                }
                ++n4;
                continue;
            }
            vector3.add(phyloTree.getLeaf2NumMap().get(i));
            for (n6 = 0; n6 < n2; ++n6) {
                if (!phyloTree.getEdge(n6).contains(i)) continue;
                vector6.get(n6).addOne(n5);
            }
            for (n6 = 0; n6 < n3; ++n6) {
                if (!phyloTree2.getEdges().get(n6).contains(i)) continue;
                vector7.get(n6).addOne(n5);
            }
            ++n5;
        }
        vector4 = TreeDistance.deleteZeroEdges(vector4);
        vector5 = TreeDistance.deleteZeroEdges(vector5);
        vector6 = TreeDistance.deleteZeroEdges(vector6);
        vector7 = TreeDistance.deleteZeroEdges(vector7);
        PhyloTree phyloTree3 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector4), TreeDistance.myVectorCloneString(vector2));
        PhyloTree phyloTree4 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector6), TreeDistance.myVectorCloneString(vector3));
        PhyloTree phyloTree5 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector5), TreeDistance.myVectorCloneString(vector2));
        PhyloTree phyloTree6 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(vector7), TreeDistance.myVectorCloneString(vector3));
        Geodesic geodesic = TreeDistance.getGeodesicRecursive(phyloTree3, phyloTree5, string);
        Geodesic geodesic2 = TreeDistance.getGeodesicRecursive(phyloTree4, phyloTree6, string);
        Vector<PhyloTreeEdge> vector8 = new Vector<PhyloTreeEdge>();
        vector8.addAll(geodesic.getCommonEdges());
        vector8.addAll(geodesic2.getCommonEdges());
        EdgeAttribute edgeAttribute = EdgeAttribute.difference(phyloTree.getAttribOfSplit(phyloTreeEdge), phyloTree2.getAttribOfSplit(phyloTreeEdge));
        edgeAttribute.ensurePositive();
        vector8.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
        return new Geodesic(RatioSequence.interleave(geodesic.getRS(), geodesic2.getRS()), vector8);
    }

    public static Geodesic[][] getAllInterTreeGeodesics(PhyloTree[] phyloTreeArray, int n, String string, boolean bl) {
        Date date;
        Date date2;
        int n2;
        int n3;
        long[][] lArray = new long[n][n];
        long l = 0L;
        double[][] dArray = new double[n][n];
        Geodesic[][] geodesicArray = new Geodesic[n][n];
        if (verbose >= 1) {
            System.out.println("Algorithm: " + string + "\n");
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                if (string.equals("divide") || string.equals("DivideAndConquerRS") || string.equals("ConjBothEnds") || string.equals("dynamic")) {
                    date2 = new Date();
                    geodesicArray[n3][n2] = TreeDistance.getGeodesic2(phyloTreeArray[n3], phyloTreeArray[n2], string, "geo_" + n3 + "_" + n2);
                    dArray[n3][n2] = geodesicArray[n3][n2].getDist();
                    date = new Date();
                    lArray[n3][n2] = date.getTime() - date2.getTime();
                    l += lArray[n3][n2];
                    continue;
                }
                System.out.println("Unknown algorithm " + string + "; exiting.");
                System.exit(0);
            }
        }
        System.out.println("Average dist. computation of " + string + " was " + (l /= (long)(n * (n - 1) / 2)) + " ms for " + n * (n - 1) / 2 + " trees.");
        if (bl) {
            l = 0L;
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = n3 + 1; n2 < n; ++n2) {
                    if (string.equals("divide") || string.equals("DivideAndConquerRS") || string.equals("ConjBothEnds") || string.equals("dynamic")) {
                        date2 = new Date();
                        geodesicArray[n2][n3] = TreeDistance.getGeodesic2(phyloTreeArray[n2], phyloTreeArray[n3], string, "geo_" + n2 + "_" + "i");
                        dArray[n2][n3] = geodesicArray[n2][n3].getDist();
                        date = new Date();
                        lArray[n2][n3] = date.getTime() - date2.getTime();
                        l += lArray[n2][n3];
                    } else {
                        System.out.println("Unknown algorithm " + string + "; exiting.");
                        System.exit(0);
                    }
                    if (TreeDistance.truncate(geodesicArray[n3][n2].getDist(), 10) == TreeDistance.truncate(geodesicArray[n2][n3].getDist(), 10)) continue;
                    System.out.println("***" + string + " distances don't match for trees " + n3 + " and " + n2 + "***");
                    System.out.println("Dist " + n3 + " -> " + n2 + " is " + geodesicArray[n3][n2].getDist() + " but dist " + n2 + " -> " + n3 + " is " + geodesicArray[n2][n3].getDist());
                    System.out.println("RS " + n3 + " -> " + n2 + "           : " + geodesicArray[n3][n2]);
                    System.out.println("geos[" + n3 + "][" + n2 + "].getRS().getAscRSWithMinDist().getDistance() is " + geodesicArray[n3][n2].getRS().getNonDesRSWithMinDist().getDistance() + "; commonEdges is " + geodesicArray[n3][n2].getCommonEdges() + "; and leafContributionSquared is " + geodesicArray[n3][n2].getLeafContributionSquared());
                    System.out.println("RS " + n2 + " -> " + n3 + " (reversed): " + geodesicArray[n2][n3].reverse());
                    System.out.println("geos[" + n2 + "][" + n3 + "].getRS().getAscRSWithMinDist().getDistance() is " + geodesicArray[n2][n3].getRS().getNonDesRSWithMinDist().getDistance() + "; commonEdges is " + geodesicArray[n2][n3].getCommonEdges() + "; and leafContributionSquared is " + geodesicArray[n2][n3].getLeafContributionSquared());
                }
            }
            System.out.println("In doubleCheck, average dist. computation of " + string + " was " + (l /= (long)(n * (n - 1) / 2)) + " ms for " + n * (n - 1) / 2 + " trees.");
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = n3 + 1; n2 < n; ++n2) {
                    geodesicArray[n2][n3] = geodesicArray[n3][n2];
                }
            }
        }
        return geodesicArray;
    }

    public static Geodesic getPruned1GeodesicNoCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        TreeDistance.resetTreeDistanceState();
        numMaxPaths = 0L;
        int n = phyloTree.getEdges().size();
        if (n == 0) {
            return new Geodesic(new RatioSequence());
        }
        if (n == 1) {
            Ratio ratio = new Ratio();
            ratio.addEEdge(phyloTree.getEdge(0));
            ratio.addFEdge(phyloTree2.getEdge(0));
            RatioSequence ratioSequence = new RatioSequence();
            ratioSequence.add(ratio);
            return new Geodesic(ratioSequence);
        }
        Vector<Bipartition> vector = phyloTree2.getCrossingsWith(phyloTree);
        if (vector == null) {
            System.out.println("The trees " + phyloTree + " and " + phyloTree2 + " do not have the same leaf labels.");
            System.exit(0);
        }
        TreeDistance.getMaxPathSpacesAsRatioSeqs(vector, new RatioSequence(), phyloTree.getEdges(), phyloTree2.getEdges());
        return new Geodesic(minTreeDistRatioSeq);
    }

    public static Geodesic getPruned2GeodesicNoCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        TreeDistance.resetTreeDistanceState();
        numMaxPaths = 0L;
        int n = phyloTree.getEdges().size();
        int n2 = phyloTree2.getEdges().size();
        Vector<Bipartition> vector = phyloTree2.getCrossingsWith(phyloTree);
        if (vector == null) {
            System.out.println("The trees " + phyloTree + " and " + phyloTree2 + " do not have the same leaf labels.");
            System.exit(0);
        }
        Bipartition bipartition = vector.get(0);
        Boolean bl = true;
        for (int i = 1; i < vector.size(); ++i) {
            if (vector.get(i).equals(bipartition)) continue;
            bl = false;
            break;
        }
        if (bl.booleanValue()) {
            ++numBaseCase;
            RatioSequence ratioSequence = new RatioSequence();
            ratioSequence.add(new Ratio(TreeDistance.myVectorClonePhyloTreeEdge(phyloTree.getEdges()), TreeDistance.myVectorClonePhyloTreeEdge(phyloTree2.getEdges())));
            return new Geodesic(ratioSequence);
        }
        TreeDistance.getPruned2MaxPathSpacesAsRatioSeqs(vector, new RatioSequence(), phyloTree.getEdges(), phyloTree2.getEdges());
        if (n > 2 && n2 > 2) {
            System.out.println("Calculating distance between " + phyloTree.getLeaf2NumMap().size() + "-leaved trees took " + numPrunes + " prunes, " + numMaxPaths + " shorter paths and " + numNodes + " nodes; min path was " + minTreeDist / firstTreeDist + " of first path");
        }
        return new Geodesic(minTreeDistRatioSeq);
    }

    public static Geodesic getDivideAndConquerGeodesicNoCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        PhyloTree phyloTree3 = null;
        Geodesic geodesic = null;
        Geodesic geodesic2 = null;
        RatioSequence ratioSequence = null;
        Vector<Bipartition> vector = phyloTree2.getCrossingsWith(phyloTree);
        if (vector == null) {
            System.out.println("The trees " + phyloTree + " and " + phyloTree2 + " do not have the same leaf labels.");
            System.exit(0);
        }
        Bipartition bipartition = vector.get(0);
        Boolean bl = true;
        for (int i = 1; i < vector.size(); ++i) {
            if (vector.get(i).equals(bipartition)) continue;
            bl = false;
            break;
        }
        if (bl.booleanValue()) {
            ++numBaseCase;
            RatioSequence ratioSequence2 = new RatioSequence();
            ratioSequence2.add(new Ratio(TreeDistance.myVectorClonePhyloTreeEdge(phyloTree.getEdges()), TreeDistance.myVectorClonePhyloTreeEdge(phyloTree2.getEdges())));
            return new Geodesic(ratioSequence2);
        }
        Vector<Bipartition> vector2 = TreeDistance.getMinElements(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            Bipartition bipartition2 = vector2.get(i);
            Ratio ratio = TreeDistance.calculateRatio(bipartition2, vector, phyloTree.getEdges(), phyloTree2.getEdges());
            phyloTree3 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(phyloTree.getEdges()), TreeDistance.myVectorCloneString(phyloTree.getLeaf2NumMap()));
            phyloTree3.removeEdgesIndicatedByOnes(bipartition2);
            for (int j = 0; j < vector.size(); ++j) {
                if (!vector.get(j).equals(bipartition2)) continue;
                phyloTree3.addEdge(phyloTree2.getEdge(j).clone());
            }
            Geodesic geodesic3 = TreeDistance.getGeodesicRecursive(phyloTree3, phyloTree2, "divide");
            ratioSequence = new RatioSequence();
            ratioSequence.add(ratio);
            ratioSequence.addAll(geodesic3.getRS());
            geodesic2 = new Geodesic(ratioSequence);
            if (geodesic == null) {
                geodesic = geodesic2.clone();
                continue;
            }
            if (!(geodesic2.getDist() < geodesic.getDist())) continue;
            geodesic = geodesic2.clone();
        }
        return geodesic;
    }

    public static RatioSequence getDivideAndConquerRSNoCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        PhyloTree phyloTree3 = null;
        RatioSequence ratioSequence = null;
        RatioSequence ratioSequence2 = null;
        Vector<Bipartition> vector = phyloTree2.getCrossingsWith(phyloTree);
        if (vector == null) {
            System.out.println("The trees " + phyloTree + " and " + phyloTree2 + " do not have the same leaf labels.");
            System.exit(0);
        }
        Bipartition bipartition = vector.get(0);
        Boolean bl = true;
        for (int i = 1; i < vector.size(); ++i) {
            if (vector.get(i).equals(bipartition)) continue;
            bl = false;
            break;
        }
        if (bl.booleanValue()) {
            ++numBaseCase;
            ratioSequence = new RatioSequence();
            ratioSequence.add(new Ratio(TreeDistance.myVectorClonePhyloTreeEdge(phyloTree.getEdges()), TreeDistance.myVectorClonePhyloTreeEdge(phyloTree2.getEdges())));
            return ratioSequence;
        }
        Vector<Bipartition> vector2 = TreeDistance.getMinElements(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            RatioSequence ratioSequence3;
            int n;
            Bipartition bipartition2 = vector2.get(i);
            Ratio ratio = TreeDistance.calculateRatio(bipartition2, vector, phyloTree.getEdges(), phyloTree2.getEdges());
            phyloTree3 = new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(phyloTree.getEdges()), TreeDistance.myVectorCloneString(phyloTree.getLeaf2NumMap()));
            phyloTree3.removeEdgesIndicatedByOnes(bipartition2);
            for (n = 0; n < vector.size(); ++n) {
                if (!vector.get(n).equals(bipartition2)) continue;
                phyloTree3.addEdge(phyloTree2.getEdge(n).clone());
            }
            n = aTreesNoCommonEdges.size();
            TreeDistance.splitOnCommonEdge(phyloTree3, phyloTree2);
            RatioSequence ratioSequence4 = TreeDistance.getDivideAndConquerRSNoCommonEdges(aTreesNoCommonEdges.lastElement(), bTreesNoCommonEdges.lastElement());
            aTreesNoCommonEdges.remove(aTreesNoCommonEdges.lastElement());
            bTreesNoCommonEdges.remove(bTreesNoCommonEdges.lastElement());
            if (n != aTreesNoCommonEdges.size()) {
                RatioSequence ratioSequence5 = TreeDistance.getDivideAndConquerRSNoCommonEdges(aTreesNoCommonEdges.lastElement(), bTreesNoCommonEdges.lastElement());
                aTreesNoCommonEdges.remove(aTreesNoCommonEdges.lastElement());
                bTreesNoCommonEdges.remove(bTreesNoCommonEdges.lastElement());
                ratioSequence3 = RatioSequence.interleave(ratioSequence5, ratioSequence4);
            } else {
                ratioSequence3 = ratioSequence4;
            }
            ratioSequence2 = new RatioSequence();
            ratioSequence2.add(ratio);
            ratioSequence2.addAll(ratioSequence3);
            if (ratioSequence == null) {
                ratioSequence = ratioSequence2.clone();
                continue;
            }
            if (!(ratioSequence2.getMinNonDesRSDistance() < ratioSequence.getMinNonDesRSDistance())) continue;
            ratioSequence = ratioSequence2.clone();
        }
        return ratioSequence;
    }

    public static Ratio calculateRatio(Bipartition bipartition, Vector<Bipartition> vector, Vector<PhyloTreeEdge> vector2, Vector<PhyloTreeEdge> vector3) {
        Ratio ratio = new Ratio();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null || !vector.get(i).equals(bipartition)) continue;
            ratio.addFEdge(vector3.get(i).clone());
        }
        for (int n : TreeDistance.binaryToVector(bipartition.getPartition())) {
            if (n > vector2.size()) {
                System.out.println("Trying to add split " + n + " as indicated by minEl " + bipartition);
                System.out.println("but edges are " + vector2);
            }
            ratio.addEEdge(vector2.get(n));
        }
        return ratio;
    }

    public static void getMaxPathSpacesAsRatioSeqs(Vector<Bipartition> vector, RatioSequence ratioSequence, Vector<PhyloTreeEdge> vector2, Vector<PhyloTreeEdge> vector3) {
        Ratio ratio;
        Vector<Bipartition> vector4 = TreeDistance.getMinElements(vector);
        if (vector4.size() == 0) {
            ++numMaxPaths;
            double d = ratioSequence.getNonDesRSWithMinDist().getDistance();
            if (minTreeDist < 0.0 || d < minTreeDist) {
                minTreeDist = d;
                minTreeDistRatioSeq = ratioSequence.clone();
            }
            if (firstTreeDist == -1.0) {
                firstTreeDist = d;
            }
            return;
        }
        Vector<Bipartition> vector5 = new Vector<Bipartition>();
        Vector<Ratio> vector6 = new Vector<Ratio>();
        for (Bipartition bipartition : vector4) {
            ratio = TreeDistance.calculateRatio(bipartition, vector, vector2, vector3);
            Boolean bl = false;
            for (int i = 0; i < vector6.size(); ++i) {
                if (!(((Ratio)vector6.get(i)).getRatio() > ratio.getRatio())) continue;
                vector6.add(i, ratio.clone());
                vector5.add(i, bipartition.clone());
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            vector6.add(ratio.clone());
            vector5.add(bipartition.clone());
        }
        for (int i = 0; i < vector6.size(); ++i) {
            Bipartition bipartition;
            bipartition = (Bipartition)vector5.get(i);
            ratio = (Ratio)vector6.get(i);
            Vector<Bipartition> vector7 = TreeDistance.removeMinElFrom(vector, bipartition);
            ratioSequence.add(ratio);
            double d = ratioSequence.getNonDesRSWithMinDist().getDistance();
            if (vector2.size() > 5 && minTreeDist > 0.0 && d > minTreeDist) {
                if (++numPrunes % 1000L == 0L) {
                    // empty if block
                }
            } else {
                TreeDistance.getMaxPathSpacesAsRatioSeqs(vector7, ratioSequence, vector2, vector3);
            }
            ratioSequence.remove(ratio);
        }
        vector4 = null;
    }

    public static void getPruned2MaxPathSpacesAsRatioSeqs(Vector<Bipartition> vector, RatioSequence ratioSequence, Vector<PhyloTreeEdge> vector2, Vector<PhyloTreeEdge> vector3) {
        Ratio ratio;
        Vector<Bipartition> vector4 = TreeDistance.getMinElements(vector);
        if (vector4.size() == 0) {
            ++numMaxPaths;
            double d = ratioSequence.getNonDesRSWithMinDist().getDistance();
            if (pathToSearch == 1) {
                System.out.println("In base case with distance " + d + " and rs " + ratioSequence.getNonDesRSWithMinDist());
            }
            if (minTreeDist < 0.0 || d < minTreeDist) {
                minTreeDist = d;
                minTreeDistRatioSeq = ratioSequence.clone();
            }
            if (firstTreeDist == -1.0) {
                firstTreeDist = d;
            }
            return;
        }
        Vector<Bipartition> vector5 = new Vector<Bipartition>();
        Vector<Ratio> vector6 = new Vector<Ratio>();
        for (Bipartition bipartition : vector4) {
            ratio = TreeDistance.calculateRatio(bipartition, vector, vector2, vector3);
            Boolean bl = false;
            for (int i = 0; i < vector6.size(); ++i) {
                if (!(((Ratio)vector6.get(i)).getRatio() > ratio.getRatio())) continue;
                vector6.add(i, ratio.clone());
                vector5.add(i, bipartition.clone());
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            vector6.add(ratio.clone());
            vector5.add(bipartition.clone());
        }
        if (pathToSearch == 1 && minTreeDistRatioSeq == null) {
            System.out.println("sortedMinElRatios is " + vector6);
        }
        for (int i = 0; i < vector6.size(); ++i) {
            Bipartition bipartition;
            bipartition = (Bipartition)vector5.get(i);
            ratio = (Ratio)vector6.get(i);
            Vector<Bipartition> vector7 = TreeDistance.removeMinElFrom(vector, bipartition);
            Double d = nodeHashtable.get(vector7.toString());
            ratioSequence.add(ratio);
            double d2 = ratioSequence.getNonDesRSWithMinDist().getDistance();
            if (d != null) {
                double d3 = d;
                if (d2 < d3) {
                    nodeHashtable.put(vector7.toString(), new Double(d2));
                    if (d2 < minTreeDist) {
                        if (pathToSearch == 1) {
                            // empty if block
                        }
                        TreeDistance.getPruned2MaxPathSpacesAsRatioSeqs(vector7, ratioSequence, vector2, vector3);
                    } else {
                        ++numPrunes;
                    }
                } else {
                    ++numPrunes;
                }
            } else {
                ++numNodes;
                nodeHashtable.put(vector7.toString(), new Double(d2));
                TreeDistance.getPruned2MaxPathSpacesAsRatioSeqs(vector7, ratioSequence, vector2, vector3);
            }
            ratioSequence.remove(ratio);
        }
        vector4 = null;
    }

    public static Vector<Integer> binaryToVector(BitSet bitSet) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            vector.add(i);
        }
        return vector;
    }

    public static Vector<Bipartition> getMinElements(Vector<Bipartition> vector) {
        Vector<Bipartition> vector2 = new Vector<Bipartition>();
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) continue;
            bl = true;
            int n = 0;
            while (n < vector2.size()) {
                Bipartition bipartition = vector2.get(n);
                if (bipartition.properlyContains(vector.get(i))) {
                    vector2.remove(bipartition);
                } else {
                    ++n;
                }
                if (!vector.get(i).contains(bipartition)) continue;
                bl = false;
            }
            if (!bl) continue;
            vector2.add(vector.get(i));
        }
        return vector2;
    }

    public static Vector<PhyloTreeEdge> deleteZeroEdges(Vector<PhyloTreeEdge> vector) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.get(n).isZero()) {
                vector.remove(n);
                continue;
            }
            ++n;
        }
        return vector;
    }

    public static Vector<PhyloTreeEdge> myVectorClonePhyloTreeEdge(Vector<PhyloTreeEdge> vector) {
        if (vector == null) {
            return null;
        }
        Vector<PhyloTreeEdge> vector2 = new Vector<PhyloTreeEdge>();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) {
                vector2.add(null);
                continue;
            }
            vector2.add(vector.get(i).clone());
        }
        return vector2;
    }

    public static Vector<RatioSequence> myVectorCloneRatioSequence(Vector<RatioSequence> vector) {
        if (vector == null) {
            return null;
        }
        Vector<RatioSequence> vector2 = new Vector<RatioSequence>();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) {
                vector2.add(null);
                continue;
            }
            vector2.add(vector.get(i).clone());
        }
        return vector2;
    }

    public static Vector<Bipartition> removeMinElFrom(Vector<Bipartition> vector, Bipartition bipartition) {
        Vector<Bipartition> vector2 = TreeDistance.myVectorCloneBipartition(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector2.get(i) == null || !vector2.get(i).equals(bipartition)) continue;
            vector2.set(i, null);
        }
        for (int n : TreeDistance.binaryToVector(bipartition.getPartition())) {
            vector2 = TreeDistance.zeroCol(n, vector2);
        }
        return vector2;
    }

    public static Vector<String> myVectorCloneString(Vector<String> vector) {
        if (vector == null) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) {
                vector2.add(null);
                continue;
            }
            vector2.add(new String(vector.get(i)));
        }
        return vector2;
    }

    public static double truncate(double d, int n) {
        return Math.floor(d * Math.pow(10.0, n)) / Math.pow(10.0, n);
    }

    public static double round(double d, int n) {
        return (double)Math.round(d * Math.pow(10.0, n)) / Math.pow(10.0, n);
    }

    public static PhyloTree[] readInTreesFromFile(String string) {
        PhyloTree[] phyloTreeArray;
        int n = 0;
        Vector<PhyloTree[]> vector = new Vector<PhyloTree[]>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((phyloTreeArray = bufferedReader.readLine()) != null) {
                if (phyloTreeArray == "") continue;
                vector.add(phyloTreeArray);
                ++n;
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening or reading from " + string + ": " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Error opening or reading from " + string + ": " + iOException.getMessage());
            System.exit(1);
        }
        phyloTreeArray = new PhyloTree[n];
        for (int i = 0; i < n; ++i) {
            phyloTreeArray[i] = new PhyloTree((String)vector.get(i), rooted);
            if (!normalize) continue;
            phyloTreeArray[i].normalize();
        }
        return phyloTreeArray;
    }

    public static void computeAllInterTreeGeodesicsFromFile(String string, String string2, String string3, boolean bl) {
        PhyloTree[] phyloTreeArray = TreeDistance.readInTreesFromFile(string);
        int n = phyloTreeArray.length;
        if (n < 2) {
            System.out.println("Error:  tree file must contain at least 2 trees");
            System.exit(1);
        }
        if (verbose >= 1) {
            System.out.println("" + n + " trees read in from " + string);
        }
        Geodesic[][] geodesicArray = TreeDistance.getAllInterTreeGeodesics(phyloTreeArray, n, string3, bl);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string2));
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    printWriter.println(i + "\t" + j + "\t" + TreeDistance.round(geodesicArray[i][j].getDist(), 6));
                }
                printWriter.println();
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening or writing to " + string2 + ": " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Error opening or writing to " + string2 + ": " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void compareAlgorithms(PhyloTree[] phyloTreeArray, int n, String string, String string2) {
        long l = 0L;
        long l2 = 0L;
        if (!((string.equals("divide") || string.equals("DivideAndConquerRS") || string.equals("ConjBothEnds") || string.equals("dynamic")) && (string2.equals("divide") || string2.equals("ConjBothEnds") || string2.equals("dynamic")))) {
            System.out.println("Error:  either " + string + " or " + string2 + " is an invalid algorithm.");
            System.exit(1);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                Date date = new Date();
                Geodesic geodesic = TreeDistance.getGeodesic2(phyloTreeArray[i], phyloTreeArray[j], string, "geo_alg1_" + i + "_" + j);
                Date date2 = new Date();
                double d = geodesic.getDist();
                long l3 = date2.getTime() - date.getTime();
                l += l3;
                date = new Date();
                Geodesic geodesic2 = TreeDistance.getGeodesic2(phyloTreeArray[i], phyloTreeArray[j], string2, "geo_alg2_" + i + "_" + j);
                date2 = new Date();
                double d2 = geodesic2.getDist();
                long l4 = date2.getTime() - date.getTime();
                l2 += l4;
                if (TreeDistance.truncate(d, 10) == TreeDistance.truncate(d2, 10)) continue;
                System.out.println("***" + string + " and " + string2 + " distances don't match for trees " + i + " -> " + j + "***");
                System.out.println(string + " dist is " + d + " but " + string2 + " dist is " + d2);
                System.out.println("RS " + i + " -> " + j + " for algorithm " + string + ":");
                System.out.println("" + geodesic);
                System.out.println("RS " + i + " -> " + j + " for algorithm " + string2 + ":");
                System.out.println("" + geodesic2);
            }
        }
        System.out.println("Average dist. computation of " + string + " was " + (l /= (long)(n * (n - 1))) + " ms for " + n * (n - 1) + " trees.");
        System.out.println("Average dist. computation of " + string2 + " was " + (l2 /= (long)(n * (n - 1))) + " ms for " + n * (n - 1) + " trees.");
    }

    public static void displayHelp() {
        System.out.println("Command line syntax:");
        System.out.println("geodeMAPS [options] treefile");
        System.out.println("Optional arguments:");
        System.out.println("\t -a <algorithm> \t uses <algorithm> to compute the geodesic distance.  Current options are divide to run GeodeMaps-Divide, and dynamic to run GeodeMaps-Dynamic.  The default is dynamic.");
        System.out.println("\t -d \t double check results, by computing each distance with the target tree as the starting tree and vice versa; default is false");
        System.out.println("\t -h || --help \t displays this message");
        System.out.println("\t -n \t normalize (vector of the lengths of all edges has length 1)");
        System.out.println("\t -o <outfile> \t store the output in the file <outfile>");
        System.out.println("\t -u \t unrooted trees (default is rooted trees)");
        System.out.println("\t -v || --verbose \t verbose output");
    }

    public static void main(String[] stringArray) {
        String string = "dynamic";
        String string2 = "";
        String string3 = "output.txt";
        boolean bl = false;
        if (stringArray.length < 1) {
            TreeDistance.displayHelp();
            System.exit(0);
        }
        string2 = stringArray[stringArray.length - 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].startsWith("-")) {
                System.out.println("Invalid command line option");
                TreeDistance.displayHelp();
                System.exit(0);
            }
            if (stringArray[i].equals("--verbose")) {
                verbose = 1;
                continue;
            }
            if (stringArray[i].equals("--help")) {
                TreeDistance.displayHelp();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-a")) {
                if (i < stringArray.length - 2) {
                    string = stringArray[i + 1];
                    ++i;
                    continue;
                }
                TreeDistance.displayHelp();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-o")) {
                if (i < stringArray.length - 2) {
                    string3 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                TreeDistance.displayHelp();
                System.exit(0);
                continue;
            }
            block8: for (int j = 1; j < stringArray[i].length(); ++j) {
                switch (stringArray[i].charAt(j)) {
                    case 'd': {
                        bl = true;
                        continue block8;
                    }
                    case 'h': {
                        TreeDistance.displayHelp();
                        System.exit(0);
                        continue block8;
                    }
                    case 'n': {
                        normalize = true;
                        continue block8;
                    }
                    case 'u': {
                        rooted = false;
                        continue block8;
                    }
                    case 'v': {
                        verbose = 1;
                        continue block8;
                    }
                    default: {
                        System.out.println("Illegal command line option.\n");
                        TreeDistance.displayHelp();
                        System.exit(0);
                    }
                }
            }
        }
        TreeDistance.computeAllInterTreeGeodesicsFromFile(string2, string3, string, bl);
        System.exit(0);
    }

    public static Vector<Bipartition> myVectorCloneBipartition(Vector<Bipartition> vector) {
        if (vector == null) {
            return null;
        }
        Vector<Bipartition> vector2 = new Vector<Bipartition>();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) {
                vector2.add(null);
                continue;
            }
            vector2.add(vector.get(i).clone());
        }
        return vector2;
    }
}

