/*
 * Decompiled with CFR 0.152.
 */
package polyAlg;

import distanceAlg1.EdgeAttribute;
import distanceAlg1.Geodesic;
import distanceAlg1.PhyloTree;
import distanceAlg1.PhyloTreeEdge;
import distanceAlg1.Ratio;
import distanceAlg1.RatioSequence;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import polyAlg.BipartiteGraph;
import polyAlg.Tools;

public class PolyMain {
    public static Vector<PhyloTree> aTreesNoCommonEdges = new Vector();
    public static Vector<PhyloTree> bTreesNoCommonEdges = new Vector();
    public static boolean normalize = false;
    public static int verbose = 0;
    public static String LEAF_CONTRIBUTION_SQUARED_DESCRIPTION = "(Leaf contribution squared = square of the length of the vector whose i-th element is the absolute value of the difference between the length of the split ending in leaf i in the first tree and the length of the split ending in leaf i in the second tree.)";

    public static void splitOnCommonEdge(PhyloTree phyloTree, PhyloTree phyloTree2) {
        int n = phyloTree.getEdges().size();
        int n2 = phyloTree2.getEdges().size();
        if (n == 0 || n2 == 0) {
            return;
        }
        Vector<PhyloTreeEdge> vector = PhyloTree.getCommonEdges(phyloTree, phyloTree2);
        if (vector.size() == 0) {
            aTreesNoCommonEdges.add(phyloTree);
            bTreesNoCommonEdges.add(phyloTree2);
            return;
        }
        PhyloTreeEdge phyloTreeEdge = vector.get(0);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<PhyloTreeEdge> vector4 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector5 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector6 = new Vector<PhyloTreeEdge>();
        Vector<PhyloTreeEdge> vector7 = new Vector<PhyloTreeEdge>();
        for (PhyloTreeEdge phyloTreeEdge2 : phyloTree.getEdges()) {
            vector4.add(new PhyloTreeEdge(phyloTreeEdge2.getAttribute().clone(), phyloTreeEdge2.getOriginalEdge(), phyloTreeEdge2.getOriginalID()));
            vector6.add(new PhyloTreeEdge(phyloTreeEdge2.getAttribute().clone(), phyloTreeEdge2.getOriginalEdge(), phyloTreeEdge2.getOriginalID()));
        }
        for (PhyloTreeEdge phyloTreeEdge2 : phyloTree2.getEdges()) {
            vector5.add(new PhyloTreeEdge(phyloTreeEdge2.getAttribute().clone(), phyloTreeEdge2.getOriginalEdge(), phyloTreeEdge2.getOriginalID()));
            vector7.add(new PhyloTreeEdge(phyloTreeEdge2.getAttribute().clone(), phyloTreeEdge2.getOriginalEdge(), phyloTreeEdge2.getOriginalID()));
        }
        Object object = false;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < phyloTree.getLeaf2NumMap().size(); ++i) {
            int n5;
            if (phyloTreeEdge.contains(i)) {
                vector2.add(phyloTree.getLeaf2NumMap().get(i));
                if (!((Boolean)object).booleanValue()) {
                    vector3.add(phyloTree.getLeaf2NumMap().get(i) + "*");
                    for (n5 = 0; n5 < n; ++n5) {
                        if (!phyloTree.getEdge(n5).properlyContains(phyloTreeEdge)) continue;
                        vector6.get(n5).addOne(n4);
                    }
                    for (n5 = 0; n5 < n2; ++n5) {
                        if (!phyloTree2.getEdge(n5).properlyContains(phyloTreeEdge)) continue;
                        vector7.get(n5).addOne(n4);
                    }
                    ++n4;
                    object = true;
                }
                for (n5 = 0; n5 < n; ++n5) {
                    if (!phyloTreeEdge.properlyContains(phyloTree.getEdge(n5)) || !phyloTree.getEdge(n5).contains(i)) continue;
                    vector4.get(n5).addOne(n3);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    if (!phyloTreeEdge.properlyContains(phyloTree2.getEdge(n5)) || !phyloTree2.getEdge(n5).contains(i)) continue;
                    vector5.get(n5).addOne(n3);
                }
                ++n3;
                continue;
            }
            vector3.add(phyloTree.getLeaf2NumMap().get(i));
            for (n5 = 0; n5 < n; ++n5) {
                if (!phyloTree.getEdge(n5).contains(i)) continue;
                vector6.get(n5).addOne(n4);
            }
            for (n5 = 0; n5 < n2; ++n5) {
                if (!phyloTree2.getEdges().get(n5).contains(i)) continue;
                vector7.get(n5).addOne(n4);
            }
            ++n4;
        }
        vector4 = Tools.deleteEmptyEdges(vector4);
        vector5 = Tools.deleteEmptyEdges(vector5);
        vector6 = Tools.deleteEmptyEdges(vector6);
        vector7 = Tools.deleteEmptyEdges(vector7);
        PhyloTree phyloTree3 = new PhyloTree(Tools.myVectorClonePhyloTreeEdge(vector4), Tools.myVectorCloneString(vector2));
        PhyloTree phyloTree4 = new PhyloTree(Tools.myVectorClonePhyloTreeEdge(vector6), Tools.myVectorCloneString(vector3));
        PhyloTree phyloTree5 = new PhyloTree(Tools.myVectorClonePhyloTreeEdge(vector5), Tools.myVectorCloneString(vector2));
        PhyloTree phyloTree6 = new PhyloTree(Tools.myVectorClonePhyloTreeEdge(vector7), Tools.myVectorCloneString(vector3));
        PolyMain.splitOnCommonEdge(phyloTree3, phyloTree5);
        PolyMain.splitOnCommonEdge(phyloTree4, phyloTree6);
    }

    public static PhyloTree[] readInTreesFromFile(String string, boolean bl) {
        Object object;
        int n = 0;
        boolean bl2 = false;
        Vector<Object> vector = new Vector<Object>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            object = bufferedReader.readLine();
            if (((String)object).equals("#NEXUS")) {
                bl2 = true;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening or reading from " + string + ": " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Error opening or reading from " + string + ": " + iOException.getMessage());
            System.exit(1);
        }
        if (!bl2) {
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)object).equals("") || ((String)object).equals("\n")) continue;
                    object = ((String)object).substring(((String)object).indexOf("("));
                    vector.add(object);
                    ++n;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error opening or reading from " + string + ": " + fileNotFoundException.getMessage());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("Error opening or reading from " + string + ": " + iOException.getMessage());
                System.exit(1);
            }
        } else {
            System.out.println("Nexus format not supported.");
            System.exit(0);
        }
        object = new PhyloTree[n];
        for (int i = 0; i < n; ++i) {
            object[i] = new PhyloTree((String)vector.get(i), bl);
            if (!normalize) continue;
            ((PhyloTree)object[i]).normalize();
        }
        if (n > 1) {
            Vector<String> vector2 = ((PhyloTree)object[0]).getLeaf2NumMap();
            for (int i = 1; i < n; ++i) {
                if (vector2.equals(((PhyloTree)object[i]).getLeaf2NumMap())) continue;
                System.out.println("Warning:  tree at line " + (i + 1) + " does not have same leaves as first tree in file");
                System.out.println("Line 1 tree leaf set: " + vector2);
                System.out.println("Line " + (i + 1) + " tree leaf set: " + ((PhyloTree)object[i]).getLeaf2NumMap());
            }
        }
        return object;
    }

    public static Geodesic getGeodesic(PhyloTree phyloTree, PhyloTree phyloTree2, String string) {
        int n;
        int n2;
        double d = 0.0;
        EdgeAttribute[] edgeAttributeArray = phyloTree.getLeafEdgeAttribs();
        EdgeAttribute[] edgeAttributeArray2 = phyloTree2.getLeafEdgeAttribs();
        Geodesic geodesic = new Geodesic(new RatioSequence());
        String string2 = "";
        for (n2 = 0; n2 < phyloTree.getLeaf2NumMap().size(); ++n2) {
            if (!phyloTree.getLeaf2NumMap().get(n2).equals(phyloTree2.getLeaf2NumMap().get(n2))) {
                System.out.println("Error getting geodesic: trees do not have the same sets of leaves");
                System.out.println("Starting tree leaves: " + phyloTree.getLeaf2NumMap());
                System.out.println("Target tree leaves: " + phyloTree2.getLeaf2NumMap());
                System.out.println("Starting tree: " + phyloTree.getNewick(true));
                System.out.println("Target tree: " + phyloTree2.getNewick(true));
                System.exit(1);
            }
            d += Math.pow(EdgeAttribute.difference(edgeAttributeArray[n2], edgeAttributeArray2[n2]).norm(), 2.0);
        }
        geodesic.setLeafContributionSquared(d);
        if (verbose > 0) {
            System.out.println("Starting tree: " + phyloTree.getNewick(true));
            string2 = string2 + "Starting tree: " + phyloTree.getNewick(true) + "\n";
            System.out.println("Target tree: " + phyloTree2.getNewick(true));
            string2 = string2 + "Target tree: " + phyloTree2.getNewick(true) + "\n";
            System.out.println("\nStarting tree edges:");
            string2 = string2 + "\nStarting tree edges:\n";
            string2 = string2 + PhyloTreeEdge.printEdgesVerbose(phyloTree.getEdges(), phyloTree.getLeaf2NumMap(), true);
            System.out.println("\nTarget tree edges:");
            string2 = string2 + "\nTarget tree edges:\n";
            string2 = string2 + PhyloTreeEdge.printEdgesVerbose(phyloTree2.getEdges(), phyloTree2.getLeaf2NumMap(), true);
            System.out.println("\nLeaf contribution squared " + Tools.truncate(d, 6));
            string2 = string2 + "\nLeaf contribution squared " + Tools.truncate(d, 6) + "\n";
            System.out.println(LEAF_CONTRIBUTION_SQUARED_DESCRIPTION);
            string2 = string2 + LEAF_CONTRIBUTION_SQUARED_DESCRIPTION + "\n";
        }
        aTreesNoCommonEdges = new Vector();
        bTreesNoCommonEdges = new Vector();
        PolyMain.splitOnCommonEdge(phyloTree, phyloTree2);
        geodesic.setCommonEdges(PhyloTree.getCommonEdges(phyloTree, phyloTree2));
        if (verbose > 0) {
            System.out.println("\nCommon edges are:  (Length = abs. value of difference in length between the two trees)");
            string2 = string2 + "\nCommon edges are:  (Length = abs. value of difference in length between the two trees)\n";
            Vector<PhyloTreeEdge> vector = geodesic.getCommonEdges();
            string2 = string2 + PhyloTreeEdge.printEdgesVerbose(vector, phyloTree.getLeaf2NumMap(), true);
            double d2 = 0.0;
            for (n = 0; n < vector.size(); ++n) {
                d2 += Math.pow(vector.get(n).getLength(), 2.0);
            }
            System.out.println("\nCommon edges contribution squared: " + Tools.truncate(d2, 6));
            string2 = string2 + "\nCommon edges contribution squared: " + Tools.truncate(d2, 6) + "\n";
            System.out.println("(sum of squares of above differences in length)");
            string2 = string2 + "(sum of squares of above differences in length)\n";
            System.out.println("=============================================================================================================================");
            string2 = string2 + "=============================================================================================================================\n";
            System.out.println("\nNow finding the geodesic between the following subtrees, which have no edges in common:");
            string2 = string2 + "\nNow finding the geodesic between the following subtrees, which have no edges in common:\n";
        }
        for (n2 = 0; n2 < aTreesNoCommonEdges.size(); ++n2) {
            PhyloTree phyloTree3 = aTreesNoCommonEdges.get(n2);
            PhyloTree phyloTree4 = bTreesNoCommonEdges.get(n2);
            if (verbose > 0) {
                System.out.println("Leaves or subtree representatives in subtrees:");
                string2 = string2 + "Leaves or subtree representatives in subtrees:\n";
                for (n = 0; n < phyloTree3.getLeaf2NumMap().size(); ++n) {
                    System.out.println("" + phyloTree3.getLeaf2NumMap().get(n));
                    string2 = string2 + phyloTree3.getLeaf2NumMap().get(n) + "\n";
                }
                System.out.println("\nStarting subtree edges:");
                string2 = string2 + "\nStarting subtree edges:\n";
                string2 = string2 + PhyloTreeEdge.printEdgesVerbose(phyloTree3.getEdges(), phyloTree3.getLeaf2NumMap(), false);
                System.out.println("\nTarget subtree edges:");
                string2 = string2 + "\nTarget subtree edges:\n";
                string2 = string2 + PhyloTreeEdge.printEdgesVerbose(phyloTree4.getEdges(), phyloTree4.getLeaf2NumMap(), false);
            }
            Geodesic geodesic2 = PolyMain.getGeodesicNoCommonEdges(phyloTree3, phyloTree4);
            if (verbose > 0) {
                System.out.println("\nGeodesic distance between above subtrees, ignoring edges ending in leaves: " + Tools.truncate(geodesic2.getRS().getNonDesRSWithMinDist().getDistance(), 6));
                string2 = string2 + "\nGeodesic distance between above subtrees, ignoring edges ending in leaves: " + Tools.truncate(geodesic2.getRS().getNonDesRSWithMinDist().getDistance(), 6) + "\n";
                System.out.println("Ratio sequence corresponding to the geodesic:\nCombinatorial type: " + geodesic2.getRS().getNonDesRSWithMinDist().toStringCombType());
                string2 = string2 + "Ratio sequence corresponding to the geodesic:\nCombinatorial type: " + geodesic2.getRS().getNonDesRSWithMinDist().toStringCombType() + "\n";
                System.out.println(geodesic2.getRS().getNonDesRSWithMinDist().toStringVerbose(phyloTree3.getLeaf2NumMap()));
                string2 = string2 + geodesic2.getRS().getNonDesRSWithMinDist().toStringVerbose(phyloTree3.getLeaf2NumMap()) + "\n";
                System.out.println("------------------------------------------------------------------------------------------------------------");
                string2 = string2 + "------------------------------------------------------------------------------------------------------------\n";
            }
            geodesic.setRS(RatioSequence.interleave(geodesic.getRS(), geodesic2.getRS()));
        }
        if (verbose > 0) {
            System.out.println("\nGeodesic distance between start and target tree is " + Tools.truncate(geodesic.getDist(), 6));
            string2 = string2 + "\nGeodesic distance between start and target tree is " + Tools.truncate(geodesic.getDist(), 6) + "\n";
        }
        if (verbose > 0 && string != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println(string2);
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error opening or writing to " + string + ": " + fileNotFoundException.getMessage());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("Error opening or writing to " + string + ": " + iOException.getMessage());
                System.exit(1);
            }
        }
        return geodesic;
    }

    public static Geodesic getGeodesicNoCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        int n = phyloTree.getEdges().size();
        int n2 = phyloTree2.getEdges().size();
        RatioSequence ratioSequence = new RatioSequence();
        Vector<Ratio> vector = new Vector<Ratio>();
        if (n == 0 && n2 == 0) {
            return new Geodesic(new RatioSequence());
        }
        Vector<PhyloTreeEdge> vector2 = PhyloTree.getCommonEdges(phyloTree, phyloTree2);
        if (vector2.size() != 0) {
            System.out.println("Exiting: tried to compute geodesic between subtrees that should not have common edges, but do!  t1 = " + phyloTree + " and t2 = " + phyloTree2);
            System.exit(1);
        }
        if (n == 0 || n2 == 0) {
            System.out.println("Exiting: tried to compute geodesic between subtrees that should not have common/compatible edges, but do!  t1 = " + phyloTree + " and t2 = " + phyloTree2);
            System.exit(1);
        }
        if (n == 1 || n2 == 1) {
            ratioSequence.add(new Ratio(phyloTree.getEdges(), phyloTree2.getEdges()));
            return new Geodesic(ratioSequence);
        }
        boolean[][] blArray = Tools.getIncidenceMatrix(phyloTree.getEdges(), phyloTree2.getEdges());
        BipartiteGraph bipartiteGraph = new BipartiteGraph(blArray, phyloTree.getIntEdgeAttribNorms(), phyloTree2.getIntEdgeAttribNorms());
        vector.add(new Ratio(phyloTree.getEdges(), phyloTree2.getEdges()));
        while (vector.size() > 0) {
            int n3;
            int n4;
            Ratio ratio = (Ratio)vector.remove(0);
            int[] nArray = new int[ratio.getEEdges().size()];
            int[] nArray2 = new int[ratio.getFEdges().size()];
            for (n4 = 0; n4 < ratio.getEEdges().size(); ++n4) {
                nArray[n4] = phyloTree.getEdges().indexOf(ratio.getEEdges().get(n4));
            }
            for (n4 = 0; n4 < ratio.getFEdges().size(); ++n4) {
                nArray2[n4] = phyloTree2.getEdges().indexOf(ratio.getFEdges().get(n4));
            }
            int[][] nArray3 = bipartiteGraph.vertex_cover(nArray, nArray2);
            if (nArray3[0][0] == 0 || nArray3[0][0] == nArray.length) {
                ratioSequence.add(ratio);
                continue;
            }
            Ratio ratio2 = new Ratio();
            Ratio ratio3 = new Ratio();
            int n5 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (n5 < nArray3[2].length && nArray[n3] == nArray3[2][n5]) {
                    ratio2.addEEdge(phyloTree.getEdge(nArray[n3]));
                    ++n5;
                    continue;
                }
                ratio3.addEEdge(phyloTree.getEdge(nArray[n3]));
            }
            n5 = 0;
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                if (n5 < nArray3[3].length && nArray2[n3] == nArray3[3][n5]) {
                    ratio3.addFEdge(phyloTree2.getEdge(nArray2[n3]));
                    ++n5;
                    continue;
                }
                ratio2.addFEdge(phyloTree2.getEdge(nArray2[n3]));
            }
            vector.add(0, ratio3);
            vector.add(0, ratio2);
        }
        return new Geodesic(ratioSequence);
    }

    public static Geodesic[][] getAllInterTreeGeodesics(PhyloTree[] phyloTreeArray, boolean bl) {
        Date date;
        Date date2;
        int n;
        int n2;
        int n3 = phyloTreeArray.length;
        long[][] lArray = new long[n3][n3];
        long l = 0L;
        double[][] dArray = new double[n3][n3];
        Geodesic[][] geodesicArray = new Geodesic[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3; ++n) {
                date2 = new Date();
                geodesicArray[n2][n] = PolyMain.getGeodesic(phyloTreeArray[n2], phyloTreeArray[n], "geo_" + n2 + "_" + n);
                dArray[n2][n] = geodesicArray[n2][n].getDist();
                date = new Date();
                lArray[n2][n] = date.getTime() - date2.getTime();
                l += lArray[n2][n];
            }
        }
        System.out.println("Average dist. computation was " + (l /= (long)(n3 * (n3 - 1) / 2)) + " ms for " + n3 * (n3 - 1) / 2 + " trees.");
        if (bl) {
            l = 0L;
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = n2 + 1; n < n3; ++n) {
                    date2 = new Date();
                    geodesicArray[n][n2] = PolyMain.getGeodesic(phyloTreeArray[n], phyloTreeArray[n2], "geo_" + n + "_" + n2);
                    dArray[n][n2] = geodesicArray[n][n2].getDist();
                    date = new Date();
                    lArray[n][n2] = date.getTime() - date2.getTime();
                    l += lArray[n][n2];
                    if (Tools.truncate(geodesicArray[n2][n].getDist(), 10) == Tools.truncate(geodesicArray[n][n2].getDist(), 10)) continue;
                    System.out.println("*** Distances don't match for trees " + n2 + " and " + n + "***");
                    System.out.println("Dist " + n2 + " -> " + n + " is " + geodesicArray[n2][n].getDist() + " but dist " + n + " -> " + n2 + " is " + geodesicArray[n][n2].getDist());
                    System.out.println("RS " + n2 + " -> " + n + "           : " + geodesicArray[n2][n]);
                    System.out.println("geos[" + n2 + "][" + n + "].getRS().getAscRSWithMinDist().getDistance() is " + geodesicArray[n2][n].getRS().getNonDesRSWithMinDist().getDistance() + "; commonEdges is " + geodesicArray[n2][n].getCommonEdges() + "; and leafContributionSquared is " + geodesicArray[n2][n].getLeafContributionSquared());
                    System.out.println("RS " + n + " -> " + n2 + " (reversed): " + geodesicArray[n][n2].reverse());
                    System.out.println("geos[" + n + "][" + n2 + "].getRS().getAscRSWithMinDist().getDistance() is " + geodesicArray[n][n2].getRS().getNonDesRSWithMinDist().getDistance() + "; commonEdges is " + geodesicArray[n][n2].getCommonEdges() + "; and leafContributionSquared is " + geodesicArray[n][n2].getLeafContributionSquared());
                }
            }
            System.out.println("In doubleCheck, average dist. computation was " + (l /= (long)(n3 * (n3 - 1) / 2)) + " ms for " + n3 * (n3 - 1) / 2 + " trees.");
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = n2 + 1; n < n3; ++n) {
                    geodesicArray[n][n2] = geodesicArray[n2][n];
                }
            }
        }
        return geodesicArray;
    }

    public static void computeAllInterTreeGeodesicsFromFile(String string, String string2, boolean bl, boolean bl2) {
        PhyloTree[] phyloTreeArray = PolyMain.readInTreesFromFile(string, bl2);
        int n = phyloTreeArray.length;
        if (verbose >= 1) {
            System.out.println("" + n + " trees read in from " + string);
        }
        Geodesic[][] geodesicArray = PolyMain.getAllInterTreeGeodesics(phyloTreeArray, bl);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string2));
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    printWriter.println(i + "\t" + j + "\t" + Tools.round(geodesicArray[i][j].getDist(), 8));
                }
                printWriter.println();
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening or writing to " + string2 + ": " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Error opening or writing to " + string2 + ": " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static Geodesic[] getAllRowGeodesics(PhyloTree[] phyloTreeArray, int n) {
        int n2 = phyloTreeArray.length;
        double[] dArray = new double[n2];
        Geodesic[] geodesicArray = new Geodesic[n2];
        PhyloTree phyloTree = phyloTreeArray[n];
        for (int i = n + 1; i < n2; ++i) {
            geodesicArray[i] = PolyMain.getGeodesic(phyloTree, phyloTreeArray[i], "geo_" + n + "_" + i);
            dArray[i] = geodesicArray[i].getDist();
        }
        return geodesicArray;
    }

    public static void computeAllRowGeodesicsFromFile(String string, String string2, boolean bl, int n) {
        PhyloTree[] phyloTreeArray = PolyMain.readInTreesFromFile(string, bl);
        int n2 = phyloTreeArray.length;
        if (verbose >= 1) {
            System.out.println("" + n2 + " trees read in from " + string);
        }
        if (n > n2 - 1) {
            System.out.println("Row value " + n + " is too high for " + n2 + " trees");
            System.exit(1);
        }
        Geodesic[] geodesicArray = PolyMain.getAllRowGeodesics(phyloTreeArray, n);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string2));
            for (int i = n + 1; i < n2; ++i) {
                printWriter.println(n + "\t" + i + "\t" + Tools.round(geodesicArray[i].getDist(), 8));
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening or writing to " + string2 + ": " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Error opening or writing to " + string2 + ": " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void displayHelp() {
        System.out.println("Command line syntax:");
        System.out.println("gtp [options] treefile");
        System.out.println("Optional arguments:");
        System.out.println("\t -d \t double check results, by computing each distance with the target tree as the starting tree and vice versa; default is false");
        System.out.println("\t -h || --help \t displays this message");
        System.out.println("\t -n \t normalize (vector of the lengths of all edges has length 1)");
        System.out.println("\t -o <outfile> \t store the output in the file <outfile>");
        System.out.println("\t -u \t unrooted trees (default is rooted trees)");
        System.out.println("\t -v || --verbose \t verbose output");
        System.out.println("\t -r || --row + integer i\t Compute geodesics between the ith tree in the input file and all the others (not an all-all comparison)");
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "output.txt";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n = -1;
        if (stringArray.length < 1) {
            PolyMain.displayHelp();
            System.exit(0);
        }
        string = stringArray[stringArray.length - 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].startsWith("-")) {
                System.out.println("Invalid command line option");
                PolyMain.displayHelp();
                System.exit(0);
            }
            if (stringArray[i].equals("--verbose")) {
                verbose = 1;
                continue;
            }
            if (stringArray[i].equals("--help")) {
                PolyMain.displayHelp();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-o")) {
                if (i < stringArray.length - 2) {
                    string2 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                PolyMain.displayHelp();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-r") || stringArray[i].equals("-row")) {
                if (i < stringArray.length - 1) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                System.out.println("-r needs an integer follow-up value");
                PolyMain.displayHelp();
                System.exit(0);
                continue;
            }
            block9: for (int j = 1; j < stringArray[i].length(); ++j) {
                switch (stringArray[i].charAt(j)) {
                    case 'd': {
                        bl = true;
                        continue block9;
                    }
                    case 'h': {
                        PolyMain.displayHelp();
                        System.exit(0);
                        continue block9;
                    }
                    case 'm': {
                        bl2 = true;
                        continue block9;
                    }
                    case 'n': {
                        normalize = true;
                        continue block9;
                    }
                    case 'u': {
                        bl3 = false;
                        continue block9;
                    }
                    case 'v': {
                        verbose = 1;
                        continue block9;
                    }
                    default: {
                        System.out.println("Illegal command line option.\n");
                        PolyMain.displayHelp();
                        System.exit(0);
                    }
                }
            }
        }
        if (bl2) {
            PhyloTree[] phyloTreeArray = PolyMain.readInTreesFromFile(string, bl3);
            PolyMain.getMinLabelling(phyloTreeArray[0], phyloTreeArray[1], string2);
            System.exit(0);
        }
        if (n > -1) {
            PolyMain.computeAllRowGeodesicsFromFile(string, string2, bl3, n);
        } else {
            PolyMain.computeAllInterTreeGeodesicsFromFile(string, string2, bl, bl3);
        }
        System.exit(0);
    }

    public static PhyloTree getMinLabelling(PhyloTree phyloTree, PhyloTree phyloTree2, String string) {
        double d;
        int n = 100;
        double d2 = 1.0;
        Random random = new Random();
        PhyloTree phyloTree3 = phyloTree2.clone();
        double d3 = d = PolyMain.getGeodesic(phyloTree, phyloTree3, null).getDist();
        PhyloTree phyloTree4 = phyloTree3.clone();
        for (int i = 0; i < n; ++i) {
            System.out.println("current geo: " + d + "; tree: " + phyloTree3);
            PhyloTree phyloTree5 = phyloTree3.clone();
            phyloTree5.swapleaves(random.nextInt(phyloTree3.numLeaves()), random.nextInt(phyloTree3.numLeaves()));
            double d4 = PolyMain.getGeodesic(phyloTree, phyloTree5, null).getDist();
            if (d4 <= d) {
                phyloTree3 = phyloTree5.clone();
                d = d4;
            } else {
                double d5 = Math.exp(-(d4 - d) / d2);
                if (Math.random() < d5) {
                    phyloTree3 = phyloTree5.clone();
                    d = d4;
                }
            }
            if (!(d < d3)) continue;
            phyloTree4 = phyloTree3.clone();
            d3 = d;
        }
        System.out.println("Min labelled tree with dist " + d3 + " is: " + phyloTree4);
        return phyloTree4;
    }
}

