/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Ratio;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Vector;

public class RatioSequence
extends Vector<Ratio> {
    private static final long serialVersionUID = 42L;
    private int combineCode = 0;

    public RatioSequence() {
    }

    public RatioSequence(String string, String string2) {
        while (!string.equals("")) {
            this.add(new Ratio(Double.valueOf(string.substring(0, string.indexOf(","))), Double.valueOf(string2.substring(0, string2.indexOf(",")))));
            string = string.substring(string.indexOf(",") + 1);
            string2 = string2.substring(string2.indexOf(",") + 1);
        }
    }

    public void setCombineCode(int n) {
        this.combineCode = n;
    }

    public int getCombineCode() {
        return this.combineCode;
    }

    public Ratio getRatio(int n) {
        return (Ratio)this.get(n);
    }

    public boolean isAscending() {
        for (int i = 0; i < this.size() - 1; ++i) {
            if (!(((Ratio)this.get(i)).getRatio() > ((Ratio)this.get(i + 1)).getRatio())) continue;
            return false;
        }
        return true;
    }

    public double getDistance() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            Ratio ratio = this.getRatio(i);
            d += Math.pow(ratio.getELength() + ratio.getFLength(), 2.0);
        }
        return Math.sqrt(d);
    }

    public double getMinNonDesRSDistance() {
        return this.getNonDesRSWithMinDist().getDistance();
    }

    public static RatioSequence interleave(RatioSequence ratioSequence, RatioSequence ratioSequence2) {
        RatioSequence ratioSequence3 = ratioSequence.getNonDesRSWithMinDist();
        RatioSequence ratioSequence4 = ratioSequence2.getNonDesRSWithMinDist();
        RatioSequence ratioSequence5 = new RatioSequence();
        int n = 0;
        int n2 = 0;
        while (n < ratioSequence3.size() && n2 < ratioSequence4.size()) {
            if (((Ratio)ratioSequence3.get(n)).getRatio() <= ((Ratio)ratioSequence4.get(n2)).getRatio()) {
                ratioSequence5.add(ratioSequence3.get(n));
                ++n;
                continue;
            }
            ratioSequence5.add(ratioSequence4.get(n2));
            ++n2;
        }
        while (n < ratioSequence3.size()) {
            ratioSequence5.add(ratioSequence3.get(n));
            ++n;
        }
        while (n2 < ratioSequence4.size()) {
            ratioSequence5.add(ratioSequence4.get(n2));
            ++n2;
        }
        return ratioSequence5;
    }

    @Override
    public RatioSequence clone() {
        if (this == null) {
            return null;
        }
        RatioSequence ratioSequence = new RatioSequence();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null) {
                ratioSequence.add(null);
                continue;
            }
            ratioSequence.add(((Ratio)this.get(i)).clone());
        }
        ratioSequence.setCombineCode(this.getCombineCode());
        return ratioSequence;
    }

    public static RatioSequence getRandomRS(int n) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string = string + (Math.random() + 0.1) / 1.1 + ",";
            string2 = string2 + (Math.random() + 0.1) / 1.1 + ",";
        }
        return new RatioSequence(string, string2);
    }

    public RatioSequence getCombinedRS(int n) {
        RatioSequence ratioSequence = new RatioSequence();
        Ratio ratio = (Ratio)this.get(0);
        for (int i = 0; i < this.size() - 1; ++i) {
            if ((n & (int)Math.pow(2.0, i)) == (int)Math.pow(2.0, i)) {
                ratio = Ratio.combine(ratio, (Ratio)this.get(i + 1));
                continue;
            }
            ratioSequence.add(ratio);
            ratio = (Ratio)this.get(i + 1);
        }
        ratioSequence.add(ratio);
        return ratioSequence;
    }

    public RatioSequence getNonDesRSWithMinDist() {
        if (this.size() < 2) {
            return this;
        }
        RatioSequence ratioSequence = this.clone();
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.size() - 1];
        Arrays.fill(nArray, 2);
        int n3 = 0;
        while (n < ratioSequence.size() - 1) {
            if (((Ratio)ratioSequence.get(n)).getRatio() > ((Ratio)ratioSequence.get(n + 1)).getRatio()) {
                Ratio ratio = Ratio.combine((Ratio)ratioSequence.get(n), (Ratio)ratioSequence.get(n + 1));
                ratioSequence.remove(n);
                ratioSequence.remove(n);
                ratioSequence.add(n, ratio);
                nArray[n3] = 1;
                if (n > 0) {
                    --n;
                    while (nArray[n3] == 1) {
                        --n3;
                    }
                    continue;
                }
                while (n3 < this.size() - 1 && nArray[n3] != 2) {
                    ++n3;
                }
                continue;
            }
            nArray[n3] = 0;
            ++n;
            while (n3 < this.size() - 1 && nArray[n3] != 2) {
                ++n3;
            }
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            if (nArray[i] != 1) continue;
            n2 += (int)Math.pow(2.0, i);
        }
        ratioSequence.setCombineCode(n2);
        return ratioSequence;
    }

    public RatioSequence getAscRSWithMinDist() {
        if (this.size() < 2) {
            return this;
        }
        RatioSequence ratioSequence = this.clone();
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.size() - 1];
        Arrays.fill(nArray, 2);
        int n3 = 0;
        while (n < ratioSequence.size() - 1) {
            if (((Ratio)ratioSequence.get(n)).getRatio() >= ((Ratio)ratioSequence.get(n + 1)).getRatio()) {
                Ratio ratio = Ratio.combine((Ratio)ratioSequence.get(n), (Ratio)ratioSequence.get(n + 1));
                ratioSequence.remove(n);
                ratioSequence.remove(n);
                ratioSequence.add(n, ratio);
                nArray[n3] = 1;
                if (n > 0) {
                    --n;
                    while (nArray[n3] == 1) {
                        --n3;
                    }
                    continue;
                }
                while (n3 < this.size() - 1 && nArray[n3] != 2) {
                    ++n3;
                }
                continue;
            }
            nArray[n3] = 0;
            ++n;
            while (n3 < this.size() - 1 && nArray[n3] != 2) {
                ++n3;
            }
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            if (nArray[i] != 1) continue;
            n2 += (int)Math.pow(2.0, i);
        }
        ratioSequence.setCombineCode(n2);
        return ratioSequence;
    }

    public RatioSequence reverse() {
        RatioSequence ratioSequence = new RatioSequence();
        for (int i = this.size() - 1; i >= 0; --i) {
            ratioSequence.add(((Ratio)this.get(i)).reverse());
        }
        return ratioSequence;
    }

    public String toStringValueAndRatio() {
        DecimalFormat decimalFormat = new DecimalFormat("#0.####");
        String string = "[ ";
        for (int i = 0; i < this.size(); ++i) {
            string = string + decimalFormat.format(((Ratio)this.get(i)).getRatio()) + " = " + this.get(i) + " , ";
        }
        return string.substring(0, string.length() - 2) + "]";
    }

    public String toStringValue() {
        DecimalFormat decimalFormat = new DecimalFormat("#0.####");
        String string = "[ ";
        for (int i = 0; i < this.size(); ++i) {
            string = string + decimalFormat.format(((Ratio)this.get(i)).getRatio()) + " , ";
        }
        return string.substring(0, string.length() - 2) + "]";
    }

    public String toStringVerbose(Vector<String> vector) {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            string = string + "\nRatio " + i + ":  ";
            string = string + ((Ratio)this.get(i)).toStringVerbose(vector);
        }
        return string;
    }

    public String toStringCombType() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            string = string + ((Ratio)this.get(i)).toStringCombType() + ";";
        }
        return string;
    }

    public String toStringCombTypeAndValue() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            string = string + ((Ratio)this.get(i)).toStringCombTypeAndValue() + ";";
        }
        return string;
    }
}

