/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.PhyloTreeEdge;
import java.util.BitSet;
import java.util.Vector;

public class Bipartition
implements Cloneable {
    protected BitSet partition;

    public Bipartition() {
        this.partition = new BitSet();
    }

    public Bipartition(BitSet bitSet) {
        this.partition = bitSet;
    }

    public Bipartition(String string) {
        this.partition = new BitSet();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '1') {
                this.partition.set(i);
                continue;
            }
            if (string.charAt(i) == '0') continue;
            throw new RuntimeException("Error creating bipartition: input string " + string + " should only contain 0s and 1s");
        }
    }

    public BitSet getPartition() {
        return this.partition;
    }

    public boolean isEmpty() {
        return this.partition.isEmpty();
    }

    public void setPartition(BitSet bitSet) {
        this.partition = bitSet;
    }

    public void addOne(int n) {
        this.partition.set(n);
    }

    public void removeOne(int n) {
        this.partition.clear(n);
    }

    public boolean disjointFrom(Bipartition bipartition) {
        return !this.partition.intersects(bipartition.partition);
    }

    public boolean contains(Bipartition bipartition) {
        BitSet bitSet = (BitSet)bipartition.partition.clone();
        bitSet.and(this.partition);
        return bitSet.equals(bipartition.partition);
    }

    public boolean contains(int n) {
        return this.partition.get(n);
    }

    public boolean properlyContains(Bipartition bipartition) {
        return this.contains(bipartition) && !bipartition.contains(this);
    }

    public boolean crosses(Bipartition bipartition) {
        return !this.disjointFrom(bipartition) && !this.contains(bipartition) && !bipartition.contains(this);
    }

    public void complement(int n) {
        for (int i = 0; i < n; ++i) {
            this.partition.flip(i);
        }
    }

    public String toString() {
        return this.partition.toString();
    }

    public static String toStringVerbose(BitSet bitSet, Vector<String> vector) {
        String string = "";
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            string = string + vector.get(i) + ",";
        }
        return string.substring(0, string.length() - 1);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Bipartition) || object instanceof PhyloTreeEdge) {
            return false;
        }
        return this.partition.equals(((Bipartition)object).partition);
    }

    public Bipartition clone() {
        return new Bipartition((BitSet)this.partition.clone());
    }

    public boolean isCompatibleWith(Vector<Bipartition> vector) {
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.crosses(vector.get(i))) continue;
            bl = false;
        }
        return bl;
    }
}

