/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Bipartition;
import distanceAlg1.EdgeAttribute;
import distanceAlg1.Geodesic;
import distanceAlg1.PhyloTreeEdge;
import distanceAlg1.TreeDistance;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import polyAlg.PolyMain;
import polyAlg.Tools;

public class PhyloTree {
    private Vector<PhyloTreeEdge> edges;
    private Vector<String> leaf2NumMap;
    private EdgeAttribute[] leafEdgeAttribs;
    private String newick;

    public PhyloTree(Vector<PhyloTreeEdge> vector, Vector<String> vector2, EdgeAttribute[] edgeAttributeArray) {
        this.edges = vector;
        this.leaf2NumMap = vector2;
        this.leafEdgeAttribs = edgeAttributeArray;
    }

    public PhyloTree(Vector<PhyloTreeEdge> vector, Vector<String> vector2) {
        this.edges = vector;
        this.leaf2NumMap = vector2;
    }

    public PhyloTree(PhyloTree phyloTree) {
        this.edges = Tools.myVectorClonePhyloTreeEdge(phyloTree.edges);
        this.leaf2NumMap = Tools.myVectorCloneString(phyloTree.leaf2NumMap);
        if (phyloTree.leafEdgeAttribs != null) {
            this.leafEdgeAttribs = Arrays.copyOf(phyloTree.leafEdgeAttribs, phyloTree.leafEdgeAttribs.length);
        }
        if (phyloTree.newick != null) {
            this.newick = new String(phyloTree.newick);
        }
    }

    private void setLeaf2NumMapFromNewick() {
        int n = 0;
        while (n < this.newick.length()) {
            if ((this.newick.charAt(n) == '(' || this.newick.charAt(n) == ',') && this.newick.charAt(n + 1) != '(') {
                this.leaf2NumMap.add(this.newick.substring(n + 1, this.newick.substring(n).indexOf(":") + n));
                n = PhyloTree.nextIndex(this.newick, n, ",)");
                continue;
            }
            ++n;
        }
        Collections.sort(this.leaf2NumMap);
    }

    public PhyloTree(String string, boolean bl) throws StringIndexOutOfBoundsException {
        int n;
        int n2 = 0;
        LinkedList<PhyloTreeEdge> linkedList = new LinkedList<PhyloTreeEdge>();
        this.edges = new Vector();
        this.leaf2NumMap = new Vector();
        int n3 = 0;
        this.newick = string = string.substring(string.indexOf(40));
        if (string.charAt(string.length() - 1) == ';') {
            string = string.substring(0, string.length() - 1);
        }
        string = string.substring(string.indexOf(40) + 1);
        string = string.substring(0, string.lastIndexOf(41));
        int n4 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '(') {
                ++n4;
            } else if (string.charAt(n) == ')') {
                --n4;
            }
            if (n4 >= 0) continue;
            System.err.println("Error reading in tree:  bracket problem in Newick string " + this.newick);
            throw new RuntimeException();
        }
        if (n4 != 0) {
            System.err.println("Error reading in tree: uneven number of brackets in Newick string " + this.newick);
            throw new RuntimeException();
        }
        try {
            this.setLeaf2NumMapFromNewick();
            this.leafEdgeAttribs = new EdgeAttribute[this.leaf2NumMap.size()];
            n = 0;
            block8: while (n < string.length() && n > -1) {
                switch (string.charAt(n)) {
                    case '(': {
                        linkedList.addFirst(new PhyloTreeEdge());
                        ++n;
                        continue block8;
                    }
                    case ')': {
                        ((PhyloTreeEdge)linkedList.peek()).setAttribute(new EdgeAttribute(string.substring(n + 2, PhyloTree.nextIndex(string, n, ",)"))));
                        this.edges.add((PhyloTreeEdge)linkedList.poll());
                        n = PhyloTree.nextIndex(string, n, ",)");
                        continue block8;
                    }
                    case ',': {
                        ++n;
                        continue block8;
                    }
                }
                n2 = this.leaf2NumMap.indexOf(string.substring(n, string.substring(n).indexOf(":") + n));
                n3 = string.substring(n + 1).indexOf(44) > -1 && string.substring(n + 1).indexOf(41) > -1 ? Math.min(string.substring(n + 1).indexOf(44), string.substring(n + 1).indexOf(41)) + n + 1 : (string.substring(n + 1).indexOf(41) > -1 ? string.substring(n + 1).indexOf(41) + n + 1 : (string.substring(n + 1).indexOf(44) > -1 ? string.substring(n + 1).indexOf(44) + n + 1 : string.length()));
                this.leafEdgeAttribs[n2] = new EdgeAttribute(string.substring(string.substring(n + 1).indexOf(58) + n + 2, n3));
                for (PhyloTreeEdge phyloTreeEdge : linkedList) {
                    phyloTreeEdge.addOne(n2);
                }
                n = PhyloTree.nextIndex(string, n, ",)");
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Error reading in tree:  invalid Newick string: (" + string + ");");
            throw stringIndexOutOfBoundsException;
        }
        if (!bl) {
            for (PhyloTreeEdge phyloTreeEdge : this.edges) {
                int n5;
                if (!phyloTreeEdge.contains(n5 = this.leaf2NumMap.size() - 1)) continue;
                phyloTreeEdge.complement(n5 + 1);
            }
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            this.edges.get(i).setOriginalEdge(this.edges.get(i).asSplit());
            this.edges.get(i).setOriginalID(i);
        }
    }

    public Vector<PhyloTreeEdge> getEdges() {
        return this.edges;
    }

    public PhyloTreeEdge getEdge(int n) {
        return this.edges.get(n);
    }

    public void setEdges(Vector<PhyloTreeEdge> vector) {
        this.edges = vector;
    }

    public Vector<String> getLeaf2NumMap() {
        return this.leaf2NumMap;
    }

    public EdgeAttribute getAttribOfSplit(Bipartition bipartition) {
        for (PhyloTreeEdge phyloTreeEdge : this.edges) {
            if (!phyloTreeEdge.sameBipartition(bipartition)) continue;
            return phyloTreeEdge.getAttribute();
        }
        return null;
    }

    public Vector<Bipartition> getSplits() {
        Vector<Bipartition> vector = new Vector<Bipartition>();
        for (int i = 0; i < this.edges.size(); ++i) {
            vector.add(this.getEdge(i).asSplit());
        }
        return vector;
    }

    public void normalize() {
        double d = this.getDistanceFromOrigin();
        this.normalize(d);
    }

    private void normalize(double d) {
        int n;
        for (n = 0; n < this.leafEdgeAttribs.length; ++n) {
            this.leafEdgeAttribs[n].scaleBy(1.0 / d);
        }
        for (n = 0; n < this.edges.size(); ++n) {
            this.edges.get(n).getAttribute().scaleBy(1.0 / d);
        }
    }

    public void normalize(PhyloTree phyloTree) {
        double d = this.getDistanceFromOrigin() + phyloTree.getDistanceFromOrigin();
        this.normalize(d);
        phyloTree.normalize(d);
    }

    public int numLeaves() {
        return this.leaf2NumMap.size();
    }

    public void setLeaf2NumMap(Vector<String> vector) {
        this.leaf2NumMap = vector;
    }

    public double getDistanceFromOrigin() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.edges.size(); ++n) {
            d += Math.pow(this.edges.get(n).getLength(), 2.0);
        }
        for (n = 0; n < this.leafEdgeAttribs.length; ++n) {
            d += Math.pow(this.leafEdgeAttribs[n].norm(), 2.0);
        }
        return Math.sqrt(d);
    }

    public double getDistanceFromOriginNoLeaves() {
        double d = 0.0;
        for (int i = 0; i < this.edges.size(); ++i) {
            d += Math.pow(this.edges.get(i).getLength(), 2.0);
        }
        return Math.sqrt(d);
    }

    public double getBranchLengthSum() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.edges.size(); ++n) {
            d += this.edges.get(n).getLength();
        }
        for (n = 0; n < this.leafEdgeAttribs.length; ++n) {
            d += this.leafEdgeAttribs[n].norm();
        }
        return d;
    }

    public static Vector<PhyloTreeEdge> getCommonEdges(PhyloTree phyloTree, PhyloTree phyloTree2) {
        EdgeAttribute edgeAttribute;
        Vector<PhyloTreeEdge> vector = new Vector<PhyloTreeEdge>();
        if (!phyloTree.getLeaf2NumMap().equals(phyloTree2.getLeaf2NumMap())) {
            System.out.println("Error: the two trees do not have the same leaves!");
            System.out.println("First tree's leaves are " + phyloTree.getLeaf2NumMap());
            System.out.println("Second tree's leaves are " + phyloTree2.getLeaf2NumMap());
            throw new RuntimeException();
        }
        for (PhyloTreeEdge phyloTreeEdge : phyloTree.edges) {
            if (phyloTreeEdge.isZero()) continue;
            if (phyloTree2.getSplits().contains(phyloTreeEdge.asSplit())) {
                edgeAttribute = EdgeAttribute.difference(phyloTreeEdge.getAttribute(), phyloTree2.getAttribOfSplit(phyloTreeEdge.asSplit()));
                vector.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
                continue;
            }
            if (!phyloTreeEdge.isCompatibleWith(phyloTree2.getSplits())) continue;
            edgeAttribute = EdgeAttribute.difference(phyloTreeEdge.getAttribute(), null);
            vector.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
        }
        for (PhyloTreeEdge phyloTreeEdge : phyloTree2.getEdges()) {
            if (phyloTreeEdge.isZero() || !phyloTreeEdge.isCompatibleWith(phyloTree.getSplits()) || phyloTree.getSplits().contains(phyloTreeEdge.asSplit())) continue;
            edgeAttribute = EdgeAttribute.difference(null, phyloTreeEdge.getAttribute());
            vector.add(new PhyloTreeEdge(phyloTreeEdge.asSplit(), edgeAttribute, phyloTreeEdge.getOriginalID()));
        }
        return vector;
    }

    public Vector<PhyloTreeEdge> getEdgesNotInCommonWith(PhyloTree phyloTree) {
        Vector<PhyloTreeEdge> vector = new Vector<PhyloTreeEdge>();
        if (!this.getLeaf2NumMap().equals(phyloTree.getLeaf2NumMap())) {
            System.out.println("Error: the two trees do not have the same leaves!");
            System.out.println("First tree's leaves are " + this.getLeaf2NumMap());
            System.out.println("Second tree's leaves are " + phyloTree.getLeaf2NumMap());
            throw new RuntimeException();
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Boolean bl = false;
            for (int j = 0; j < phyloTree.edges.size(); ++j) {
                if (this.getEdge(i).isZero() || phyloTree.getEdge(j).isZero() || !this.getEdge(i).sameBipartition(phyloTree.getEdge(j))) continue;
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            vector.add(this.getEdge(i).clone());
        }
        return vector;
    }

    public void permuteLeaves() {
        int n;
        Vector<PhyloTreeEdge> vector = this.edges;
        int n2 = vector.size();
        int n3 = n2 + 2;
        Vector<PhyloTreeEdge> vector2 = new Vector<PhyloTreeEdge>();
        Random random = new Random();
        for (int i = 0; i < n2; ++i) {
            vector2.add(new PhyloTreeEdge(vector.get(i).getAttribute()));
            ((PhyloTreeEdge)vector2.get(i)).setOriginalEdge(vector2.get(i).asSplit());
        }
        Vector<Integer> vector3 = new Vector<Integer>();
        for (n = 0; n < n3; ++n) {
            vector3.add(new Integer(n));
        }
        for (n = n3; n > 0; --n) {
            int n4 = (Integer)vector3.remove(random.nextInt(n));
            for (int i = 0; i < n2; ++i) {
                if (!vector.get(i).getPartition().get(n4)) continue;
                vector2.get(i).getPartition().set(n - 1);
            }
        }
        this.edges = TreeDistance.myVectorClonePhyloTreeEdge(vector2);
    }

    public void permuteLeaves(int[] nArray) {
        int n;
        Vector<PhyloTreeEdge> vector = this.edges;
        int n2 = vector.size();
        Vector<PhyloTreeEdge> vector2 = new Vector<PhyloTreeEdge>();
        for (n = 0; n < n2; ++n) {
            vector2.add(new PhyloTreeEdge(vector.get(n).getAttribute(), vector.get(n).getOriginalID()));
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                if (!vector.get(n).getPartition().get(i)) continue;
                vector2.get(n).getPartition().set(nArray[i]);
            }
        }
        this.edges = TreeDistance.myVectorClonePhyloTreeEdge(vector2);
    }

    public void swapleaves(int n, int n2) {
        Vector<PhyloTreeEdge> vector = this.edges;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            boolean bl = vector.get(i).getPartition().get(n);
            if (vector.get(i).getPartition().get(n2)) {
                vector.get(i).getPartition().set(n);
            } else {
                vector.get(i).getPartition().clear(n);
            }
            if (bl) {
                vector.get(i).getPartition().set(n2);
                continue;
            }
            vector.get(i).getPartition().clear(n2);
        }
    }

    public boolean removeSplit(Bipartition bipartition) {
        boolean bl = false;
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!this.edges.get(i).sameBipartition(bipartition)) continue;
            this.edges.remove(i);
            bl = true;
            break;
        }
        return bl;
    }

    public void removeSplits(Vector<Bipartition> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.removeSplit(vector.get(i));
        }
    }

    public void removeEdgesIndicatedByOnes(Bipartition bipartition) {
        int n = 0;
        for (int i = 0; i < this.leaf2NumMap.size() - 2; ++i) {
            if (!bipartition.contains(i)) continue;
            this.edges.remove(i - n);
            ++n;
        }
    }

    public void addEdge(PhyloTreeEdge phyloTreeEdge) {
        this.edges.add(phyloTreeEdge);
    }

    public static int nextIndex(String string, int n, String string2) {
        int n2 = string.length();
        int n3 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            n3 = string.substring(n + 1).indexOf(string2.charAt(i));
            if (n3 == -1 || n3 + n + 1 >= n2) continue;
            n2 = n3 + n + 1;
        }
        return n2;
    }

    public Vector<Bipartition> getCrossingsWith(PhyloTree phyloTree) {
        if (!this.getLeaf2NumMap().equals(phyloTree.getLeaf2NumMap())) {
            return null;
        }
        Vector<Bipartition> vector = new Vector<Bipartition>();
        for (int i = 0; i < this.edges.size(); ++i) {
            PhyloTreeEdge phyloTreeEdge = this.edges.get(i);
            Bipartition bipartition = new Bipartition();
            for (int j = 0; j < phyloTree.edges.size(); ++j) {
                PhyloTreeEdge phyloTreeEdge2 = phyloTree.edges.get(j);
                if (!phyloTreeEdge2.crosses(phyloTreeEdge)) continue;
                bipartition.addOne(j);
            }
            vector.add(bipartition.clone());
        }
        return vector;
    }

    public String toString() {
        return "Leaves: " + this.leaf2NumMap + "; edges: " + this.edges + "; leaf edges: " + Arrays.toString(this.leafEdgeAttribs);
    }

    public PhyloTree clone() {
        return new PhyloTree(TreeDistance.myVectorClonePhyloTreeEdge(this.edges), TreeDistance.myVectorCloneString(this.leaf2NumMap), (EdgeAttribute[])this.leafEdgeAttribs.clone());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof PhyloTree)) {
            return false;
        }
        return this.leaf2NumMap.equals(((PhyloTree)object).leaf2NumMap) && Arrays.equals(this.leafEdgeAttribs, ((PhyloTree)object).leafEdgeAttribs) && this.edges.containsAll(((PhyloTree)object).edges) && ((PhyloTree)object).edges.containsAll(this.edges);
    }

    public boolean approxEquals(PhyloTree phyloTree, Double d) throws IOException {
        if (this == null || phyloTree == null) {
            return false;
        }
        return PolyMain.getGeodesic(this, phyloTree, null).getDist() < d;
    }

    public static void main(String[] stringArray) {
        PhyloTree phyloTree = new PhyloTree("((A:0.1,B:0.2):1,(C:0.3,D:0.4):2)", true);
        System.out.println("Edges of tree 1 (length, followed by leaves as 1's): " + phyloTree.getEdges().toString());
        PhyloTree phyloTree2 = new PhyloTree("(((B:0.1,A:0.2):1,C:0.3):2,(D:0.4,E:0.5):3)", true);
        System.out.println("Edges of tree 2: " + phyloTree2.getEdges().toString());
        PhyloTree phyloTree3 = new PhyloTree("((A:0.1,B:0.2):1,(C:0.3,(D:0.4,E:0.5):2):3)", true);
        System.out.println("Edges of tree 3: " + phyloTree3.getEdges().toString());
        System.out.println("common edges of t2 and t3: " + PhyloTree.getCommonEdges(phyloTree2, phyloTree3));
        PhyloTree phyloTree4 = new PhyloTree("((A:0,C:0):1,(D:0,(B:0,E:0):2):3)", true);
        System.out.println("Edges of tree 4:" + phyloTree4.getEdges().toString());
        System.out.println("1s indicate edges in tree 4 crossed by that split in tree2: " + phyloTree2.getCrossingsWith(phyloTree4));
        System.out.println("1s indicate edges in tree 1 crossed by that split in tree 4: " + phyloTree.getCrossingsWith(phyloTree4));
        PhyloTree phyloTree5 = new PhyloTree("(((A:0,B:0):1,(C:0,D:0):2):3,E:0)", true);
        System.out.println("Edges of tree TriTop: " + phyloTree5.getEdges());
        PhyloTree phyloTree6 = new PhyloTree("(((D:0,E:0):1,(C:0,B:0):2):3,A:0)", true);
        System.out.println("1s indicate edgdes in tree triBot crossed by that split in tree triTop:" + phyloTree6.getCrossingsWith(phyloTree5));
        PhyloTree phyloTree7 = new PhyloTree("(((A:0,C:0):1,E:0):2,(B:0,D:0):3)", true);
        System.out.println("Edges of tree noCommonSortingWithTriTop: " + phyloTree7.getEdges());
        System.out.println("1s indicate edges in tree triTop crossed by that split in tree noCommonSortingWithTriTop: " + phyloTree7.getCrossingsWith(phyloTree5));
    }

    public EdgeAttribute[] getLeafEdgeAttribs() {
        return this.leafEdgeAttribs;
    }

    public EdgeAttribute[] getCopyLeafEdgeAttribs() {
        if (this.leafEdgeAttribs == null) {
            return null;
        }
        EdgeAttribute[] edgeAttributeArray = new EdgeAttribute[this.leafEdgeAttribs.length];
        for (int i = 0; i < this.leafEdgeAttribs.length; ++i) {
            edgeAttributeArray[i] = this.leafEdgeAttribs[i].clone();
        }
        return edgeAttributeArray;
    }

    public double[] getIntEdgeAttribNorms() {
        double[] dArray = new double[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            dArray[i] = this.edges.get(i).getAttribute().norm();
        }
        return dArray;
    }

    public void setLeafEdgeAttribs(EdgeAttribute[] edgeAttributeArray) {
        this.leafEdgeAttribs = edgeAttributeArray;
    }

    public String getNewick(boolean bl) {
        int n;
        String string;
        Cloneable cloneable;
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        Vector<PhyloTreeEdge> vector2 = new Vector<PhyloTreeEdge>();
        if (this.edges.size() == 0) {
            string2 = "(";
            for (int i = 0; i < this.leaf2NumMap.size(); ++i) {
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + this.leaf2NumMap.get(i);
                if (!bl) continue;
                string2 = string2 + ":" + this.leafEdgeAttribs[i];
            }
            string2 = string2 + ");";
            return string2;
        }
        Vector<PhyloTreeEdge> vector3 = TreeDistance.myVectorClonePhyloTreeEdge(this.edges);
        while (vector3.size() > 0) {
            cloneable = vector3.get(0);
            for (int i = 1; i < vector3.size(); ++i) {
                if (!((Bipartition)cloneable).contains(vector3.get(i))) continue;
                cloneable = vector3.get(i);
            }
            vector3.remove(cloneable);
            vector2.add(0, ((PhyloTreeEdge)cloneable).clone());
            vector.add(0, "");
            string = "(";
            n = 1;
            while (n < vector2.size()) {
                if (((Bipartition)cloneable).contains((Bipartition)vector2.get(n))) {
                    string = string + (String)vector.get(n) + ",";
                    ((Bipartition)cloneable).getPartition().andNot(((PhyloTreeEdge)vector2.get(n)).getPartition());
                    vector.remove(n);
                    vector2.remove(n);
                    continue;
                }
                ++n;
            }
            if (!((Bipartition)cloneable).getPartition().isEmpty()) {
                for (int i = 0; i < ((Bipartition)cloneable).getPartition().length(); ++i) {
                    if (!((Bipartition)cloneable).getPartition().get(i)) continue;
                    string = string + this.leaf2NumMap.get(i);
                    if (bl) {
                        string = string + ":" + this.leafEdgeAttribs[i];
                    }
                    string = string + ",";
                }
            }
            string = string.substring(0, string.length() - 1) + ")";
            if (bl) {
                string = string + ":" + ((PhyloTreeEdge)cloneable).getAttribute();
            }
            vector.set(0, new String(string));
        }
        cloneable = new BitSet();
        ((BitSet)cloneable).set(0, this.leaf2NumMap.size(), true);
        string = "(";
        for (n = 0; n < vector2.size(); ++n) {
            string = string + (String)vector.get(n) + ",";
            ((BitSet)cloneable).andNot(((PhyloTreeEdge)vector2.get(n)).getPartition());
        }
        if (!((BitSet)cloneable).isEmpty()) {
            for (n = 0; n < ((BitSet)cloneable).length(); ++n) {
                if (!((BitSet)cloneable).get(n)) continue;
                string = string + this.leaf2NumMap.get(n);
                if (bl) {
                    string = string + ":" + this.leafEdgeAttribs[n];
                }
                string = string + ",";
            }
        }
        string = string.substring(0, string.length() - 1) + ");";
        return string;
    }

    public void setNewick(String string) {
        this.newick = string;
    }

    public int numEdges() {
        return this.edges.size();
    }

    public PhyloTree projectToGeo(PhyloTree phyloTree, PhyloTree phyloTree2, double d) throws IOException {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.5;
        if (PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, 0.0), null).getDist() < PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d), null).getDist()) {
            return Geodesic.getTreeAt(phyloTree, phyloTree2, 0.0);
        }
        if (PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, 1.0), null).getDist() < PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, 1.0 - d), null).getDist()) {
            return Geodesic.getTreeAt(phyloTree, phyloTree2, 1.0);
        }
        while (d2 - d3 > d) {
            double d5;
            double d6 = PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d2), null).getDist();
            double d7 = PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d3), null).getDist();
            if (d7 < (d5 = PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d4), null).getDist()) && d5 < d6) {
                d2 = d4;
                d4 = (d2 - d3) / 2.0 + d3;
                continue;
            }
            if (d7 > d5 && d5 > d6) {
                d3 = d4;
                d4 = (d2 - d3) / 2.0 + d3;
                continue;
            }
            if (d5 < d6 && d6 < d7 || d5 < d7 && d7 < d6) {
                double d8;
                double d9;
                if (d2 - d4 < d4 - d3) {
                    d9 = (d4 - d3) / 2.0 + d3;
                    d8 = PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d9), null).getDist();
                    if (d8 > d5) {
                        d3 = d9;
                        continue;
                    }
                    d2 = d4;
                    d4 = d9;
                    continue;
                }
                d9 = (d2 - d4) / 2.0 + d4;
                d8 = PolyMain.getGeodesic(this, Geodesic.getTreeAt(phyloTree, phyloTree2, d9), null).getDist();
                if (d5 < d8) {
                    d2 = d9;
                    continue;
                }
                d3 = d4;
                d4 = d9;
                continue;
            }
            System.err.println("Error projecting tree onto geodesic: illegal ordering in line search");
            throw new RuntimeException();
        }
        d4 = (d2 - d3) / 2.0 + d3;
        return Geodesic.getTreeAt(phyloTree, phyloTree2, d4);
    }
}

