/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Bipartition;
import distanceAlg1.EdgeAttribute;
import java.util.BitSet;
import java.util.Vector;

public class PhyloTreeEdge
extends Bipartition {
    private EdgeAttribute attribute;
    private Bipartition originalEdge;
    private int originalID;

    public PhyloTreeEdge() {
        this.originalEdge = new Bipartition();
        this.originalID = -1;
    }

    public PhyloTreeEdge(BitSet bitSet) {
        super(bitSet);
        this.originalEdge = new Bipartition();
        this.originalID = -1;
    }

    public PhyloTreeEdge(EdgeAttribute edgeAttribute) {
        this.attribute = edgeAttribute;
        this.originalEdge = new Bipartition();
        this.originalID = -1;
    }

    public PhyloTreeEdge(EdgeAttribute edgeAttribute, int n) {
        this.attribute = edgeAttribute;
        this.originalEdge = new Bipartition();
        this.originalID = n;
    }

    public PhyloTreeEdge(EdgeAttribute edgeAttribute, Bipartition bipartition, int n) {
        this.attribute = edgeAttribute;
        this.originalEdge = new Bipartition(bipartition.partition);
        this.originalID = n;
    }

    public PhyloTreeEdge(Bipartition bipartition, EdgeAttribute edgeAttribute, int n) {
        super(bipartition.partition);
        this.attribute = edgeAttribute;
        this.originalEdge = new Bipartition(bipartition.partition);
        this.originalID = n;
    }

    public PhyloTreeEdge(BitSet bitSet, EdgeAttribute edgeAttribute, BitSet bitSet2, int n) {
        super(bitSet);
        this.attribute = edgeAttribute;
        this.originalEdge = new Bipartition(bitSet2);
        this.originalID = n;
    }

    public double getLength() {
        return this.attribute.norm();
    }

    public boolean isZero() {
        return this.getLength() == 0.0;
    }

    @Override
    public String toString() {
        return "" + this.attribute + " " + this.partition;
    }

    public String toStringVerbose(Vector<String> vector) {
        return "" + this.originalID + "\t\t" + this.attribute + "\t\t" + Bipartition.toStringVerbose(this.partition, vector);
    }

    public static String printEdgesVerbose(Vector<PhyloTreeEdge> vector, Vector<String> vector2, Boolean bl) {
        String string = "";
        System.out.println("Edge ID\t\tLength\t\tLeaves Below");
        string = string + "Edge ID\t\tLength\t\tLeaves Below\n";
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i).getOriginalEdge().getPartition() != null && bl.booleanValue()) {
                System.out.println(vector.get(i).getOriginalID() + "\t\t" + vector.get((int)i).attribute + "\t\t" + Bipartition.toStringVerbose(vector.get(i).getOriginalEdge().getPartition(), vector2));
                string = string + vector.get(i).getOriginalID() + "\t\t" + vector.get((int)i).attribute + "\t\t" + Bipartition.toStringVerbose(vector.get(i).getOriginalEdge().getPartition(), vector2) + "\n";
                continue;
            }
            System.out.println(vector.get(i).toStringVerbose(vector2));
            string = string + vector.get(i).toStringVerbose(vector2) + "\n";
        }
        return string;
    }

    @Override
    public PhyloTreeEdge clone() {
        return new PhyloTreeEdge((BitSet)this.partition.clone(), this.attribute.clone(), (BitSet)this.originalEdge.getPartition().clone(), this.originalID);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof PhyloTreeEdge)) {
            return false;
        }
        return this.partition.equals(((Bipartition)object).partition) && this.attribute.equals(((PhyloTreeEdge)object).attribute);
    }

    public boolean sameBipartition(PhyloTreeEdge phyloTreeEdge) {
        return this.partition.equals(phyloTreeEdge.partition);
    }

    public boolean sameBipartition(Bipartition bipartition) {
        return this.partition.equals(bipartition.partition);
    }

    public Bipartition asSplit() {
        return new Bipartition((BitSet)this.partition.clone());
    }

    public Bipartition getOriginalEdge() {
        return this.originalEdge;
    }

    public void setOriginalEdge(Bipartition bipartition) {
        this.originalEdge = bipartition;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public void setOriginalID(int n) {
        this.originalID = n;
    }

    public void setAttribute(EdgeAttribute edgeAttribute) {
        this.attribute = edgeAttribute;
    }

    public EdgeAttribute getAttribute() {
        return this.attribute;
    }
}

