/*
 * Decompiled with CFR 0.152.
 */
package distanceAlg1;

import distanceAlg1.Bipartition;
import distanceAlg1.PhyloTreeEdge;
import distanceAlg1.TreeDistance;
import java.text.DecimalFormat;
import java.util.Vector;
import polyAlg.Tools;

public class Ratio {
    private double eLength;
    private double fLength;
    private Vector<PhyloTreeEdge> eEdges;
    private Vector<PhyloTreeEdge> fEdges;

    public Ratio() {
        this.eLength = 0.0;
        this.fLength = 0.0;
        this.eEdges = new Vector();
        this.fEdges = new Vector();
    }

    public Ratio(Vector<PhyloTreeEdge> vector, Vector<PhyloTreeEdge> vector2) {
        this.eLength = Ratio.geoAvg(vector);
        this.fLength = Ratio.geoAvg(vector2);
        this.eEdges = vector;
        this.fEdges = vector2;
    }

    public Ratio(double d, double d2) {
        this.eLength = d;
        this.fLength = d2;
        this.eEdges = new Vector();
        this.fEdges = new Vector();
    }

    public Vector<PhyloTreeEdge> getEEdges() {
        return this.eEdges;
    }

    public void addEEdge(PhyloTreeEdge phyloTreeEdge) {
        this.eEdges.add(phyloTreeEdge);
        this.eLength = Ratio.geoAvg(this.eLength, phyloTreeEdge.getLength());
    }

    public void addAllEEdges(Vector<PhyloTreeEdge> vector) {
        this.eEdges.addAll(vector);
        this.eLength = Ratio.geoAvg(this.eEdges);
    }

    public double getELength() {
        return Ratio.geoAvg(this.eEdges);
    }

    public void setELength(double d) {
        if (this.eEdges.size() == 0) {
            this.eLength = d;
        }
    }

    public void setFLength(double d) {
        if (this.fEdges.size() == 0) {
            this.fLength = d;
        }
    }

    public Vector<PhyloTreeEdge> getFEdges() {
        return this.fEdges;
    }

    public void addFEdge(PhyloTreeEdge phyloTreeEdge) {
        this.fEdges.add(phyloTreeEdge);
        this.fLength = Ratio.geoAvg(this.fLength, phyloTreeEdge.getLength());
    }

    public void addAllFEdges(Vector<PhyloTreeEdge> vector) {
        this.fEdges.addAll(vector);
        this.fLength = Ratio.geoAvg(this.fEdges);
    }

    public double getFLength() {
        return Ratio.geoAvg(this.fEdges);
    }

    public double getRatio() {
        return this.eLength / this.fLength;
    }

    public double getTime() {
        return this.eLength / (this.eLength + this.fLength);
    }

    public static Ratio combine(Ratio ratio, Ratio ratio2) {
        Ratio ratio3 = new Ratio();
        if (ratio.eEdges.size() == 0 && ratio2.eEdges.size() == 0) {
            ratio3.setELength(Ratio.geoAvg(ratio.eLength, ratio2.eLength));
        } else {
            ratio3.addAllEEdges(TreeDistance.myVectorClonePhyloTreeEdge(ratio.eEdges));
            ratio3.addAllEEdges(TreeDistance.myVectorClonePhyloTreeEdge(ratio2.eEdges));
        }
        if (ratio.fEdges.size() == 0 && ratio2.fEdges.size() == 0) {
            ratio3.setFLength(Ratio.geoAvg(ratio.fLength, ratio2.fLength));
        } else {
            ratio3.addAllFEdges(TreeDistance.myVectorClonePhyloTreeEdge(ratio.fEdges));
            ratio3.addAllFEdges(TreeDistance.myVectorClonePhyloTreeEdge(ratio2.fEdges));
        }
        return ratio3;
    }

    public static double geoAvg(double d, double d2) {
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
    }

    public static double geoAvg(Vector<PhyloTreeEdge> vector) {
        double d = 0.0;
        for (PhyloTreeEdge phyloTreeEdge : vector) {
            d += Math.pow(phyloTreeEdge.getLength(), 2.0);
        }
        return Math.sqrt(d);
    }

    public Ratio reverse() {
        Ratio ratio = new Ratio();
        ratio.addAllEEdges(this.fEdges);
        ratio.addAllFEdges(this.eEdges);
        return ratio;
    }

    public Boolean containsOriginalEEdge(Bipartition bipartition) {
        PhyloTreeEdge phyloTreeEdge;
        int n;
        for (n = 0; n < this.eEdges.size(); ++n) {
            phyloTreeEdge = this.eEdges.get(n);
            if (!phyloTreeEdge.getOriginalEdge().equals(bipartition)) continue;
            return true;
        }
        for (n = 0; n < this.fEdges.size(); ++n) {
            phyloTreeEdge = this.fEdges.get(n);
            if (!phyloTreeEdge.getOriginalEdge().equals(bipartition)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("#0.####");
        return this.eEdges.toString() + " " + decimalFormat.format(this.eLength) + "/" + decimalFormat.format(this.fLength) + " " + this.fEdges.toString();
    }

    public String toStringCombTypeAndValue() {
        int n;
        DecimalFormat decimalFormat = new DecimalFormat("#0.###");
        String string = "{";
        for (n = 0; n < this.eEdges.size(); ++n) {
            string = string + this.eEdges.get(n).getOriginalID();
            if (n >= this.eEdges.size() - 1) continue;
            string = string + ",";
        }
        string = string + "}/{";
        for (n = 0; n < this.fEdges.size(); ++n) {
            string = string + this.fEdges.get(n).getOriginalID();
            if (n >= this.fEdges.size() - 1) continue;
            string = string + ",";
        }
        string = string + "} " + decimalFormat.format(this.eLength) + "/" + decimalFormat.format(this.fLength) + "=" + decimalFormat.format(this.getRatio());
        return string;
    }

    public String toStringCombType() {
        int n;
        String string = "{";
        for (n = 0; n < this.eEdges.size(); ++n) {
            string = string + this.eEdges.get(n).getOriginalID();
            if (n >= this.eEdges.size() - 1) continue;
            string = string + ",";
        }
        string = string + "}/{";
        for (n = 0; n < this.fEdges.size(); ++n) {
            string = string + this.fEdges.get(n).getOriginalID();
            if (n >= this.fEdges.size() - 1) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    public String toStringJustValue() {
        return "" + this.getRatio();
    }

    public String toStringVerbose(Vector<String> vector) {
        int n;
        DecimalFormat decimalFormat = new DecimalFormat("#0.########");
        String string = "" + decimalFormat.format(this.getRatio()) + "\nTotal length and corresponding edges dropped:\n";
        string = string + decimalFormat.format(this.eLength) + "\t";
        for (n = 0; n < this.eEdges.size(); ++n) {
            string = n == 0 ? string + Bipartition.toStringVerbose(this.eEdges.get(n).getPartition(), vector) + "\n" : string + "\t\t" + Bipartition.toStringVerbose(this.eEdges.get(n).getPartition(), vector) + "\n";
        }
        string = string + "\nTotal length and corresponding edges added:\n";
        string = string + decimalFormat.format(this.fLength) + "\t";
        for (n = 0; n < this.fEdges.size(); ++n) {
            string = n == 0 ? string + Bipartition.toStringVerbose(this.fEdges.get(n).getPartition(), vector) + "\n" : string + "\t\t" + Bipartition.toStringVerbose(this.fEdges.get(n).getPartition(), vector) + "\n";
        }
        return string;
    }

    public Ratio clone() {
        Ratio ratio = new Ratio();
        if (this.eEdges.size() == 0) {
            ratio.eLength = this.eLength;
        } else {
            ratio.addAllEEdges(Tools.myVectorClonePhyloTreeEdge(this.eEdges));
        }
        if (this.fEdges.size() == 0) {
            ratio.fLength = this.fLength;
        } else {
            ratio.addAllFEdges(Tools.myVectorClonePhyloTreeEdge(this.fEdges));
        }
        return ratio;
    }
}

