/*
 * Decompiled with CFR 0.152.
 */
package polyAlg;

import java.lang.reflect.Array;
import polyAlg.Vertex;

public class BipartiteGraph {
    private boolean[][] edge;
    private int nA;
    private int nB;
    private int n;
    private int i;
    private int j;
    private Vertex[] Avertex;
    private Vertex[] Bvertex;
    private boolean debug = false;

    public BipartiteGraph(boolean[][] blArray, double[] dArray, double[] dArray2) {
        this.nA = Array.getLength(dArray);
        this.nB = Array.getLength(dArray2);
        this.n = Math.max(this.nA, this.nB);
        this.edge = blArray;
        this.Avertex = new Vertex[this.n];
        this.Bvertex = new Vertex[this.n];
        this.i = 0;
        while (this.i <= this.nA - 1) {
            this.Avertex[this.i] = new Vertex(dArray[this.i]);
            ++this.i;
        }
        this.j = 0;
        while (this.j <= this.nB - 1) {
            this.Bvertex[this.j] = new Vertex(dArray2[this.j]);
            ++this.j;
        }
        if (this.debug) {
            System.out.format("Size of Bipartite Graph = A-side: %d, B-side: %d\n", this.nA, this.nB);
            System.out.format("Data passed out of vertex_cover will be int [4][%d]\n\n", this.n);
            System.out.format("A (squared) weights:", new Object[0]);
            this.i = 0;
            while (this.i <= this.nA - 1) {
                System.out.format(" %3.2f", this.Avertex[this.i].weight);
                ++this.i;
            }
            System.out.format("\nB (squared) weights:", new Object[0]);
            this.j = 0;
            while (this.j <= this.nB - 1) {
                System.out.format(" %3.2f", this.Bvertex[this.j].weight);
                ++this.j;
            }
            System.out.format("\n\n", new Object[0]);
            System.out.format("bipartite graph incidence matrix =\n", new Object[0]);
            this.i = 0;
            while (this.i <= this.nA - 1) {
                this.j = 0;
                while (this.j <= this.nB - 1) {
                    System.out.format("%5s ", this.edge[this.i][this.j]);
                    ++this.j;
                }
                System.out.format("\n", new Object[0]);
                ++this.i;
            }
            System.out.format("\n", new Object[0]);
        }
    }

    public static void main(String[] stringArray) {
        boolean[][] blArrayArray = new boolean[][]{{false, true, false, false}, {true, false, true, true}, {false, true, false, false}, {false, true, true, true}, {false, true, false, true}};
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[] dArray2 = new double[]{1.0, 1.0, 1.0, 1.0};
        int[] nArray = new int[]{0, 1, 2, 3};
        int[] nArray2 = new int[]{0, 1, 2, 3};
        BipartiteGraph bipartiteGraph = new BipartiteGraph(blArrayArray, dArray, dArray2);
        int[][] nArray3 = bipartiteGraph.vertex_cover(nArray, nArray2);
        System.out.format("Vertex Cover = A-side: ", new Object[0]);
        System.out.format("", new Object[0]);
        for (int i = 0; i <= nArray3[0][0] - 1; ++i) {
            System.out.format(" %d", nArray3[2][i]);
        }
        System.out.format("\n               B-side: ", new Object[0]);
        for (int i = 0; i <= nArray3[1][0] - 1; ++i) {
            System.out.format(" %d", nArray3[3][i]);
        }
        System.out.format("\n", new Object[0]);
    }

    public int[][] vertex_cover(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = Array.getLength(nArray);
        int n4 = Array.getLength(nArray2);
        double[][] dArray = new double[this.nA][this.nB];
        int n5 = -1;
        int[][] nArray3 = new int[4][this.n];
        int[] nArray4 = new int[this.nA];
        int[] nArray5 = new int[this.nB];
        if (this.debug) {
            System.out.format("A indices = ", new Object[0]);
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                System.out.format("%3d ", nArray[n2]);
            }
            System.out.format("\n", new Object[0]);
            System.out.format("B indices = ", new Object[0]);
            for (n = 0; n <= n4 - 1; ++n) {
                System.out.format("%3d ", nArray2[n]);
            }
            System.out.format("\n\n", new Object[0]);
        }
        double d = 0.0;
        for (n2 = 0; n2 <= n3 - 1; ++n2) {
            d += this.Avertex[nArray[n2]].weight;
        }
        for (n2 = 0; n2 <= n3 - 1; ++n2) {
            this.Avertex[nArray[n2]].residual = this.Avertex[nArray[n2]].weight / d;
        }
        d = 0.0;
        for (n = 0; n <= n4 - 1; ++n) {
            d += this.Bvertex[nArray2[n]].weight;
        }
        for (n = 0; n <= n4 - 1; ++n) {
            this.Bvertex[nArray2[n]].residual = this.Bvertex[nArray2[n]].weight / d;
        }
        if (this.debug) {
            System.out.format("normalized A weights = ", new Object[0]);
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                System.out.format("%3.2f ", this.Avertex[nArray[n2]].residual);
            }
            System.out.format("\n", new Object[0]);
            System.out.format("normalized B weights = ", new Object[0]);
            for (n = 0; n <= n4 - 1; ++n) {
                System.out.format("%3.2f ", this.Bvertex[nArray2[n]].residual);
            }
            System.out.format("\n\n", new Object[0]);
        }
        for (n2 = 0; n2 <= this.nA - 1; ++n2) {
            for (n = 0; n <= this.nB - 1; ++n) {
                dArray[n2][n] = 0.0;
            }
        }
        d = 1.0;
        while (d > 0.0) {
            d = 0.0;
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                this.Avertex[nArray[n2]].label = -1.0;
                this.Avertex[nArray[n2]].pred = -1;
            }
            for (n = 0; n <= n4 - 1; ++n) {
                this.Bvertex[nArray2[n]].label = -1.0;
                this.Bvertex[nArray2[n]].pred = -1;
            }
            int n6 = 0;
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                if (this.Avertex[nArray[n2]].residual > 0.0) {
                    this.Avertex[nArray[n2]].label = this.Avertex[nArray[n2]].residual;
                    nArray4[n6] = nArray[n2];
                    ++n6;
                    continue;
                }
                this.Avertex[nArray[n2]].label = -1.0;
            }
            for (n2 = 0; n2 <= n4 - 1; ++n2) {
                this.Bvertex[n2].label = -1.0;
            }
            block15: while (n6 != 0) {
                int n7 = 0;
                for (n2 = 0; n2 <= n6 - 1; ++n2) {
                    for (n = 0; n <= n4 - 1; ++n) {
                        if (!this.edge[nArray4[n2]][nArray2[n]] || this.Bvertex[nArray2[n]].label != -1.0) continue;
                        this.Bvertex[nArray2[n]].label = this.Avertex[nArray4[n2]].label;
                        this.Bvertex[nArray2[n]].pred = nArray4[n2];
                        nArray5[n7] = nArray2[n];
                        ++n7;
                    }
                }
                n6 = 0;
                for (n = 0; n <= n7 - 1; ++n) {
                    if (this.Bvertex[nArray5[n]].residual > 0.0) {
                        d = Math.min(this.Bvertex[nArray5[n]].residual, this.Bvertex[nArray5[n]].label);
                        n5 = nArray5[n];
                        break block15;
                    }
                    for (n2 = 0; n2 <= n3 - 1; ++n2) {
                        if (!this.edge[nArray[n2]][nArray5[n]] || this.Avertex[nArray[n2]].label != -1.0 || !(dArray[nArray[n2]][nArray5[n]] > 0.0)) continue;
                        this.Avertex[nArray[n2]].label = Math.min(this.Bvertex[nArray5[n]].label, dArray[nArray[n2]][nArray5[n]]);
                        this.Avertex[nArray[n2]].pred = nArray5[n];
                        nArray4[n6] = nArray[n2];
                        ++n6;
                    }
                }
            }
            if (d > 0.0) {
                this.Bvertex[n5].residual -= d;
                int n8 = n5;
                int n9 = this.Bvertex[n8].pred;
                dArray[n9][n8] = dArray[n9][n8] + d;
                while (this.Avertex[n9].pred != -1) {
                    n8 = this.Avertex[n9].pred;
                    dArray[n9][n8] = dArray[n9][n8] - d;
                    n9 = this.Bvertex[n8].pred;
                    dArray[n9][n8] = dArray[n9][n8] + d;
                }
                this.Avertex[n9].residual -= d;
                continue;
            }
            int n10 = 0;
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                if (this.Avertex[nArray[n2]].label != -1.0) continue;
                nArray3[2][n10] = nArray[n2];
                ++n10;
            }
            nArray3[0][0] = n10;
            n10 = 0;
            for (n = 0; n <= n4 - 1; ++n) {
                if (!(this.Bvertex[nArray2[n]].label >= 0.0)) continue;
                nArray3[3][n10] = nArray2[n];
                ++n10;
            }
            nArray3[1][0] = n10;
        }
        return nArray3;
    }
}

