"""
.. This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

.. This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

.. You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import math


def solve(sought, angle=None, adjacent=None, opposite=None, hypotenuse=None):

    """
    Solve for ``sought``.

    ``sought`` should be a string with the following possible values:
    ``adjacent``, ``opposite``, ``hypotenuse``.

    Angles are expected and returned in degrees.
    """

    if len([item for item in [angle, adjacent, opposite, hypotenuse] if
            item is not None]) < 2:
        raise ValueError("At least two values are needed to solve.")

    angle = math.radians(angle)
    if sought == "adjacent":
        if hypotenuse:
            unknown = hypotenuse * math.cos(angle)
        elif opposite:
            unknown = opposite / math.tan(angle)
    elif sought == "opposite":
        if hypotenuse:
            unknown = hypotenuse * math.sin(angle)
        elif adjacent:
            unknown = adjacent * math.tan(angle)
    else:
        if opposite:
            unknown = opposite / math.sin(angle)
        elif adjacent:
            unknown = adjacent / math.cos(angle)
    return unknown
