#!/usr/bin/env python
# coding=utf-8
from setuptools import setup
import trmaid
import os


def read(fname):
    fpath = os.path.join(os.path.dirname(__file__), fname)
    if not os.path.exists(fpath):
        return ''
    return open(fpath).read()


setup(
    name="trmaid",
    version=trmaid.__version__,
    author="Tanel Puhu",
    author_email="tanel@lusikas.com",
    description="Tool to maintain transmission (bittorrent) settings, add items from feeds and redis queues",
    keywords="transmission torrent",
    url="https://github.com/tanelpuhu/trmaid",
    packages=['trmaid'],
    install_requires=['feedparser', 'requests', 'redis', 'pyyaml'],
    entry_points={
        'console_scripts': [
            'trmaid = trmaid.trmaid:main',
        ]},
    long_description=read('README.md'),
    classifiers=[
        "Development Status :: 3 - Alpha",
        'Environment :: Console',
        "Topic :: Utilities",

    ],
)
