#!/usr/bin/env python
# coding=utf-8
from setuptools import setup
import sys
import re
import os


def read(fname):
    fpath = os.path.join(os.path.dirname(__file__), fname)
    if not os.path.exists(fpath):
        return ''
    return open(fpath).read()


def get_version():
    init_py = open(os.path.join('trmaid', '__init__.py')).read()
    return re.search("^__version__ = ['\"]([^'\"]+)['\"]", init_py, re.MULTILINE).group(1)

if sys.argv[-1] == 'publish':
    os.system("python setup.py sdist upload")
    args = {'version': get_version()}
    print("You probably want to also tag the version now:")
    print("git tag -a %(version)s -m 'version %(version)s'" % args)
    print("git push --tags")
    sys.exit()


setup(
    name="trmaid",
    version=get_version(),
    author="Tanel Puhu",
    author_email="tanel@lusikas.com",
    description="Tool to maintain transmission (bittorrent) settings, add items from feeds and redis queues",
    keywords="transmission torrent",
    url="https://github.com/tanelpuhu/trmaid",
    packages=['trmaid'],
    install_requires=['feedparser', 'requests', 'redis', 'pyyaml'],
    entry_points={
        'console_scripts': [
            'trmaid = trmaid.trmaid:main',
        ]},
    long_description=read('README.md'),
    classifiers=[
        "Development Status :: 3 - Alpha",
        'Environment :: Console',
        "Topic :: Utilities",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3.4",
    ],
)
