'''
Author:      www.tropofy.com

Copyright 2013 Tropofy Pty Ltd, all rights reserved.

This source file is part of Tropofy and govered by the Tropofy terms of service
available at: http://www.tropofy.com/terms_of_service.html

This source file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
'''

import os

from setuptools import setup

here = os.path.abspath(os.path.dirname(__file__))
README = open(os.path.join(here, 'README.txt')).read()

requires = [
    'pyramid==1.5a2',
    'SQLAlchemy>=0.8.2,<=0.8.4',
    'transaction==1.4.1',
    'pyramid_tm==0.7',
    'zope.sqlalchemy==0.7.3',
    'waitress==0.8.7',
    'openpyxl==1.6.2',
    'pyramid_exclog==0.7',
    'requests==2.0.0',
    'simplekml==1.2.2',
    'pulp==1.5.4',
    'xlrd==0.9.2',
]

setup(
    name='tropofy',
    version='0.37.4',
    description='Tropofy enables problem solvers to deploy their solutions as web apps, without the need for any web development knowledge or experience. Vist http://www.tropofy.com for more info',
    long_description='Tropofy enables problem solvers to deploy their solutions as web apps, without the need for any web development knowledge or experience. Vist http://www.tropofy.com for more info',
    classifiers=[
        "Programming Language :: Python",
    ],
    author='Tropofy',
    author_email='info@tropofy.com',
    url='http://www.tropofy.com',
    license='LICENSE.txt',
    keywords='tropofy, paas, web-app, cloud',
    packages=[
        'tropofy',
        'tropofy.app',
        'tropofy.database',
        'tropofy.widgets',
        'tropofy.widgets.chart_widget',
        'tropofy.widgets.examples',
        'tropofy.widgets.execute_function_widget',
        'tropofy.widgets.grid_widget',
        'tropofy.widgets.kml_map_widget',
        'tropofy.widgets.image_widget',
        'tropofy.widgets.custom_export_widget',
        'tropofy.widgets.file_upload_widget',
        'tropofy.widgets.form_widget',
        'tropofy.widgets.data_sets_widget',
        'tropofy_example_apps',
        'tropofy.scripts',
    ],
    include_package_data=True,
    zip_safe=False,
    test_suite='tropofy',
    install_requires=requires,
    entry_points="""\
        [paste.app_factory]
        main = tropofy:main
        [console_scripts]
        tropofy_quickstart = tropofy.scripts.quickstart:main
        tropofy_run = tropofy.scripts.run:main
    """,
)
