from sqlalchemy.types import Text, Float, Integer
from sqlalchemy.schema import Column, ForeignKeyConstraint, UniqueConstraint
from tropofy.database.tropofy_orm import DataSetMixin
from tropofy.app import AppWithDataSets, Step, StepGroup
from tropofy.widgets import SimpleGrid, KMLMap
from simplekml import Kml


class Store(DataSetMixin):
    name = Column(Text, nullable=False)
    latitude = Column(Float, nullable=False)
    longitude = Column(Float, nullable=False)

    __table_args__ = (UniqueConstraint('name', 'data_set_id'),)


class Performance(DataSetMixin):
    store_name = Column(Text, nullable=False)
    year = Column(Integer, nullable=False)
    sales = Column(Float, nullable=False, default=0)
    expenses = Column(Float, nullable=False, default=0)

    __table_args__ = (
        ForeignKeyConstraint(['store_name', 'data_set_id'], ['store.name', 'store.data_set_id'], ondelete='CASCADE', onupdate='CASCADE'),
    )


class MyKMLMap(KMLMap):
    def get_kml(self, data_set):
        kml = Kml()
        for store in data_set.query(Store).all():
            kml.newpoint(name=store.name, coords=[(store.longitude, store.latitude)])
        return kml.kml()


class MyFirstApp(AppWithDataSets):
    def get_name(self):
        return "My First App"

    def get_gui(self):
        return [
            StepGroup(name='Stores', steps=[Step(name='Stores', widgets=[SimpleGrid(Store)])]),
            StepGroup(name='Performances', steps=[Step(name='Performances', widgets=[SimpleGrid(Performance)])]),
            StepGroup(name='Map', steps=[Step(name='Map', widgets=[MyKMLMap()])])
        ]
