#include <Python.h>
#include <exception>
#include <algorithm>
#include <vector>
#include <map>
#include <string>

#define CEdge std::pair<std::string, std::string>

static PyObject* exmodError = NULL;
static PyObject* exmodCallback = NULL;

std::vector<std::pair<double, CEdge > > graph;
std::vector<std::pair<double, CEdge > > min_span_tree;
std::map<std::string, std::string> parent;

static std::string find_set(std::string x)
{
    if(x != parent[x])
    {
        parent[x] = find_set(parent[x]);
    }
    return parent[x];
}

static void kruskal()
{
    sort(graph.begin(), graph.end());

    for(int i = 0; i < (int)graph.size(); i++)
    {
        std::string pu = find_set(graph[i].second.first);
        std::string pv = find_set(graph[i].second.second);
		if (pu.compare(pv) != 0)
        {
            min_span_tree.push_back(graph[i]);
            parent[pu] = parent[pv];
        }
    }
}

static PyObject* exmod_solve_kruskal(PyObject* self, PyObject *args)
{
	kruskal();

    for(int i = 0; i < (int)min_span_tree.size(); i++)
    {
		PyObject* arglist = Py_BuildValue("(ss)", min_span_tree[i].second.first.c_str(),
											min_span_tree[i].second.second.c_str());

		PyObject* result = PyObject_CallObject(exmodCallback, arglist);

		Py_DECREF(arglist);
		if (result == NULL)
		{
			return NULL;
		}
		Py_DECREF(result);
    }

	return Py_None;
}

static PyObject* exmod_add_edge(PyObject* self, PyObject* args)
{
    PyObject* result = NULL;
	const char* orig = NULL;
	const char* dest = NULL;
	const double weight = 0.0;

	if(PyArg_ParseTuple(args, "dss", &weight, &orig, &dest))
	{
		parent[orig] = orig;
		parent[dest] = dest;
		graph.push_back(std::pair<double, CEdge >(weight, CEdge(orig, dest)));
		result = Py_None;
	}

	return result;
}

static PyObject* exmod_callback(PyObject *dummy, PyObject *args)
{
    PyObject* result = NULL;
    PyObject* temp;

    if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
        if (!PyCallable_Check(temp))
        {
            PyErr_SetString(PyExc_TypeError, "parameter must be callable");
            return NULL;
        }

        Py_XINCREF(temp);
        Py_XDECREF(exmodCallback);
        exmodCallback = temp;
        Py_INCREF(Py_None);
        result = Py_None;
    }

    return result;
}

static PyMethodDef exmod_methods[] = {
	{"solve_kruskal",	exmod_solve_kruskal,	METH_VARARGS,	"Say hello from C and print message"},
	{"add_edge",		exmod_add_edge,			METH_VARARGS,	"Add two number in C"},
	{"callback",		exmod_callback,			METH_VARARGS,	"Register the callback function with exmod"},
	{NULL,				NULL,					0,				NULL}
};

PyMODINIT_FUNC initexmod(void)
{
	PyObject* m = NULL;
	m = Py_InitModule("exmod", exmod_methods);
	if (m == NULL)
	{
		return;
	}

	exmodError = PyErr_NewException("exmod.error", NULL, NULL);
	Py_INCREF(exmodError);

	PyModule_AddObject(m, "error", exmodError);
}
