/********** knapsack.lsp **********/

function input() {
  usage = "\nUsage: localsolver knapsack.lsp "
    + "inFileName=inputFile [lsTimeLimit=timeLimit]\n";

  if (inFileName == nil) error(usage);
  
  inFile = openRead(inFileName);
  nbItems = readInt(inFile);
  for [i in 0..nbItems-1] weights[i] = readInt(inFile);
  for [i in 0..nbItems-1] values[i] = readInt(inFile);
  knapsackBound = readInt(inFile);
}

function model() {
  // 0-1 decisions
  for [i in 0..nbItems-1] x[i] <- bool();
  
  // weight constraint
  knapsackWeight <- sum[i in 0..nbItems-1](weights[i] * x[i]);
  constraint knapsackWeight <= knapsackBound;
  
  // maximize value
  knapsackValue <- sum[i in 0..nbItems-1](values[i] * x[i]);
  maximize knapsackValue;
}

function param() {
  if (lsTimeLimit == nil) lsTimeLimit = 10; 
  lsNbThreads = 1;
}

function display() {
  println("knapsackWeight = " + getValue(knapsackWeight) 
    + ", knapsackValue = " + getValue(knapsackValue)); 
}

function output() {
  println("Write solution into file");
  solFile = openWrite(solFileName);
  for [i in 0..nbItems-1 : getValue(x[i]) == 1]
    println(solFile, i);
}
