'''
Author:      www.tropofy.com

Copyright 2013 Tropofy Pty Ltd, all rights reserved.

This source file is part of Tropofy and govered by the Tropofy terms of service
available at: http://www.tropofy.com/terms_of_service.html

This source file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
'''

import os
import sys
from subprocess import call
from glob import glob


def usage(argv, error='incorrect arguments'):
    cmd = os.path.basename(argv[0])
    print(
        '\nError: ' + error + '.\n'

        'Usage: {cmd}\n'
    ).format(cmd=cmd)


def multiple_ini_files_error(argv):
    cmd = os.path.basename(argv[0])
    print(
        '\nError: Multiple .ini files in working directory, must specify which ini file to use in tropofy_run or remove ini files so that only one remains.\n\n'

        'Usage: {cmd} <ini file>\n'
        'Example: {cmd} development.ini\n'
    ).format(cmd=cmd)
    sys.exit(1)


def no_ini_files_error(argv):
    print('\nError: No .ini files in working directory. Use tropofy_quickstart to create a new app folder and .ini file.\n\n')
    sys.exit(1)


def main(argv=sys.argv):
    """Runs a tropofy app from 2 possible argument configurations.
    Both configurations create log files in working directory /logs.

    Args:
    (*.ini file): Launch pserve with this .ini file.
    """

    ini_file_location = None
    pserve_arg = None  # e.g. --reload
    num_args = len(argv)

    if argv[num_args - 1].startswith('--'):
        pserve_arg = argv[num_args - 1]

    ini_files_in_cwd = [file_ for file_ in os.listdir(".") if file_.endswith('.ini')]
    if num_args > 3:
        usage(argv)
        sys.exit(1)
    else:
        # Determine the ini file, could be specified, or there already
        if num_args >= 2 and argv[1].endswith('.ini'):
            ini_file_location = argv[1]
        elif len(ini_files_in_cwd) != 1:
            if len(ini_files_in_cwd) == 0:
                no_ini_files_error(argv)
            else:
                multiple_ini_files_error(argv)

        else:
            ini_file_location = os.path.join(os.getcwd(), ini_files_in_cwd[0])

        # Determine if you have asked for the db to be deleted
        for n in range(num_args):
            if argv[n] == "delete_db":
                for f in glob(os.getcwd() + '/*.db'):
                    os.unlink(f)
                    print "\ndeleting " + str(f) + "\n"

    pserve_call = ["pserve", ini_file_location]
    if pserve_arg:
        pserve_call.append(pserve_arg)

    call(pserve_call)
