'''
Author:      www.tropofy.com

Copyright 2013 Tropofy Pty Ltd, all rights reserved.

This source file is part of Tropofy and govered by the Tropofy terms of service
available at: http://www.tropofy.com/terms_of_service.html

This source file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
'''

from sqlalchemy.orm import Session, scoped_session, sessionmaker
from zope.sqlalchemy import ZopeTransactionExtension  # Automatically issues transaction commit after every request unless exception is rased. Ensures a single Session is associated with each request. Strongly recommended by SQLAlchemy.

from pyramid import threadlocal
#from tropofy.app import AppManager


class RoutingSession(Session):
    def get_bind(self, mapper=None, clause=None):
        if threadlocal.get_current_request().app:
            return threadlocal.get_current_request().app.engine
        return None

DBSession = scoped_session(sessionmaker(class_=RoutingSession, extension=ZopeTransactionExtension(), expire_on_commit=False))
