'''
Author:      www.tropofy.com

Copyright 2013 Tropofy Pty Ltd, all rights reserved.

This source file is part of Tropofy and govered by the Tropofy terms of service
available at: http://www.tropofy.com/terms_of_service.html

This source file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
'''

from tropofy.widgets.widgets import Widget
from pyramid.response import Response
from pyramid import threadlocal


class DownloadFileFromUrl(Widget):
    """Displays a download button in the GUI to download custom content.

    The following is a reference of the functions required to define a Export.
    """
    def get_type(self):
        return "DownloadFileFromUrlWidget"

    def refresh_from_db(self, data_set, request):
        pass

    def update_from_db(self, data, data_set_id, oper='', data_set=None):
        return {'url': self.get_file_url(data_set)}

    def serialise(self):
        '''Join serialisation dict with Widget to get all params needed on client'''
        return dict(Widget.serialise(self).items() + {
            'buttonText': self.get_export_button_text()
        }.items())

    def get_file_url(self, data_set):
        """The url of the file to be download

        :param data_set: The DataSet object on which queries can be made to access the apps data.
        :type data_set: :class:`tropofy.app.AppDataSet`
        :returns: url
        :rtype: str
        """
        raise NotImplementedError
    
    def get_export_button_text(self):
        """The text on the button in the GUI.

        :rtype: str
        """
        return 'Export'
