'''
Author:      www.tropofy.com

Copyright 2013 Tropofy Pty Ltd, all rights reserved.

This source file is part of Tropofy and govered by the Tropofy terms of service
available at: http://www.tropofy.com/terms_of_service.html

This source file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
'''

from tropofy.widgets import Chart


class TableChart(Chart):  # Default Chart Interface
    def get_chart_type(self, data_set):
        return Chart.TABLE

    def get_table_schema(self, data_set):
        return {
            "name": ("string", "Name"),
            "salary": ("number", "Salary"),
            "full_time": ("boolean", "Full Time Employee")
        }

    def get_table_data(self, data_set):
        return [
            {"name": "Mike", "salary": (10000, "$10,000"), "full_time": True},
            {"name": "Jim", "salary": (800, "$800"), "full_time": False},
            {"name": "Alice", "salary": (12500, "$12,500"), "full_time": True},
            {"name": "Bob", "salary": (7000, "$7,000"), "full_time": True}
        ]

    def get_column_ordering(self, data_set):
        return ["name", "salary", "full_time"]

    def get_order_by_column(self, data_set):
        return "salary"

    def get_chart_options(self, data_set):
        return {'title': 'Employee Details'}


class ExampleBarChart(Chart):
    def get_chart_type(self, data_set):
        return Chart.BARCHART

    def get_table_schema(self, data_set):
        return {
            "year": ("string", "Year"),
            "sales": ("number", "Sales"),
            "expenses": ("number", "Expenses")
        }

    def get_table_data(self, data_set):
        return [
            {"year": 2004, "sales": 1000, "expenses": 400},
            {"year": 2005, "sales": 1170, "expenses": 460},
            {"year": 2006, "sales": 660, "expenses": 1120},
            {"year": 2007, "sales": 1030, "expenses": 540}
        ]

    def get_column_ordering(self, data_set):
        return ["year", "sales", "expenses"]

    def get_order_by_column(self, data_set):
        return "year"

    def get_chart_options(self, data_set):
        return {
            'title': 'Company Performance',
            'vAxis': {
                'title': 'Year',
                'titleTextStyle': {'color': 'red'}
            }
        }


class ExamplePieChart(Chart):
    def get_chart_options(self, data_set):
        return {'title': 'Daily Schedule'}

    def get_chart_type(self, data_set):
        return Chart.PIECHART

    def get_column_ordering(self, data_set):
        return ["task", "hours"]

    def get_order_by_column(self, data_set):
        return "task"

    def get_table_data(self, data_set):
        return [
            {"task": 'Work', "hours": 11},
            {"task": 'Eat', "hours": 2},
            {"task": 'Commute', "hours": 2},
            {"task": 'Watch TV', "hours": 2},
            {"task": 'Sleep', "hours": 7},
        ]

    def get_table_schema(self, data_set):
        return {
            "task": ("string", "Task"),
            "hours": ("number", "Hours per Day")
        }
        
class MyLocsLinesKMLMap(KMLMap):
    
    def get_kml(self, data_set):

        kml = Kml()

        def LongLat(l):
            return (l.longitude, l.latitude)

        mylocstyle = Style(iconstyle=IconStyle(scale=0.8, icon=Icon(href='https://maps.google.com/mapfiles/kml/paddle/blu-circle-lv.png')))
        LocsFolder = kml.newfolder(name="Locations")
        for p in [LocsFolder.newpoint(name=loc.name, coords=[LongLat(loc)]) for loc in data_set.query(Location).all()]:
            p.style = mylocstyle

        mylinestyle = Style(linestyle=LineStyle(color='FF00F5FF', width=4))
        LinesFolder = kml.newfolder(name="Lines")
        for line in [LinesFolder.newlinestring(name='line', coords=[LongLat(l.start_location), LongLat(l.end_location)]) for l in data_set.query(Line).all()]:
            line.style = mylinestyle

        return kml.kml()

class MyKMLMap(KMLMap):
    
    def get_kml(self, data_set):
        kml = Kml()
        for p in [kml.newpoint(name=loc.name, coords=[(loc.longitude, loc.latitude)]) for loc in data_set.query(Location).all()]:
            p.style = Style(iconstyle=IconStyle(scale=0.8, icon=Icon(href='https://maps.google.com/mapfiles/kml/paddle/blu-circle-lv.png')))
        return kml.kml()
    
class ConformingClass(TropofyBase()):
    name = Column(Text, nullable=False)
    latitude = Column(Float, nullable=False)
    longitude = Column(Float, nullable=False)
    demand = Column(Integer, nullable=False)

    def __init__(self, name, latitude, longitude, demand):
        self.name = name
        self.latitude = latitude
        self.longitude = longitude
        self.demand = demand
        
