/********** maxcut.lsp **********/

/* Reads instance data */
function input(){
	 usage = "\nUsage: localsolver maxcut.lsp "
    	 + "inFileName=inputFile [lsTimeLimit=timeLimit]\n";

	if (inFileName == nil) error(usage);
		 
	 instance=openRead(inFileName);
	 n=readInt(instance);
	 m=readInt(instance);
	 for [i in 1..m]{
	     origin[i] = readInt(instance);
	     dest[i] = readInt(instance);
	     w[i] = readInt(instance);
	 }
}

/* Declares the optimization model. */
function model(){
	 // x[i] is 1 if vertex i is in the subset S, 0 if it is in V-S
	 x[1..n] <- bool();
	 //an edge is in the cut-set if it has an extremity in each class of the bipartition
	 incut[i in 1..m] <- x[origin[i]] != x[dest[i]] ? 1 : 0;
	 maximize sum[i in 1..m] (w[i]* incut[i]);
}


/* Parameterizes the solver. */
function param(){
	 if(lsTimeLimit == nil) 
		lsTimeLimit=10;
}

/* Writes the solution in a file following the following format: 
 * each line contains a vertex number and its subset (1 for S, 0 for V-S) */
function output(){
  println("Write solution into file");
  solFile = openWrite(solFileName);
  for [i in 1..n]
    println(solFile, i, " ", getValue(x[i]));
}
