from sqlalchemy import select
import transaction


def populate_tables_from_reference_data_set(reference_data_set, data_set, class_mapping):

    def get_data_columns(table):
        return [
            col
            for col in table.columns
            if col.key not in ["id", "data_set_id"]
        ]

    def get_data_set_id_col(table):
        return next(col for col in table.columns if col.key == "data_set_id")

    transaction.commit()

    db_engine = reference_data_set.db_session().get_bind()
    db_connection = db_engine.connect()

    for from_table, to_table in class_mapping:

        src_db_data = db_connection.execute(
            select(get_data_columns(from_table)).where(get_data_set_id_col(from_table) == reference_data_set.id)
        )

        copied_data = [dict([('data_set_id', data_set.id)] + row.items()) for row in src_db_data]

        print "Copied %d items for table %s" % (len(copied_data), from_table.name)

        if copied_data:
            db_connection.execute(to_table.insert(), copied_data)
