class AlternateDataSetForm(Form):
    def __init__(self, data_set_getter_func, widget_subscriptions=None):
        self.data_set_getter_func = data_set_getter_func
        super(AlternateDataSetForm, self).__init__(widget_subscriptions)

    def get_form_elements(self, data_set, **kwargs):
        data_set = self.data_set_getter_func() if self.data_set_getter_func else data_set
        return self.altds_get_form_elements(data_set, **kwargs)

    def process_data(self, data, data_set, **kwargs):
        data_set = self.data_set_getter_func() if self.data_set_getter_func else data_set
        return self.altds_process_data(data, data_set, **kwargs)

    def altds_get_form_elements(self, data_set, **kwargs):
        raise NotImplementedError

    def altds_process_data(self, data, data_set, **kwargs):
        raise NotImplementedError




class AlternateDataSetCustomFileUpload(FileUpload):
    def __init__(self, data_set_getter_func, widget_subscriptions=None):
        self.data_set_getter_func = data_set_getter_func
        super(AlternateDataSetCustomFileUpload, self).__init__(widget_subscriptions)

    def get_allowed_file_types(self, data_set, **kwargs):
        return FileUpload.excel_file_types

    def process_file(self, data_set, in_memory_file, result, **kwargs):
        data_set = self.data_set_getter_func() if self.data_set_getter_func else data_set
        return self.altds_process_file(data_set, in_memory_file, result, **kwargs)

    def altds_process_file(self, data_set, in_memory_file, result, **kwargs):
        raise NotImplementedError

    def get_class_ws_mappings(self, data_set):
        data_set = self.data_set_getter_func() if self.data_set_getter_func else data_set
        return self.altds_get_class_ws_mappings(data_set)

    def altds_get_class_ws_mappings(self, data_set):
        raise NotImplementedError
