#The COPYRIGHT file at the top level of this repository contains the full
#copyright notices and license terms.

from trytond.pool import Pool
from .statement import *
from .account import *
from .move import *
from .bank import *
from .configuration import *

def register():
    Pool.register(
        BankStatementConfiguration,
        Account,
        Bank,
        BankAccount,
        BankStatement,
        BankStatementLine,
        BankStatementTransaction,
        BankReconciliation,
        Move,
        Line,
        SearchBankUnreconciledsLinesStart,
        CreateBankStatementStart,
        module='account_bank_statement', type_='model')
    Pool.register(
        UpdateBankStatementLines,
        SearchBankUnreconciledLines,
        CreateBankStatement,
        module='account_bank_statement', type_='wizard')
