#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.pool import Pool
from .move import *
from .configuration import *
from .party import *
from .invoice import *
from .account import *

def register():
    Pool.register(
        Address,
        CashflowTemplate,
        Cashflow,
        Account,
        Party,
        Configuration,
        Move,
        Line,
        Invoice,
        InvoiceForceDrawStart,
        AuxiliaryBookStart,
        AuxiliaryPartyStart,
        PrintTrialBalanceDetailedStart,
        PrintTrialBalanceStart,
        BankAccountNumber,
        OpenCashflowStart,
        MoveFixNumberStart,
        module='account_plus', type_='model')
    Pool.register(
        AccountMoveSheet,
        AuxiliaryBook,
        AuxiliaryParty,
        TrialBalanceDetailed,
        PortfolioByPartyDetailed,
        TrialBalance,
        BalanceSheet,
        IncomeStatement,
        module='account_plus', type_='report')
    Pool.register(
        MoveForceDraw,
        InvoiceForceDraw,
        PrintAuxiliaryBook,
        PrintTrialBalanceDetailed,
        PrintAuxiliaryParty,
        PrintTrialBalance,
        OpenCashflowStatement,
        MoveFixNumber, 
        module='account_plus', type_='wizard')
